<?php
echo "PHP is working!<br>";
echo "PHP Version: " . phpversion() . "<br>";

// Test database connection
try {
    require_once '../includes/db.php';
    echo "Database connection: SUCCESS<br>";
    
    // Test if events table exists
    $result = $pdo->query("SHOW TABLES LIKE 'events'");
    if ($result->rowCount() > 0) {
        echo "Events table: EXISTS<br>";
        
        // Check if there are any events
        $count = $pdo->query("SELECT COUNT(*) FROM events")->fetchColumn();
        echo "Events count: $count<br>";
    } else {
        echo "Events table: DOES NOT EXIST<br>";
        echo "Creating events table...<br>";
        
        $create_table = "
        CREATE TABLE IF NOT EXISTS events (
            event_id INT AUTO_INCREMENT PRIMARY KEY,
            event_name VARCHAR(255) NOT NULL,
            discipline VARCHAR(100),
            event_date DATE,
            location VARCHAR(255),
            event_status ENUM('draft', 'active', 'completed') DEFAULT 'draft',
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        )";
        
        $pdo->exec($create_table);
        echo "Events table created!<br>";
        
        // Insert sample event
        $insert_sample = "
        INSERT INTO events (event_name, discipline, event_date, location, event_status) 
        VALUES ('Sample Freestyle Event', 'freestyle', CURDATE(), 'Test Location', 'active')";
        
        $pdo->exec($insert_sample);
        echo "Sample event inserted!<br>";
    }
    
} catch (Exception $e) {
    echo "Database error: " . $e->getMessage() . "<br>";
}
?>
