<?php
include 'db.php';

echo "Checking token_actions table structure...\n\n";

try {
    $stmt = $pdo->query('DESCRIBE token_actions');
    echo "token_actions table structure:\n";
    while ($row = $stmt->fetch()) {
        echo "  " . $row['Field'] . " - " . $row['Type'] . "\n";
    }
} catch (Exception $e) {
    echo "Error (table might not exist): " . $e->getMessage() . "\n";
    
    // Check what tables exist
    echo "\nChecking for similar tables...\n";
    $tables = $pdo->query("SHOW TABLES LIKE '%action%'")->fetchAll();
    if ($tables) {
        foreach ($tables as $table) {
            echo "Found table: " . $table[0] . "\n";
        }
    } else {
        echo "No action-related tables found.\n";
    }
}

echo "\nDone!\n";
?>
