<?php
if(!isset($_SESSION)) { session_start(); }

function requireAuth($allowed_types = ['admin', 'judge']) {
    if (!isset($_SESSION['user_logged_in']) || $_SESSION['user_logged_in'] !== true) {
        header("Location: /v2/login.php");
        exit;
    }
    
    if (!in_array($_SESSION['user_type'], $allowed_types)) {
        header("Location: /v2/login.php?error=unauthorized");
        exit;
    }
}

// Usage examples:
// requireAuth(['admin']); // Only admin
// requireAuth(['judge']); // Only judge
// requireAuth(['admin', 'judge']); // Both admin and judge
?>