<?php
// Show recent error log entries
$log_files = [
    'C:\xampp\php\logs\php_error_log',
    'C:\xampp\apache\logs\error.log',
    'C:\wamp64\logs\php_error.log',
    'C:\wamp64\logs\apache_error.log',
    '/var/log/php_errors.log'
];

echo "<h1>Recent Error Log Entries</h1>";
echo "<p><a href='?refresh=1'>Refresh</a></p>";

$found = false;
foreach ($log_files as $log_file) {
    if (file_exists($log_file)) {
        $found = true;
        echo "<h2>Log File: " . htmlspecialchars($log_file) . "</h2>";
        
        // Get last 100 lines
        $lines = file($log_file);
        $recent_lines = array_slice($lines, -100);
        
        // Filter for our debug messages
        $our_lines = array_filter($recent_lines, function($line) {
            return strpos($line, 'SUMMARY TABLE STYLING') !== false ||
                   strpos($line, 'Querying styling') !== false ||
                   strpos($line, 'Found styling') !== false ||
                   strpos($line, 'NO styling') !== false ||
                   strpos($line, 'Generated header') !== false ||
                   strpos($line, 'Error loading styling') !== false;
        });
        
        if (!empty($our_lines)) {
            echo "<h3>Relevant Debug Messages:</h3>";
            echo "<pre style='background: #f5f5f5; padding: 10px; border: 1px solid #ccc;'>";
            echo htmlspecialchars(implode('', $our_lines));
            echo "</pre>";
        }
        
        echo "<h3>Last 30 Lines (All):</h3>";
        echo "<pre style='background: #f5f5f5; padding: 10px; border: 1px solid #ccc; max-height: 400px; overflow-y: scroll;'>";
        echo htmlspecialchars(implode('', array_slice($lines, -30)));
        echo "</pre>";
    }
}

if (!$found) {
    echo "<p style='color: red;'>No error log files found. Try checking phpinfo() for error_log location.</p>";
    echo "<p><a href='?showinfo=1'>Show PHP Info</a></p>";
    
    if (isset($_GET['showinfo'])) {
        phpinfo();
    }
}
