@echo off
echo ========================================
echo SSH2 Extension Verification
echo ========================================
echo.

REM Check if SSH2 extension is loaded
echo Checking if SSH2 extension is loaded...
C:\xampp\php\php.exe -r "if (function_exists('ssh2_connect')) { echo 'SUCCESS: SSH2 extension is installed and working!\n'; echo 'Version: ' . phpversion('ssh2') . '\n'; } else { echo 'ERROR: SSH2 extension NOT found\n'; exit(1); }"

if %ERRORLEVEL% EQU 0 (
    echo.
    echo ========================================
    echo All checks passed!
    echo ========================================
    echo.
    echo Next steps:
    echo   1. Visit: http://localhost/v2/admin/check_ssh2.php
    echo   2. Go to: http://localhost/v2/admin/publish_servers.php
    echo   3. Add an SFTP server and test the connection
    echo.
) else (
    echo.
    echo ========================================
    echo SSH2 NOT installed correctly
    echo ========================================
    echo.
    echo Please check:
    echo   1. php_ssh2.dll is in: C:\xampp\php\ext\
    echo   2. libssh2.dll is in: C:\xampp\php\
    echo   3. libssh2.dll is in: C:\xampp\apache\bin\
    echo   4. php.ini contains: extension=ssh2
    echo   5. Apache has been restarted
    echo.
    echo Run this command to check which php.ini is being used:
    echo   C:\xampp\php\php.exe --ini
    echo.
)

echo.
pause
