<?php
require 'includes/db.php';

echo "=== Permissions System Verification ===\n\n";

try {
    // Check permissions table
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM permissions");
    $perm_count = $stmt->fetch()['count'];
    echo "✓ Permissions table: {$perm_count} permissions\n";

    // Check role_permissions table
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM role_permissions");
    $assignment_count = $stmt->fetch()['count'];
    echo "✓ Role permissions table: {$assignment_count} assignments\n\n";

    // Show permissions per role
    echo "Permissions per role:\n";
    $stmt = $pdo->query("
        SELECT role, COUNT(*) as perm_count 
        FROM role_permissions 
        GROUP BY role 
        ORDER BY perm_count DESC
    ");
    
    foreach ($stmt->fetchAll() as $row) {
        printf("  %-20s %2d permissions\n", $row['role'], $row['perm_count']);
    }

    echo "\n✅ Permissions system is operational!\n";
    echo "\nAccess panel: http://localhost/v2/admin/permissions_manager.php\n";

} catch (PDOException $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}
