<?php
// Test real StyleScore scoring data connection
try {
    require_once '../includes/db.php';
    echo "<h2>🎯 StyleScore Real Scoring Data Test</h2>";
    
    // Test 1: Check if we have any events
    $events = $pdo->query("SELECT id, name, date FROM events ORDER BY date DESC LIMIT 5")->fetchAll(PDO::FETCH_ASSOC);
    echo "<h3>📅 Recent Events (" . count($events) . " found):</h3>";
    if ($events) {
        echo "<table border='1' style='border-collapse: collapse; margin: 10px 0;'>";
        echo "<tr><th>ID</th><th>Event Name</th><th>Date</th><th>Test API</th></tr>";
        foreach ($events as $event) {
            echo "<tr>";
            echo "<td>{$event['id']}</td>";
            echo "<td>{$event['name']}</td>";
            echo "<td>{$event['date']}</td>";
            echo "<td><a href='api.php?action=participants&event_id={$event['id']}' target='_blank'>Test Participants API</a></td>";
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "<p style='color: orange;'>⚠️ No events found in database</p>";
    }
    
    // Test 2: Check participants for the first event
    if (!empty($events)) {
        $event_id = $events[0]['id'];
        echo "<h3>👥 Participants for Event: {$events[0]['name']}</h3>";
        
        $participants = $pdo->prepare("
            SELECT ep.id, ep.first_name, ep.last_name, ep.bib_number, ep.heat_number,
                   COUNT(DISTINCT r.id) as total_runs,
                   COUNT(DISTINCT s.id) as total_scores
            FROM event_participants ep
            LEFT JOIN runs r ON r.event_participant_id = ep.id
            LEFT JOIN scores s ON s.run_id = r.id AND s.status = 'OK'
            WHERE ep.event_id = ?
            GROUP BY ep.id
            ORDER BY ep.bib_number
            LIMIT 10
        ");
        $participants->execute([$event_id]);
        $participant_data = $participants->fetchAll(PDO::FETCH_ASSOC);
        
        if ($participant_data) {
            echo "<table border='1' style='border-collapse: collapse; margin: 10px 0;'>";
            echo "<tr><th>ID</th><th>Name</th><th>Bib</th><th>Heat</th><th>Runs</th><th>Scores</th><th>Test APIs</th></tr>";
            foreach ($participant_data as $p) {
                echo "<tr>";
                echo "<td>{$p['id']}</td>";
                echo "<td>{$p['first_name']} {$p['last_name']}</td>";
                echo "<td>#{$p['bib_number']}</td>";
                echo "<td>{$p['heat_number']}</td>";
                echo "<td>{$p['total_runs']}</td>";
                echo "<td>{$p['total_scores']}</td>";
                echo "<td>";
                echo "<a href='api.php?action=judge_scores&event_id=$event_id&participant_id={$p['id']}&run_number=1' target='_blank'>Judge Scores</a>";
                echo "</td>";
                echo "</tr>";
            }
            echo "</table>";
        } else {
            echo "<p style='color: orange;'>⚠️ No participants found for this event</p>";
        }
        
        // Test 3: Recent scoring activity
        echo "<h3>📊 Recent Scoring Activity</h3>";
        $recent_scores = $pdo->prepare("
            SELECT ep.first_name, ep.last_name, ep.bib_number, r.run_number,
                   s.score_value, s.status, 
                   COALESCE(s.updated_at, s.created_at) as timestamp,
                   u.username as judge_name
            FROM scores s
            JOIN runs r ON s.run_id = r.id
            JOIN event_participants ep ON r.event_participant_id = ep.id
            LEFT JOIN users u ON u.judge_id = s.judge_id OR u.id = s.judge_id
            WHERE ep.event_id = ?
            AND s.status = 'OK'
            ORDER BY COALESCE(s.updated_at, s.created_at) DESC
            LIMIT 10
        ");
        $recent_scores->execute([$event_id]);
        $scores_data = $recent_scores->fetchAll(PDO::FETCH_ASSOC);
        
        if ($scores_data) {
            echo "<table border='1' style='border-collapse: collapse; margin: 10px 0;'>";
            echo "<tr><th>Participant</th><th>Bib</th><th>Run</th><th>Score</th><th>Judge</th><th>Time</th></tr>";
            foreach ($scores_data as $score) {
                echo "<tr>";
                echo "<td>{$score['first_name']} {$score['last_name']}</td>";
                echo "<td>#{$score['bib_number']}</td>";
                echo "<td>{$score['run_number']}</td>";
                echo "<td><strong>{$score['score_value']}</strong></td>";
                echo "<td>{$score['judge_name']}</td>";
                echo "<td><small>{$score['timestamp']}</small></td>";
                echo "</tr>";
            }
            echo "</table>";
            
            echo "<p style='background: #d4edda; padding: 10px; border-radius: 5px;'>
                ✅ <strong>Real scoring data found!</strong> The TV overlay will now display live scores from StyleScore.
            </p>";
        } else {
            echo "<p style='color: orange;'>⚠️ No scoring data found. Judges may not have started scoring yet.</p>";
        }
    }
    
    // Test 4: API Endpoints
    echo "<h3>🔗 Test TV Overlay API Endpoints</h3>";
    if (!empty($events)) {
        $test_event_id = $events[0]['id'];
        echo "<ul>";
        echo "<li><a href='api.php?action=participants&event_id=$test_event_id' target='_blank'>Participants API</a></li>";
        echo "<li><a href='api.php?action=rankings&event_id=$test_event_id&limit=5' target='_blank'>Rankings API</a></li>";
        echo "<li><a href='api.php?action=live_scores&event_id=$test_event_id&limit=5' target='_blank'>Live Scores API</a></li>";
        echo "<li><a href='api.php?action=event_info&event_id=$test_event_id' target='_blank'>Event Info API</a></li>";
        echo "</ul>";
    }
    
    echo "<hr><a href='index.php' style='background: #39FF14; color: black; padding: 10px 20px; text-decoration: none; border-radius: 5px;'>→ Open TV Overlay Control Panel</a>";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
?>
