<?php

// Build API URL from configuration JSON (for summary tables)
function buildSummaryTableAPIUrl($config) {
    $settings = json_decode($config['configuration'], true);
    
    $params = [
        'event_id' => $config['event_id'],
        'format' => 'json',
        'styling' => 'full'
    ];
    
    // Heat filter
    if (isset($settings['heat_number']) && $settings['heat_number']) {
        $params['heat_number'] = $settings['heat_number'];
    }
    
    // Column visibility
    $params['show_rank'] = isset($settings['showRank']) && $settings['showRank'] ? 'true' : 'false';
    $params['show_bib'] = isset($settings['showBib']) && $settings['showBib'] ? 'true' : 'false';
    $params['show_participant'] = isset($settings['showParticipant']) && $settings['showParticipant'] ? 'true' : 'false';
    $params['show_category'] = isset($settings['showCategory']) && $settings['showCategory'] ? 'true' : 'false';
    $params['show_club'] = isset($settings['showClub']) && $settings['showClub'] ? 'true' : 'false';
    $params['show_gender'] = isset($settings['showGender']) && $settings['showGender'] ? 'true' : 'false';
    $params['show_fis_code'] = isset($settings['showFisCode']) && $settings['showFisCode'] ? 'true' : 'false';
    $params['show_licence_code'] = isset($settings['showLicenceCode']) && $settings['showLicenceCode'] ? 'true' : 'false';
    $params['show_country'] = isset($settings['showCountry']) && $settings['showCountry'] ? 'true' : 'false';
    $params['show_birth_year'] = isset($settings['showBirthYear']) && $settings['showBirthYear'] ? 'true' : 'false';
    $params['show_age'] = isset($settings['showAge']) && $settings['showAge'] ? 'true' : 'false';
    $params['show_runs'] = isset($settings['showRuns']) && $settings['showRuns'] ? 'true' : 'false';
    $params['show_judges'] = isset($settings['showJudges']) && $settings['showJudges'] ? 'true' : 'false';
    $params['show_control_points'] = isset($settings['showControlPoints']) && $settings['showControlPoints'] ? 'true' : 'false';
    $params['show_figures'] = isset($settings['showFigures']) && $settings['showFigures'] ? 'true' : 'false';
    $params['show_event_settings'] = isset($settings['showEventSettings']) && $settings['showEventSettings'] ? 'true' : 'false';
    $params['show_heat_best'] = isset($settings['showHeatBest']) && $settings['showHeatBest'] ? 'true' : 'false';
    $params['show_heat_average'] = isset($settings['showHeatAverage']) && $settings['showHeatAverage'] ? 'true' : 'false';
    $params['show_overall_best'] = isset($settings['showOverallBest']) && $settings['showOverallBest'] ? 'true' : 'false';
    $params['show_highest_average'] = isset($settings['showHighestAverage']) && $settings['showHighestAverage'] ? 'true' : 'false';
    
    // Heat direction
    if (isset($settings['heatDirection'])) {
        $params['heat_direction'] = $settings['heatDirection'];
    }
    
    // Sorting
    if (isset($settings['sortBy'])) {
        $params['sort'] = $settings['sortBy'];
    }
    if (isset($settings['sortDirection'])) {
        $params['sort_direction'] = $settings['sortDirection'];
    }
    
    // Gender filter
    if (isset($settings['gender'])) {
        $params['gender'] = $settings['gender'];
    } elseif (isset($settings['gender_filter_main'])) {
        $params['gender'] = $settings['gender_filter_main'];
    }
    
    // Category filter
    if (isset($settings['category_filter']) && $settings['category_filter'] !== 'all') {
        $params['category'] = $settings['category_filter'];
    }
    
    // Column renames
    if (isset($settings['columnRenames']) && is_array($settings['columnRenames']) && count($settings['columnRenames']) > 0) {
        foreach ($settings['columnRenames'] as $key => $value) {
            $params['rename_' . $key] = $value;
        }
    }
    
    return 'http://localhost/v2/api/summary_table_api.php?' . http_build_query($params);
}

// Test with config 16
$config = [
    'event_id' => 3,
    'id' => 16,
    'configuration' => '{"event_id":"3","heat_number":"1","gender_filter_main":"all","category_filter":"all","showRank":true,"showBib":true,"showParticipant":true,"showCategory":false,"showClub":false,"showGender":false,"showFisCode":false,"showLicenceCode":false,"showCountry":false,"showRuns":true,"showJudges":false,"showControlPoints":false,"showFigures":false,"showEventSettings":true,"showHeatBest":true,"showHeatAverage":false,"showOverallBest":false,"showHighestAverage":true,"showFormatName":false,"showJudgeInfo":false,"showScaleInfo":false,"showDropRule":true,"showModeConfig":false,"showHeatInfo":false,"sortBy":"OverallAverage","sortDirection":"desc","gender":"all","columnRenames":{"rank":"Miej","participant":"Nazwisko Imię","club":"Klub","H1R1_figures":"Trick 1"},"heatDirection":"column"}'
];

$url = buildSummaryTableAPIUrl($config);
echo "Generated URL:\n";
echo $url . "\n\n";

echo "Testing API call...\n";
$json = file_get_contents($url);
echo "Response length: " . strlen($json) . " bytes\n";
echo "Is valid JSON: " . (json_decode($json) !== null ? 'YES' : 'NO') . "\n";

if (json_decode($json) === null) {
    echo "JSON Error: " . json_last_error_msg() . "\n";
    echo "First 500 chars:\n" . substr($json, 0, 500) . "\n";
}
