<?php
require_once 'includes/db.php';

echo "=== Login Password Verification Test ===\n\n";

// Get test users
$stmt = $pdo->query("SELECT id, username, password, role FROM users WHERE username IN ('admin', 'jacek')");
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);

foreach ($users as $user) {
    echo "User: {$user['username']} (Role: {$user['role']})\n";
    echo "Password in DB: " . substr($user['password'], 0, 30) . "...\n";
    echo "Is Hashed: " . ((strlen($user['password']) === 60 && strpos($user['password'], '$2y$') === 0) ? 'YES' : 'NO') . "\n";
    
    // Test password verification logic (same as process_login.php)
    $test_passwords = [
        'admin' => 'password',  // Change to actual admin password
        'jacek' => 'test123'    // Change to actual jacek password
    ];
    
    if (isset($test_passwords[$user['username']])) {
        $password = $test_passwords[$user['username']];
        
        $password_valid = false;
        if (strlen($user['password']) === 60 && strpos($user['password'], '$2y$') === 0) {
            // Hashed password
            $password_valid = password_verify($password, $user['password']);
            echo "Method: password_verify() - ";
        } else {
            // Plain text
            $password_valid = ($password === $user['password']);
            echo "Method: plain text compare - ";
        }
        
        echo "Result: " . ($password_valid ? "✓ VALID" : "✗ INVALID") . "\n";
    }
    
    echo "\n";
}

echo "=== Summary ===\n";
echo "The login system now supports:\n";
echo "- Plain text passwords (legacy users)\n";
echo "- Bcrypt hashed passwords (new users)\n";
echo "\nRecommendation: Migrate all users to hashed passwords for security.\n";
?>
