<?php
/**
 * Test Judge Event Assignment Redirect Logic
 */

require_once 'includes/db.php';

echo "=== Judge Event Assignment Test ===\n\n";

// Get all judges
$stmt = $pdo->query("SELECT id, username, role FROM users WHERE role IN ('judge', 'head_judge') LIMIT 5");
$judges = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (empty($judges)) {
    echo "No judges found in the system.\n";
    exit;
}

echo "Testing event assignments for judges:\n";
echo str_repeat("-", 70) . "\n";

foreach ($judges as $judge) {
    echo "Judge: {$judge['username']} (ID: {$judge['id']}, Role: {$judge['role']})\n";
    
    // Check if judge has assigned events
    $check_stmt = $pdo->prepare("
        SELECT e.id, e.name 
        FROM events e
        JOIN judge_assignments ja ON e.id = ja.event_id
        WHERE ja.judge_id = ?
    ");
    $check_stmt->execute([$judge['id']]);
    $assigned_events = $check_stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if (empty($assigned_events)) {
        echo "  ✗ No events assigned\n";
        echo "  → Would redirect to: dashboard.php?message=no_events_assigned\n";
        echo "  → Message shown: 'You currently have no events assigned to judge'\n";
    } else {
        echo "  ✓ Assigned to " . count($assigned_events) . " event(s):\n";
        foreach ($assigned_events as $event) {
            echo "    - Event #{$event['id']}: {$event['name']}\n";
        }
        echo "  → Would load scoring interface\n";
    }
    
    echo str_repeat("-", 70) . "\n";
}

echo "\n=== Redirect Logic Summary ===\n";
echo "score.php:\n";
echo "  - Checks if \$assigned_events is empty AND not in manual mode\n";
echo "  - Redirects: header('Location: dashboard.php?message=no_events_assigned')\n";
echo "  - Prevents judges from accessing empty scoring interface\n\n";

echo "score_panel.html:\n";
echo "  - Checks if eventId exists after loading judge context\n";
echo "  - Redirects: window.location.href = 'dashboard.php?message=no_events_assigned'\n";
echo "  - Shows friendly error message instead of technical error\n\n";

echo "dashboard.php:\n";
echo "  - Displays warning alert if ?message=no_events_assigned\n";
echo "  - Message: 'You currently have no events assigned to judge'\n";
echo "  - Instructs judge to contact administrator\n";
?>
