<?php
/**
 * Test Auto-Detection Login
 * Simulates the new login process without user type selection
 */

require_once 'includes/db.php';

echo "=== Auto-Detection Login Test ===\n\n";

// Get sample users
$stmt = $pdo->query("SELECT id, username, role FROM users LIMIT 5");
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo "Testing login for multiple users:\n";
echo str_repeat("-", 60) . "\n";

foreach ($users as $user) {
    echo "Username: {$user['username']}\n";
    
    // Simulate new login process (username only)
    $test_username = $user['username'];
    $stmt = $pdo->prepare("SELECT id, username, password, role, judge_id FROM users WHERE username = ?");
    $stmt->execute([$test_username]);
    $found_user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($found_user) {
        echo "✓ User found automatically\n";
        echo "  - Role detected: {$found_user['role']}\n";
        echo "  - Redirect would go to: ";
        
        if (in_array($found_user['role'], ['admin', 'super_admin'])) {
            echo "admin/dashboard.php\n";
        } elseif ($found_user['role'] === 'judge' || $found_user['role'] === 'head_judge') {
            echo "judge/dashboard.php\n";
        } else {
            echo "Default dashboard (role: {$found_user['role']})\n";
        }
    } else {
        echo "✗ User not found\n";
    }
    
    echo str_repeat("-", 60) . "\n";
}

echo "\n=== Summary ===\n";
echo "✓ Login no longer requires user type selection\n";
echo "✓ Role is automatically detected from username\n";
echo "✓ Redirect is determined by detected role\n";
echo "✓ Simplified user experience (one less field)\n\n";

echo "Login Flow:\n";
echo "1. User enters username + password\n";
echo "2. System queries database by username only\n";
echo "3. Password validated (bcrypt or plain text)\n";
echo "4. Role auto-detected from user record\n";
echo "5. User redirected to appropriate dashboard\n";
?>
