<?php
/**
 * Judge Drawings Table Migration
 * Run this file once to create the judge_drawings table and directory structure
 */

require_once 'includes/db.php';

try {
    // Read SQL file
    $sql = file_get_contents(__DIR__ . '/create_judge_drawings_table.sql');
    
    // Execute SQL
    $pdo->exec($sql);
    
    echo "✅ Database table 'judge_drawings' created successfully!\n";
    
    // Create directory structure for storing JSON files
    $directories = [
        __DIR__ . '/drawings',
        __DIR__ . '/drawings/backgrounds',
        __DIR__ . '/drawings/scores'
    ];
    
    foreach ($directories as $dir) {
        if (!is_dir($dir)) {
            if (mkdir($dir, 0755, true)) {
                echo "✅ Created directory: $dir\n";
            } else {
                echo "⚠️ Failed to create directory: $dir (may need manual creation)\n";
            }
        } else {
            echo "ℹ️ Directory already exists: $dir\n";
        }
    }
    
    // Create .htaccess to protect JSON files (optional - allows direct access for now)
    $htaccess_content = "# Allow JSON files to be served\n<Files *.json>\n    Order allow,deny\n    Allow from all\n</Files>\n";
    
    file_put_contents(__DIR__ . '/drawings/.htaccess', $htaccess_content);
    echo "✅ Created .htaccess protection\n";
    
    echo "\n✅ Migration completed successfully!\n";
    echo "📁 Drawing files will be stored in:\n";
    echo "   - Backgrounds: /drawings/backgrounds/\n";
    echo "   - Drawings: /drawings/scores/\n";
    
} catch (Exception $e) {
    echo "❌ Migration failed: " . $e->getMessage() . "\n";
    exit(1);
}
