<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>StyleScore – Freestyle scoring made as dynamic as your tricks.</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        :root {
            --ss-lime: #39FF14;
            --ss-blue: #4B7BFF;
            --ss-violet: #AD26FF;
            --ss-ink: #EAF2FF;
            --ss-muted: #9FB0C9;
            --ss-dark: #0B1220;
        }

        body {
            font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
            background: radial-gradient(circle at top left, #162242 0, #050712 45%, #050509 100%);
            color: var(--ss-ink);
        }

        .navbar {
            background: rgba(5, 7, 15, 0.92);
            backdrop-filter: blur(16px);
            border-bottom: 1px solid rgba(148, 163, 184, 0.15);
        }

        .navbar-brand span.logo-mark {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 34px;
            height: 34px;
            border-radius: 14px;
            background: radial-gradient(circle at 20% 0, var(--ss-lime), var(--ss-violet));
            box-shadow: 0 0 24px rgba(57, 255, 20, 0.5);
            margin-right: 10px;
            font-weight: 700;
            font-size: 18px;
            letter-spacing: -0.06em;
            color: #020617;
        }

        .navbar-brand {
            font-weight: 600;
            letter-spacing: 0.03em;
        }

        .nav-link {
            color: var(--ss-muted) !important;
            font-size: 0.92rem;
        }

        .nav-link:hover {
            color: var(--ss-ink) !important;
        }

        /* Hero */
        .hero {
            padding: 5rem 0 4rem;
            position: relative;
            overflow: hidden;
        }

        .hero::before {
            content: "";
            position: absolute;
            inset: -40%;
            background:
                radial-gradient(circle at 10% 0, rgba(57, 255, 20, 0.08), transparent 55%),
                radial-gradient(circle at 90% 10%, rgba(77, 124, 255, 0.10), transparent 60%),
                radial-gradient(circle at 50% 120%, rgba(173, 38, 255, 0.14), transparent 65%);
            opacity: 0.85;
            pointer-events: none;
        }

        .hero-inner {
            position: relative;
            z-index: 1;
        }

        .hero-badge {
            display: inline-flex;
            align-items: center;
            gap: .5rem;
            padding: .2rem .75rem .2rem .25rem;
            border-radius: 999px;
            background: rgba(15, 23, 42, 0.9);
            border: 1px solid rgba(148, 163, 184, 0.3);
            color: var(--ss-muted);
            font-size: 0.78rem;
            margin-bottom: 1.25rem;
        }

        .hero-badge-dot {
            width: 18px;
            height: 18px;
            border-radius: 999px;
            background: conic-gradient(from 220deg, var(--ss-lime), var(--ss-blue), var(--ss-violet), var(--ss-lime));
            padding: 3px;
        }

        .hero-badge-dot-inner {
            width: 100%;
            height: 100%;
            border-radius: inherit;
            background: #020617;
        }

        .hero-title {
            font-size: clamp(2.4rem, 3.3vw, 3rem);
            font-weight: 700;
            letter-spacing: -0.04em;
            line-height: 1.05;
            margin-bottom: 1rem;
        }

        .hero-title span.highlight {
            background: linear-gradient(120deg, var(--ss-lime), var(--ss-blue), var(--ss-violet));
            -webkit-background-clip: text;
            color: transparent;
        }

        .hero-lead {
            color: var(--ss-muted);
            max-width: 560px;
            font-size: 0.98rem;
        }

        .hero-metadata {
            display: flex;
            flex-wrap: wrap;
            gap: 1.25rem;
            margin-top: 1.75rem;
        }

        .hero-meta-item {
            font-size: 0.8rem;
            color: var(--ss-muted);
            border-left: 1px solid rgba(148, 163, 184, 0.4);
            padding-left: .85rem;
        }

        .hero-meta-item strong {
            display: block;
            color: var(--ss-ink);
            font-size: 0.82rem;
        }

        .btn-ss-primary {
            background: linear-gradient(130deg, var(--ss-lime), var(--ss-blue));
            border: none;
            color: #020617;
            font-weight: 600;
            box-shadow: 0 0 26px rgba(57, 255, 20, 0.45);
        }

        .btn-ss-primary:hover {
            filter: brightness(1.06);
            box-shadow: 0 0 34px rgba(57, 255, 20, 0.65);
        }

        .btn-ss-ghost {
            border-radius: 999px;
            border: 1px solid rgba(148, 163, 184, 0.6);
            color: var(--ss-muted);
        }

        .hero-cta {
            margin-top: 2rem;
            display: flex;
            flex-wrap: wrap;
            gap: 0.75rem;
            align-items: center;
        }

        .hero-note {
            font-size: 0.8rem;
            color: var(--ss-muted);
        }

        .hero-visual {
            position: relative;
            min-height: 280px;
            border-radius: 24px;
            padding: 1.5rem;
            background: radial-gradient(circle at top, rgba(15, 23, 42, 0.8), rgba(15, 23, 42, 0.98));
            border: 1px solid rgba(148, 163, 184, 0.35);
            box-shadow: 0 35px 80px rgba(15, 23, 42, 0.8);
            overflow: hidden;
        }

        .hero-visual-placeholder {
            position: absolute;
            inset: 0;
            background: radial-gradient(circle at 20% 10%, rgba(57, 255, 20, 0.1), transparent 55%),
                        radial-gradient(circle at 80% 10%, rgba(77, 124, 255, 0.15), transparent 55%),
                        radial-gradient(circle at 40% 90%, rgba(173, 38, 255, 0.22), transparent 50%);
            opacity: 0.85;
        }

        .hero-visual-inner {
            position: relative;
            z-index: 1;
        }

        .hero-visual-tag {
            display: inline-flex;
            align-items: center;
            gap: .4rem;
            font-size: 0.78rem;
            color: var(--ss-muted);
            margin-bottom: .7rem;
        }

        .hero-pill {
            display: inline-flex;
            align-items: center;
            gap: .4rem;
            border-radius: 999px;
            border: 1px solid rgba(148, 163, 184, 0.6);
            padding: .15rem .7rem;
            font-size: 0.72rem;
            color: var(--ss-muted);
            margin-right: .5rem;
            margin-bottom: .4rem;
        }

        .hero-pill-dot {
            width: 7px;
            height: 7px;
            border-radius: 999px;
            background: var(--ss-lime);
        }

        .hero-glass-card {
            border-radius: 18px;
            border: 1px solid rgba(148, 163, 184, 0.3);
            background: linear-gradient(145deg, rgba(15, 23, 42, 0.88), rgba(15, 23, 42, 0.5));
            padding: .9rem 1rem;
            font-size: 0.8rem;
            color: var(--ss-muted);
            margin-top: .5rem;
        }

        .hero-metric {
            display: flex;
            justify-content: space-between;
            margin-bottom: .4rem;
        }

        .hero-metric span.label {
            color: var(--ss-muted);
            font-size: 0.76rem;
        }

        .hero-metric span.value {
            color: var(--ss-ink);
            font-weight: 600;
            font-size: 0.9rem;
        }

        .mini-tag {
            font-size: 0.7rem;
            color: var(--ss-muted);
        }

        /* Sections */
        section {
            position: relative;
            z-index: 1;
        }

        .section-label {
            text-transform: uppercase;
            letter-spacing: 0.12em;
            color: var(--ss-muted);
            font-size: 0.75rem;
            font-weight: 600;
        }

        .section-title {
            font-size: 1.7rem;
            font-weight: 650;
            letter-spacing: -0.03em;
            margin-top: .5rem;
            margin-bottom: .75rem;
        }

        .section-lead {
            color: var(--ss-muted);
            max-width: 640px;
            font-size: 0.96rem;
        }

        .feature-card {
            border-radius: 18px;
            background: rgba(15, 23, 42, 0.9);
            border: 1px solid rgba(148, 163, 184, 0.3);
            padding: 1.4rem 1.35rem;
            height: 100%;
        }

        .feature-icon {
            width: 32px;
            height: 32px;
            border-radius: 11px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            font-size: 1.1rem;
            margin-bottom: .7rem;
            background: radial-gradient(circle at 20% 0, rgba(57,255,20,0.2), rgba(37,99,235,0.4));
        }

        .feature-title {
            font-size: 1rem;
            font-weight: 600;
            margin-bottom: .4rem;
        }

        .feature-text {
            font-size: 0.9rem;
            color: var(--ss-muted);
        }

        .role-chip {
            display: inline-flex;
            align-items: center;
            border-radius: 999px;
            border: 1px solid rgba(148, 163, 184, 0.45);
            padding: .2rem .7rem;
            font-size: 0.78rem;
            color: var(--ss-muted);
            margin-right: .4rem;
            margin-bottom: .4rem;
        }

        .role-chip span.dot {
            width: 7px;
            height: 7px;
            border-radius: 999px;
            margin-right: .35rem;
        }

        .role-chip.organizers span.dot { background: var(--ss-lime); }
        .role-chip.judges span.dot { background: var(--ss-blue); }
        .role-chip.federations span.dot { background: var(--ss-violet); }

        .timeline {
            list-style: none;
            padding-left: 0;
            margin: 0;
            border-left: 1px dashed rgba(148, 163, 184, 0.5);
        }

        .timeline-item {
            padding-left: 1.2rem;
            position: relative;
            margin-bottom: 1.3rem;
        }

        .timeline-dot {
            position: absolute;
            left: -6px;
            top: 0.15rem;
            width: 11px;
            height: 11px;
            border-radius: 999px;
            background: var(--ss-blue);
            box-shadow: 0 0 0 6px rgba(59, 130, 246, 0.25);
        }

        .timeline-label {
            font-size: 0.8rem;
            text-transform: uppercase;
            letter-spacing: .09em;
            color: var(--ss-muted);
        }

        .timeline-title {
            font-size: 0.96rem;
            font-weight: 600;
        }

        .pill-list {
            display: flex;
            flex-wrap: wrap;
            gap: .4rem;
        }

        .pill {
            font-size: 0.8rem;
            padding: .2rem .6rem;
            border-radius: 999px;
            border: 1px solid rgba(148, 163, 184, 0.4);
            color: var(--ss-muted);
        }

        .cta-section {
            border-radius: 22px;
            background: radial-gradient(circle at top left, rgba(57,255,20,0.25), rgba(24,31,54,0.95));
            border: 1px solid rgba(148,163,184,0.5);
            padding: 2.2rem 2rem;
        }

        .footer {
            border-top: 1px solid rgba(148, 163, 184, 0.25);
            padding-top: 1.5rem;
            padding-bottom: 2rem;
            font-size: 0.8rem;
            color: var(--ss-muted);
        }

        .footer a {
            color: var(--ss-muted);
            text-decoration: none;
        }
        .footer a:hover {
            color: var(--ss-ink);
            text-decoration: underline;
        }

        @media (max-width: 991.98px) {
            .hero {
                padding-top: 3.5rem;
            }
            .hero-visual {
                margin-top: 2rem;
            }
        }
    </style>
</head>
<body>

<nav class="navbar navbar-expand-lg sticky-top">
    <div class="container">
        <a class="navbar-brand d-flex align-items-center" href="#">
            <span class="logo-mark">SS</span>
            <span>StyleScore</span>
        </a>
        <button class="navbar-toggler text-light border-secondary" type="button" data-bs-toggle="collapse" data-bs-target="#mainNav">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="mainNav">
            <ul class="navbar-nav ms-auto mb-2 mb-lg-0 me-3">
                <li class="nav-item"><a class="nav-link" href="#what">What it is</a></li>
                <li class="nav-item"><a class="nav-link" href="#workflow">Workflow</a></li>
                <li class="nav-item"><a class="nav-link" href="#features">Features</a></li>
                <li class="nav-item"><a class="nav-link" href="#sports">Sports</a></li>
                <li class="nav-item"><a class="nav-link" href="#contact">Contact</a></li>
            </ul>
            <span class="navbar-text d-none d-lg-inline-flex small text-secondary">
                Freestyle scoring made as dynamic as your tricks.
            </span>
        </div>
    </div>
</nav>

<main>

    <!-- HERO -->
    <section class="hero">
        <div class="container hero-inner">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <div class="hero-badge">
                        <span class="hero-badge-dot"><span class="hero-badge-dot-inner"></span></span>
                        Trusted freestyle scoring engine for winter sports events
                    </div>
                    <h1 class="hero-title">
                        StyleScore – <span class="highlight">freestyle scoring made as dynamic as your tricks.</span>
                    </h1>
                    <p class="hero-lead">
                        StyleScore is a competition management and live scoring system built specifically for freestyle
                        skiing, snowboarding and other judged sports. From bib lists and heats to judges’ panels and
                        live public ranking – everything stays in one, event-ready platform.
                    </p>

                    <div class="hero-cta">
                        <a href="#contact" class="btn btn-ss-primary rounded-pill px-4 py-2">
                            Book a demo event
                        </a>
                        <a href="#features" class="btn btn-ss-ghost px-3 py-2">
                            View key features
                        </a>
                        <div class="hero-note ms-lg-2">
                            For organisers, clubs, federations and timing partners.
                        </div>
                    </div>

                    <div class="hero-metadata">
                        <div class="hero-meta-item">
                            <strong>Built for freestyle</strong>
                            Slopestyle, Big Air, rail jams, snowboard & freeski.
                        </div>
                        <div class="hero-meta-item">
                            <strong>End-to-end workflow</strong>
                            Registration data, heats, runs, judges, results & rankings.
                        </div>
                        <div class="hero-meta-item">
                            <strong>Polish & English UI</strong>
                            Ready for local events and international guests.
                        </div>
                    </div>
                </div>
                <div class="col-lg-5 offset-lg-1">
                    <div class="hero-visual">
                        <div class="hero-visual-placeholder"></div>
                        <div class="hero-visual-inner">

                            <!-- PLACEHOLDER: you can replace this whole block with a dynamic image / mockup -->
                            <div class="hero-visual-tag">
                                <span class="mini-tag">Preview: live competition dashboard</span>
                            </div>

                            <div class="mb-2">
                                <span class="hero-pill">
                                    <span class="hero-pill-dot"></span> Heat 2 · Slopestyle Junior
                                </span>
                                <span class="hero-pill">
                                    Run 2 of 3 · 7 riders
                                </span>
                            </div>

                            <div class="hero-glass-card">
                                <div class="hero-metric">
                                    <span class="label">Current leader</span>
                                    <span class="value">#24  Nowak • 89.33 pts</span>
                                </div>
                                <div class="hero-metric">
                                    <span class="label">Next on course</span>
                                    <span class="value">#31  Kowalski • Run 2</span>
                                </div>
                                <div class="hero-metric">
                                    <span class="label">Judges online</span>
                                    <span class="value">5 / 5 connected</span>
                                </div>
                            </div>

                            <p class="mini-tag mt-3 mb-0">
                                This area can be replaced with your own dynamic screenshot or animation of
                                the StyleScore interface.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- WHAT IS STYLESCORE -->
    <section id="what" class="py-5">
        <div class="container">
            <div class="row mb-4">
                <div class="col-lg-7">
                    <div class="section-label">What is StyleScore?</div>
                    <h2 class="section-title">A complete scoring & event layer for judged winter sports.</h2>
                    <p class="section-lead">
                        StyleScore connects organisers, judges, clubs and athletes in one system. It helps you set up
                        heats and runs, control judging, and publish results in real-time – without losing time on
                        spreadsheets, manual recalculations or last-minute chaos in the judges’ tent.
                    </p>
                </div>
                <div class="col-lg-5">
                    <div class="pill-list">
                        <span class="role-chip organizers">
                            <span class="dot"></span> Event organisers
                        </span>
                        <span class="role-chip judges">
                            <span class="dot"></span> Judges & head judges
                        </span>
                        <span class="role-chip federations">
                            <span class="dot"></span> Federations & clubs
                        </span>
                        <span class="pill">Winter resorts & snowparks</span>
                        <span class="pill">Timing & results partners</span>
                    </div>
                </div>
            </div>

            <div class="row g-4">
                <div class="col-md-4">
                    <div class="feature-card">
                        <div class="feature-icon">🏁</div>
                        <h3 class="feature-title">For organisers</h3>
                        <p class="feature-text mb-2">
                            Create events, categories, heats and runs. Import athlete lists, assign bibs, configure
                            scoring formats and control the entire competition flow in one place.
                        </p>
                        <ul class="feature-text mb-0">
                            <li>Clear structure for heats & runs</li>
                            <li>Support for qualifications and finals</li>
                            <li>Live view for speaker & audience screens</li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="feature-card">
                        <div class="feature-icon">🎧</div>
                        <h3 class="feature-title">For judges</h3>
                        <p class="feature-text mb-2">
                            Each judge gets a focused interface for scoring runs. The head judge can monitor all scores,
                            manage re-runs and approve final results before publishing.
                        </p>
                        <ul class="feature-text mb-0">
                            <li>Multiple judging panels (1–8 judges)</li>
                            <li>Support for different scoring methods</li>
                            <li>Head judge control & overrides</li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="feature-card">
                        <div class="feature-icon">📊</div>
                        <h3 class="feature-title">For federations & clubs</h3>
                        <p class="feature-text mb-2">
                            StyleScore can feed your seasonal rankings, athlete profiles and statistics. Export clean
                            data to your ranking system, website or federation database.
                        </p>
                        <ul class="feature-text mb-0">
                            <li>Season rankings across events</li>
                            <li>Support for point systems & penalties</li>
                            <li>Export to Excel / CSV / PDF</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- WORKFLOW -->
    <section id="workflow" class="py-5">
        <div class="container">
            <div class="row align-items-start mb-4">
                <div class="col-lg-6">
                    <div class="section-label">Event workflow</div>
                    <h2 class="section-title">Built around the way real competitions run.</h2>
                    <p class="section-lead">
                        StyleScore is designed to match how events actually happen: hectic mornings, light changes,
                        weather delays and all. It keeps your structure stable, so the crew can stay focused on safety
                        and the show.
                    </p>
                </div>
                <div class="col-lg-5 offset-lg-1">
                    <p class="section-lead">
                        Below you see a typical flow – from pre-event setup to live scoring and final rankings. The same
                        structure works for small jam sessions and bigger national-level events.
                    </p>
                </div>
            </div>

            <div class="row g-4">
                <div class="col-md-6">
                    <ul class="timeline">
                        <li class="timeline-item">
                            <span class="timeline-dot"></span>
                            <div class="timeline-label">Before the event</div>
                            <div class="timeline-title">Event & heat setup</div>
                            <p class="feature-text mb-1">
                                Define categories (age, gender, discipline), create heats and runs, and assign judges.
                            </p>
                            <ul class="feature-text mb-0">
                                <li>Import registration / federation lists</li>
                                <li>Assign bib numbers and colours</li>
                                <li>Configure scoring type and tie-break rules</li>
                            </ul>
                        </li>

                        <li class="timeline-item">
                            <span class="timeline-dot"></span>
                            <div class="timeline-label">On the hill</div>
                            <div class="timeline-title">Runs & live scoring</div>
                            <p class="feature-text mb-1">
                                Judges score each run in real time. The head judge monitors consistency and validates
                                results before they go public.
                            </p>
                            <ul class="feature-text mb-0">
                                <li>Per-run breakdown for each athlete</li>
                                <li>Automatic ordering by best run / total</li>
                                <li>Speaker-friendly result views</li>
                            </ul>
                        </li>
                    </ul>
                </div>
                <div class="col-md-6">
                    <ul class="timeline">
                        <li class="timeline-item">
                            <span class="timeline-dot"></span>
                            <div class="timeline-label">For the audience</div>
                            <div class="timeline-title">Live & public results</div>
                            <p class="feature-text mb-1">
                                Publish live rankings to screens or web. Viewers see position changes, best runs and
                                cut-lines without having to decode spreadsheets.
                            </p>
                            <ul class="feature-text mb-0">
                                <li>Responsive rankings for mobile screens</li>
                                <li>Heat and category switching</li>
                                <li>Optional branding for your event or partners</li>
                            </ul>
                        </li>

                        <li class="timeline-item">
                            <span class="timeline-dot"></span>
                            <div class="timeline-label">After the event</div>
                            <div class="timeline-title">Reports & rankings</div>
                            <p class="feature-text mb-1">
                                Export full result data for federation rankings or club archives. Build season overviews
                                showing progress of athletes and teams.
                            </p>
                            <ul class="feature-text mb-0">
                                <li>Official result PDFs for publication</li>
                                <li>Data export for federation ranking systems</li>
                                <li>Historical archive of events and athletes</li>
                            </ul>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    <!-- FEATURES -->
    <section id="features" class="py-5">
        <div class="container">
            <div class="row mb-4">
                <div class="col-lg-6">
                    <div class="section-label">Key capabilities</div>
                    <h2 class="section-title">What StyleScore brings to your competition day.</h2>
                    <p class="section-lead">
                        The system is flexible enough for different judging formats and simple enough to run under
                        pressure. Below are some of the core areas organisers usually care about most.
                    </p>
                </div>
            </div>

            <div class="row g-4 mb-3">
                <div class="col-md-6 col-xl-3">
                    <div class="feature-card">
                        <div class="feature-icon">📱</div>
                        <h3 class="feature-title">Live scoring screens</h3>
                        <p class="feature-text mb-0">
                            Clean, responsive result views for speakers, LED screens and mobile devices. No need to
                            mirror spreadsheets or zoom tiny tables.
                        </p>
                    </div>
                </div>
                <div class="col-md-6 col-xl-3">
                    <div class="feature-card">
                        <div class="feature-icon">⚙️</div>
                        <h3 class="feature-title">Flexible scoring formats</h3>
                        <p class="feature-text mb-0">
                            Best-run, sum of runs, qualifier + finals, eliminations – configure how scores are combined
                            without changing the way judges work.
                        </p>
                    </div>
                </div>
                <div class="col-md-6 col-xl-3">
                    <div class="feature-card">
                        <div class="feature-icon">👥</div>
                        <h3 class="feature-title">Multiple judges</h3>
                        <p class="feature-text mb-0">
                            From small local events with one judge to panels of 5–8 judges. Head judge has a dedicated
                            control view to approve or correct scores.
                        </p>
                    </div>
                </div>
                <div class="col-md-6 col-xl-3">
                    <div class="feature-card">
                        <div class="feature-icon">🌍</div>
                        <h3 class="feature-title">Bilingual interface</h3>
                        <p class="feature-text mb-0">
                            Polish and English language support, ready for events with international riders and foreign
                            coaches in the mix.
                        </p>
                    </div>
                </div>
            </div>

            <div class="row g-4">
                <div class="col-md-6">
                    <div class="feature-card">
                        <div class="feature-icon">🧩</div>
                        <h3 class="feature-title">Athlete & club context</h3>
                        <p class="feature-text mb-2">
                            Store athlete data (name, year of birth, club, licence, category) and reuse it across
                            events. Make it easy to track who is progressing from season to season.
                        </p>
                        <ul class="feature-text mb-0">
                            <li>Club and country information</li>
                            <li>Category-based start lists</li>
                            <li>Options for licence and federation IDs</li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="feature-card">
                        <div class="feature-icon">🔗</div>
                        <h3 class="feature-title">Ready for integration</h3>
                        <p class="feature-text mb-2">
                            StyleScore is designed to work alongside registration systems, timing services and federation
                            ranking engines.
                        </p>
                        <ul class="feature-text mb-0">
                            <li>Import participant data from spreadsheets</li>
                            <li>Export results for federation ranking logic</li>
                            <li>Cooperation model for timing & event partners</li>
                        </ul>
                    </div>
                </div>
            </div>

        </div>
    </section>

    <!-- SPORTS -->
    <section id="sports" class="py-5">
        <div class="container">
            <div class="row mb-4 align-items-center">
                <div class="col-lg-7">
                    <div class="section-label">Disciplines</div>
                    <h2 class="section-title">Optimised for freestyle & judged snow sports.</h2>
                    <p class="section-lead">
                        StyleScore was designed together with riders, coaches and event crews. It focuses on the judged,
                        style-driven disciplines where each run is a story – not just a time on the clock.
                    </p>
                </div>
                <div class="col-lg-5">
                    <div class="pill-list">
                        <span class="pill">Snowboard slopestyle</span>
                        <span class="pill">Snowboard Big Air</span>
                        <span class="pill">Freeski slopestyle</span>
                        <span class="pill">Freeski Big Air</span>
                        <span class="pill">Rail jams</span>
                        <span class="pill">Park events & show formats</span>
                        <span class="pill">Custom judged formats</span>
                    </div>
                </div>
            </div>

            <div class="row g-4">
                <div class="col-md-6">
                    <div class="feature-card">
                        <div class="feature-icon">❄️</div>
                        <h3 class="feature-title">Winter-proof by design</h3>
                        <p class="feature-text mb-0">
                            Lightweight web interface works on laptops and tablets in less-than-ideal conditions: cold,
                            snow, flat-light. The structure stays stable even when you need to adjust start lists on the
                            fly.
                        </p>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="feature-card">
                        <div class="feature-icon">🎙️</div>
                        <h3 class="feature-title">Speaker-friendly rankings</h3>
                        <p class="feature-text mb-0">
                            Commentators can see who is leading, who still has another run and what score is needed to
                            move into podium positions – without doing mental math on the mic.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA / CONTACT -->
    <section id="contact" class="py-5">
        <div class="container">
            <div class="cta-section">
                <div class="row align-items-center">
                    <div class="col-lg-7">
                        <div class="section-label">Next steps</div>
                        <h2 class="section-title">Ready to try StyleScore at your next event?</h2>
                        <p class="section-lead mb-3">
                            StyleScore is currently being tested and refined at real competitions. If you are organising
                            freestyle events and want a scoring layer that understands your sport, let’s talk.
                        </p>
                        <ul class="feature-text mb-3">
                            <li>Pilot events with on-site support can be arranged.</li>
                            <li>Cooperation models for federations, clubs and resorts.</li>
                            <li>Integration options for timing and event-production partners.</li>
                        </ul>
                    </div>
                    <div class="col-lg-5">
                        <div class="feature-card">
                            <div class="feature-title mb-2">Contact & demo requests</div>
                            <p class="feature-text mb-2">
                                Send a short description of your event or series, and we will prepare a proposal that
                                matches your format and organisational setup.
                            </p>
                            <p class="feature-text mb-2">
                                <strong>Email:</strong><br>
                                <a href="mailto:info@sport-timing.pl" class="text-decoration-none">
                                    info@sport-timing.pl
                                </a>
                            </p>
                            <p class="feature-text mb-0">
                                <strong>Organisation:</strong><br>
                                Sport-Timing Poland<br>
                                Zakopane, Poland
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

</main>

<footer class="footer">
    <div class="container d-flex flex-column flex-md-row justify-content-between gap-2">
        <div>
            © <span id="year"></span> StyleScore / Sport-Timing Poland. All rights reserved.
        </div>
        <div>
            Part of the freestyle & winter sports technology ecosystem by
            <a href="https://sport-timing.pl" target="_blank" rel="noopener">sport-timing.pl</a>.
        </div>
    </div>
</footer>

<script>
    document.getElementById("year").textContent = new Date().getFullYear();
</script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
