<?php
if(!isset($_SESSION)) { session_start(); }

// db.php includes the getBaseUrl() helper function
require_once __DIR__ . '/includes/db.php';

$baseUrl = getBaseUrl();

// If already logged in, redirect to appropriate dashboard
if (isset($_SESSION['user_logged_in']) && $_SESSION['user_logged_in'] === true) {
    if ($_SESSION['user_type'] === 'admin' || $_SESSION['user_type'] === 'super_admin') {
        header("Location: {$baseUrl}/v2/admin/dashboard.php");
    } elseif ($_SESSION['user_type'] === 'judge') {
        header("Location: {$baseUrl}/v2/judge/dashboard.php");
    }
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - StyleScore</title>
    <?php include_once 'includes/stylesheets.php'; ?>
<!-- style skin holder -->
    <link href="<?= $baseUrl ?>/v2/assets/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .login-container {
            max-width: 400px;
            width: 100%;
            margin: 20px;
        }
        
        .login-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border: none;
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            overflow: hidden;
        }
        
        .login-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 40px 30px 30px;
            text-align: center;
        }
        
        .login-body {
            padding: 40px 30px;
        }
        
        .form-control, .form-select {
            border: 2px solid #e9ecef;
            border-radius: 12px;
            padding: 15px;
            font-size: 16px;
            transition: all 0.3s ease;
            background: #f8f9fa;
        }
        
        .form-control:focus, .form-select:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.15);
            background: white;
        }
        
        .form-label {
            font-weight: 600;
            color: #495057;
            margin-bottom: 8px;
        }
        
        .btn-login {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 12px;
            padding: 15px;
            font-weight: 600;
            font-size: 16px;
            width: 100%;
            transition: all 0.3s ease;
            color: white;
        }
        
        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(102, 126, 234, 0.3);
            color: white;
        }
        
        .alert {
            border-radius: 12px;
            border: none;
            padding: 15px;
        }
        
        .back-link {
            color: white;
            text-decoration: none;
            font-size: 14px;
            opacity: 0.8;
            transition: opacity 0.3s ease;
        }
        
        .back-link:hover {
            opacity: 1;
            color: white;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="border-0 shadow-none card login-card">
            <div class="login-header">
                <h1 class="h3 mb-3">
                    <a class="navbar-brand navbar-brand-logo" href="<?= $baseUrl ?>/v2/dashboard.php">
            <img src="<?= $baseUrl ?>/v2/assets/img/SVG/logo-ss-_2.svg" alt="Logo" class="">
        </a>
                </h1>
                <p class="mb-0 opacity-75">Sign in to continue</p>
            </div>
            
            <div class="login-body">
                <?php if (isset($_GET['error'])): ?>
                    <div class="alert alert-danger mb-4" role="alert">
                        <i class="bi bi-exclamation-triangle-fill me-2"></i>
                        <?php
                        switch($_GET['error']) {
                            case 'missing_fields':
                                echo 'Please fill in all fields.';
                                break;
                            case 'invalid_credentials':
                                echo 'Invalid username or password.';
                                break;
                            case 'unauthorized':
                                echo '<strong>Access Denied</strong><br>';
                                if (isset($_SESSION['unauthorized_required_roles']) && isset($_SESSION['unauthorized_user_role'])) {
                                    $required = $_SESSION['unauthorized_required_roles'];
                                    $current = $_SESSION['unauthorized_user_role'];
                                    $page = $_SESSION['unauthorized_page'] ?? 'the requested page';
                                    
                                    echo '<small class="d-block mt-2">';
                                    echo 'You are logged in as: <span class="badge bg-secondary">' . htmlspecialchars(ucfirst(str_replace('_', ' ', $current))) . '</span><br>';
                                    echo 'Required role(s): ';
                                    foreach ($required as $role) {
                                        echo '<span class="badge bg-danger me-1">' . htmlspecialchars(ucfirst(str_replace('_', ' ', $role))) . '</span>';
                                    }
                                    echo '<br><small class="text-muted">Page: ' . htmlspecialchars(basename($page)) . '</small>';
                                    echo '</small>';
                                    
                                    // Clear session data after displaying
                                    unset($_SESSION['unauthorized_required_roles']);
                                    unset($_SESSION['unauthorized_user_role']);
                                    unset($_SESSION['unauthorized_page']);
                                } else {
                                    echo 'You are not authorized to access that page.';
                                }
                                break;
                            default:
                                echo 'An error occurred. Please try again.';
                        }
                        ?>
                    </div>
                <?php endif; ?>

                <?php if (isset($_GET['message']) && $_GET['message'] === 'logged_out'): ?>
                    <div class="alert alert-success mb-4" role="alert">
                        <i class="bi bi-check-circle-fill me-2"></i>
                        You have been successfully logged out.
                    </div>
                <?php endif; ?>

                <form method="POST" action="<?= $baseUrl ?>/v2/includes/process_login.php">
                    <div class="mb-4">
                        <label for="username" class="form-label">
                            <i class="bi bi-person me-1"></i>
                            Username
                        </label>
                        <input type="text" class="form-control" id="username" name="username" 
                               placeholder="Enter your username" required>
                    </div>
                    
                    <div class="mb-4">
                        <label for="password" class="form-label">
                            <i class="bi bi-lock me-1"></i>
                            Password
                        </label>
                        <input type="password" class="form-control" id="password" name="password" 
                               placeholder="Enter your password" required>
                    </div>

                    <button type="submit" class="btn btn-login">
                        <i class="bi bi-box-arrow-in-right me-2"></i>
                        Sign In
                    </button>
                </form>
                
                <!-- Server Information -->
                <div class="mt-4 pt-3 border-top text-center">
                    <small class="text-muted d-block mb-2">
                        <i class="bi bi-server me-1"></i>
                        <strong>Server:</strong> 
                        <span class="badge bg-light text-dark"><?php echo $_SERVER['SERVER_ADDR'] ?? $_SERVER['LOCAL_ADDR'] ?? 'N/A'; ?></span>
                    </small>
                    <small class="text-muted d-block">
                        <i class="bi bi-wifi me-1"></i>
                        <strong>Connection:</strong> 
                        <span class="badge" id="connectionType">Checking...</span>
                    </small>
                </div>
               
            </div>
        </div>
    </div>

    <script src="<?= $baseUrl ?>/v2/assets/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script>
        // Detect connection type (local network vs internet)
        function detectConnectionType() {
            const serverIP = '<?php echo $_SERVER['SERVER_ADDR'] ?? $_SERVER['LOCAL_ADDR'] ?? ''; ?>';
            const clientIP = '<?php echo $_SERVER['REMOTE_ADDR'] ?? ''; ?>';
            const hostname = window.location.hostname;
            
            const badge = document.getElementById('connectionType');
            
            // Check if accessing via localhost or local IP
            const isLocalhost = hostname === 'localhost' || hostname === '127.0.0.1' || hostname === '::1';
            const isLocalIP = /^(10\.|172\.(1[6-9]|2[0-9]|3[0-1])\.|192\.168\.)/.test(hostname);
            
            if (isLocalhost) {
                badge.textContent = 'Local Machine';
                badge.className = 'badge bg-success';
            } else if (isLocalIP) {
                badge.textContent = 'Local Network (LAN)';
                badge.className = 'badge bg-info';
            } else {
                badge.textContent = 'Internet';
                badge.className = 'badge bg-warning text-dark';
            }
        }
        
        // Run on page load
        detectConnectionType();
    </script>
</body>
</html>