<?php
/**
 * Event Access Validation
 * Include this file on pages that require event_id validation
 * 
 * This file:
 * - Validates current event_id against user's assigned events
 * - Clears invalid cookies and redirects if access denied
 * - Must be included AFTER session_start() and db.php
 */

if (!isset($_SESSION)) {
    session_start();
}

require_once __DIR__ . '/event_access.php';

// Get event_id from various sources
$event_id = $_GET['event_id'] ?? $_COOKIE['selectedEventId'] ?? $_COOKIE['event_id'] ?? null;

// If event_id exists, validate access
if ($event_id) {
    if (!hasEventAccess($event_id)) {
        // User doesn't have access to this event
        
        // Use JavaScript to clear cookies and localStorage (avoid header issues)
        echo '<script>
            // Clear localStorage
            if (typeof localStorage !== "undefined") {
                localStorage.removeItem("selectedEventId");
                localStorage.removeItem("event_id");
            }
            // Clear cookies
            document.cookie = "event_id=;expires=Thu, 01 Jan 1970 00:00:00 UTC;path=/;SameSite=Lax";
            document.cookie = "selectedEventId=;expires=Thu, 01 Jan 1970 00:00:00 UTC;path=/;SameSite=Lax";
        </script>';
        
        // Get first accessible event for redirect
        $accessible_events = getUserAccessibleEvents();
        
        if (empty($accessible_events)) {
            // Admin - redirect to event list
            header('Location: events.php?error=access_denied');
        } else {
            // Non-admin - redirect to first accessible event or event list if none
            if (count($accessible_events) > 0) {
                $first_event_id = $accessible_events[0];
                header('Location: ' . $_SERVER['PHP_SELF'] . '?event_id=' . $first_event_id . '&error=access_denied');
            } else {
                header('Location: events.php?error=no_events_assigned');
            }
        }
        exit;
    }
}
?>
