<?php
/**
 * StyleScore System Stylesheets
 * Centralized stylesheet management to ensure consistency across all pages
 * 
 * Usage: Include this file in the <head> section of any page that needs StyleScore styling
 * Example: <?php include_once __DIR__ . '/includes/stylesheets.php'; ?>
 */

// Ensure btTheme function is available

// Prevent duplicate includes

    
    // Get current theme
    //$currentTheme = btTheme('nameCode');
    ?>
    <!-- Lexend Font (Offline) -->
    <link href="/v2/assets/css/lexend-font-local.css" rel="stylesheet">
    <!-- Satoshi Font (Offline) -->
    <link href="/v2/assets/fonts/satoshi-webfont/style.css" rel="stylesheet">
    <!-- StyleScore System Stylesheets -->
    <!-- Bootstrap Theme (Bootswatch) -->
    <link id="" href="/v2/assets/bootswatch/zephyr/bootstrap.min.css" rel="stylesheet">
    <link href="/v2/assets/css/global.css" rel="stylesheet">
    
    <!-- Lucide Icons (Offline) -->
    <script src="/v2/assets/js/lucide.min.js"></script>
    
    <!-- Font Awesome Icons (Offline) -->
    <link rel="stylesheet" href="/v2/assets/css/fontawesome.min.css">
    
    <!-- StyleScore Notification Manager -->
    <script src="/v2/assets/js/notification_manager.js"></script>
    
    <!-- Bootstrap Icons (Offline) -->
    <link rel="stylesheet" href="/v2/assets/css/bootstrap-icons.min.css">
    
    <!-- StyleScore Background Themes -->
    <link rel="stylesheet" href="/v2/assets/css/backgrounds.css">
    
    <!-- Country Flag Emoji Polyfill (Offline) -->
    <script type="module" src="/v2/assets/js/country-flag-polyfill.js"></script>
    
    <!-- StyleScore Custom Styles -->
    <style>
        @font-face {
      font-family: "Twemoji Country Flags";
      src: url("/v2/assets/fonts/TwemojiCountryFlags.woff2") format("woff2");
      unicode-range: U+1F1E6-1F1FF, U+1F3F4, U+E0062-E0063, U+E0065, U+E0067,
        U+E006C, U+E006E, U+E0073-E0074, U+E0077, U+E007F;     
      font-display: swap;
    }
        /* Global StyleScore System Variables */
        :root {
            --ss-primary: #007bff;
            --ss-secondary: #6c757d;
            --ss-success: #28a745;
            --ss-danger: #dc3545;
            --ss-warning: #ffc107;
            --ss-info: #17a2b8;
            --ss-light: #f8f9fa;
            --ss-dark: #343a40;
            --ss-accent: #39FF14; /* StyleScore Neon Lime */
            
            /* Menu and Navigation */
            --ss-sidebar-bg: linear-gradient(180deg, #1a1a2e 0%, #16213e 50%, #0f3460 100%);
            --ss-sidebar-text: #EAF2FF;
            --ss-sidebar-icon: #9FB0C9;
            --ss-sidebar-icon-active: #39FF14;
        }
        
        /* Live Badge Animation */
        .pulse {
            animation: pulse 2s infinite;
        }
        
        @keyframes pulse {
            0% { opacity: 1; }
            50% { opacity: 0.5; }
            100% { opacity: 1; }
        }
        
        /* StyleScore Button Variants */
        .btn-ss-primary {
            background: linear-gradient(135deg, var(--ss-primary) 0%, #0056b3 100%);
            border: none;
            color: white;
        }
        .bg-ss-gradient {
           background: #B0F761;
            /*background: linear-gradient(270deg,rgba(176, 247, 97, 1) 0%, rgba(76, 190, 201, 1) 21%, rgba(25, 162, 255, 1) 82%, rgba(52, 89, 230, 1) 100%);
        }*/
            background: linear-gradient(270deg,rgba(76, 190, 201, 1) 21%, rgba(25, 162, 255, 1) 82%, rgba(52, 89, 230, 1) 100%);
            background-size: 400% 400%;
            animation: gradientBG 15s ease infinite;
        }
        .btn-ss-accent {
            background: var(--ss-accent);
            border: none;
            color: #000;
            font-weight: 600;
        }
        
        .btn-ss-accent:hover {
            background: #2ee000;
            color: #000;
        }
        
        /* Consistent form styling */
        .form-control:focus {
            border-color: var(--ss-accent);
            box-shadow: 0 0 0 0.2rem rgba(57, 255, 20, 0.25);
        }
        
        /* Loading states */
        .loading {
            opacity: 0.6;
            pointer-events: none;
            position: relative;
        }
        
        .loading::after {
            content: '';
            position: absolute;
            inset: 0;
            background: rgba(255,255,255,0.8);
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: inherit;
        }
        .btn{    font-size: clamp(0.8rem, 0.325rem + 1vw, .95rem);}

        
        /* Responsive text sizing */
        @media (max-width: 768px) {
            .display-1, .display-2, .display-3, .display-4, .display-5, .display-6 {
                font-size: calc(1.375rem + 1.5vw);
            }
        }
        
        /* Print styles */
        @media print {
            .no-print, .sidebar-nav, .navbar, .btn, .alert {
                display: none !important;
            }
            
            body {
                padding-left: 0 !important;
            }
        }
    </style>
    
