<?php
if (!isset($_SESSION)) { session_start(); }

require_once __DIR__ . '/db.php';

$baseUrl = getBaseUrl();

// Check if using token-based login (new secure method)
if (isset($_GET['token'])) {
    $token = $_GET['token'];
    
    try {
        // Validate token
        $stmt = $pdo->prepare("
            SELECT qlt.*, u.username, u.role 
            FROM qr_login_tokens qlt
            JOIN users u ON qlt.user_id = u.id
            WHERE qlt.token = ? 
            AND qlt.expires_at > NOW() 
            AND qlt.used_at IS NULL
        ");
        $stmt->execute([$token]);
        $token_data = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if (!$token_data) {
            header("Location: {$baseUrl}/v2/login.php?error=invalid_or_expired_token");
            exit;
        }
        
        // Mark token as used
        $mark_used = $pdo->prepare("UPDATE qr_login_tokens SET used_at = NOW() WHERE token = ?");
        $mark_used->execute([$token]);
        
        // Log the user in
        $_SESSION['user_id'] = $token_data['user_id'];
        $_SESSION['username'] = $token_data['username'];
        $_SESSION['role'] = $token_data['role'];
        $_SESSION['user_type'] = $token_data['user_type'];
        
        // Redirect based on role
        if ($token_data['role'] === 'judge' || $token_data['role'] === 'head_judge') {
            header("Location: {$baseUrl}/v2/judge/score.php");
        } else {
            header("Location: {$baseUrl}/v2/dashboard.php");
        }
        exit;
        
    } catch (Exception $e) {
        error_log("QR Token Login Error: " . $e->getMessage());
        header("Location: {$baseUrl}/v2/login.php?error=token_error");
        exit;
    }
}

// Legacy method: Plain-text password in URL (for backward compatibility)
$user_type = $_GET['user_type'] ?? '';
$username  = $_GET['username'] ?? '';
$password  = $_GET['password'] ?? '';

// Only allow judge QR logins
if ($user_type !== 'judge' || $username === '' || $password === '') {
    header("Location: {$baseUrl}/v2/login.php?error=missing_fields");
    exit;
}

// Emulate a normal POST login to reuse existing logic
$_POST['user_type'] = 'judge';
$_POST['username']  = $username;
$_POST['password']  = $password;
$_SERVER['REQUEST_METHOD'] = 'POST';

// Hand off to the existing processor (will redirect on success/failure)
require __DIR__ . '/process_login.php';
exit;
