<?php
// Include application configuration
require_once __DIR__ . '/config.php';

/*

PRoduction database configuration DO
$host = 'localhost';
$db = 'freestyle_db';
$user = 'stylescore_user';
$pass = 'Space1983!';
$dsn = "mysql:host=$host;dbname=$db;charset=utf8mb4";
*/

// Database configuration
$host = 'localhost';
$db = 'freestyle_db';
$user = 'root';
$pass = '';
$dsn = "mysql:host=$host;dbname=$db;charset=utf8mb4";

try {
    $pdo = new PDO($dsn, $user, $pass);
} catch (PDOException $e) {
    die('Connection failed: ' . $e->getMessage());
}

// Include notification configuration (set NOTIFICATIONS_DISABLED constant)
if (file_exists(__DIR__ . '/../config/notifications.php')) {
    require_once __DIR__ . '/../config/notifications.php';
}

// Include notification system configuration (PHP logic only)
require_once __DIR__ . '/notifications_config.php';

// Helper function to get base URL with port preservation
if (!function_exists('getBaseUrl')) {
    function getBaseUrl() {
        // Detect protocol with multiple checks for proxy/load balancer scenarios
        $protocol = 'http';

        if (
            (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ||
            (!empty($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] === 'https') ||
            (!empty($_SERVER['HTTP_X_FORWARDED_SSL']) && $_SERVER['HTTP_X_FORWARDED_SSL'] === 'on') ||
            (isset($_SERVER['SERVER_PORT']) && $_SERVER['SERVER_PORT'] == '443')
        ) {
            $protocol = 'https';
        }

        // Get current host (strip any port)
        $host = $_SERVER['SERVER_NAME'] ?? $_SERVER['HTTP_HOST'] ?? 'localhost';
        if (strpos($host, ':') !== false) {
            $host = explode(':', $host)[0];
        }

        // If force HTTPS is enabled for production domain, hard-code clean HTTPS URL
        if (defined('FORCE_HTTPS') && FORCE_HTTPS === true && defined('PRODUCTION_DOMAIN') && $host === PRODUCTION_DOMAIN) {
            return 'https://' . $host;
        }

        // Fallback: append non-standard ports only
        $port = $_SERVER['SERVER_PORT'] ?? '';
        if (($protocol === 'http' && $port !== '' && $port !== '80') ||
            ($protocol === 'https' && $port !== '' && $port !== '443')) {
            return $protocol . '://' . $host . ':' . $port;
        }

        return $protocol . '://' . $host;
    }
}

// Helper function to resolve relative URLs to absolute URLs
if (!function_exists('resolveUrl')) {
    function resolveUrl($path) {
        // If already absolute URL, return as-is
        if (preg_match('/^https?:\/\//', $path)) {
            return $path;
        }
        
        // Build absolute URL using base URL
        $baseUrl = getBaseUrl();
        
        // Ensure path starts with /
        if (strpos($path, '/') !== 0) {
            $path = '/' . $path;
        }
        
        return $baseUrl . $path;
    }
}
?>