<?php
/**
 * Country Codes with Emoji Flags
 * For use in select fields for participant create/edit forms
 */

$countries = [
    'AD' => ['name' => 'Andorra', 'emoji' => '🇦🇩'],
    'AE' => ['name' => 'United Arab Emirates', 'emoji' => '🇦🇪'],
    'AF' => ['name' => 'Afghanistan', 'emoji' => '🇦🇫'],
    'AG' => ['name' => 'Antigua and Barbuda', 'emoji' => '🇦🇬'],
    'AI' => ['name' => 'Anguilla', 'emoji' => '🇦🇮'],
    'AL' => ['name' => 'Albania', 'emoji' => '🇦🇱'],
    'AM' => ['name' => 'Armenia', 'emoji' => '🇦🇲'],
    'AO' => ['name' => 'Angola', 'emoji' => '🇦🇴'],
    'AQ' => ['name' => 'Antarctica', 'emoji' => '🇦🇶'],
    'AR' => ['name' => 'Argentina', 'emoji' => '🇦🇷'],
    'AS' => ['name' => 'American Samoa', 'emoji' => '🇦🇸'],
    'AT' => ['name' => 'Austria', 'emoji' => '🇦🇹'],
    'AU' => ['name' => 'Australia', 'emoji' => '🇦🇺'],
    'AW' => ['name' => 'Aruba', 'emoji' => '🇦🇼'],
    'AX' => ['name' => 'Åland Islands', 'emoji' => '🇦🇽'],
    'AZ' => ['name' => 'Azerbaijan', 'emoji' => '🇦🇿'],
    'BA' => ['name' => 'Bosnia and Herzegovina', 'emoji' => '🇧🇦'],
    'BB' => ['name' => 'Barbados', 'emoji' => '🇧🇧'],
    'BD' => ['name' => 'Bangladesh', 'emoji' => '🇧🇩'],
    'BE' => ['name' => 'Belgium', 'emoji' => '🇧🇪'],
    'BF' => ['name' => 'Burkina Faso', 'emoji' => '🇧🇫'],
    'BG' => ['name' => 'Bulgaria', 'emoji' => '🇧🇬'],
    'BH' => ['name' => 'Bahrain', 'emoji' => '🇧🇭'],
    'BI' => ['name' => 'Burundi', 'emoji' => '🇧🇮'],
    'BJ' => ['name' => 'Benin', 'emoji' => '🇧🇯'],
    'BL' => ['name' => 'Saint Barthélemy', 'emoji' => '🇧🇱'],
    'BM' => ['name' => 'Bermuda', 'emoji' => '🇧🇲'],
    'BN' => ['name' => 'Brunei', 'emoji' => '🇧🇳'],
    'BO' => ['name' => 'Bolivia', 'emoji' => '🇧🇴'],
    'BQ' => ['name' => 'Caribbean Netherlands', 'emoji' => '🇧🇶'],
    'BR' => ['name' => 'Brazil', 'emoji' => '🇧🇷'],
    'BS' => ['name' => 'Bahamas', 'emoji' => '🇧🇸'],
    'BT' => ['name' => 'Bhutan', 'emoji' => '🇧🇹'],
    'BV' => ['name' => 'Bouvet Island', 'emoji' => '🇧🇻'],
    'BW' => ['name' => 'Botswana', 'emoji' => '🇧🇼'],
    'BY' => ['name' => 'Belarus', 'emoji' => '🇧🇾'],
    'BZ' => ['name' => 'Belize', 'emoji' => '🇧🇿'],
    'CA' => ['name' => 'Canada', 'emoji' => '🇨🇦'],
    'CC' => ['name' => 'Cocos Islands', 'emoji' => '🇨🇨'],
    'CD' => ['name' => 'Democratic Republic of the Congo', 'emoji' => '🇨🇩'],
    'CF' => ['name' => 'Central African Republic', 'emoji' => '🇨🇫'],
    'CG' => ['name' => 'Republic of the Congo', 'emoji' => '🇨🇬'],
    'CH' => ['name' => 'Switzerland', 'emoji' => '🇨🇭'],
    'CI' => ['name' => 'Côte d\'Ivoire', 'emoji' => '🇨🇮'],
    'CK' => ['name' => 'Cook Islands', 'emoji' => '🇨🇰'],
    'CL' => ['name' => 'Chile', 'emoji' => '🇨🇱'],
    'CM' => ['name' => 'Cameroon', 'emoji' => '🇨🇲'],
    'CN' => ['name' => 'China', 'emoji' => '🇨🇳'],
    'CO' => ['name' => 'Colombia', 'emoji' => '🇨🇴'],
    'CR' => ['name' => 'Costa Rica', 'emoji' => '🇨🇷'],
    'CU' => ['name' => 'Cuba', 'emoji' => '🇨🇺'],
    'CV' => ['name' => 'Cape Verde', 'emoji' => '🇨🇻'],
    'CW' => ['name' => 'Curaçao', 'emoji' => '🇨🇼'],
    'CX' => ['name' => 'Christmas Island', 'emoji' => '🇨🇽'],
    'CY' => ['name' => 'Cyprus', 'emoji' => '🇨🇾'],
    'CZ' => ['name' => 'Czech Republic', 'emoji' => '🇨🇿'],
    'DE' => ['name' => 'Germany', 'emoji' => '🇩🇪'],
    'DJ' => ['name' => 'Djibouti', 'emoji' => '🇩🇯'],
    'DK' => ['name' => 'Denmark', 'emoji' => '🇩🇰'],
    'DM' => ['name' => 'Dominica', 'emoji' => '🇩🇲'],
    'DO' => ['name' => 'Dominican Republic', 'emoji' => '🇩🇴'],
    'DZ' => ['name' => 'Algeria', 'emoji' => '🇩🇿'],
    'EC' => ['name' => 'Ecuador', 'emoji' => '🇪🇨'],
    'EE' => ['name' => 'Estonia', 'emoji' => '🇪🇪'],
    'EG' => ['name' => 'Egypt', 'emoji' => '🇪🇬'],
    'EH' => ['name' => 'Western Sahara', 'emoji' => '🇪🇭'],
    'ER' => ['name' => 'Eritrea', 'emoji' => '🇪🇷'],
    'ES' => ['name' => 'Spain', 'emoji' => '🇪🇸'],
    'ET' => ['name' => 'Ethiopia', 'emoji' => '🇪🇹'],
    'FI' => ['name' => 'Finland', 'emoji' => '🇫🇮'],
    'FJ' => ['name' => 'Fiji', 'emoji' => '🇫🇯'],
    'FK' => ['name' => 'Falkland Islands', 'emoji' => '🇫🇰'],
    'FM' => ['name' => 'Micronesia', 'emoji' => '🇫🇲'],
    'FO' => ['name' => 'Faroe Islands', 'emoji' => '🇫🇴'],
    'FR' => ['name' => 'France', 'emoji' => '🇫🇷'],
    'GA' => ['name' => 'Gabon', 'emoji' => '🇬🇦'],
    'GB' => ['name' => 'United Kingdom', 'emoji' => '🇬🇧'],
    'GD' => ['name' => 'Grenada', 'emoji' => '🇬🇩'],
    'GE' => ['name' => 'Georgia', 'emoji' => '🇬🇪'],
    'GF' => ['name' => 'French Guiana', 'emoji' => '🇬🇫'],
    'GG' => ['name' => 'Guernsey', 'emoji' => '🇬🇬'],
    'GH' => ['name' => 'Ghana', 'emoji' => '🇬🇭'],
    'GI' => ['name' => 'Gibraltar', 'emoji' => '🇬🇮'],
    'GL' => ['name' => 'Greenland', 'emoji' => '🇬🇱'],
    'GM' => ['name' => 'Gambia', 'emoji' => '🇬🇲'],
    'GN' => ['name' => 'Guinea', 'emoji' => '🇬🇳'],
    'GP' => ['name' => 'Guadeloupe', 'emoji' => '🇬🇵'],
    'GQ' => ['name' => 'Equatorial Guinea', 'emoji' => '🇬🇶'],
    'GR' => ['name' => 'Greece', 'emoji' => '🇬🇷'],
    'GS' => ['name' => 'South Georgia and the South Sandwich Islands', 'emoji' => '🇬🇸'],
    'GT' => ['name' => 'Guatemala', 'emoji' => '🇬🇹'],
    'GU' => ['name' => 'Guam', 'emoji' => '🇬🇺'],
    'GW' => ['name' => 'Guinea-Bissau', 'emoji' => '🇬🇼'],
    'GY' => ['name' => 'Guyana', 'emoji' => '🇬🇾'],
    'HK' => ['name' => 'Hong Kong', 'emoji' => '🇭🇰'],
    'HM' => ['name' => 'Heard Island and McDonald Islands', 'emoji' => '🇭🇲'],
    'HN' => ['name' => 'Honduras', 'emoji' => '🇭🇳'],
    'HR' => ['name' => 'Croatia', 'emoji' => '🇭🇷'],
    'HT' => ['name' => 'Haiti', 'emoji' => '🇭🇹'],
    'HU' => ['name' => 'Hungary', 'emoji' => '🇭🇺'],
    'ID' => ['name' => 'Indonesia', 'emoji' => '🇮🇩'],
    'IE' => ['name' => 'Ireland', 'emoji' => '🇮🇪'],
    'IL' => ['name' => 'Israel', 'emoji' => '🇮🇱'],
    'IM' => ['name' => 'Isle of Man', 'emoji' => '🇮🇲'],
    'IN' => ['name' => 'India', 'emoji' => '🇮🇳'],
    'IO' => ['name' => 'British Indian Ocean Territory', 'emoji' => '🇮🇴'],
    'IQ' => ['name' => 'Iraq', 'emoji' => '🇮🇶'],
    'IR' => ['name' => 'Iran', 'emoji' => '🇮🇷'],
    'IS' => ['name' => 'Iceland', 'emoji' => '🇮🇸'],
    'IT' => ['name' => 'Italy', 'emoji' => '🇮🇹'],
    'JE' => ['name' => 'Jersey', 'emoji' => '🇯🇪'],
    'JM' => ['name' => 'Jamaica', 'emoji' => '🇯🇲'],
    'JO' => ['name' => 'Jordan', 'emoji' => '🇯🇴'],
    'JP' => ['name' => 'Japan', 'emoji' => '🇯🇵'],
    'KE' => ['name' => 'Kenya', 'emoji' => '🇰🇪'],
    'KG' => ['name' => 'Kyrgyzstan', 'emoji' => '🇰🇬'],
    'KH' => ['name' => 'Cambodia', 'emoji' => '🇰🇭'],
    'KI' => ['name' => 'Kiribati', 'emoji' => '🇰🇮'],
    'KM' => ['name' => 'Comoros', 'emoji' => '🇰🇲'],
    'KN' => ['name' => 'Saint Kitts and Nevis', 'emoji' => '🇰🇳'],
    'KP' => ['name' => 'North Korea', 'emoji' => '🇰🇵'],
    'KR' => ['name' => 'South Korea', 'emoji' => '🇰🇷'],
    'KW' => ['name' => 'Kuwait', 'emoji' => '🇰🇼'],
    'KY' => ['name' => 'Cayman Islands', 'emoji' => '🇰🇾'],
    'KZ' => ['name' => 'Kazakhstan', 'emoji' => '🇰🇿'],
    'LA' => ['name' => 'Laos', 'emoji' => '🇱🇦'],
    'LB' => ['name' => 'Lebanon', 'emoji' => '🇱🇧'],
    'LC' => ['name' => 'Saint Lucia', 'emoji' => '🇱🇨'],
    'LI' => ['name' => 'Liechtenstein', 'emoji' => '🇱🇮'],
    'LK' => ['name' => 'Sri Lanka', 'emoji' => '🇱🇰'],
    'LR' => ['name' => 'Liberia', 'emoji' => '🇱🇷'],
    'LS' => ['name' => 'Lesotho', 'emoji' => '🇱🇸'],
    'LT' => ['name' => 'Lithuania', 'emoji' => '🇱🇹'],
    'LU' => ['name' => 'Luxembourg', 'emoji' => '🇱🇺'],
    'LV' => ['name' => 'Latvia', 'emoji' => '🇱🇻'],
    'LY' => ['name' => 'Libya', 'emoji' => '🇱🇾'],
    'MA' => ['name' => 'Morocco', 'emoji' => '🇲🇦'],
    'MC' => ['name' => 'Monaco', 'emoji' => '🇲🇨'],
    'MD' => ['name' => 'Moldova', 'emoji' => '🇲🇩'],
    'ME' => ['name' => 'Montenegro', 'emoji' => '🇲🇪'],
    'MF' => ['name' => 'Saint Martin', 'emoji' => '🇲🇫'],
    'MG' => ['name' => 'Madagascar', 'emoji' => '🇲🇬'],
    'MH' => ['name' => 'Marshall Islands', 'emoji' => '🇲🇭'],
    'MK' => ['name' => 'North Macedonia', 'emoji' => '🇲🇰'],
    'ML' => ['name' => 'Mali', 'emoji' => '🇲🇱'],
    'MM' => ['name' => 'Myanmar', 'emoji' => '🇲🇲'],
    'MN' => ['name' => 'Mongolia', 'emoji' => '🇲🇳'],
    'MO' => ['name' => 'Macao', 'emoji' => '🇲🇴'],
    'MP' => ['name' => 'Northern Mariana Islands', 'emoji' => '🇲🇵'],
    'MQ' => ['name' => 'Martinique', 'emoji' => '🇲🇶'],
    'MR' => ['name' => 'Mauritania', 'emoji' => '🇲🇷'],
    'MS' => ['name' => 'Montserrat', 'emoji' => '🇲🇸'],
    'MT' => ['name' => 'Malta', 'emoji' => '🇲🇹'],
    'MU' => ['name' => 'Mauritius', 'emoji' => '🇲🇺'],
    'MV' => ['name' => 'Maldives', 'emoji' => '🇲🇻'],
    'MW' => ['name' => 'Malawi', 'emoji' => '🇲🇼'],
    'MX' => ['name' => 'Mexico', 'emoji' => '🇲🇽'],
    'MY' => ['name' => 'Malaysia', 'emoji' => '🇲🇾'],
    'MZ' => ['name' => 'Mozambique', 'emoji' => '🇲🇿'],
    'NA' => ['name' => 'Namibia', 'emoji' => '🇳🇦'],
    'NC' => ['name' => 'New Caledonia', 'emoji' => '🇳🇨'],
    'NE' => ['name' => 'Niger', 'emoji' => '🇳🇪'],
    'NF' => ['name' => 'Norfolk Island', 'emoji' => '🇳🇫'],
    'NG' => ['name' => 'Nigeria', 'emoji' => '🇳🇬'],
    'NI' => ['name' => 'Nicaragua', 'emoji' => '🇳🇮'],
    'NL' => ['name' => 'Netherlands', 'emoji' => '🇳🇱'],
    'NO' => ['name' => 'Norway', 'emoji' => '🇳🇴'],
    'NP' => ['name' => 'Nepal', 'emoji' => '🇳🇵'],
    'NR' => ['name' => 'Nauru', 'emoji' => '🇳🇷'],
    'NU' => ['name' => 'Niue', 'emoji' => '🇳🇺'],
    'NZ' => ['name' => 'New Zealand', 'emoji' => '🇳🇿'],
    'OM' => ['name' => 'Oman', 'emoji' => '🇴🇲'],
    'PA' => ['name' => 'Panama', 'emoji' => '🇵🇦'],
    'PE' => ['name' => 'Peru', 'emoji' => '🇵🇪'],
    'PF' => ['name' => 'French Polynesia', 'emoji' => '🇵🇫'],
    'PG' => ['name' => 'Papua New Guinea', 'emoji' => '🇵🇬'],
    'PH' => ['name' => 'Philippines', 'emoji' => '🇵🇭'],
    'PK' => ['name' => 'Pakistan', 'emoji' => '🇵🇰'],
    'PL' => ['name' => 'Poland', 'emoji' => '🇵🇱'],
    'PM' => ['name' => 'Saint Pierre and Miquelon', 'emoji' => '🇵🇲'],
    'PN' => ['name' => 'Pitcairn', 'emoji' => '🇵🇳'],
    'PR' => ['name' => 'Puerto Rico', 'emoji' => '🇵🇷'],
    'PS' => ['name' => 'Palestinian Territory', 'emoji' => '🇵🇸'],
    'PT' => ['name' => 'Portugal', 'emoji' => '🇵🇹'],
    'PW' => ['name' => 'Palau', 'emoji' => '🇵🇼'],
    'PY' => ['name' => 'Paraguay', 'emoji' => '🇵🇾'],
    'QA' => ['name' => 'Qatar', 'emoji' => '🇶🇦'],
    'RE' => ['name' => 'Réunion', 'emoji' => '🇷🇪'],
    'RO' => ['name' => 'Romania', 'emoji' => '🇷🇴'],
    'RS' => ['name' => 'Serbia', 'emoji' => '🇷🇸'],
    'RU' => ['name' => 'Russia', 'emoji' => '🇷🇺'],
    'RW' => ['name' => 'Rwanda', 'emoji' => '🇷🇼'],
    'SA' => ['name' => 'Saudi Arabia', 'emoji' => '🇸🇦'],
    'SB' => ['name' => 'Solomon Islands', 'emoji' => '🇸🇧'],
    'SC' => ['name' => 'Seychelles', 'emoji' => '🇸🇨'],
    'SD' => ['name' => 'Sudan', 'emoji' => '🇸🇩'],
    'SE' => ['name' => 'Sweden', 'emoji' => '🇸🇪'],
    'SG' => ['name' => 'Singapore', 'emoji' => '🇸🇬'],
    'SH' => ['name' => 'Saint Helena', 'emoji' => '🇸🇭'],
    'SI' => ['name' => 'Slovenia', 'emoji' => '🇸🇮'],
    'SJ' => ['name' => 'Svalbard and Jan Mayen', 'emoji' => '🇸🇯'],
    'SK' => ['name' => 'Slovakia', 'emoji' => '🇸🇰'],
    'SL' => ['name' => 'Sierra Leone', 'emoji' => '🇸🇱'],
    'SM' => ['name' => 'San Marino', 'emoji' => '🇸🇲'],
    'SN' => ['name' => 'Senegal', 'emoji' => '🇸🇳'],
    'SO' => ['name' => 'Somalia', 'emoji' => '🇸🇴'],
    'SR' => ['name' => 'Suriname', 'emoji' => '🇸🇷'],
    'SS' => ['name' => 'South Sudan', 'emoji' => '🇸🇸'],
    'ST' => ['name' => 'São Tomé and Príncipe', 'emoji' => '🇸🇹'],
    'SV' => ['name' => 'El Salvador', 'emoji' => '🇸🇻'],
    'SX' => ['name' => 'Sint Maarten', 'emoji' => '🇸🇽'],
    'SY' => ['name' => 'Syria', 'emoji' => '🇸🇾'],
    'SZ' => ['name' => 'Eswatini', 'emoji' => '🇸🇿'],
    'TC' => ['name' => 'Turks and Caicos Islands', 'emoji' => '🇹🇨'],
    'TD' => ['name' => 'Chad', 'emoji' => '🇹🇩'],
    'TF' => ['name' => 'French Southern Territories', 'emoji' => '🇹🇫'],
    'TG' => ['name' => 'Togo', 'emoji' => '🇹🇬'],
    'TH' => ['name' => 'Thailand', 'emoji' => '🇹🇭'],
    'TJ' => ['name' => 'Tajikistan', 'emoji' => '🇹🇯'],
    'TK' => ['name' => 'Tokelau', 'emoji' => '🇹🇰'],
    'TL' => ['name' => 'Timor-Leste', 'emoji' => '🇹🇱'],
    'TM' => ['name' => 'Turkmenistan', 'emoji' => '🇹🇲'],
    'TN' => ['name' => 'Tunisia', 'emoji' => '🇹🇳'],
    'TO' => ['name' => 'Tonga', 'emoji' => '🇹🇴'],
    'TR' => ['name' => 'Turkey', 'emoji' => '🇹🇷'],
    'TT' => ['name' => 'Trinidad and Tobago', 'emoji' => '🇹🇹'],
    'TV' => ['name' => 'Tuvalu', 'emoji' => '🇹🇻'],
    'TW' => ['name' => 'Taiwan', 'emoji' => '🇹🇼'],
    'TZ' => ['name' => 'Tanzania', 'emoji' => '🇹🇿'],
    'UA' => ['name' => 'Ukraine', 'emoji' => '🇺🇦'],
    'UG' => ['name' => 'Uganda', 'emoji' => '🇺🇬'],
    'UM' => ['name' => 'United States Minor Outlying Islands', 'emoji' => '🇺🇲'],
    'US' => ['name' => 'United States', 'emoji' => '🇺🇸'],
    'UY' => ['name' => 'Uruguay', 'emoji' => '🇺🇾'],
    'UZ' => ['name' => 'Uzbekistan', 'emoji' => '🇺🇿'],
    'VA' => ['name' => 'Vatican City', 'emoji' => '🇻🇦'],
    'VC' => ['name' => 'Saint Vincent and the Grenadines', 'emoji' => '🇻🇨'],
    'VE' => ['name' => 'Venezuela', 'emoji' => '🇻🇪'],
    'VG' => ['name' => 'British Virgin Islands', 'emoji' => '🇻🇬'],
    'VI' => ['name' => 'U.S. Virgin Islands', 'emoji' => '🇻🇮'],
    'VN' => ['name' => 'Vietnam', 'emoji' => '🇻🇳'],
    'VU' => ['name' => 'Vanuatu', 'emoji' => '🇻🇺'],
    'WF' => ['name' => 'Wallis and Futuna', 'emoji' => '🇼🇫'],
    'WS' => ['name' => 'Samoa', 'emoji' => '🇼🇸'],
    'YE' => ['name' => 'Yemen', 'emoji' => '🇾🇪'],
    'YT' => ['name' => 'Mayotte', 'emoji' => '🇾🇹'],
    'ZA' => ['name' => 'South Africa', 'emoji' => '🇿🇦'],
    'ZM' => ['name' => 'Zambia', 'emoji' => '🇿🇲'],
    'ZW' => ['name' => 'Zimbabwe', 'emoji' => '🇿🇼'],
];

/**
 * Function to generate HTML select options for countries
 * @param string $selectedCountry - The currently selected country code
 * @param bool $includeEmpty - Whether to include an empty option
 * @return string HTML options
 */
function getCountryOptions($selectedCountry = '', $includeEmpty = true) {
    global $countries;
    
    $options = '';
    
    if ($includeEmpty) {
        $options .= '<option value="">Select Country...</option>' . "\n";
    }
    
    foreach ($countries as $code => $country) {
        $selected = ($selectedCountry === $code) ? ' selected' : '';
        $options .= sprintf(
            '<option value="%s"%s>%s %s</option>' . "\n",
            htmlspecialchars($code),
            $selected,
            $country['emoji'],
            htmlspecialchars($country['name'])
        );
    }
    
    return $options;
}

/**
 * Function to get country name by code
 * @param string $code - Country code
 * @return string Country name or empty string if not found
 */
function getCountryName($code) {
    global $countries;
    return isset($countries[$code]) ? $countries[$code]['name'] : '';
}

/**
 * Function to get country emoji by code
 * @param string $code - Country code
 * @return string Country emoji or empty string if not found
 */
function getCountryEmoji($code) {
    global $countries;
    return isset($countries[$code]) ? $countries[$code]['emoji'] : '';
}

/**
 * Function to get both emoji and name formatted
 * @param string $code - Country code
 * @return string Formatted "emoji name" or empty string if not found
 */
function getCountryDisplay($code) {
    global $countries;
    if (isset($countries[$code])) {
        return $countries[$code]['emoji'] . ' ' . $countries[$code]['name'];
    }
    return '';
}

/**
 * Function to search countries by name (useful for autocomplete)
 * @param string $search - Search term
 * @param int $limit - Maximum results to return
 * @return array Array of matching countries
 */
function searchCountries($search, $limit = 10) {
    global $countries;
    
    $search = strtolower($search);
    $results = [];
    $count = 0;
    
    foreach ($countries as $code => $country) {
        if ($count >= $limit) break;
        
        if (strpos(strtolower($country['name']), $search) !== false || 
            strpos(strtolower($code), $search) !== false) {
            $results[$code] = $country;
            $count++;
        }
    }
    
    return $results;
}

/**
 * Function to get popular/common countries (for prioritized display)
 * @return array Array of popular country codes
 */
function getPopularCountries() {
    return [
        'US', 'CA', 'GB', 'DE', 'FR', 'IT', 'ES', 'AU', 'NL', 'SE',
        'NO', 'DK', 'FI', 'JP', 'KR', 'CN', 'BR', 'MX', 'AR', 'RU'
    ];
}

/**
 * Function to generate select options with popular countries first
 * @param string $selectedCountry - The currently selected country code
 * @param bool $includeEmpty - Whether to include an empty option
 * @return string HTML options with popular countries first
 */
function getCountryOptionsWithPopular($selectedCountry = '', $includeEmpty = true) {
    global $countries;
    
    $options = '';
    
    if ($includeEmpty) {
        $options .= '<option value="">Select Country...</option>' . "\n";
    }
    
    $popularCountries = getPopularCountries();
    $remainingCountries = $countries;
    
    // Add popular countries first
    if (!empty($popularCountries)) {
        $options .= '<optgroup label="Popular Countries">' . "\n";
        foreach ($popularCountries as $code) {
            if (isset($countries[$code])) {
                $selected = ($selectedCountry === $code) ? ' selected' : '';
                $options .= sprintf(
                    '<option value="%s"%s>%s %s</option>' . "\n",
                    htmlspecialchars($code),
                    $selected,
                    $countries[$code]['emoji'],
                    htmlspecialchars($countries[$code]['name'])
                );
                unset($remainingCountries[$code]);
            }
        }
        $options .= '</optgroup>' . "\n";
        
        // Add separator
        $options .= '<optgroup label="All Countries">' . "\n";
    }
    
    // Add remaining countries
    foreach ($remainingCountries as $code => $country) {
        $selected = ($selectedCountry === $code) ? ' selected' : '';
        $options .= sprintf(
            '<option value="%s"%s>%s %s</option>' . "\n",
            htmlspecialchars($code),
            $selected,
            $country['emoji'],
            htmlspecialchars($country['name'])
        );
    }
    
    if (!empty($popularCountries)) {
        $options .= '</optgroup>' . "\n";
    }
    
    return $options;
}
?>
