<?php
/**
 * Simple test authentication for API demo
 */

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// For testing purposes, simulate a logged-in judge
if (!isset($_SESSION['user_id'])) {
    $_SESSION['user_id'] = 1;
    $_SESSION['user_type'] = 'admin';
    $_SESSION['username'] = 'admin';
}

// Check if user is authenticated
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    header('Content-Type: application/json');
    echo json_encode([
        'success' => false,
        'message' => 'Authentication required',
        'error_code' => 'AUTH_REQUIRED'
    ]);
    exit;
}
?>
