<?php
if(!isset($_SESSION)) { session_start(); }

// Include db.php to get getBaseUrl() function
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/../includes/permissions.php';
function requireAuth($allowed_types = ['admin', 'judge']) {
    $baseUrl = getBaseUrl();
    
    if (!isset($_SESSION['user_logged_in']) || $_SESSION['user_logged_in'] !== true) {
        header("Location: {$baseUrl}/v2/login.php");
        exit;
    }
    
    if (!in_array($_SESSION['user_type'], $allowed_types)) {
        // Store required roles and current user role for error display
        $_SESSION['unauthorized_required_roles'] = $allowed_types;
        $_SESSION['unauthorized_user_role'] = $_SESSION['user_type'] ?? 'unknown';
        $_SESSION['unauthorized_page'] = $_SERVER['REQUEST_URI'] ?? 'unknown page';
        header("Location: {$baseUrl}/v2/login.php?error=unauthorized");
        exit;
    }
}



// Usage examples:
// requireAuth(['admin']); // Only admin
// requireAuth(['judge']); // Only judge
// requireAuth(['admin', 'judge']); // Both admin and judge
?>