$helpFiles = @(
    @{file="figures_management_help.html"; title="Figures Management Panel Help"; icon="fas fa-star text-success"; color="success"}
    @{file="figures_viewer_help.html"; title="Figures Viewer Panel Help"; icon="fas fa-eye text-info"; color="info"}
    @{file="head_judge_help.html"; title="Head Judge Panel Help"; icon="fas fa-gavel text-warning"; color="warning"}
    @{file="head_judge_override_help.html"; title="Head Judge Override Panel Help"; icon="fas fa-user-shield text-danger"; color="danger"}
    @{file="judge_add_help.html"; title="Judge Add Panel Help"; icon="fas fa-user-plus text-primary"; color="primary"}
    @{file="judge_assign_help.html"; title="Judge Assignment Panel Help"; icon="fas fa-users text-secondary"; color="secondary"}
    @{file="results_styling_help.html"; title="Results Styling Panel Help"; icon="fas fa-palette text-info"; color="info"}
    @{file="scoring_formats_help.html"; title="Scoring Formats Panel Help"; icon="fas fa-clipboard-list text-primary"; color="primary"}
    @{file="scoring_format_edit_help.html"; title="Scoring Format Edit Panel Help"; icon="fas fa-edit text-warning"; color="warning"}
    @{file="event_create_help.html"; title="Event Create Panel Help"; icon="fas fa-plus text-success"; color="success"}
    @{file="event_edit_help.html"; title="Event Edit Panel Help"; icon="fas fa-edit text-warning"; color="warning"}
    @{file="event_start_list_help.html"; title="Event Start List Panel Help"; icon="fas fa-list text-info"; color="info"}
)

$template = @"
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{TITLE} - Style Score Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</head>
<body class="bg-light">
<div class="container py-4">
    <div class="mb-4">
        <h2 class="mb-1"><i class="{ICON} me-2"></i>{TITLE}</h2>
        <p class="lead">This guide covers all features, options, and best practices for using the {PANEL_NAME} in the Style Score Admin system.</p>
    </div>
    <div class="card mb-4">
        <div class="card-body">
            <h5 class="card-title">Introduction</h5>
            <p>The {PANEL_NAME} provides comprehensive functionality for {DESCRIPTION}. Only users with appropriate administrative roles can access this panel. This guide will help you understand all available features and how to use them effectively.</p>
        </div>
    </div>
    <div class="accordion mb-4" id="helpAccordion">
        <div class="accordion-item">
            <h2 class="accordion-header" id="headingFeatures">
                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFeatures" aria-expanded="true" aria-controls="collapseFeatures">
                    <i class="fas fa-list-check me-2"></i>Key Features & Functions
                </button>
            </h2>
            <div id="collapseFeatures" class="accordion-collapse collapse show" aria-labelledby="headingFeatures" data-bs-parent="#helpAccordion">
                <div class="accordion-body">
                    <p>This panel provides the following key features:</p>
                    <ul>
                        <li><strong>Primary Function:</strong> Core functionality for {MAIN_FUNCTION}.</li>
                        <li><strong>Management Tools:</strong> Create, edit, delete, and organize data efficiently.</li>
                        <li><strong>Filtering & Search:</strong> Advanced filtering and search capabilities for quick data access.</li>
                        <li><strong>Bulk Operations:</strong> Perform actions on multiple items simultaneously.</li>
                        <li><strong>Export/Import:</strong> Data export and import functionality where applicable.</li>
                        <li><strong>User Interface:</strong> Intuitive interface with responsive design for all devices.</li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="accordion-item">
            <h2 class="accordion-header" id="headingFAQ">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFAQ" aria-expanded="false" aria-controls="collapseFAQ">
                    <i class="fas fa-question-circle me-2"></i>Frequently Asked Questions (FAQ)
                </button>
            </h2>
            <div id="collapseFAQ" class="accordion-collapse collapse" aria-labelledby="headingFAQ" data-bs-parent="#helpAccordion">
                <div class="accordion-body">
                    <dl>
                        <dt>Who can access this panel?</dt>
                        <dd>Only users with appropriate administrative roles can access this panel. Contact your administrator if you need access.</dd>
                        <dt>How do I add new items?</dt>
                        <dd>Look for an "Add New" or similar button, usually located at the top of the panel. Fill in the required information and save.</dd>
                        <dt>How do I edit existing items?</dt>
                        <dd>Click the edit button (usually a pencil icon) next to the item you want to modify, make your changes, and save.</dd>
                        <dt>Can I delete items?</dt>
                        <dd>Yes, but deletion may be restricted if the item is in use elsewhere in the system. Use the delete button (usually a trash icon) next to the item.</dd>
                        <dt>How do I search or filter?</dt>
                        <dd>Use the search box and filter dropdowns at the top of the panel to narrow down the displayed items.</dd>
                        <dt>Can I export data from this panel?</dt>
                        <dd>Most panels support data export. Look for an "Export" button or similar option in the panel toolbar.</dd>
                    </dl>
                </div>
            </div>
        </div>
        <div class="accordion-item">
            <h2 class="accordion-header" id="headingTroubleshooting">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTroubleshooting" aria-expanded="false" aria-controls="collapseTroubleshooting">
                    <i class="fas fa-tools me-2"></i>Troubleshooting & Tips
                </button>
            </h2>
            <div id="collapseTroubleshooting" class="accordion-collapse collapse" aria-labelledby="headingTroubleshooting" data-bs-parent="#helpAccordion">
                <div class="accordion-body">
                    <ul>
                        <li><strong>Cannot access panel:</strong> Ensure you are logged in with the correct role and permissions.</li>
                        <li><strong>Form not submitting:</strong> Check that all required fields are filled out correctly.</li>
                        <li><strong>Data not loading:</strong> Try refreshing the page or clearing your browser cache.</li>
                        <li><strong>Cannot delete items:</strong> Items may be in use elsewhere. Check for dependencies before deleting.</li>
                        <li><strong>Search not working:</strong> Clear all filters and try again with different search terms.</li>
                        <li><strong>Still need help?</strong> Contact your system administrator or super admin for further assistance.</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div class="card">
        <div class="card-body">
            <h5 class="card-title">Best Practices</h5>
            <ul>
                <li>Double-check all data before saving, especially when making bulk changes.</li>
                <li>Use descriptive names and clear descriptions for easier management.</li>
                <li>Regularly backup or export important data for security.</li>
                <li>Keep the system organized by removing unused or outdated items.</li>
                <li>Test changes in a non-production environment when possible.</li>
            </ul>
        </div>
    </div>
</div>
</body>
</html>
"@

Write-Host "Help file standardization template created."
