<?php
// Complete API test with full output capture
header('Content-Type: text/plain; charset=utf-8');

// Enable error logging to output
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Capture error_log calls
$captured_logs = [];
set_error_handler(function($errno, $errstr, $errfile, $errline) use (&$captured_logs) {
    $captured_logs[] = "$errstr (in $errfile:$errline)";
    return false; // Let PHP handle it too
});

// Override error_log to capture
function error_log($message, $message_type = 0, $destination = null, $extra_headers = null) {
    global $captured_logs;
    $captured_logs[] = $message;
}

// Simulate API call
$_GET['config_id'] = 93;
$_GET['format'] = 'json';

echo "=== API Test for Config 93 ===\n\n";
echo "Request Parameters:\n";
echo "  config_id: 93\n";
echo "  format: json\n\n";

// Start output buffering to capture API output
ob_start();

try {
    require 'includes/db.php';
    
    // We need to include the API but it has relative paths
    chdir('api');
    
    // Mock missing functions
    if (!function_exists('collectParticipantColors')) {
        function collectParticipantColors($x) { return []; }
    }
    if (!function_exists('get_country_flag_emoji')) {
        function get_country_flag_emoji($x) { return ''; }
    }
    
    // Include API (will exit with JSON output)
    include 'summary_table_api.php';
    
} catch (Exception $e) {
    ob_end_clean();
    echo "EXCEPTION: " . $e->getMessage() . "\n";
    echo $e->getTraceAsString() . "\n";
}

$api_output = ob_get_clean();

echo "=== Captured Logs ===\n";
foreach ($captured_logs as $log) {
    echo "$log\n";
}

echo "\n\n=== API Response ===\n";
echo substr($api_output, 0, 5000) . "\n";

// Try to decode
$json = json_decode($api_output, true);
if ($json === null) {
    echo "\n\nJSON PARSE ERROR: " . json_last_error_msg() . "\n";
} else {
    echo "\n\nParsed JSON successfully!\n";
    echo "Keys: " . implode(', ', array_keys($json)) . "\n";
    
    if (isset($json['debug_info'])) {
        echo "\nDebug Info:\n";
        print_r($json['debug_info']);
    }
}
