-- Migration: Fix participants.updated_at to auto-update on row changes
-- Date: 2025-11-22
-- Description: Add ON UPDATE current_timestamp() to participants.updated_at column

USE `freestyle_db`;

-- Fix the updated_at column to automatically update on row modification
ALTER TABLE `participants` 
MODIFY COLUMN `updated_at` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp();

-- Verify the change
SELECT 
    COLUMN_NAME,
    COLUMN_TYPE,
    IS_NULLABLE,
    COLUMN_DEFAULT,
    EXTRA
FROM INFORMATION_SCHEMA.COLUMNS
WHERE TABLE_SCHEMA = 'freestyle_db'
  AND TABLE_NAME = 'participants'
  AND COLUMN_NAME = 'updated_at';
