<?php
require_once 'includes/db.php';

// Get current configuration
$stmt = $pdo->prepare("SELECT id, view_name, configuration FROM result_configurations WHERE id = 74");
$stmt->execute();
$config = $stmt->fetch(PDO::FETCH_ASSOC);

echo "BEFORE UPDATE:\n";
echo "Config ID: " . $config['id'] . "\n";
echo "View Name: " . $config['view_name'] . "\n";
echo "Current Configuration: " . $config['configuration'] . "\n\n";

// Parse and update configuration
$settings = json_decode($config['configuration'], true);
if ($settings === null) {
    $settings = [];
}

// Set heatDirection to 'column'
$settings['heatDirection'] = 'column';

// Save back to database
$newConfigJson = json_encode($settings);
$updateStmt = $pdo->prepare("UPDATE result_configurations SET configuration = ? WHERE id = 74");
$updateStmt->execute([$newConfigJson]);

echo "AFTER UPDATE:\n";
echo "New Configuration: " . $newConfigJson . "\n\n";

// Verify
$verifyStmt = $pdo->prepare("SELECT configuration FROM result_configurations WHERE id = 74");
$verifyStmt->execute();
$verifyConfig = $verifyStmt->fetch(PDO::FETCH_ASSOC);

echo "VERIFICATION:\n";
echo "Saved Configuration: " . $verifyConfig['configuration'] . "\n";
$verifySettings = json_decode($verifyConfig['configuration'], true);
echo "Heat Direction is now: " . ($verifySettings['heatDirection'] ?? 'NOT SET') . "\n";
echo "\n✅ Configuration 74 has been updated to use Column layout!\n";
