<?php
// Simplified API test - outputs debug logs inline
header('Content-Type: text/plain; charset=utf-8');

// Override error_log to display inline
$debug_logs = [];
function my_error_log($message) {
    global $debug_logs;
    $debug_logs[] = $message;
}

// Temporarily replace error_log in the API
$code = file_get_contents('api/summary_table_api.php');
$code = str_replace('error_log(', 'my_error_log(', $code);

// Set up environment
$_GET['config_id'] = 93;
$_GET['format'] = 'json';

// Execute the modified code
ob_start();
eval('?>' . $code);
$output = ob_get_clean();

// Display results
echo "=== DEBUG LOGS ===\n\n";
foreach ($debug_logs as $log) {
    echo "$log\n";
}

echo "\n\n=== API OUTPUT (first 2000 chars) ===\n\n";
echo substr($output, 0, 2000) . "\n";

// Try to parse JSON
$json = json_decode($output, true);
if ($json !== null) {
    echo "\n\n=== PARSED JSON ===\n\n";
    if (isset($json['debug_info'])) {
        echo "Debug Info:\n";
        print_r($json['debug_info']);
    }
    if (isset($json['success'])) {
        echo "\nSuccess: " . ($json['success'] ? 'true' : 'false') . "\n";
    }
    if (isset($json['message'])) {
        echo "Message: {$json['message']}\n";
    }
    if (isset($json['summary_data'])) {
        echo "\nSummary Data Categories: " . implode(', ', array_keys($json['summary_data'])) . "\n";
    }
}
