-- Judge Drawings Table Migration
-- Creates table for storing judge drawing references and metadata

CREATE TABLE IF NOT EXISTS `judge_drawings` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `judge_id` INT(11) NOT NULL,
  `score_id` INT(11) DEFAULT NULL COMMENT 'NULL if drawing created before score submission',
  `event_id` INT(11) NOT NULL,
  `heat_number` INT(11) NOT NULL,
  `run_number` INT(11) NOT NULL,
  `participant_id` INT(11) NOT NULL,
  `background_json` VARCHAR(255) DEFAULT NULL COMMENT 'Filename only - reusable template/grid',
  `drawing_json` VARCHAR(255) NOT NULL COMMENT 'Filename only - actual drawing data',
  `canvas_width` INT(11) DEFAULT 800,
  `canvas_height` INT(11) DEFAULT 600,
  `notes` TEXT DEFAULT NULL COMMENT 'Optional text notes about the situation',
  `status` ENUM('draft', 'final', 'archived') DEFAULT 'draft',
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_judge_id` (`judge_id`),
  KEY `idx_score_id` (`score_id`),
  KEY `idx_event_heat_run` (`event_id`, `heat_number`, `run_number`),
  KEY `idx_participant` (`participant_id`),
  KEY `idx_status` (`status`),
  CONSTRAINT `fk_drawing_judge` FOREIGN KEY (`judge_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_drawing_score` FOREIGN KEY (`score_id`) REFERENCES `scores` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_drawing_event` FOREIGN KEY (`event_id`) REFERENCES `events` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_drawing_participant` FOREIGN KEY (`participant_id`) REFERENCES `event_participants` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Create drawings directory structure (needs to be created manually via PHP or filesystem)
-- /drawings/backgrounds/ - for reusable templates
-- /drawings/scores/ - for individual drawings
