<?php
require_once 'includes/db.php';

echo "=== Password Format Check ===\n\n";

$stmt = $pdo->query('SELECT id, username, password, role FROM users LIMIT 10');
while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $password = $row['password'];
    $is_hashed = (strlen($password) === 60 && strpos($password, '$2y$') === 0);
    
    echo sprintf(
        "ID: %d | User: %-15s | Role: %-10s | Format: %s | Length: %d\n",
        $row['id'],
        $row['username'],
        $row['role'],
        $is_hashed ? 'HASHED (bcrypt)' : 'PLAIN TEXT',
        strlen($password)
    );
}

echo "\n=== Password Hash Test ===\n";
$test_password = 'test123';
$hashed = password_hash($test_password, PASSWORD_DEFAULT);
echo "Plain text: $test_password\n";
echo "Hashed: $hashed\n";
echo "Verify correct: " . (password_verify($test_password, $hashed) ? 'YES' : 'NO') . "\n";
echo "Verify wrong: " . (password_verify('wrong', $hashed) ? 'YES' : 'NO') . "\n";
?>
