/**
 * Country Flag Emoji Polyfill - ES6 Module Version
 * Local offline version for StyleScore
 */

const emojiFont = '"Twemoji Mozilla","Apple Color Emoji","Segoe UI Emoji","Segoe UI Symbol","Noto Color Emoji","EmojiOne Color","Android Emoji",sans-serif';

function createCanvas() {
    const canvas = document.createElement("canvas");
    canvas.width = canvas.height = 1;
    const context = canvas.getContext("2d", {willReadFrequently: true});
    context.textBaseline = "top";
    context.font = `100px ${emojiFont}`;
    context.scale(0.01, 0.01);
    return context;
}

function getImageData(context, emoji, fillStyle) {
    context.clearRect(0, 0, 100, 100);
    context.fillStyle = fillStyle;
    context.fillText(emoji, 0, 0);
    return context.getImageData(0, 0, 1, 1).data.join(",");
}

function supportsEmoji(emoji) {
    const context = createCanvas();
    const whiteData = getImageData(context, emoji, "#fff");
    const blackData = getImageData(context, emoji, "#000");
    return blackData === whiteData && !blackData.startsWith("0,0,0,");
}

export function polyfillCountryFlagEmojis(
    fontFamily = "Twemoji Country Flags",
    fontUrl = "/v2/assets/fonts/TwemojiCountryFlags.woff2"
) {
    if (typeof window !== "undefined" && 
        supportsEmoji("😊") && 
        !supportsEmoji("🇨🇭")) {
        
        const style = document.createElement("style");
        style.textContent = `@font-face {
      font-family: "${fontFamily}";
      unicode-range: U+1F1E6-1F1FF, U+1F3F4, U+E0062-E0063, U+E0065, U+E0067,
        U+E006C, U+E006E, U+E0073-E0074, U+E0077, U+E007F;
      src: url('${fontUrl}') format('woff2');
      font-display: swap;
    }`;
        document.head.appendChild(style);
        return true;
    }
    return false;
}

// Auto-initialize on import
polyfillCountryFlagEmojis();
