<?php
try {
    include '../includes/db.php';
    
    echo "Testing table existence...\n";
    
    // Check if result_configurations table exists
    $stmt = $pdo->query("SHOW TABLES LIKE 'result_configurations'");
    if ($stmt->rowCount() > 0) {
        echo "✓ Table 'result_configurations' exists\n";
        
        // Check table structure
        $stmt = $pdo->query("DESCRIBE result_configurations");
        $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
        echo "Table columns:\n";
        foreach ($columns as $column) {
            echo "  - {$column['Field']} ({$column['Type']})\n";
        }
        
        // Count records
        $stmt = $pdo->query("SELECT COUNT(*) as count FROM result_configurations");
        $count = $stmt->fetch(PDO::FETCH_ASSOC);
        echo "Total records: {$count['count']}\n";
        
        // Test with event_id = 3
        $stmt = $pdo->prepare("SELECT COUNT(*) as count FROM result_configurations WHERE event_id = ?");
        $stmt->execute([3]);
        $count = $stmt->fetch(PDO::FETCH_ASSOC);
        echo "Records for event_id = 3: {$count['count']}\n";
        
    } else {
        echo "✗ Table 'result_configurations' does NOT exist\n";
        
        // Show available tables
        $stmt = $pdo->query("SHOW TABLES");
        $tables = $stmt->fetchAll(PDO::FETCH_COLUMN);
        echo "Available tables:\n";
        foreach ($tables as $table) {
            echo "  - $table\n";
        }
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
