<?php
// Test the reset participant status API
session_start();

// Simulate authenticated admin user
$_SESSION['user_id'] = 1;
$_SESSION['role'] = 'admin';

// Simulate POST data
$_POST['event_id'] = 3;
$_POST['heat_number'] = 4;

echo "<h2>Testing Reset Participant Status API</h2>";
echo "<p>Event ID: {$_POST['event_id']}</p>";
echo "<p>Heat Number: {$_POST['heat_number']}</p>";
echo "<hr>";

// Call the API
ob_start();
include 'reset_participant_status_api.php';
$output = ob_get_clean();

echo "<h3>API Response:</h3>";
echo "<pre>";
echo htmlspecialchars($output);
echo "</pre>";

// Decode and display formatted
$response = json_decode($output, true);
if ($response) {
    echo "<h3>Parsed Response:</h3>";
    echo "<pre>";
    print_r($response);
    echo "</pre>";
} else {
    echo "<p style='color: red;'>Failed to parse JSON response</p>";
    echo "<p>Raw output:</p>";
    echo "<pre>" . htmlspecialchars($output) . "</pre>";
}
?>
