<!DOCTYPE html>
<html>
<head>
    <title>Participant Media Fields Test</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-5">
    <h2>Test New Participant Fields</h2>
    
    <?php
    // Test database connection and new fields
    include '../includes/db.php';
    
    echo "<div class='alert alert-info'>";
    
    try {
        // Check if new columns exist
        $stmt = $pdo->query("DESCRIBE participants");
        $columns = $stmt->fetchAll(PDO::FETCH_COLUMN);
        
        echo "<h5>Participants table columns:</h5><ul>";
        foreach ($columns as $column) {
            echo "<li>$column</li>";
        }
        echo "</ul>";
        
        // Check if participant_facts table exists
        $stmt = $pdo->query("SHOW TABLES LIKE 'participant_facts'");
        if ($stmt->rowCount() > 0) {
            echo "<h5>✓ participant_facts table exists</h5>";
            
            $stmt = $pdo->query("DESCRIBE participant_facts");
            $fact_columns = $stmt->fetchAll(PDO::FETCH_COLUMN);
            echo "<ul>";
            foreach ($fact_columns as $column) {
                echo "<li>$column</li>";
            }
            echo "</ul>";
        } else {
            echo "<h5>✗ participant_facts table missing</h5>";
        }
        
        // Check uploads directory
        $upload_dir = '../uploads/participants/';
        if (!is_dir($upload_dir)) {
            mkdir($upload_dir, 0755, true);
            echo "<h5>✓ Created uploads directory: $upload_dir</h5>";
        } else {
            echo "<h5>✓ Uploads directory exists: $upload_dir</h5>";
        }
        
    } catch (Exception $e) {
        echo "<div class='alert alert-danger'>Error: " . $e->getMessage() . "</div>";
    }
    
    echo "</div>";
    ?>
    
    <div class="alert alert-success">
        <h5>New Features Added:</h5>
        <ul>
            <li><strong>Photo Upload:</strong> Participants can now have a profile photo (JPG, PNG, GIF, WEBP)</li>
            <li><strong>Motion Video:</strong> Upload video files showing participant in motion (MP4, AVI, MOV, etc.)</li>
            <li><strong>Facts Repeater:</strong> Add multiple facts/information items with title and description</li>
        </ul>
    </div>
    
    <a href="participant_add.php" class="btn btn-primary">Test Add Participant Form</a>
</div>
</body>
</html>
