<?php
include '../includes/db.php';

echo "=== Judges Table ===\n";
$judges_stmt = $pdo->query("SELECT * FROM judges ORDER BY id LIMIT 10");
foreach ($judges_stmt->fetchAll(PDO::FETCH_ASSOC) as $judge) {
    echo "ID: {$judge['id']}, Name: {$judge['name']}, Head: " . ($judge['is_head'] ?? 'NULL') . "\n";
}

echo "\n=== Judge Assignments ===\n";
$ja_stmt = $pdo->query("SELECT * FROM judge_assignments WHERE event_id = 6");
foreach ($ja_stmt->fetchAll(PDO::FETCH_ASSOC) as $ja) {
    echo "Assignment ID: {$ja['id']}, Judge ID: {$ja['judge_id']}, Status: {$ja['status']}\n";
}

echo "\n=== Try JOIN ===\n";
$join_stmt = $pdo->query("
    SELECT ja.*, j.name, j.is_head 
    FROM judge_assignments ja 
    LEFT JOIN judges j ON ja.judge_id = j.id 
    WHERE ja.event_id = 6
");
foreach ($join_stmt->fetchAll(PDO::FETCH_ASSOC) as $row) {
    echo "Assignment: {$row['id']}, Judge: {$row['judge_id']}, Name: {$row['name']}, Head: {$row['is_head']}\n";
}
