<?php
require_once '../includes/db.php';

try {
    // Test the fix by checking current state
    echo "Current records for snowboard_big_air_best_two:\n";
    
    $checkQuery = $pdo->prepare("SELECT * FROM scoring_format_judges WHERE format_id = ?");
    $checkQuery->execute(['snowboard_big_air_best_two']);
    $records = $checkQuery->fetchAll(PDO::FETCH_ASSOC);
    
    foreach ($records as $record) {
        echo "ID: {$record['id']}, Drop Rule: {$record['drop_rule']}, Min Judges: {$record['min_judges']}\n";
    }
    
    echo "\nTotal records: " . count($records) . "\n";
    
    if (count($records) == 1) {
        echo "✓ Fix successful - only one record exists\n";
    } else {
        echo "✗ Issue still exists - multiple records found\n";
    }
    
    // Test the unique constraint
    echo "\nTesting unique constraint...\n";
    
    try {
        $testInsert = $pdo->prepare("
            INSERT INTO scoring_format_judges (format_id, min_judges, max_judges, scale_type, scale_min, scale_max, drop_rule)
            VALUES (?, ?, ?, ?, ?, ?, ?)
        ");
        
        $testInsert->execute([
            'snowboard_big_air_best_two',
            5,
            7,
            'numeric',
            0.00,
            100.00,
            'test_rule'
        ]);
        
        echo "✗ Unique constraint not working - insert succeeded\n";
        
    } catch (PDOException $e) {
        if (strpos($e->getMessage(), 'Duplicate entry') !== false) {
            echo "✓ Unique constraint working - duplicate insert prevented\n";
        } else {
            echo "? Unknown error: " . $e->getMessage() . "\n";
        }
    }
    
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
