<?php
// Test script to check judge assignments for heat cards
include '../includes/db.php';

echo "=== Events with Judges ===\n";
$stmt = $pdo->query("
    SELECT e.id, e.name, COUNT(DISTINCT ja.judge_id) as judge_count 
    FROM events e 
    LEFT JOIN judge_assignments ja ON e.id = ja.event_id 
    GROUP BY e.id 
    ORDER BY e.id DESC 
    LIMIT 5
");

foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $row) {
    echo "Event {$row['id']}: {$row['name']} - {$row['judge_count']} judges\n";
}

echo "\n=== All Judge Assignments ===\n";
$all_stmt = $pdo->query("SELECT * FROM judge_assignments ORDER BY event_id DESC LIMIT 10");
foreach ($all_stmt->fetchAll(PDO::FETCH_ASSOC) as $ja) {
    echo "Event {$ja['event_id']}, Judge {$ja['judge_id']}, Status: {$ja['status']}, Heat: {$ja['heat_number']}, Run: {$ja['run_number']}\n";
}

echo "\n=== Judge Details for Event 6 ===\n";
$judges_stmt = $pdo->prepare("
    SELECT 
        ja.id,
        ja.event_id,
        ja.judge_id,
        ja.status,
        ja.status_updated_at,
        ja.heat_number as assigned_heat_number,
        ja.run_number as assigned_run_number,
        j.name as judge_name,
        j.is_head
    FROM judge_assignments ja
    JOIN judges j ON ja.judge_id = j.id
    WHERE ja.event_id = 6
    ORDER BY j.is_head DESC, j.name ASC
");
$judges_stmt->execute();

$count = 0;
foreach ($judges_stmt->fetchAll(PDO::FETCH_ASSOC) as $judge) {
    $count++;
    $location = '';
    if ($judge['assigned_heat_number'] && $judge['assigned_run_number']) {
        $location = "H{$judge['assigned_heat_number']}R{$judge['assigned_run_number']}";
    } elseif ($judge['assigned_heat_number']) {
        $location = "Heat {$judge['assigned_heat_number']}";
    } else {
        $location = "No heat assigned";
    }
    
    $head = $judge['is_head'] ? '[HEAD]' : '';
    echo "{$head} {$judge['judge_name']} - Status: {$judge['status']} - Location: {$location}\n";
}

echo "\nTotal judges for event 6: $count\n";
