<?php
require_once '../includes/db.php';
require_once 'publish_generators.php';

echo "<h2>Heats Data Test</h2>";

// First get available events
echo "<h3>Available Events</h3>";
try {
    $events_stmt = $pdo->query("SELECT id, name, status FROM events ORDER BY id ASC LIMIT 10");
    $events = $events_stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if (empty($events)) {
        echo "<p style='color: red;'>No events found!</p>";
        exit;
    }
    
    echo "<table border='1'>";
    echo "<tr><th>ID</th><th>Name</th><th>Status</th></tr>";
    foreach ($events as $event) {
        echo "<tr><td>{$event['id']}</td><td>{$event['name']}</td><td>{$event['status']}</td></tr>";
    }
    echo "</table>";
    
    $event_id = $events[0]['id'];
    echo "<p><strong>Testing with Event ID: $event_id</strong></p>";
    
} catch (Exception $e) {
    echo "<p style='color: red;'>Error: " . htmlspecialchars($e->getMessage()) . "</p>";
    exit;
}

// Test the heats data generation
echo "<h3>Heats Data Generation Test</h3>";
try {
    $heats_data = getHeatsData($event_id, $pdo);
    
    echo "<p>✓ Function executed successfully</p>";
    echo "<p>Data structure returned:</p>";
    echo "<pre>" . htmlspecialchars(json_encode($heats_data, JSON_PRETTY_PRINT)) . "</pre>";
    
    if (isset($heats_data['heats']) && is_array($heats_data['heats'])) {
        echo "<p>Found " . count($heats_data['heats']) . " heats</p>";
        
        foreach ($heats_data['heats'] as $heat_num => $heat) {
            echo "<h4>Heat $heat_num</h4>";
            echo "<ul>";
            if (isset($heat['heat_name'])) echo "<li>Name: " . htmlspecialchars($heat['heat_name']) . "</li>";
            if (isset($heat['is_active'])) echo "<li>Active: " . ($heat['is_active'] ? 'Yes' : 'No') . "</li>";
            if (isset($heat['participants'])) echo "<li>Participants: " . htmlspecialchars($heat['participants']) . "</li>";
            if (isset($heat['bib_on_start'])) echo "<li>BIB on Start: " . htmlspecialchars($heat['bib_on_start']) . "</li>";
            if (isset($heat['bib_start_name'])) echo "<li>Start Name: " . htmlspecialchars($heat['bib_start_name']) . "</li>";
            echo "</ul>";
        }
    } else {
        echo "<p style='color: red;'>No heats data in result</p>";
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>Error in getHeatsData: " . htmlspecialchars($e->getMessage()) . "</p>";
    echo "<pre>" . htmlspecialchars($e->getTraceAsString()) . "</pre>";
}

// Test the scores data generation
echo "<h3>Scores Data Generation Test</h3>";
try {
    $scores_data = getScoresData($event_id, $pdo);
    
    echo "<p>✓ Function executed successfully</p>";
    echo "<p>Data structure returned:</p>";
    echo "<pre>" . htmlspecialchars(json_encode($scores_data, JSON_PRETTY_PRINT)) . "</pre>";
    
    if (isset($scores_data['scores']) && is_array($scores_data['scores'])) {
        echo "<p>Found " . count($scores_data['scores']) . " scores</p>";
    } else {
        echo "<p>No scores data in result</p>";
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>Error in getScoresData: " . htmlspecialchars($e->getMessage()) . "</p>";
    echo "<pre>" . htmlspecialchars($e->getTraceAsString()) . "</pre>";
}

// Test database structure
echo "<h3>Database Structure Check</h3>";
try {
    // Check event_heat_settings table
    $heat_settings_stmt = $pdo->query("DESCRIBE event_heat_settings");
    $heat_columns = $heat_settings_stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<h4>event_heat_settings columns:</h4>";
    echo "<ul>";
    foreach ($heat_columns as $col) {
        echo "<li>{$col['Field']} ({$col['Type']})</li>";
    }
    echo "</ul>";
    
    // Check if there are any heat settings for our event
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM event_heat_settings WHERE event_id = ?");
    $stmt->execute([$event_id]);
    $heat_count = $stmt->fetchColumn();
    echo "<p>Event $event_id has $heat_count heat settings</p>";
    
    if ($heat_count > 0) {
        $stmt = $pdo->prepare("SELECT heat_number, heat_name, is_active FROM event_heat_settings WHERE event_id = ? ORDER BY heat_number");
        $stmt->execute([$event_id]);
        $heats = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo "<h4>Actual heat data:</h4>";
        echo "<table border='1'>";
        echo "<tr><th>Heat Number</th><th>Heat Name</th><th>Active</th></tr>";
        foreach ($heats as $heat) {
            echo "<tr><td>{$heat['heat_number']}</td><td>{$heat['heat_name']}</td><td>" . ($heat['is_active'] ? 'Yes' : 'No') . "</td></tr>";
        }
        echo "</table>";
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>Error checking database: " . htmlspecialchars($e->getMessage()) . "</p>";
}
?>
