<?php
// Test heat cards API directly
$event_id = $_GET['event_id'] ?? 3;
$layout = $_GET['layout'] ?? 'judges';

$api_url = "heat_cards_api.php?event_id=$event_id&layout=$layout";

echo "<h2>Heat Cards API Test</h2>";
echo "<p>Event ID: $event_id</p>";
echo "<p>Layout: $layout</p>";
echo "<p>API URL: <a href='$api_url' target='_blank'>$api_url</a></p>";

echo "<hr>";
echo "<h3>API Response:</h3>";

$response = file_get_contents($api_url);
echo "<h4>Raw JSON:</h4>";
echo "<pre>" . htmlspecialchars($response) . "</pre>";

$data = json_decode($response, true);
if ($data) {
    echo "<h4>Parsed Data:</h4>";
    echo "<pre>" . print_r($data, true) . "</pre>";
    
    if ($data['success'] && !empty($data['data'])) {
        echo "<h4>Generated HTML Preview:</h4>";
        echo "<div style='border: 2px solid #ccc; padding: 10px; background: #f5f5f5;'>";
        echo $data['data'];
        echo "</div>";
        
        echo "<h4>HTML Source:</h4>";
        echo "<textarea style='width: 100%; height: 300px;'>" . htmlspecialchars($data['data']) . "</textarea>";
    } else {
        echo "<div style='color: red; font-weight: bold;'>ERROR: " . ($data['message'] ?? 'Unknown error') . "</div>";
    }
}
?>
