-- Migration: Add 'enabled' column to event_notification_settings
-- Purpose: Allow global enable/disable of notifications for all users per event
-- Date: 2025-11-17

-- Check if column exists, if not add it
SET @exist := (
    SELECT COUNT(*) 
    FROM INFORMATION_SCHEMA.COLUMNS 
    WHERE TABLE_SCHEMA = DATABASE() 
    AND TABLE_NAME = 'event_notification_settings' 
    AND COLUMN_NAME = 'enabled'
);

SET @sqlstmt := IF(@exist = 0, 
    'ALTER TABLE event_notification_settings ADD COLUMN enabled BOOLEAN DEFAULT TRUE AFTER event_id',
    'SELECT ''Column enabled already exists'' AS Info'
);

PREPARE stmt FROM @sqlstmt;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Check if index exists, if not add it
SET @index_exist := (
    SELECT COUNT(*) 
    FROM INFORMATION_SCHEMA.STATISTICS 
    WHERE TABLE_SCHEMA = DATABASE() 
    AND TABLE_NAME = 'event_notification_settings' 
    AND INDEX_NAME = 'idx_enabled'
);

SET @indexstmt := IF(@index_exist = 0, 
    'ALTER TABLE event_notification_settings ADD INDEX idx_enabled (enabled)',
    'SELECT ''Index idx_enabled already exists'' AS Info'
);

PREPARE stmt FROM @indexstmt;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Update comment
ALTER TABLE event_notification_settings 
COMMENT = 'Notification system settings per event, including global enable/disable toggle';

-- Verify the change
SELECT 
    COLUMN_NAME, 
    DATA_TYPE, 
    COLUMN_DEFAULT, 
    IS_NULLABLE,
    COLUMN_COMMENT
FROM INFORMATION_SCHEMA.COLUMNS
WHERE TABLE_NAME = 'event_notification_settings' 
  AND TABLE_SCHEMA = DATABASE()
ORDER BY ORDINAL_POSITION;
