<?php
include '../includes/auth.php';
include '../includes/db.php';

$event_id = 3;

echo "<h1>Simple Database Test</h1>";

echo "<h2>Direct Query Test:</h2>";
$sql = "SELECT * FROM events WHERE id = $event_id";
echo "SQL: $sql<br><br>";

$stmt = $pdo->query($sql);
$event = $stmt->fetch(PDO::FETCH_ASSOC);

echo "<h3>Result:</h3>";
echo "<pre>";
var_dump($event);
echo "</pre>";

echo "<h2>Prepared Statement Test:</h2>";
$stmt2 = $pdo->prepare("SELECT * FROM events WHERE id = ?");
$stmt2->execute([$event_id]);
$event2 = $stmt2->fetch(PDO::FETCH_ASSOC);

echo "<pre>";
var_dump($event2);
echo "</pre>";

echo "<h2>Field Access Test:</h2>";
if ($event2) {
    echo "Name: '" . ($event2['name'] ?? 'NOT_FOUND') . "'<br>";
    echo "Location: '" . ($event2['location'] ?? 'NOT_FOUND') . "'<br>";
    echo "Sport Discipline: '" . ($event2['sport_discipline'] ?? 'NOT_FOUND') . "'<br>";
    echo "Scoring Format: '" . ($event2['scoring_format'] ?? 'NOT_FOUND') . "'<br>";
    echo "Scoring Mode: '" . ($event2['scoring_mode'] ?? 'NOT_FOUND') . "'<br>";
    
    echo "<h3>Available Keys:</h3>";
    echo "<pre>";
    print_r(array_keys($event2));
    echo "</pre>";
}
?>