<?php
session_start();
require_once '../includes/db.php';
require_once '../includes/auth.php';

// Check authentication
requireAuth();

// Set JSON header
header('Content-Type: application/json');

try {
    // Get JSON input
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($input['ids']) || !is_array($input['ids']) || empty($input['ids'])) {
        echo json_encode([
            'success' => false,
            'message' => 'Participant IDs are required'
        ]);
        exit;
    }
    
    $participant_ids = array_map('intval', $input['ids']);
    
    // Begin transaction
    $pdo->beginTransaction();
    
    try {
        $total_deleted = 0;
        $total_event_assignments = 0;
        
        foreach ($participant_ids as $participant_id) {
            // Delete from event_participants (event assignments)
            $stmt = $pdo->prepare("DELETE FROM event_participants WHERE participant_id = ?");
            $stmt->execute([$participant_id]);
            $total_event_assignments += $stmt->rowCount();
            
            // Delete from participants_event (import history)
            $stmt = $pdo->prepare("DELETE FROM participants_event WHERE participant_id = ?");
            $stmt->execute([$participant_id]);
            
            // Delete the participant
            $stmt = $pdo->prepare("DELETE FROM participants WHERE id = ?");
            $stmt->execute([$participant_id]);
            $total_deleted += $stmt->rowCount();
        }
        
        // Commit transaction
        $pdo->commit();
        
        $message = "{$total_deleted} participant(s) deleted successfully";
        if ($total_event_assignments > 0) {
            $message .= " ({$total_event_assignments} event assignment(s) removed)";
        }
        
        echo json_encode([
            'success' => true,
            'message' => $message
        ]);
        
    } catch (Exception $e) {
        $pdo->rollBack();
        throw $e;
    }
    
} catch (Exception $e) {
    error_log("Bulk participant delete error: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Bulk delete failed: ' . $e->getMessage()
    ]);
}
