<?php
session_start();
require_once '../includes/db.php';
require_once '../includes/auth.php';

// Check authentication
requireAuth();

// Set JSON header
header('Content-Type: application/json');

try {
    // Get JSON input
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($input['id']) || empty($input['id'])) {
        echo json_encode([
            'success' => false,
            'message' => 'Participant ID is required'
        ]);
        exit;
    }
    
    $participant_id = (int)$input['id'];
    
    // Get participant info before deletion
    $stmt = $pdo->prepare("SELECT first_name, last_name FROM participants WHERE id = ?");
    $stmt->execute([$participant_id]);
    $participant = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$participant) {
        echo json_encode([
            'success' => false,
            'message' => 'Participant not found'
        ]);
        exit;
    }
    
    $participant_name = $participant['first_name'] . ' ' . $participant['last_name'];
    
    // Begin transaction
    $pdo->beginTransaction();
    
    try {
        // Delete from event_participants (event assignments)
        $stmt = $pdo->prepare("DELETE FROM event_participants WHERE participant_id = ?");
        $stmt->execute([$participant_id]);
        $event_assignments_deleted = $stmt->rowCount();
        
        // Delete from participants_event (import history)
        $stmt = $pdo->prepare("DELETE FROM participants_event WHERE participant_id = ?");
        $stmt->execute([$participant_id]);
        
        // Delete the participant
        $stmt = $pdo->prepare("DELETE FROM participants WHERE id = ?");
        $stmt->execute([$participant_id]);
        
        // Commit transaction
        $pdo->commit();
        
        $message = "Participant '{$participant_name}' deleted successfully";
        if ($event_assignments_deleted > 0) {
            $message .= " ({$event_assignments_deleted} event assignment(s) removed)";
        }
        
        echo json_encode([
            'success' => true,
            'message' => $message
        ]);
        
    } catch (Exception $e) {
        $pdo->rollBack();
        throw $e;
    }
    
} catch (Exception $e) {
    error_log("Participant delete error: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Delete failed: ' . $e->getMessage()
    ]);
}
