<?php
/**
 * Sample page demonstrating the fixed navbar implementation
 */

// Sample session data for demonstration
session_start();

// Include required files for event access control
require_once '../includes/db.php';
require_once '../includes/event_access.php';

$current_user = [
    'id' => 1,
    'username' => 'admin',
    'full_name' => 'Administrator',
    'email' => 'admin@stylescore.com'
];

// Get event_id and validate access
$event_id = $_GET['event_id'] ?? $_COOKIE['selectedEventId'] ?? $_COOKIE['event_id'] ?? null;

// Validate event access
if ($event_id && !hasEventAccess($event_id)) {
    // Clear invalid cookies
    setcookie('selectedEventId', '', time() - 3600, '/');
    setcookie('event_id', '', time() - 3600, '/');
    $event_id = null;
}

// Configuration for the navbar
$show_token_balance = true;
$show_event_selector = true;
$use_localStorage = true;
$navbar_theme = 'dark';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>StyleScore - Fixed Navbar Demo</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Lucide Icons -->
    <script src="../assets/js/lucide.min.js"></script>
    
    <!-- Font Awesome Fallback -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <?php if ($event_id && !hasEventAccess($event_id)): ?>
    <script>
        // Clear localStorage if event_id is invalid
        if (typeof localStorage !== 'undefined') {
            localStorage.removeItem('selectedEventId');
            localStorage.removeItem('event_id');
        }
    </script>
    <?php endif; ?>
</head>
<body>
    <!-- Include the fixed navbar -->
    <?php include 'navbar_fixed.php'; ?>
    
    <!-- Main content -->
    <div class="container-fluid mt-4">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4><i data-lucide="monitor" class="me-2"></i>Fixed Navbar Demo</h4>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-8">
                                <h5>Features Demonstrated</h5>
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item">
                                        <i data-lucide="check" class="me-2 text-success"></i>
                                        <strong>Fixed Navigation:</strong> Navbar stays at top while scrolling
                                    </li>
                                    <li class="list-group-item">
                                        <i data-lucide="check" class="me-2 text-success"></i>
                                        <strong>Event Selector:</strong> Dropdown with recent events and status indicators
                                    </li>
                                    <li class="list-group-item">
                                        <i data-lucide="check" class="me-2 text-success"></i>
                                        <strong>Dynamic Actions:</strong> Event-specific actions based on current selection
                                    </li>
                                    <li class="list-group-item">
                                        <i data-lucide="check" class="me-2 text-success"></i>
                                        <strong>Token Balance:</strong> Real-time balance display with auto-refresh
                                    </li>
                                    <li class="list-group-item">
                                        <i data-lucide="check" class="me-2 text-success"></i>
                                        <strong>Notifications:</strong> Bell icon with badge and modal interface
                                    </li>
                                    <li class="list-group-item">
                                        <i data-lucide="check" class="me-2 text-success"></i>
                                        <strong>User Menu:</strong> Avatar with dropdown for profile and settings
                                    </li>
                                    <li class="list-group-item">
                                        <i data-lucide="check" class="me-2 text-success"></i>
                                        <strong>Keyboard Shortcuts:</strong> Alt+D, Alt+S, Alt+H for quick navigation
                                    </li>
                                    <li class="list-group-item">
                                        <i data-lucide="check" class="me-2 text-success"></i>
                                        <strong>Responsive Design:</strong> Collapses to mobile menu on smaller screens
                                    </li>
                                </ul>
                            </div>
                            <div class="col-md-4">
                                <div class="card bg-light">
                                    <div class="card-header">
                                        <h6><i data-lucide="keyboard" class="me-1"></i>Keyboard Shortcuts</h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="mb-2">
                                            <kbd>Alt + D</kbd> Dashboard
                                        </div>
                                        <div class="mb-2">
                                            <kbd>Alt + S</kbd> Score Event
                                        </div>
                                        <div class="mb-2">
                                            <kbd>Alt + H</kbd> Head Judge
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="card bg-light mt-3">
                                    <div class="card-header">
                                        <h6><i data-lucide="palette" class="me-1"></i>Customization</h6>
                                    </div>
                                    <div class="card-body">
                                        <p class="small">The navbar supports:</p>
                                        <ul class="small">
                                            <li>Light/Dark themes</li>
                                            <li>Conditional components</li>
                                            <li>localStorage integration</li>
                                            <li>Real-time updates</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Sample content to demonstrate scrolling -->
                        <div class="mt-5">
                            <h5>Sample Content (Scroll to see fixed navbar in action)</h5>
                            <?php for($i = 1; $i <= 20; $i++): ?>
                            <div class="card mb-3">
                                <div class="card-body">
                                    <h6>Content Block <?= $i ?></h6>
                                    <p>This is sample content to demonstrate the fixed navbar functionality. 
                                    Notice how the navbar remains at the top as you scroll through this content.</p>
                                </div>
                            </div>
                            <?php endfor; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Font Awesome to Lucide converter -->
    <script src="../assets/js/fa-to-lucide.js"></script>
</body>
</html>
