<?php
/**
 * Migration: Add flow_position_range column to event_heat_settings
 * This allows specifying position ranges (e.g., "1-3", "4-8") for heat flow
 */

require_once __DIR__ . '/../includes/db.php';

try {
    $pdo->beginTransaction();
    
    // Check if column already exists
    $check = $pdo->query("SHOW COLUMNS FROM event_heat_settings LIKE 'flow_position_range'");
    
    if ($check->rowCount() == 0) {
        // Add the column
        $sql = "ALTER TABLE `event_heat_settings` 
                ADD COLUMN `flow_position_range` VARCHAR(50) DEFAULT NULL 
                COMMENT 'Position range from source heat (e.g., \"1-3\", \"4-8\")' 
                AFTER `flow_participants_per_category`";
        
        $pdo->exec($sql);
        echo "✅ Successfully added flow_position_range column to event_heat_settings\n";
    } else {
        echo "ℹ️  Column flow_position_range already exists, skipping migration\n";
    }
    
    $pdo->commit();
    echo "✅ Migration completed successfully!\n";
    
} catch (PDOException $e) {
    $pdo->rollBack();
    echo "❌ Migration failed: " . $e->getMessage() . "\n";
    exit(1);
}
?>
