<?php
/**
 * Initialize sort_order values for event participants
 * Sets sort_order = bib_number for all participants where sort_order is 0
 */

include_once '../includes/db.php';

$event_id = $_GET['event_id'] ?? null;
$heat_number = $_GET['heat_number'] ?? null;

if (!$event_id) {
    die(json_encode(['success' => false, 'message' => 'Event ID required']));
}

try {
    $pdo->beginTransaction();
    
    if ($heat_number) {
        // Initialize for specific heat
        $stmt = $pdo->prepare("
            UPDATE event_participants 
            SET sort_order = bib_number 
            WHERE event_id = ? AND heat_number = ? AND (sort_order IS NULL OR sort_order = 0)
        ");
        $stmt->execute([$event_id, $heat_number]);
        $updated = $stmt->rowCount();
    } else {
        // Initialize for entire event
        $stmt = $pdo->prepare("
            UPDATE event_participants 
            SET sort_order = bib_number 
            WHERE event_id = ? AND (sort_order IS NULL OR sort_order = 0)
        ");
        $stmt->execute([$event_id]);
        $updated = $stmt->rowCount();
    }
    
    $pdo->commit();
    
    echo json_encode([
        'success' => true,
        'message' => "Initialized sort_order for $updated participants",
        'updated_count' => $updated
    ]);
    
} catch (Exception $e) {
    if ($pdo->inTransaction()) {
        $pdo->rollBack();
    }
    echo json_encode([
        'success' => false,
        'message' => 'Error: ' . $e->getMessage()
    ]);
}
