<?php
include '../includes/auth.php';
include '../includes/db.php';
///
// https://sortablejs.github.io/Sortable/
///
// Define selected_event first
$selected_event = $_GET['event_id'] ?? $_COOKIE['event_id'] ?? $_COOKIE['selectedEventId'] ?? null;

// Fetch event list
$events = $pdo->query("SELECT id, name FROM events")->fetchAll(PDO::FETCH_ASSOC);

// Fetch filters - get categories from event_participants for selected event
$categories = [];
$genders = $pdo->query("SELECT DISTINCT gender FROM participants ORDER BY gender")->fetchAll(PDO::FETCH_COLUMN);
$clubs = $pdo->query("SELECT DISTINCT club FROM participants ORDER BY club")->fetchAll(PDO::FETCH_COLUMN);
$years = $pdo->query("SELECT DISTINCT YEAR(date_of_birth) as year FROM participants ORDER BY year DESC")->fetchAll(PDO::FETCH_COLUMN);

// Get categories specific to the selected event from event_participants
if ($selected_event) {
    $categories_stmt = $pdo->prepare("SELECT DISTINCT category FROM event_participants WHERE event_id = ? AND category IS NOT NULL ORDER BY category");
    $categories_stmt->execute([$selected_event]);
    $categories = $categories_stmt->fetchAll(PDO::FETCH_COLUMN);
}

// Load heat options for dropdowns in modals
$heat_options = [];
if ($selected_event) {
    $stmt = $pdo->prepare("SELECT heat_number, heat_name FROM event_heat_settings WHERE event_id = ? ORDER BY heat_number ASC");
    $stmt->execute([$selected_event]);
    $heat_options = $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// Load participants - show those assigned to event but not in any heat
if ($selected_event) {
$stmt = $pdo->prepare("
    SELECT DISTINCT p.id, p.bib, p.first_name, p.last_name, p.club, p.gender, p.date_of_birth,
           COALESCE(ep_cat.category, p.category) as category,
           0 as assignment_count,
           NULL as assigned_heats
    FROM participants p
    INNER JOIN participants_event pe ON p.id = pe.participant_id AND pe.event_id = ?
    LEFT JOIN event_participants ep ON p.id = ep.participant_id AND ep.event_id = ?
    LEFT JOIN event_participants ep_cat ON p.id = ep_cat.participant_id AND ep_cat.event_id = ? AND ep_cat.category IS NOT NULL
    WHERE (ep.id IS NULL OR ep.heat_number IS NULL)
    ORDER BY p.bib ASC
");
$stmt->execute([$selected_event, $selected_event, $selected_event]);
    $participants = $stmt->fetchAll(PDO::FETCH_ASSOC);
} else {
    // If no event selected, show all participants with their base category
    $participants = $pdo->query("SELECT id, bib, first_name, last_name, club, category, gender, date_of_birth, 0 as assignment_count, NULL as assigned_heats FROM participants ORDER BY first_name ASC")->fetchAll(PDO::FETCH_ASSOC);
}

// Assign logic
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['assign_participants'])) {
    $event_id = $_POST['event_id'];
    $heat_number = $_POST['heat_number'];
    $participants_to_assign = $_POST['participant_ids'] ?? [];

    foreach ($participants_to_assign as $participant_id) {
        if (!$participant_id) continue;

        // Check if participant already has a record in event_participants
        $check = $pdo->prepare("
            SELECT id, heat_number FROM event_participants 
            WHERE event_id = ? AND participant_id = ?
        ");
        $check->execute([$event_id, $participant_id]);
        $existing = $check->fetch(PDO::FETCH_ASSOC);
        
        if ($existing) {
            // Update existing record
            $stmt = $pdo->prepare("
                UPDATE event_participants 
                SET heat_number = ?, updated_at = NOW() 
                WHERE id = ?
            ");
            $stmt->execute([$heat_number, $existing['id']]);
        } else {
            // Insert new record
            $stmt = $pdo->prepare("
                INSERT INTO event_participants (event_id, participant_id, heat_number) 
                VALUES (?, ?, ?)
            ");
            $stmt->execute([$event_id, $participant_id, $heat_number]);
        }
    }
}

// Delete single
if (isset($_GET['delete_id'])) {
    // Get participant_id and event_id before deleting
    $stmt = $pdo->prepare("SELECT participant_id, event_id FROM event_participants WHERE id = ?");
    $stmt->execute([(int)$_GET['delete_id']]);
    $assignment = $stmt->fetch();
    
    if ($assignment) {
        // Delete from event_participants
        $pdo->prepare("DELETE FROM event_participants WHERE id = ?")->execute([(int)$_GET['delete_id']]);
        
        // Also remove from participants_event
       // $pdo->prepare("DELETE FROM participants_event WHERE participant_id = ? AND event_id = ?")->execute([
       //     $assignment['participant_id'], 
       //     $assignment['event_id']
       // ]);
    }
    
    header("Location: heats_configure.php?event_id=" . (int)$_GET['event_id']);
    exit;
}

// Bulk delete
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'bulk_delete_assignments') {
    // Collect IDs from both checkbox name formats
    $ids = array_merge(
        $_POST['delete_ids'] ?? [],           // Legacy table checkboxes
        $_POST['delete_assignments'] ?? []    // Heat board checkboxes
    );
    
    if ($ids) {
        // Get all participant_id and event_id pairs before deleting
        $placeholders = implode(',', array_fill(0, count($ids), '?'));
        $stmt = $pdo->prepare("SELECT participant_id, event_id FROM event_participants WHERE id IN ($placeholders)");
        $stmt->execute($ids);
        $assignments = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        // Delete from event_participants
        $in = implode(',', array_fill(0, count($ids), '?'));
        $pdo->prepare("DELETE FROM event_participants WHERE id IN ($in)")->execute($ids);
        
        // Also remove from participants_event for each assignment
        //foreach ($assignments as $assignment) {
        //    $pdo->prepare("DELETE FROM participants_event WHERE participant_id = ? AND event_id = ?")->execute([
        //        $assignment['participant_id'], 
        //        $assignment['event_id']
        //    ]);
        //}
    }
    header("Location: heats_configure.php?event_id=" . (int)$_GET['event_id']);
    exit;
}

// Auto assign
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['auto_assign'])) {
    $event_id = $_GET['event_id'];
    $heat_number = $_POST['auto_heat'];
    $ids = explode(',', $_POST['filtered_ids']);
    foreach ($ids as $participant_id) {
        $bib_check = $pdo->prepare("
            SELECT COUNT(*) FROM event_participants ep
            JOIN participants p ON ep.participant_id = p.id
            WHERE ep.event_id = ? AND ep.heat_number = ? AND p.bib = (
                SELECT bib FROM participants WHERE id = ?
            )
        ");
        $bib_check->execute([$event_id, $heat_number, $participant_id]);
        if ($bib_check->fetchColumn() == 0) {
            $stmt = $pdo->prepare("INSERT INTO event_participants (event_id, participant_id, heat_number) VALUES (?, ?, ?)");
            $stmt->execute([$event_id, $participant_id, $heat_number]);
        }
    }
    header("Location: heats_configure.php?event_id=" . $event_id);
    exit;
}

// Current assignments
$assignments = [];
$selected_event = $_GET['event_id'] ?? null;
$heat_filter = $_GET['heat_filter'] ?? null;
// Current assignments - get bib from event_participants.bib_number
if ($selected_event) {
    $query = "
        SELECT ep.id, ep.heat_number, ep.bib_number as bib, ep.category, 
               p.first_name, p.last_name, p.club, p.gender, p.date_of_birth, p.id as participant_id
        FROM event_participants ep
        JOIN participants p ON ep.participant_id = p.id
        WHERE ep.event_id = ?
    ";
    
    if ($heat_filter) {
        $query .= " AND ep.heat_number = ? ORDER BY ep.sort_order ASC, ep.bib_number ASC";
        $stmt = $pdo->prepare($query);
        $stmt->execute([$selected_event, $heat_filter]);
    } else {
        $query .= " ORDER BY ep.sort_order ASC, ep.bib_number ASC";
        $stmt = $pdo->prepare($query);
        $stmt->execute([$selected_event]);
    }
    $assignments = $stmt->fetchAll(PDO::FETCH_ASSOC);
}



    // Get bib series
    $stmt = $pdo->prepare("SELECT * FROM bib_series WHERE event_id = ? ORDER BY id ASC");
    $stmt->execute([$selected_event]);
    $bib_series = $stmt->fetchAll(PDO::FETCH_ASSOC);

?>
<!DOCTYPE html>
<html>
<head>
     <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Configure Heats</title>
    <?php include_once '../includes/stylesheets.php'; ?>
    
    <!-- jQuery UI CSS for legacy table sortable -->
    <link rel="stylesheet" href="../assets/css/jquery-ui.min.css">
    
    <!-- SortableJS for drag-and-drop heat reordering -->
    <script src="../assets/js/vendor/Sortable.min.js"></script>
    <script>
        // Mount MultiDrag plugin for SortableJS (if available)
        if (window.Sortable && window.Sortable.MultiDrag) {
            Sortable.mount(new Sortable.MultiDrag());
            console.log('✅ SortableJS MultiDrag plugin mounted successfully');
        } else if (window.Sortable) {
            console.warn('⚠️ SortableJS loaded but MultiDrag plugin not available - will use custom multi-drag');
        } else {
            console.error('❌ SortableJS not loaded');
        }
    </script>
    
    <!-- jQuery for legacy table functionality -->
    <script src="../assets/js/vendor/jquery-3.6.0.min.js"></script>
    <script src="../assets/js/vendor/jquery-ui.min.js"></script>

<script>
    function collectFiltered() {
        let visible = Array.from(document.querySelectorAll('#participantSelect option'))
            .filter(opt => opt.style.display !== 'none')
            .map(opt => opt.value);
        document.getElementById('autoFilteredIDs').value = visible.join(',');
    }
    </script>
</head>
<body class="body-bg-aurora-bright">
    <?php include '../menu.php'; ?>
<div class="container-fluid p-4 container-StyleScore">
    <!-- event action menu. -->
    <div class="row mb-2">
        <div class="col-12 d-flex flex-row align-items-center gap-3">
            <?php       
            $use_localStorage = true;
            $show_header = false;
            //$show_public_view = false;
            include 'event_actions_menu.php'; 
            ?>

            <form method="get" class="card border mb-2 load-event-selection d-none">
                <div class="border-0 shadow-none card-body p-2">
                    <div class="row align-items-center">
                        <div class="col-md-2">
                            <label class="form-label small fw-bold mb-0">Event:</label>
                        </div>
                        <div class="col-md-10">
                            <select name="event_id" class="form-select form-select-sm" onchange="this.form.submit()" required>
                                <option value="">-- Choose Event --</option>
                                <?php foreach ($events as $event): ?>
                                    <option value="<?= $event['id'] ?>" <?= $selected_event == $event['id'] ? 'selected' : '' ?>>
                                        <?= htmlspecialchars($event['name']) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>
            </form>
            <!-- Header -->
        <div class="d-flex justify-content-between align-items-center mb-3 me-auto">
        <div>
            <h1 class="h4 mb-1">
                <i class="fas fa-users text-primary me-2"></i>Assign Athletes to Heats
            </h1>
            <p class="text-muted mb-0 small">Manage judges, control points, and event assignments</p>
        </div>
       
    </div>

           
            
               
      <?php if ($selected_event): ?>
        <?php
            // Calculate workspace metrics
            $totalParticipants = count($participants);
            $assignedCount = count($assignments);
            $heatCount = count($heat_options);
        ?>
                             
        <!-- Workspace Metrics Strip -->
        <div class="g-3 mb-3 row col-md-5 d-none d-lg-flex">
            <div class="col-auto">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-body">
                        <p class="text-muted text-uppercase small mb-1 fw-bold">Available Pool</p>
                        <div class="d-flex align-items-end justify-content-between">
                            <h3 class="mb-0 fw-bold"><?= $totalParticipants ?></h3>
                            <span class="badge bg-info-subtle text-info">Unassigned</span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-auto">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-body">
                        <p class="text-muted text-uppercase small mb-1 fw-bold">Assigned to Heats</p>
                        <div class="d-flex align-items-end justify-content-between">
                            <h3 class="mb-0 fw-bold"><?= $assignedCount ?></h3>
                            <span class="badge bg-success-subtle text-success">Active</span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-auto">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-body">
                        <p class="text-muted text-uppercase small mb-1 fw-bold">Heats Configured</p>
                        <div class="d-flex align-items-end justify-content-between">
                            <h3 class="mb-0 fw-bold"><?= $heatCount ?></h3>
                            <span class="badge bg-primary-subtle text-primary">Ready</span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-auto">
                <button type="button" class="btn btn-outline-secondary btn-sm" data-bs-toggle="modal" data-bs-target="#helpModal">
                <i class="fas fa-question-circle me-1"></i>Help
                </button>
            </div>
            
        </div>
           
        </div>
    </div>
        
   

       
        <!-- Two-Pane Workspace -->
        <div class="row g-3 align-items-start">
            <!-- Left Pane: Available Athletes -->
            <div class="col-12 col-lg-5 col-xxl-4 order-2 order-lg-1 border-bottom position-sticky" style="z-index: 100; top: 0px;">
                <div class="card shadow-sm">
                <div class="card shadow-sm">
                    <!-- Sticky Card Header -->
                    <div class="card-header bg-white border-bottom sticky-top p-2" style="top: 0; z-index: 100;">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-1">
                                    <i class="fas fa-users me-1 text-warning"></i>Available Athletes
                                </h6>
                                <small class="text-muted">Filter → select → assign</small>
                            </div>
                            <div class="d-flex gap-2 align-items-center">
                                <button type="button" id="bulkUnassignParticipantsBtn" 
                                        class="btn btn-warning btn-sm" 
                                        style="display: none;"
                                        title="Unassign selected from all heats">
                                    <i class="fas fa-user-minus me-1"></i>Unassign Selected
                                </button>
                                <span id="participantStatusBadge" class="badge bg-info">0 selected</span>
                            </div>
                        </div>
                    </div>
                    
                    <div class="card-body p-2">
                        <form method="post" id="ajaxAssignForm" data-event="<?= $selected_event ?>">
                            <input type="hidden" name="event_id" value="<?= $selected_event ?>">
                            <input type="hidden" name="assign_participants" value="1">
                            
                            <!-- Filter Palette -->
                            <div class="mb-3">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <label class="form-label small fw-bold mb-0">
                                        <i class="fas fa-filter me-1 text-info"></i>Filters
                                    </label>
                                    <button type="button" class="btn btn-link btn-sm p-0 text-decoration-none" onclick="clearAllFiltersAndSearch()">
                                        <i class="fas fa-eraser me-1"></i>Clear all
                                    </button>
                                </div>
                                <div class="row g-2">
                                    <div class="col-3">
                                        <select id="categoryFilter" class="form-select form-select-sm" onchange="filterParticipants()">
                                            <option value="">All Divisions</option>
                                            <?php 
                                            $available_categories = array_unique(array_filter(array_column($participants, 'category')));
                                            sort($available_categories);
                                            foreach ($available_categories as $c): ?>
                                                <option value="<?= htmlspecialchars($c) ?>"><?= htmlspecialchars($c) ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    <div class="col-3">
                                        <select id="genderFilter" class="form-select form-select-sm" onchange="filterParticipants()">
                                            <option value="">All Genders</option>
                                            <?php foreach ($genders as $g): ?>
                                                <option value="<?= htmlspecialchars($g) ?>"><?= htmlspecialchars($g) ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    <div class="col-3">
                                        <select id="clubFilter" class="form-select form-select-sm" onchange="filterParticipants()">
                                            <option value="">All Clubs</option>
                                            <?php foreach ($clubs as $c): ?>
                                                <option value="<?= htmlspecialchars($c) ?>"><?= htmlspecialchars($c) ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    <div class="col-3">
                                        <div class="input-group input-group-sm">
                                            <select id="yearFilter" class="form-select form-select-sm" onchange="handleYearFilterChange()" style="flex: 1;">
                                                <option value="">All Years</option>
                                                <optgroup label="Single Years">
                                                    <?php 
                                                    $participantYears = array_unique(array_filter(array_map(function($p) {
                                                        return $p['date_of_birth'] ? date('Y', strtotime($p['date_of_birth'])) : null;
                                                    }, $participants)));
                                                    rsort($participantYears);
                                                    foreach ($participantYears as $y): ?>
                                                        <option value="<?= $y ?>"><?= $y ?></option>
                                                    <?php endforeach; ?>
                                                </optgroup>
                                                <optgroup label="Custom Range">
                                                    <option value="custom-range">📅 Custom Range...</option>
                                                </optgroup>
                                            </select>
                                            <button class="btn btn-outline-secondary" type="button" id="yearRangeBtn" style="display: none;" onclick="showYearRangeModal()" title="Edit year range">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Search Bar -->
                            <div class="input-group input-group-sm mb-3">
                                <span class="input-group-text"><i class="fas fa-search"></i></span>
                                <input type="text" id="participantSearch" class="form-control" placeholder="Search name, bib, club..." onkeyup="searchParticipants()">
                                <button class="btn btn-outline-secondary" type="button" onclick="clearSearch()" title="Clear search">
                                    <i class="fas fa-times"></i>
                                </button>
                            </div>
                            
                            <!-- Selection Actions -->
                            <div class="d-flex justify-content-between align-items-center mb-2 d-none">
                                <div class="btn-group btn-group-sm" role="group">
                                    <button type="button" class="btn btn-outline-primary" onclick="selectAllVisible()" title="Select all visible (Ctrl+A)">
                                        <i class="fas fa-check-double"></i>
                                    </button>
                                    <button type="button" class="btn btn-outline-secondary" onclick="clearSelection()" title="Clear selection (Esc)">
                                        <i class="fas fa-times"></i>
                                    </button>
                                </div>
                                <div class="text-muted small">
                                    <span id="visibleCount"><?= count($participants) ?></span> visible • 
                                    <span id="selectedCount">0</span> selected
                                </div>
                            </div>
                            
                            <!-- Hidden Select for Form Submission -->
                            <select name="participant_ids[]" id="participantSelect" multiple style="display: none;">
                                <?php foreach ($participants as $p): ?>
                                    <option value="<?= $p['id'] ?>" 
                                            data-category="<?= htmlspecialchars($p['category'] ?? '') ?>" 
                                            data-gender="<?= htmlspecialchars($p['gender'] ?? '') ?>" 
                                            data-club="<?= htmlspecialchars($p['club'] ?? '') ?>" 
                                            data-date_of_birth="<?= $p['date_of_birth'] ?? '' ?>"
                                            data-year="<?= $p['date_of_birth'] ? date('Y', strtotime($p['date_of_birth'])) : '' ?>"
                                            data-assigned="<?= $p['assignment_count'] ?>"
                                            data-heats="<?= htmlspecialchars($p['assigned_heats'] ?? '') ?>">
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            
                            <!-- Participants Table with Sticky Header -->
                            <div class="participant-display-container position-relative" style="max-height: 50vh; overflow-y: auto;">
                                <table class="table table-hover table-sm mb-0" id="participantsTable">
                                    <thead class="table-light sticky-top" style="top: 0;">
                                        <tr>
                                            <th width="40"><input type="checkbox" id="selectAllParticipants" class="form-check-input"></th>
                                            <th width="60">BIB</th>
                                            <th>Name</th>
                                            <th>Cat</th>
                                            <th width="50">G</th>
                                            <th width="60">YoB</th>
                                            <th width="80"></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if (empty($participants)): ?>
                                            <tr>
                                                <td colspan="7" class="text-center text-muted py-4">
                                                    <i class="fas fa-users fa-2x mb-2 opacity-50"></i>
                                                    <p class="mb-0 small">No participants available</p>
                                                    <small class="text-muted">All may be assigned to heats</small>
                                                </td>
                                            </tr>
                                        <?php else: ?>
                                            <?php foreach ($participants as $p): ?>
                                                <tr class="participant-row" 
                                                    data-id="<?= $p['id'] ?>"
                                                    data-category="<?= htmlspecialchars($p['category'] ?? '') ?>" 
                                                    data-gender="<?= htmlspecialchars($p['gender'] ?? '') ?>" 
                                                    data-club="<?= htmlspecialchars($p['club'] ?? '') ?>" 
                                                    data-date_of_birth="<?= $p['date_of_birth'] ?? '' ?>"
                                                    data-year="<?= $p['date_of_birth'] ? date('Y', strtotime($p['date_of_birth'])) : '' ?>"
                                                    data-assigned="<?= $p['assignment_count'] ?>"
                                                    data-heats="<?= htmlspecialchars($p['assigned_heats'] ?? '') ?>"
                                                    data-search-text="<?= strtolower($p['last_name'] . ' ' . $p['first_name'] . ' ' . $p['bib'] . ' ' . ($p['club'] ?? '')) ?>">
                                                    <td onclick="event.stopPropagation()">
                                                        <input type="checkbox" class="form-check-input participant-checkbox" value="<?= $p['id'] ?>">
                                                    </td>
                                                    <td class="drag-handle css-bib">
                                                        <i class="fas fa-grip-vertical text-muted me-1" style="cursor: grab;" title="Drag to heat"></i>
                                                        <span class="badge bg-secondary"><?= htmlspecialchars($p['bib']) ?></span>
                                                    </td>
                                                    <td>
                                                        <div class="fw-bold small"><?= htmlspecialchars($p['last_name'] . ' ' . $p['first_name']) ?></div>
                                                    </td>
                                                    <td><span class="badge bg-info small"><?= htmlspecialchars($p['category'] ?? 'No Division!') ?></span></td>
                                                    <td>
                                                        <span class="badge bg-<?= $p['gender'] === 'M' ? 'primary' : 'danger' ?>">
                                                            <?= htmlspecialchars($p['gender'] ?? '') ?>
                                                        </span>
                                                    </td>
                                                    <td class="small"><?= $p['date_of_birth'] ? date('Y', strtotime($p['date_of_birth'])) : '-' ?></td>
                                                    <td>
                                                        <?php if ($p['assignment_count'] > 0): ?>
                                                            <div class="d-flex gap-1 align-items-center">
                                                                <span class="badge bg-warning small">H<?= $p['assigned_heats'] ?></span>
                                                                <button type="button" class="btn btn-outline-danger btn-sm p-0" 
                                                                        style="width: 20px; height: 20px; line-height: 1;"
                                                                        onclick="unassignParticipant(<?= $p['id'] ?>)" 
                                                                        title="Remove from all heats">
                                                                    <i class="fas fa-times" style="font-size: 10px;"></i>
                                                                </button>
                                                            </div>
                                                        <?php else: ?>
                                                            <a href="participant_edit.php?id=<?= $p['id'] ?>" class="btn btn-outline-primary btn-sm" title="Edit Participant" target="_blank">
                                                                                <i class="fas fa-edit"></i>
                                                                            </a>
                                                        <?php endif; ?>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                                
                                <!-- No Results Message -->
                                <div id="noParticipantsMessage" class="text-center py-4" style="display: none;">
                                    <i class="fas fa-search fa-2x text-muted mb-2"></i>
                                    <h6 class="text-muted">No participants found</h6>
                                    <p class="text-muted small">Adjust your filters</p>
                                    <button type="button" class="btn btn-outline-primary btn-sm" onclick="clearAllFiltersAndSearch()">
                                        <i class="fas fa-redo me-1"></i>Reset
                                    </button>
                                </div>
                            </div>
                            
                            <!-- Quick Assign Drawer -->
                            <div class="mt-3 p-3 bg-light rounded border">
                                <div class="row g-2 align-items-end">
                                    <div class="col-md-7">
                                        <label for="heat_number" class="form-label small fw-bold mb-1">
                                            <i class="fas fa-fire me-1 text-primary"></i>Assign to Heat
                                        </label>
                                        <select name="heat_number" id="heat_number" class="form-select form-select-sm" required>
                                            <option value="">-- Select Heat --</option>
                                            <?php foreach ($heat_options as $heat): ?>
                                                <option value="<?= $heat['heat_number'] ?>">
                                                    Heat <?= $heat['heat_number'] ?><?= $heat['heat_name'] ? ' – ' . htmlspecialchars($heat['heat_name']) : '' ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    <div class="col-md-5">
                                        <div class="d-flex gap-1">
                                            <button type="button" id="ajaxAssignBtn" class="btn btn-success btn-sm flex-grow-1">
                                                <i class="fas fa-user-plus me-1"></i>Assign
                                            </button>
                                            <button type="button" id="bulkUnassignBtn" class="btn btn-warning btn-sm" title="Unassign selected from all heats">
                                                <i class="fas fa-user-minus"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                <div class="mt-2 text-muted small">
                                    <i class="fas fa-info-circle me-1"></i>Tip: Click rows to select, then assign to heat
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
             </div>
            <!-- Right Pane: Heat Assignments -->
            <div class="col-12 col-lg-7 col-xxl-8 order-1 order-lg-2">
                <div class="card shadow-sm">
                    <!-- Heat Overview Chips -->
                    <div class="card-header bg-white border-bottom sticky-lg-top pb-2 p-2" style="z-index: 100; top: 20px;">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <h6 class="mb-0 fw-bold">
                                <i class="fas fa-fire text-primary me-2"></i>Heat Boards
                                <span class="badge bg-primary ms-2"><?= count($heat_options) ?></span>
                            </h6>
                            <div class="btn-group btn-group-sm">
                                <button type="button" class="btn btn-outline-secondary" onclick="expandAllHeats()">
                                    <i class="fas fa-expand-alt me-1"></i>Expand All
                                </button>
                                <button type="button" class="btn btn-outline-secondary" onclick="collapseAllHeats()">
                                    <i class="fas fa-compress-alt me-1"></i>Collapse All
                                </button>
                            </div>
                        </div>
                        
                        <!-- Heat Chips Scroller -->
                        <div class="heat-chips-scroller mb-1" style="overflow-x: auto; white-space: nowrap; padding-bottom: 8px;">
                            <?php foreach ($heat_options as $heat): ?>
                                <?php
                                $heat_count = 0;
                                foreach ($assignments as $a) {
                                    if ($a['heat_number'] == $heat['heat_number']) {
                                        $heat_count++;
                                    }
                                }
                                ?>
                                <button type="button" 
                                        class="btn btn-sm btn-outline-primary me-2 heat-chip" 
                                        data-heat="<?= $heat['heat_number'] ?>"
                                        onclick="scrollToHeat(<?= $heat['heat_number'] ?>)">
                                    <i class="fas fa-fire me-1"></i>
                                    Heat <?= $heat['heat_number'] ?>
                                    <?= $heat['heat_name'] ? '<small class="ms-1">(' . htmlspecialchars($heat['heat_name']) . ')</small>' : '' ?>
                                    <span class="badge bg-primary ms-1"><?= $heat_count ?></span>
                                </button>
                            <?php endforeach; ?>
                        </div>
                        
                        <!-- Enhanced Filters -->
                        <div class="p-2 bg-light border-bottom">
                            <div class="row g-1">
                                <div class="col-md-2">
                                    <select id="filterHeat" class="form-select form-select-sm" onchange="filterReorderTable()">
                                        <option value="">All Heats</option>
                                        <?php foreach ($heat_options as $heat): ?>
                                            <option value="<?= $heat['heat_number'] ?>">
                                                Heat <?= $heat['heat_number'] ?><?= $heat['heat_name'] ? ' – ' . htmlspecialchars($heat['heat_name']) : '' ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="col-md-2">
                                    <select id="filterCategory" class="form-select form-select-sm" onchange="filterReorderTable()">
                                        <option value="">All Divisions</option>
                                        <option value="No Division">No Division</option>
                                        <?php 
                                        $assignment_categories = array_unique(array_filter(array_column($assignments, 'category')));
                                        sort($assignment_categories);
                                        foreach ($assignment_categories as $c): ?>
                                            <option value="<?= htmlspecialchars($c) ?>"><?= htmlspecialchars($c) ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="col-md-2">
                                    <select id="filterClub" class="form-select form-select-sm" onchange="filterReorderTable()">
                                        <option value="">All Clubs</option>
                                        <?php foreach ($clubs as $c): ?>
                                            <option value="<?= htmlspecialchars($c) ?>"><?= htmlspecialchars($c) ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="col-md-2">
                                    <select id="filterGender" class="form-select form-select-sm" onchange="filterReorderTable()">
                                        <option value="">All Genders</option>
                                        <?php foreach ($genders as $g): ?>
                                            <option value="<?= htmlspecialchars($g) ?>"><?= htmlspecialchars($g) ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="col-md-2">
                                    <select id="filterYear" class="form-select form-select-sm" onchange="filterReorderTable()">
                                        <option value="">All Years</option>
                                        <optgroup label="Single Years">
                                            <?php foreach ($years as $y): ?>
                                                <option value="<?= $y ?>"><?= $y ?></option>
                                            <?php endforeach; ?>
                                        </optgroup>
                                        <optgroup label="Year Ranges">
                                            <option value="2010-2015">2010-2015</option>
                                            <option value="2016-2020">2016-2020</option>
                                            <option value="2021-2025">2021-2025</option>
                                            <option value="before-2010">Before 2010</option>
                                            <option value="after-2020">After 2020</option>
                                        </optgroup>
                                        <optgroup label="Age Groups">
                                            <?php
                                            $currentYear = date('Y');
                                            $ageGroups = [
                                                'under-18' => 'Under 18 (' . ($currentYear - 17) . '+)',
                                                'under-21' => 'Under 21 (' . ($currentYear - 20) . '+)', 
                                                'under-25' => 'Under 25 (' . ($currentYear - 24) . '+)',
                                                'over-30' => 'Over 30 (' . ($currentYear - 30) . '-)',
                                                'over-40' => 'Over 40 (' . ($currentYear - 40) . '-)',
                                                'over-50' => 'Over 50 (' . ($currentYear - 50) . '-)'
                                            ];
                                            foreach ($ageGroups as $value => $label): ?>
                                                <option value="<?= $value ?>"><?= $label ?></option>
                                            <?php endforeach; ?>
                                        </optgroup>
                                    </select>
                                </div>
                                <div class="col-md-2 d-flex align-items-end">
                                    <button type="button" class="btn btn-outline-secondary btn-sm w-100" onclick="clearFilters()">
                                        <i class="fas fa-times me-1"></i>Clear
                                    </button>
                                </div>
                            </div>
                        </div>

                        <!-- Action Buttons -->
                        <div class="p-1 bg-white">
                            <div class="align-items-center d-flex flex-wrap gap-1 justify-content-between">
                                <button type="button" id="reverseSelectedBtn" class="btn btn-outline-secondary btn-sm">
                                    <i class="fas fa-exchange-alt me-1"></i>Reverse
                                </button>
                                <button type="button" id="shuffleSelectedBtn" class="btn btn-outline-warning btn-sm">
                                    <i class="fas fa-random me-1"></i>Shuffle
                                </button>
                                <button type="button" id="sortByNameBtn" class="btn btn-outline-info btn-sm">
                                    <i class="fas fa-sort-alpha-down me-1"></i>by Name
                                </button>
                                <button type="button" id="sortByBibBtn" class="btn btn-outline-dark btn-sm">
                                    <i class="fas fa-sort-numeric-down me-1"></i>by BIB
                                </button>
                                <button type="button" id="sortByYearBtn" class="btn btn-outline-secondary btn-sm">
                                    <i class="fas fa-calendar me-1"></i>by Year
                                </button>
                                <button type="button" id="sortByGenderBtn" class="btn btn-outline-info btn-sm">
                                    <i class="fas fa-venus-mars me-1"></i>by Gender
                                </button>
                                <div class="vr mx-1"></div>
                                <button type="button" class="btn btn-outline-success btn-sm" data-bs-toggle="modal" data-bs-target="#assignbibModal">
                                    <i class="fas fa-hashtag me-1"></i>Assign BIB
                                </button>
                                <button type="button" id="moveToHeatBtn" class="btn btn-outline-info btn-sm" data-bs-toggle="modal" data-bs-target="#moveToHeatModal">
                                    <i class="fas fa-arrow-right me-1"></i>Move to Heat
                                </button>
                                <button type="button" id="promoteToHeatBtn" class="btn btn-outline-warning btn-sm">
                                    <i class="fas fa-level-up-alt me-1"></i>Promote to Heat
                                </button>
                                <div class="vr mx-1"></div>
                                <button type="submit" class="btn btn-outline-danger btn-sm" form="bulkDeleteForm">
                                    <i class="fas fa-trash me-1"></i>Remove
                                </button>
                            </div>
                        </div>
                        
                        <!-- Old Filters Toolbar (keeping for backward compatibility) -->
                        <div class="row g-2" style="display: none;">
                            <div class="col-6 col-md-3">
                                <select id="filter_heat_assignments" class="form-select form-select-sm" onchange="filterAssignments()">
                                    <option value="">All Heats</option>
                                    <?php foreach ($heat_options as $heat): ?>
                                        <option value="<?= $heat['heat_number'] ?>">Heat <?= $heat['heat_number'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col-6 col-md-3">
                                <select id="filter_category_assignments" class="form-select form-select-sm" onchange="filterAssignments()">
                                    <option value="">All Categories</option>
                                    <?php foreach ($categories as $cat): ?>
                                        <option value="<?= htmlspecialchars($cat) ?>"><?= htmlspecialchars($cat) ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col-6 col-md-3">
                                <select id="filter_gender_assignments" class="form-select form-select-sm" onchange="filterAssignments()">
                                    <option value="">All Genders</option>
                                    <option value="M">Male</option>
                                    <option value="F">Female</option>
                                </select>
                            </div>
                            <div class="col-6 col-md-3">
                                <button type="button" class="btn btn-outline-secondary btn-sm w-100" onclick="clearAssignmentFilters()">
                                    <i class="fas fa-times me-1"></i>Clear
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <div class="card-body" style=" overflow-y: auto;">
                        <?php if (empty($heat_options)): ?>
                            <div class="text-center py-5">
                                <i class="fas fa-fire fa-3x text-muted mb-3"></i>
                                <h5 class="text-muted">No heats configured</h5>
                                <p class="text-muted">Configure heat settings to start assigning participants</p>
                                <a href="heat_settings.php?event_id=<?= $selected_event ?>" class="btn btn-primary">
                                    <i class="fas fa-cog me-1"></i>Configure Heat Settings
                                </a>
                            </div>
                        <?php else: ?>
                            <?php foreach ($heat_options as $heat): ?>
                                <?php
                                $heat_assignments = array_filter($assignments, function($a) use ($heat) {
                                    return $a['heat_number'] == $heat['heat_number'];
                                });
                                ?>
                                <div class="heat-board mb-4" id="heat-<?= $heat['heat_number'] ?>" data-heat="<?= $heat['heat_number'] ?>">
                                    <div class="card">
                                        <div class="card-header bg-light p-2">
                                            <div class="d-flex justify-content-between align-items-center">
                                                <div>
                                                    <h6 class="mb-0">
                                                        
                                                        <strong><?= $heat['heat_name'] ? '' . htmlspecialchars($heat['heat_name']) : '' ?></strong>
                                                        <i class="fas fa-fire text-primary me-2"></i>Heat <?= $heat['heat_number'] ?>
                                                        <span class="badge bg-primary ms-2"><?= count($heat_assignments) ?></span>
                                                    </h6>
                                                </div>
                                                <div class="btn-group btn-group-sm">
                                                    <button type="button" class="btn btn-sm btn-outline-primary" onclick="openHeatConfigModal(<?= $heat['heat_number'] ?>)" title="Configure Heat Settings">
                                                        <i class="fas fa-cog"></i>
                                                    </button>
                                                    <button type="button" class="btn btn-sm btn-outline-secondary" onclick="toggleHeatCollapse(<?= $heat['heat_number'] ?>)">
                                                        <i class="fas fa-chevron-down collapse-icon"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-body collapse show heat-collapse p-1">
                                            <div class="table-responsive">
                                                <table class="table table-sm table-hover mb-0">
                                                    <thead class="table-light">
                                                        <tr>
                                                            <th width="40">
                                                                <input type="checkbox" class="form-check-input heat-check-all" data-heat="<?= $heat['heat_number'] ?>">
                                                            </th>
                                                            <th width="60">Bib</th>
                                                            <th>Name</th>
                                                            <th width="120">Category</th>
                                                            <th width="80">Gender</th>
                                                            <th width="80">Year</th>
                                                            <th width="100">Actions</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody class="sortable-tbody" data-heat="<?= $heat['heat_number'] ?>">
                                                        <?php if (empty($heat_assignments)): ?>
                                                            <tr class="empty-heat-placeholder">
                                                                <td colspan="7" class="text-center text-muted" style="height: 100px; vertical-align: middle;">
                                                                    <i class="fas fa-users-slash fa-2x mb-2 opacity-50 d-block"></i>
                                                                    <p class="mb-0 small">Drag participants here to assign to this heat</p>
                                                                </td>
                                                            </tr>
                                                        <?php else: ?>
                                                            <?php foreach ($heat_assignments as $a): ?>
                                                                <tr class="assignment-row"
                                                                    data-assignment-id="<?= $a['id'] ?>"
                                                                    data-heat="<?= $a['heat_number'] ?>"
                                                                    data-category="<?= htmlspecialchars($a['category'] ?? '') ?>"
                                                                    data-gender="<?= htmlspecialchars($a['gender'] ?? '') ?>"
                                                                    data-club="<?= htmlspecialchars($a['club'] ?? '') ?>"
                                                                    data-year="<?= $a['date_of_birth'] ? date('Y', strtotime($a['date_of_birth'])) : '' ?>"
                                                                    style="cursor: pointer;"
                                                                    title="Click to select, drag to move">
                                                                    <td onclick="event.stopPropagation()">
                                                                        <input type="checkbox" class="form-check-input assignment-checkbox" 
                                                                               name="delete_assignments[]" 
                                                                               value="<?= $a['id'] ?>" 
                                                                               form="bulkDeleteForm">
                                                                    </td>
                                                                    <td class="drag-handle css-bib">
                                                                        <i class="fas fa-grip-vertical text-muted me-1" style="cursor: grab;" title="Drag to reorder or move"></i>
                                                                        <span class="badge bg-secondary"><?= htmlspecialchars($a['bib']) ?></span>
                                                                    </td>
                                                                    <td>
                                                                        <div class="fw-bold small"><?= htmlspecialchars($a['last_name'] . ' ' . $a['first_name']) ?></div>
                                                                    </td>
                                                                    <td>
                                                                        <span class="badge bg-info small<?= !$a['category'] ? ' bg-warning' : '' ?>"><?= htmlspecialchars($a['category'] ?? 'No Division!') ?></span>
                                                                    </td>
                                                                    <td>
                                                                        <span class="badge bg-<?= $a['gender'] === 'M' ? 'primary' : 'danger' ?> small">
                                                                            <?= htmlspecialchars($a['gender'] ?? '') ?>
                                                                        </span>
                                                                    </td>
                                                                    <td class="small">
                                                                        <?= $a['date_of_birth'] ? date('Y', strtotime($a['date_of_birth'])) : '-' ?>
                                                                    </td>
                                                                    <td>
                                                                        <div class="btn-group btn-group-sm" role="group">
                                                                            <a href="participant_edit.php?id=<?= $a['participant_id'] ?>" 
                                                                               class="btn btn-outline-primary btn-sm" 
                                                                               title="Edit Participant"
                                                                               target="_blank">
                                                                                <i class="fas fa-edit"></i>
                                                                            </a>
                                                                            <button type="button" class="btn btn-outline-danger btn-sm" 
                                                                                    onclick="removeAssignment(<?= $a['id'] ?>)" 
                                                                                    title="Remove from Heat">
                                                                                <i class="fas fa-times"></i>
                                                                            </button>
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                            <?php endforeach; ?>
                                                        <?php endif; ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Bulk Delete Form -->
        <form id="bulkDeleteForm" method="POST" style="display: none;">
            <input type="hidden" name="action" value="bulk_delete_assignments">
        </form>
        
    <?php endif; ?>
    
    <!-- Legacy Assignment Table (Hidden - kept for JS compatibility) -->
    <div style="display: none;" class="legacy-section">
        <div class="card">
            <div class="card-header">
                <h5>Legacy Heat Management</h5>
            </div>
            <div class="card-body">
                <div class="border-0 shadow-none card-header bg-light py-2 justify-content-between align-items-center">
                    <h6 class="mb-0">
                        <i class="fas fa-fire me-1"></i>Heat Assignments (<?= count($assignments) ?> participants)
                    </h6>
                  <small class="text-muted">Select a heat and participants to assign them quickly</small>
                    
                </div>
                <div class="border-0 shadow-none card-body p-0">
                     <label class="form-label small fw-bold">
                <i class="fas fa-filter me-1 text-info"></i>Filter Athletes
            </label>
                                    <!-- Dynamic Filters -->
                                    <div class="p-2 bg-light border-bottom">
                                        <div class="row g-1">
                                            <div class="col-md-2">
                                                <select id="filterHeat" class="form-select form-select-sm" onchange="filterReorderTable()">
                                                    <option value="">All Heats</option>
                                                    <?php
                                                    if ($selected_event) {
                                                        $stmt = $pdo->prepare("SELECT heat_number, heat_name FROM event_heat_settings WHERE event_id = ? ORDER BY heat_number ASC");
                                                        $stmt->execute([$selected_event]);
                                                        foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $heat) {
                                                            echo '<option value="' . $heat['heat_number'] . '">' . $heat['heat_number'] . ($heat['heat_name'] ? ' – ' . htmlspecialchars($heat['heat_name']) : '') . '</option>';
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                            <div class="col-md-2">
                                                <select id="filterCategory" class="form-select form-select-sm" onchange="filterReorderTable()">
                                                    <option value="">All Divisions</option>
                                                    <option value="No Div">No Division</option>
                                                    <?php 
                                                    // Get categories from current assignments
                                                    $assignment_categories = array_unique(array_filter(array_column($assignments, 'category')));
                                                    sort($assignment_categories);
                                                    foreach ($assignment_categories as $c): ?>
                                                        <option value="<?= htmlspecialchars($c) ?>"><?= htmlspecialchars($c) ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                            <div class="col-md-2">
                                                <select id="filterClub" class="form-select form-select-sm" onchange="filterReorderTable()">
                                                    <option value="">All Clubs</option>
                                                    <?php foreach ($clubs as $c): ?>
                                                        <option value="<?= $c ?>"><?= $c ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                            <div class="col-md-2">
                                                <select id="filterGender" class="form-select form-select-sm" onchange="filterReorderTable()">
                                                    <option value="">All Genders</option>
                                                    <?php foreach ($genders as $g): ?>
                                                        <option value="<?= $g ?>"><?= $g ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                            <div class="col-md-2">
                                                <select id="filterYear" class="form-select form-select-sm" onchange="filterReorderTable()">
                                                    <option value="">All Years</option>
                                                    <optgroup label="Single Years">
                                                        <?php foreach ($years as $y): ?>
                                                            <option value="<?= $y ?>"><?= $y ?></option>
                                                        <?php endforeach; ?>
                                                    </optgroup>
                                                    <optgroup label="Year Ranges">
                                                        <option value="2010-2015">2010-2015</option>
                                                        <option value="2016-2020">2016-2020</option>
                                                        <option value="2021-2025">2021-2025</option>
                                                        <option value="before-2010">Before 2010</option>
                                                        <option value="after-2020">After 2020</option>
                                                    </optgroup>
                                                    <optgroup label="Age Groups">
                                                        <?php
                                                        $currentYear = date('Y');
                                                        $ageGroups = [
                                                            'under-18' => 'Under 18 (' . ($currentYear - 17) . '+)',
                                                            'under-21' => 'Under 21 (' . ($currentYear - 20) . '+)', 
                                                            'under-25' => 'Under 25 (' . ($currentYear - 24) . '+)',
                                                            'over-30' => 'Over 30 (' . ($currentYear - 30) . '-)',
                                                            'over-40' => 'Over 40 (' . ($currentYear - 40) . '-)',
                                                            'over-50' => 'Over 50 (' . ($currentYear - 50) . '-)'
                                                        ];
                                                        foreach ($ageGroups as $value => $label): ?>
                                                            <option value="<?= $value ?>"><?= $label ?></option>
                                                        <?php endforeach; ?>
                                                    </optgroup>
                                                </select>
                                            </div>
                                            <div class="col-md-2 d-flex align-items-end">
                                                <button type="button" class="btn btn-outline-secondary btn-sm w-100" onclick="clearFilters()">
                                                    <i class="fas fa-times me-1"></i>Clear
                                                </button>
                                            </div>
                                        </div>
                                    </div>

                                        <!-- Action Buttons -->
                                    <div class="p-3 border-bottom bg-white">
                                        <div class="d-flex flex-wrap gap-1 align-items-center">
                                            <button type="button" id="legacy-reverseSelectedBtn" class="btn btn-outline-secondary btn-sm">
                                                <i class="fas fa-exchange-alt me-1"></i>Reverse Selected
                                            </button>
                                            <button type="button" id="legacy-shuffleSelectedBtn" class="btn btn-outline-warning btn-sm">
                                                <i class="fas fa-random me-1"></i>Shuffle Selected
                                            </button>
                                            <button type="button" id="legacy-sortByNameBtn" class="btn btn-outline-info btn-sm">
                                                <i class="fas fa-sort-alpha-down me-1"></i>Sort by Name
                                            </button>
                                            <button type="button" id="legacy-sortBybibBtn" class="btn btn-outline-dark btn-sm">
                                                <i class="fas fa-sort-numeric-down me-1"></i>Sort by bib
                                            </button>
                                            <button type="button" id="legacy-sortByYearBtn" class="btn btn-outline-secondary btn-sm">
                                                <i class="fas fa-calendar me-1"></i>Sort by Year
                                            </button>
                                            <div class="vr mx-1"></div>
                                            <button type="button" class="btn btn-outline-success btn-sm" data-bs-toggle="modal" data-bs-target="#assignbibModal">
                                                <i class="fas fa-hashtag me-1"></i>Assign bib
                                            </button>
                                            <button type="button" id="legacy-moveToHeatBtn" class="btn btn-outline-info btn-sm" data-bs-toggle="modal" data-bs-target="#moveToHeatModal">
                                                <i class="fas fa-arrow-right me-1"></i>Move to Heat
                                            </button>
                                            <button type="button" id="legacy-promoteToHeatBtn" class="btn btn-outline-warning btn-sm">
                                                <i class="fas fa-level-up-alt me-1"></i>Promote to Heat
                                            </button>
                                            <div class="vr mx-1"></div>
                                            <button type="submit" class="btn btn-outline-danger btn-sm" form="bulkDeleteForm">
                                                <i class="fas fa-trash me-1"></i>Remove Selected
                                            </button>
                                        </div>
                                    </div>

                                    <!-- Table -->
                                    <div class="table-responsive">
                                        <table id="reorder-table" class="table table-hover table-sm">
                                            <thead class="table-light">
                                                <tr>
                                                    <th width="40">
                                                        <input type="checkbox" id="bulk-check-master" class="form-check-input">
                                                    </th>                                                   
                                                    <th width="60">Heat</th>
                                                    <th width="60">Bib</th>
                                                    <th>Name</th>
                                                    <!-- Club column hidden -->
                                                    <th>Category</th>
                                                    <th width="80">Gender</th>
                                                    <th width="80">Year</th>
                                                    <th width="80">Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php if (empty($assignments)): ?>
                                                    <tr>
                                                        <td colspan="9" class="text-center text-muted py-4">
                                                            <i class="fas fa-users-slash fa-2x mb-2"></i>
                                                            <br>No athletes assigned to heats yet
                                                            <br><small>Use the assignment form above to add athletes</small>
                                                        </td>
                                                    </tr>
                                                <?php else: ?>
                                                    <?php foreach ($assignments as $a): ?>
                                                    <tr data-id="<?= $a['id'] ?>"
                                                        data-heat="<?= $a['heat_number'] ?>"
                                                        data-category="<?= htmlspecialchars($a['category'] ?? 'No Division') ?>"
                                                        data-club="<?= htmlspecialchars($a['club'] ?? '') ?>"
                                                        data-gender="<?= htmlspecialchars($a['gender'] ?? '') ?>"
                                                        data-year="<?= $a['date_of_birth'] ? date('Y', strtotime($a['date_of_birth'])) : '' ?>">
                                                        <td>
                                                            <input type="checkbox" name="delete_ids[]" value="<?= $a['id'] ?>" class="form-check-input bulk-check" form="bulkDeleteForm">
                                                        </td>                                                       
                                                        <td>
                                                            <span class="badge heat-number-<?= $a['heat_number'] ?>"><?= $a['heat_number'] ?></span>
                                                        </td>
                                                        <td class="css-bib">
                                                            <span class="badge bg-secondary"><?= $a['bib'] ?></span>
                                                        </td>
                                                        <td>
                                                            <strong><?= htmlspecialchars($a['last_name'] . ' ' . $a['first_name']) ?></strong>
                                                            <br><small class="text-muted">ID: <?= $a['participant_id'] ?></small>
                                                        </td>
                                                        <!-- Club column hidden -->
                                                        <td>
                                                            <span class="badge bg-info"><?= htmlspecialchars($a['category'] ?? 'No Category') ?></span>
                                                          
                                                        </td>
                                                        <td>
                                                            <span class="badge bg-<?= $a['gender'] === 'M' ? 'primary' : 'danger' ?>">
                                                                    <i class="fas fa-<?= $a['gender'] === 'M' ? 'male' : 'female' ?> me-1"></i>
                                                                    <?= htmlspecialchars($a['gender'] ?? '') ?>
                                                                </span>
                                                        </td>
                                                        <td>
                                                             <span class="badge_p">
                                                                    <?= $a['date_of_birth'] ? date('Y', strtotime($a['date_of_birth'])) : '' ?>
                                                                </span>
                                                        </td>
                                                        <td>
                                                            <div class="btn-group btn-group-sm">
                                                                <a href="participant_edit.php?id=<?= $a['participant_id'] ?? $a['id'] ?>" class="btn btn-outline-primary btn-sm" title="Edit">
                                                                    <i class="fas fa-edit"></i>
                                                                </a>
                                                                <a href="?delete_id=<?= $a['id'] ?>&event_id=<?= $selected_event ?>" class="btn btn-outline-danger btn-sm" title="Remove" onclick="return confirm('Remove from heat?')">
                                                                    <i class="fas fa-times"></i>
                                                                </a>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <?php endforeach; ?>
                                                <?php endif; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                            <!-- Bulk Delete Form (hidden) - Move this right after the table -->
                            <form id="bulkDeleteForm" method="post" action="heats_configure.php?event_id=<?= $selected_event ?>" style="display: none;">
                                <input type="hidden" name="bulk_delete" value="1">
                                <!-- Checkboxes are linked via form="bulkDeleteForm" attribute -->
                            </form>



<script>
// Global state for participant selection
let selectedParticipants = new Set();

// Debug version of filterParticipants
function filterParticipants() {
    console.log('filterParticipants called');
    
    const category = document.getElementById('categoryFilter').value;
    const gender = document.getElementById('genderFilter').value;
    const club = document.getElementById('clubFilter').value;
    const year = document.getElementById('yearFilter').value;
    const options = document.querySelectorAll('#participantSelect option');
    
    console.log('Filter values:', { category, gender, club, year });
    console.log('Options found:', options.length);
    
    let visibleCount = 0;
    
    options.forEach((option, index) => {
        let show = true;
        
        const optionData = {
            category: option.dataset.category || '',
            gender: option.dataset.gender || '',
            club: option.dataset.club || '',
            year: option.dataset.year || (option.dataset.date_of_birth ? option.dataset.date_of_birth.substring(0, 4) : ''),
            date_of_birth: option.dataset.date_of_birth || ''
        };
        
        // Debug first few options
        if (index < 3) {
            console.log(`Option ${index}:`, {
                text: option.textContent.trim(),
                value: option.value,
                data: optionData
            });
        }
        
        // Apply filters
        if (category && optionData.category !== category) show = false;
        if (gender && optionData.gender !== gender) show = false;
        if (club && optionData.club !== club) show = false;
        if (year && optionData.year !== year) show = false;
        
        // Set visibility
        option.style.display = show ? '' : 'none';
        if (show) visibleCount++;
        
        // Debug filtering result for first few options
        if (index < 3) {
            console.log(`Option ${index} show:`, show);
        }
    });
    
    console.log('Visible count:', visibleCount);
    
    // Update participant count
    const countElement = document.getElementById('participantCount');
    if (countElement) {
        countElement.textContent = visibleCount;
    }
    
    // Clear selection of hidden options
    options.forEach(option => {
        if (option.style.display === 'none') {
            option.selected = false;
        }
    });
}

// Select all visible participants
function selectAllVisible() {
    const options = document.querySelectorAll('#participantSelect option');
    let selectedCount = 0;
    
    options.forEach(option => {
        if (option.style.display !== 'none') {
            option.selected = true;
            selectedCount++;
        }
    });
    
    console.log('Selected', selectedCount, 'visible participants');
}

// Clear selection
function clearSelection() {
    const options = document.querySelectorAll('#participantSelect option');
    options.forEach(option => {
        option.selected = false;
    });
    console.log('Selection cleared');
}

// Clear all filters
function clearAllFilters() {
    document.getElementById('categoryFilter').value = '';
    document.getElementById('genderFilter').value = '';
    document.getElementById('clubFilter').value = '';
    document.getElementById('yearFilter').value = '';
    filterParticipants();
    clearSelection();
    console.log('All filters cleared');
}

// Test function to verify everything is working
function testFilters() {
    console.log('Testing filters...');
    const participantSelect = document.getElementById('participantSelect');
    const categoryFilter = document.getElementById('categoryFilter');
    
    console.log('participantSelect found:', !!participantSelect);
    console.log('categoryFilter found:', !!categoryFilter);
    
    if (participantSelect) {
        console.log('Total options in participantSelect:', participantSelect.options.length);
        
        // Test first option data
        if (participantSelect.options.length > 0) {
            const firstOption = participantSelect.options[0];
            console.log('First option data:', {
                text: firstOption.textContent,
                category: firstOption.dataset.category,
                gender: firstOption.dataset.gender,
                club: firstOption.dataset.club,
                year: firstOption.dataset.year
            });
        }
    }
    
    if (categoryFilter && categoryFilter.options.length > 1) {
        console.log('Testing category filter...');
        //categoryFilter.value = categoryFilter.options[1].value;
        filterParticipants();
    }
}

// Run test when page loads
document.addEventListener('DOMContentLoaded', function() {
    console.log('DOM loaded, running test...');
    setTimeout(testFilters, 1000);
});
</script>
<script>

function filterReorderTable() {
    const heat = document.getElementById('filterHeat').value;
    const category = document.getElementById('filterCategory').value;
    const club = document.getElementById('filterClub').value;
    const gender = document.getElementById('filterGender').value;
    const yearFilter = document.getElementById('filterYear').value;
    
    const currentYear = new Date().getFullYear();
    
    // Filter heat boards (visible cards)
    let totalVisible = 0;
    document.querySelectorAll('.assignment-row').forEach(row => {
        let show = true;
        const rowYear = parseInt(row.dataset.year);
        const rowHeat = row.dataset.heat;
        
        if (heat && rowHeat !== heat) show = false;
        if (category && row.dataset.category !== category) show = false;
        if (club && row.dataset.club !== club) show = false;
        if (gender && row.dataset.gender !== gender) show = false;
        
        // Enhanced year filtering with ranges
        if (yearFilter && show) {
            if (yearFilter.includes('-') && !yearFilter.startsWith('before-') && !yearFilter.startsWith('after-')) {
                const [startYear, endYear] = yearFilter.split('-').map(y => parseInt(y));
                if (rowYear < startYear || rowYear > endYear) show = false;
            } else if (yearFilter === 'before-2010') {
                if (rowYear >= 2010) show = false;
            } else if (yearFilter === 'after-2020') {
                if (rowYear <= 2020) show = false;
            } else if (yearFilter.startsWith('under-')) {
                const ageLimit = parseInt(yearFilter.split('-')[1]);
                const birthYear = currentYear - ageLimit;
                if (rowYear <= birthYear) show = false;
            } else if (yearFilter.startsWith('over-')) {
                const ageLimit = parseInt(yearFilter.split('-')[1]);
                const birthYear = currentYear - ageLimit;
                if (rowYear >= birthYear) show = false;
            } else {
                if (row.dataset.year !== yearFilter) show = false;
            }
        }
        
        if (show) {
            row.classList.remove('d-none');
            totalVisible++;
        } else {
            row.classList.add('d-none');
        }
    });
    
    // Update heat board visibility and empty placeholders
    document.querySelectorAll('.heat-board').forEach(heatBoard => {
        const heatNumber = heatBoard.dataset.heat;
        const tbody = heatBoard.querySelector('.sortable-tbody');
        const visibleRows = heatBoard.querySelectorAll('.assignment-row:not(.d-none)');
        
        // Show/hide entire heat board if heat filter is active
        if (heat && heatNumber !== heat) {
            heatBoard.style.display = 'none';
        } else {
            heatBoard.style.display = '';
        }
        
        // Update empty placeholder visibility
        const emptyPlaceholder = tbody.querySelector('.empty-heat-placeholder');
        if (visibleRows.length === 0 && emptyPlaceholder) {
            emptyPlaceholder.style.display = '';
        } else if (emptyPlaceholder) {
            emptyPlaceholder.style.display = 'none';
        }
        
        // Update heat card header count
        const headerBadge = heatBoard.querySelector('.badge.bg-secondary');
        if (headerBadge) {
            headerBadge.textContent = visibleRows.length;
        }
    });
    
    // Also filter legacy table (for compatibility)
    let serial = 1;
    document.querySelectorAll('#reorder-table tbody tr').forEach(row => {
        if (row.cells.length === 1) return;
        
        let show = true;
        const rowYear = parseInt(row.dataset.year);
        
        if (heat && row.dataset.heat !== heat) show = false;
        if (category && row.dataset.category !== category) show = false;
        if (club && row.dataset.club !== club) show = false;
        if (gender && row.dataset.gender !== gender) show = false;
        
        if (yearFilter && show) {
            if (yearFilter.includes('-') && !yearFilter.startsWith('before-') && !yearFilter.startsWith('after-')) {
                const [startYear, endYear] = yearFilter.split('-').map(y => parseInt(y));
                if (rowYear < startYear || rowYear > endYear) show = false;
            } else if (yearFilter === 'before-2010') {
                if (rowYear >= 2010) show = false;
            } else if (yearFilter === 'after-2020') {
                if (rowYear <= 2020) show = false;
            } else if (yearFilter.startsWith('under-')) {
                const ageLimit = parseInt(yearFilter.split('-')[1]);
                const birthYear = currentYear - ageLimit;
                if (rowYear <= birthYear) show = false;
            } else if (yearFilter.startsWith('over-')) {
                const ageLimit = parseInt(yearFilter.split('-')[1]);
                const birthYear = currentYear - ageLimit;
                if (rowYear >= birthYear) show = false;
            } else {
                if (row.dataset.year !== yearFilter) show = false;
            }
        }
        
        row.style.display = show ? '' : 'none';
        
        if (show) {
            const serialCell = row.querySelector('.serial-number');
            if (serialCell) {
                serialCell.textContent = serial++;
            }
        }
    });
    
    // Update master checkbox state
    updateMasterCheckbox();
    
    // Update visible count display
    console.log('Total visible assignments after filter:', totalVisible);
}

function clearFilters() {
    document.getElementById('filterHeat').value = '';
    document.getElementById('filterCategory').value = '';
    document.getElementById('filterClub').value = '';
    document.getElementById('filterGender').value = '';
    document.getElementById('filterYear').value = '';
    filterReorderTable();
}

function updateMasterCheckbox() {
    const visibleCheckboxes = document.querySelectorAll('#reorder-table tbody tr:not([style*="display: none"]) .bulk-check');
    const checkedBoxes = document.querySelectorAll('#reorder-table tbody tr:not([style*="display: none"]) .bulk-check:checked');
    const masterCheckbox = document.getElementById('bulk-check-master');
    
    if (visibleCheckboxes.length === 0) {
        masterCheckbox.indeterminate = false;
        masterCheckbox.checked = false;
    } else if (checkedBoxes.length === visibleCheckboxes.length) {
        masterCheckbox.indeterminate = false;
        masterCheckbox.checked = true;
    } else if (checkedBoxes.length > 0) {
        masterCheckbox.indeterminate = true;
        masterCheckbox.checked = false;
    } else {
        masterCheckbox.indeterminate = false;
        masterCheckbox.checked = false;
    }
}

function confirmBulkDelete() {
    // Check both legacy table and new heat boards
    const legacySelected = document.querySelectorAll('#reorder-table .bulk-check:checked').length;
    const heatBoardSelected = document.querySelectorAll('.assignment-checkbox:checked').length;
    const selectedCount = legacySelected + heatBoardSelected;
    
    if (selectedCount === 0) {
        showAlert('Please select participants to remove.', 'Selection Required', 'exclamation-triangle');
        return false;
    }
    
    showConfirm(
        `Remove ${selectedCount} selected participant(s) from their heats?`,
        function() {
            document.getElementById('bulkDeleteForm').submit();
        },
        'Confirm Removal',
        'exclamation-triangle'
    );
    
    return false; // Prevent immediate submission
}

// Update master checkbox functionality to work with the form
jQuery('#bulk-check-master').on('change', function () {
    const checked = this.checked;
    jQuery('#reorder-table tbody tr:visible .bulk-check').each(function () {
        this.checked = checked;
        jQuery(this).closest('tr').toggleClass('selected-row', checked);
    });
    updateMasterCheckbox();
});

// Individual checkbox functionality
jQuery(document).on('change', '.bulk-check', function () {
    jQuery(this).closest('tr').toggleClass('selected-row', this.checked);
    updateMasterCheckbox();
});

// Bulk delete button handler
jQuery(document).on('click', 'button[form="bulkDeleteForm"]', function(e) {
    e.preventDefault();
    confirmBulkDelete();
});

// Initial numbering on page load
document.addEventListener('DOMContentLoaded', function() {
    let serial = 1;
    document.querySelectorAll('#reorder-table tbody tr').forEach(row => {
        const serialCell = row.querySelector('.serial-number');
        if (serialCell) {
            serialCell.textContent = serial++;
        }
    });
    
    // Update master checkbox on individual checkbox change
    document.addEventListener('change', function(e) {
        if (e.target.classList.contains('bulk-check')) {
            updateMasterCheckbox();
        }
    });
});

// Initialize the interface
document.addEventListener('DOMContentLoaded', function() {
    updateParticipantCounts();
    updateSelectionStatus();
    
    // Initialize master checkbox functionality
    document.getElementById('selectAllParticipants').addEventListener('change', function() {
        const isChecked = this.checked;
        const visibleRows = document.querySelectorAll('#participantsTable tbody .participant-row:not(.d-none)');
        
        visibleRows.forEach(row => {
            const checkbox = row.querySelector('.participant-checkbox');
            const participantId = row.dataset.id;
            
            if (isChecked) {
                if (!selectedParticipants.has(participantId)) {
                    selectedParticipants.add(participantId);
                    checkbox.checked = true;
                    row.classList.add('selected-row');
                    
                    const hiddenOption = document.querySelector(`#participantSelect option[value="${participantId}"]`);
                    if (hiddenOption) hiddenOption.selected = true;
                }
            } else {
                selectedParticipants.delete(participantId);
                checkbox.checked = false;
                row.classList.remove('selected-row');
                
                const hiddenOption = document.querySelector(`#participantSelect option[value="${participantId}"]`);
                if (hiddenOption) hiddenOption.selected = false;
            }
        });
        
        updateSelectionStatus();
    });
    
    // Add click handler for participant rows (event delegation, doesn't interfere with drag)
    document.querySelector('#participantsTable tbody').addEventListener('click', function(e) {
        const row = e.target.closest('.participant-row');
        // Don't toggle selection if clicking on checkbox or drag handle
        if (row && !e.target.closest('input[type="checkbox"]') && !e.target.closest('.drag-handle')) {
            toggleTableRowSelection(row);
        }
    });
    
    // Add click handler for participant checkboxes
    document.addEventListener('change', function(e) {
        if (e.target.classList.contains('participant-checkbox')) {
            const row = e.target.closest('.participant-row');
            if (row) {
                const participantId = row.dataset.id;
                const checkbox = e.target;
                
                if (checkbox.checked) {
                    selectedParticipants.add(participantId);
                    row.classList.add('selected-row');
                } else {
                    selectedParticipants.delete(participantId);
                    row.classList.remove('selected-row');
                }
                
                updateSelectionStatus();
                updateMasterCheckboxState();
            }
        }
    });
});

// Toggle table row selection
function toggleTableRowSelection(rowElement) {
    const participantId = rowElement.dataset.id;
    const checkbox = rowElement.querySelector('.participant-checkbox');
    const hiddenOption = document.querySelector(`#participantSelect option[value="${participantId}"]`);
    
    if (selectedParticipants.has(participantId)) {
        // Deselect
        selectedParticipants.delete(participantId);
        rowElement.classList.remove('selected-row');
        checkbox.checked = false;
        if (hiddenOption) hiddenOption.selected = false;
    } else {
        // Select
        selectedParticipants.add(participantId);
        rowElement.classList.add('selected-row');
        checkbox.checked = true;
        if (hiddenOption) hiddenOption.selected = true;
    }
    
    updateSelectionStatus();
    updateMasterCheckboxState();
}

// Update master checkbox state based on individual selections
function updateMasterCheckboxState() {
    const visibleRows = document.querySelectorAll('#participantsTable tbody .participant-row:not(.d-none)');
    const selectedVisibleRows = Array.from(visibleRows).filter(row => selectedParticipants.has(row.dataset.id));
    const masterCheckbox = document.getElementById('selectAllParticipants');
    
    if (visibleRows.length === 0) {
        masterCheckbox.indeterminate = false;
        masterCheckbox.checked = false;
    } else if (selectedVisibleRows.length === visibleRows.length) {
        masterCheckbox.indeterminate = false;
        masterCheckbox.checked = true;
    } else if (selectedVisibleRows.length > 0) {
        masterCheckbox.indeterminate = true;
    } else {
        masterCheckbox.indeterminate = false;
        masterCheckbox.checked = false;
    }
}

// Enhanced filtering with table row visibility
function filterParticipants() {
    console.log('filterParticipants called');
    
    const category = document.getElementById('categoryFilter').value;
    const gender = document.getElementById('genderFilter').value;
    const club = document.getElementById('clubFilter').value;
    const year = document.getElementById('yearFilter').value;
    const rows = document.querySelectorAll('#participantsTable tbody .participant-row');
    
    console.log('Filter values:', { category, gender, club, year });
    
    let visibleCount = 0;
    
    rows.forEach((row, index) => {
        let show = true;
        
        const rowData = {
            category: row.dataset.category || '',
            gender: row.dataset.gender || '',
            club: row.dataset.club || '',
            year: row.dataset.year || ''
        };
        
        // Apply filters
        if (category && rowData.category !== category) show = false;
        if (gender && rowData.gender !== gender) show = false;
        if (club && rowData.club !== club) show = false;
        if (year && rowData.year !== year) show = false;
        
        // Set visibility
        if (show) {
            row.classList.remove('d-none');
            visibleCount++;
        } else {
            row.classList.add('d-none');
            
            // Deselect if hidden
            const participantId = row.dataset.id;
            if (selectedParticipants.has(participantId)) {
                selectedParticipants.delete(participantId);
                row.classList.remove('selected-row');
                row.querySelector('.participant-checkbox').checked = false;
                const hiddenOption = document.querySelector(`#participantSelect option[value="${participantId}"]`);
                if (hiddenOption) hiddenOption.selected = false;
            }
        }
    });
    
    console.log('Visible count:', visibleCount);
    updateParticipantCounts();
    updateSelectionStatus();
    updateMasterCheckboxState();
    showNoResultsMessage(visibleCount === 0);
}

// Search functionality
function searchParticipants() {
    const searchTerm = document.getElementById('participantSearch').value.toLowerCase();
    const rows = document.querySelectorAll('#participantsTable tbody .participant-row');
    
    let visibleCount = 0;
    
    rows.forEach(row => {
        const searchText = row.dataset.searchText || '';
        const matchesSearch = searchTerm === '' || searchText.includes(searchTerm);
        
        // Also check if it passes current filters
        const category = document.getElementById('categoryFilter').value;
        const gender = document.getElementById('genderFilter').value;
        const club = document.getElementById('clubFilter').value;
        const year = document.getElementById('yearFilter').value;
        
        let passesFilters = true;
        if (category && row.dataset.category !== category) passesFilters = false;
        if (gender && row.dataset.gender !== gender) passesFilters = false;
        if (club && row.dataset.club !== club) passesFilters = false;
        if (year && row.dataset.year !== year) passesFilters = false;
        
        const show = matchesSearch && passesFilters;
        
        if (show) {
            row.classList.remove('d-none');
            visibleCount++;
        } else {
            row.classList.add('d-none');
            
            // Deselect if hidden
            const participantId = row.dataset.id;
            if (selectedParticipants.has(participantId)) {
                selectedParticipants.delete(participantId);
                row.classList.remove('selected-row');
                row.querySelector('.participant-checkbox').checked = false;
                const hiddenOption = document.querySelector(`#participantSelect option[value="${participantId}"]`);
                if (hiddenOption) hiddenOption.selected = false;
            }
        }
    });
    
    updateParticipantCounts();
    updateSelectionStatus();
    updateMasterCheckboxState();
    showNoResultsMessage(visibleCount === 0);
}

// Clear search
function clearSearch() {
    document.getElementById('participantSearch').value = '';
    searchParticipants();
}

// Select all visible participants
function selectAllVisible() {
    const visibleRows = document.querySelectorAll('#participantsTable tbody .participant-row:not(.d-none)');
    let selectedCount = 0;
    
    visibleRows.forEach(row => {
        const participantId = row.dataset.id;
        if (!selectedParticipants.has(participantId)) {
            selectedParticipants.add(participantId);
            row.classList.add('selected-row');
            row.querySelector('.participant-checkbox').checked = true;
            
            const hiddenOption = document.querySelector(`#participantSelect option[value="${participantId}"]`);
            if (hiddenOption) hiddenOption.selected = true;
            
            selectedCount++;
        }
    });
    
    updateSelectionStatus();
    updateMasterCheckboxState();
    
    // Visual feedback
    if (selectedCount > 0) {
        document.getElementById('participantStatusBadge').classList.add('has-selection');
        setTimeout(() => {
            document.getElementById('participantStatusBadge').classList.remove('has-selection');
        }, 1000);
    }
    
    console.log('Selected', selectedCount, 'visible participants');
}

// Clear selection
function clearSelection() {
    selectedParticipants.clear();
    
    // Update all table rows
    document.querySelectorAll('#participantsTable tbody .participant-row').forEach(row => {
        row.classList.remove('selected-row');
        row.querySelector('.participant-checkbox').checked = false;
    });
    
    // Update master checkbox
    const masterCheckbox = document.getElementById('masterCheckbox');
    if (masterCheckbox) {
        masterCheckbox.checked = false;
    }
    
    // Update hidden select
    document.querySelectorAll('#participantSelect option').forEach(option => {
        option.selected = false;
    });
    
    updateSelectionStatus();
    console.log('Selection cleared');
}

// Clear all filters and search
function clearAllFiltersAndSearch() {
    document.getElementById('categoryFilter').value = '';
    document.getElementById('genderFilter').value = '';
    document.getElementById('clubFilter').value = '';
    document.getElementById('yearFilter').value = '';
    document.getElementById('participantSearch').value = '';
    
    filterParticipants();
    clearSelection();
    console.log('All filters and search cleared');
}

// Alias for backward compatibility
function clearAllFilters() {
    clearAllFiltersAndSearch();
}

// Update participant counts
function updateParticipantCounts() {
    const allRows = document.querySelectorAll('#participantsTable tbody .participant-row');
    const visibleRows = document.querySelectorAll('#participantsTable tbody .participant-row:not(.d-none)');
    
    const participantCount = document.getElementById('participantCount');
    const visibleCount = document.getElementById('visibleCount');
    
    if (participantCount) participantCount.textContent = allRows.length;
    if (visibleCount) visibleCount.textContent = visibleRows.length;
}

// Update selection status
function updateSelectionStatus() {
    const selectedCount = selectedParticipants.size;
    
    document.getElementById('selectedCount').textContent = selectedCount;
    
    const badge = document.getElementById('participantStatusBadge');
    if (selectedCount > 0) {
        badge.textContent = `${selectedCount} selected`;
        badge.className = 'badge bg-success ms-2';
    } else {
        badge.textContent = '0 selected';
        badge.className = 'badge bg-info ms-2';
    }
}

// Show/hide no results message
function showNoResultsMessage(show) {
    const noResultsMessage = document.getElementById('noParticipantsMessage');
    const participantTable = document.getElementById('participantsTable');
    
    if (show) {
        noResultsMessage.style.display = 'block';
        participantTable.style.display = 'none';
    } else {
        noResultsMessage.style.display = 'none';
        participantTable.style.display = 'table';
    }
}

// Enhanced keyboard shortcuts
document.addEventListener('keydown', function(e) {
    // Ctrl/Cmd + A to select all visible
    if ((e.ctrlKey || e.metaKey) && e.key === 'a' && document.activeElement.id !== 'participantSearch') {
        e.preventDefault();
        selectAllVisible();
    }
    
    // Escape to clear selection
    if (e.key === 'Escape') {
        clearSelection();
        if (document.activeElement.id === 'participantSearch') {
            document.activeElement.blur();
        }
    }
    
    // Ctrl/Cmd + F to focus search
    if ((e.ctrlKey || e.metaKey) && e.key === 'f') {
        e.preventDefault();
        document.getElementById('participantSearch').focus();
    }
});

// Touch support for mobile
document.addEventListener('touchstart', function() {
    // Enable touch selection for table rows
    document.querySelectorAll('#participantsTable tbody .participant-row').forEach(row => {
        row.addEventListener('touchend', function(e) {
            e.preventDefault();
            toggleTableRowSelection(this);
        });
    });
});

// Simplified participant selection for table
function toggleParticipantSelection(element) {
    const participantId = element.dataset.id;
    const hiddenOption = document.querySelector(`#participantSelect option[value="${participantId}"]`);
    
    // Find table row
    const tableRow = document.querySelector(`#participantsTable tbody .participant-row[data-id="${participantId}"]`);
    const checkbox = tableRow ? tableRow.querySelector('.participant-checkbox') : null;
    
    if (selectedParticipants.has(participantId)) {
        // Deselect
        selectedParticipants.delete(participantId);
        if (tableRow) tableRow.classList.remove('selected-row');
        if (checkbox) checkbox.checked = false;
        if (hiddenOption) hiddenOption.selected = false;
    } else {
        // Select
        selectedParticipants.add(participantId);
        if (tableRow) tableRow.classList.add('selected-row');
        if (checkbox) checkbox.checked = true;
        if (hiddenOption) hiddenOption.selected = true;
    }
    
    updateSelectionStatus();
}

// Table filtering function
function filterParticipants() {
    console.log('filterParticipants called for table');
    
    const category = document.getElementById('categoryFilter').value;
    const gender = document.getElementById('genderFilter').value;
    const club = document.getElementById('clubFilter').value;
    const year = document.getElementById('yearFilter').value;
    
    console.log('Filter values:', { category, gender, club, year });
    
    let visibleCount = 0;
    
    const rows = document.querySelectorAll('#participantsTable tbody .participant-row');
    
    rows.forEach((row) => {
        let show = true;
        
        const rowData = {
            category: row.dataset.category || '',
            gender: row.dataset.gender || '',
            club: row.dataset.club || '',
            year: row.dataset.year || ''
        };
        
        // Apply filters
        if (category && rowData.category !== category) show = false;
        if (gender && rowData.gender !== gender) show = false;
        if (club && rowData.club !== club) show = false;
        if (year && rowData.year !== year) show = false;
        
        // Set visibility
        if (show) {
            row.classList.remove('d-none');
            visibleCount++;
        } else {
            row.classList.add('d-none');
            
            // Deselect if hidden
            const participantId = row.dataset.id;
            if (selectedParticipants.has(participantId)) {
                selectedParticipants.delete(participantId);
                row.classList.remove('selected-row');
                const checkbox = row.querySelector('.participant-checkbox');
                if (checkbox) checkbox.checked = false;
                const hiddenOption = document.querySelector(`#participantSelect option[value="${participantId}"]`);
                if (hiddenOption) hiddenOption.selected = false;
            }
        }
    });
    
    console.log('Visible count:', visibleCount);
    updateParticipantCounts();
    updateSelectionStatus();
    showNoResultsMessage(visibleCount === 0);
}

// Table search function
function searchParticipants() {
    const searchTerm = document.getElementById('participantSearch').value.toLowerCase();
    
    let visibleCount = 0;
    
    const rows = document.querySelectorAll('#participantsTable tbody .participant-row');
    
    rows.forEach(row => {
        const searchText = row.dataset.searchText || '';
        const matchesSearch = searchTerm === '' || searchText.includes(searchTerm);
        
        // Also check if it passes current filters
        const passesFilters = checkElementPassesFilters(row);
        const show = matchesSearch && passesFilters;
        
        if (show) {
            row.classList.remove('d-none');
            visibleCount++;
        } else {
            row.classList.add('d-none');
            
            // Deselect if hidden
            deselectParticipant(row.dataset.id);
        }
    });
    
    updateParticipantCounts();
    updateSelectionStatus();
    showNoResultsMessage(visibleCount === 0);
}

function checkElementPassesFilters(element) {
    const category = document.getElementById('categoryFilter').value;
    const gender = document.getElementById('genderFilter').value;
    const club = document.getElementById('clubFilter').value;
    const year = document.getElementById('yearFilter').value;
    
    let passesFilters = true;
    if (category && element.dataset.category !== category) passesFilters = false;
    if (gender && element.dataset.gender !== gender) passesFilters = false;
    if (club && element.dataset.club !== club) passesFilters = false;
    
    // Year filter with custom range support
    if (year) {
        if (year === 'custom-range' && customYearRange) {
            const rowYear = parseInt(element.dataset.year);
            if (rowYear < customYearRange.from || rowYear > customYearRange.to) {
                passesFilters = false;
            }
        } else if (element.dataset.year !== year) {
            passesFilters = false;
        }
    }
    
    return passesFilters;
}

function deselectParticipant(participantId) {
    if (selectedParticipants.has(participantId)) {
        selectedParticipants.delete(participantId);
        
        const tableRow = document.querySelector(`#participantsTable tbody .participant-row[data-id="${participantId}"]`);
        const checkbox = tableRow ? tableRow.querySelector('.participant-checkbox') : null;
        const hiddenOption = document.querySelector(`#participantSelect option[value="${participantId}"]`);
        
        if (tableRow) tableRow.classList.remove('selected-row');
        if (checkbox) checkbox.checked = false;
        if (hiddenOption) hiddenOption.selected = false;
    }
}

// Select all visible table rows
function selectAllVisible() {
    const visibleRows = document.querySelectorAll('#participantsTable tbody .participant-row:not(.d-none)');
    let selectedCount = 0;
    
    visibleRows.forEach(row => {
        const participantId = row.dataset.id;
        if (!selectedParticipants.has(participantId)) {
            selectedParticipants.add(participantId);
            row.classList.add('selected-row');
            
            // Update checkbox
            const checkbox = row.querySelector('.participant-checkbox');
            if (checkbox) checkbox.checked = true;
            
            // Update hidden select
            const hiddenOption = document.querySelector(`#participantSelect option[value="${participantId}"]`);
            if (hiddenOption) hiddenOption.selected = true;
            
            selectedCount++;
        }
    });
    
    updateSelectionStatus();
    console.log('Selected all', selectedCount, 'visible participants');
}

// Visual feedback
function addSelectionFeedback() {
    const badge = document.getElementById('participantStatusBadge');
    if (badge) {
        badge.classList.add('has-selection');
        setTimeout(() => {
            badge.classList.remove('has-selection');
        }, 1000);
    }
}


// (View preference functions removed - only table view now)

// Enhanced keyboard shortcuts for table
document.addEventListener('keydown', function(e) {
    // Ctrl/Cmd + A to select all visible
    if ((e.ctrlKey || e.metaKey) && e.key === 'a' && document.activeElement.id !== 'participantSearch') {
        e.preventDefault();
        selectAllVisible();
    }
    
    // Escape to clear selection
    if (e.key === 'Escape') {
        clearSelection();
        if (document.activeElement.id === 'participantSearch') {
            document.activeElement.blur();
        }
    }
    
    // Ctrl/Cmd + F to focus search
    if ((e.ctrlKey || e.metaKey) && e.key === 'f') {
        e.preventDefault();
        document.getElementById('participantSearch').focus();
    }
    
    // (View switching removed - only table view now)
});

// Table initialization on page load
document.addEventListener('DOMContentLoaded', function() {
    // Initialize table functionality
    updateParticipantCounts();
    updateSelectionStatus();
});

// Touch support for mobile table rows
document.addEventListener('touchstart', function() {
    // Enable touch selection for table rows
    document.querySelectorAll('#participantsTable tbody .participant-row').forEach(row => {
        row.addEventListener('touchend', function(e) {
            e.preventDefault();
            toggleTableRowSelection(this);
        });
    });
});
// Test function for debugging table
function testFilters() {
    console.log('Testing table-based filters...');
    const participantTable = document.getElementById('participantsTable');
    const categoryFilter = document.getElementById('categoryFilter');
    
    console.log('participantTable found:', !!participantTable);
    console.log('categoryFilter found:', !!categoryFilter);
    
    if (participantTable) {
        const rows = participantTable.querySelectorAll('tbody .participant-row');
        console.log('Total rows in table:', rows.length);
        
        if (rows.length > 0) {
            const firstRow = rows[0];
            console.log('First row data:', {
                id: firstRow.dataset.id,
                category: firstRow.dataset.category,
                gender: firstRow.dataset.gender,
                club: firstRow.dataset.club,
                year: firstRow.dataset.year
            });
        }
    }
    
    console.log('Current selection:', Array.from(selectedParticipants));
}

// Run test when page loads (for debugging)
document.addEventListener('DOMContentLoaded', function() {
    console.log('DOM loaded, running table-based test...');
    setTimeout(testFilters, 1000);
});
</script>
        
</div>
<style>
tr.selected-row td {
    background-color: #d9f2ff;
}
.shuffled {
    animation: flash 0.5s ease-in-out;
}
@keyframes flash {
    0% { background-color: #fff176; }
    100% { background-color: transparent; }
}

/* Touch drag and drop visual feedback */
.drag-ready-touch {
    background-color: rgba(13, 110, 253, 0.1) !important;
    border: 2px dashed #0d6efd !important;
}

.drag-over-touch {
    background-color: rgba(13, 110, 253, 0.15) !important;
    outline: 3px dashed #0d6efd !important;
    outline-offset: -3px;
}

#touch-drag-ghost {
    transition: transform 0.1s ease-out;
    box-shadow: 0 8px 30px rgba(0, 0, 0, 0.3) !important;
}

.participant-row, .assignment-row {
    transition: transform 0.2s ease, box-shadow 0.2s ease;
}
</style>
<style>
/* Custom styling to match participant management */
.table-hover tbody tr:hover {
    background-color: rgba(0, 123, 255, 0.05);
}

tr.selected-row {
    background-color: rgba(0, 123, 255, 0.1) !important;
}

.shuffled {
    animation: flash 0.5s ease-in-out;
}

@keyframes flash {
    0% { background-color: #fff176; }
    100% { background-color: transparent; }
}

/* Sortable cursor */
#reorder-table tbody tr {
    cursor: move;
}

#reorder-table tbody tr:hover {
    background-color: rgba(0, 123, 255, 0.05);
}

/* Badge styling for pink gender */
.bg-pink {
    background-color: #f8d7da !important;
}

/* Drag helper styling */
.ui-sortable-helper {
    background-color: rgba(0, 123, 255, 0.1);
    border: 2px dashed #007bff;
}

/* SortableJS drag styling */
.sortable-ghost {
    opacity: 0.4;
    background-color: #e3f2fd;
}

.sortable-drag {
    opacity: 1;
    cursor: grabbing !important;
}

.sortable-chosen {
    background-color: #fff3cd;
    border-left: 3px solid #ffc107;
}

/* Participant row dragging */
#participantsTable tbody .participant-row {
    cursor: grab;
    transition: background-color 0.2s;
}

#participantsTable tbody .participant-row:hover {
    background-color: rgba(0, 123, 255, 0.05);
}

#participantsTable tbody .participant-row:active {
    cursor: grabbing;
}

#participantsTable tbody .participant-row.selected-row {
    background-color: #fff3cd !important;
    border-left: 3px solid #ffc107;
}

/* Assignment row selection and dragging */
.assignment-row {
    cursor: grab;
    transition: background-color 0.2s, transform 0.1s;
}

.assignment-row:hover {
    background-color: rgba(0, 123, 255, 0.05);
}

.assignment-row:active {
    cursor: grabbing;
}

.assignment-row.selected-row {
    background-color: #fff3cd !important;
    border-left: 3px solid #ffc107;
}

.assignment-row.selected-row td:first-child {
    border-left: none;
}

/* Drag handle styling */
.drag-handle {
    user-select: none;
}

.drag-handle .fa-grip-vertical {
    opacity: 0.3;
    transition: opacity 0.2s;
}

.participant-row:hover .drag-handle .fa-grip-vertical,
.assignment-row:hover .drag-handle .fa-grip-vertical {
    opacity: 0.6;
}

.participant-row.selected-row .drag-handle .fa-grip-vertical,
.assignment-row.selected-row .drag-handle .fa-grip-vertical {
    opacity: 1;
    color: #ffc107 !important;
}

/* Heat board drop zones */
.sortable-tbody {
    min-height: 100px;
    display: table-row-group;
    transition: background-color 0.3s;
    position: relative;
}

.sortable-tbody.sortable-drag-over {
    background-color: #e3f2fd;
}

.sortable-tbody.sortable-drag-over::before {
    content: "";
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    border: 3px dashed #007bff;
    pointer-events: none;
    z-index: 1;
}

.empty-heat-placeholder {
    pointer-events: none;
    user-select: none;
    height: 100px;
}

.empty-heat-placeholder td {
    background-color: #f8f9fa !important;
    border: 2px dashed #dee2e6;
    height: 100px;
    vertical-align: middle;
}

.sortable-tbody:has(.empty-heat-placeholder) {
    background-color: #fafafa;
    position: relative;
}

/* Ensure empty tbody has clickable/droppable area */
.sortable-tbody:empty::after,
.sortable-tbody:has(.empty-heat-placeholder)::after {
    content: "";
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    min-height: 100px;
    pointer-events: all;
    z-index: 0;
}

.sortable-tbody:empty::after {
    content: "Drop participants here";
    display: table-row;
    text-align: center;
    color: #6c757d;
    padding: 2rem;
}

/* SortableJS drag states */
.sortable-ghost {
    opacity: 0.4;
    background-color: #007bff !important;
    color: white !important;
}

.sortable-ghost td {
    background-color: #007bff !important;
    color: white !important;
    border-color: #0056b3 !important;
}

.sortable-drag {
    opacity: 1 !important;
    background-color: white !important;
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3) !important;
    transform: rotate(3deg);
    cursor: grabbing !important;
}

.sortable-chosen {
    opacity: 0.8;
}

/* Multi-drag styling */
.sortable-selected {
    background-color: #fff3cd !important;
    border-left: 3px solid #ffc107 !important;
}

/* Filter section styling */
.vr {
    width: 1px;
    height: 24px;
    background-color: #dee2e6;
}
.participant-select-container {
    position: relative;
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    border: 2px solid #e9ecef;
    transition: border-color 0.3s ease;
}

.participant-select-container:focus-within {
    border-color: #0d6efd;
    box-shadow: 0 4px 12px rgba(13, 110, 253, 0.2);
}

.participant-multiselect {
    border: none !important;
    border-radius: 0 !important;
    box-shadow: none !important;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
    padding: 0;
}

.participant-multiselect:focus {
    outline: none;
    box-shadow: none !important;
}

.participant-option {
    padding: 0 !important;
    border: none !important;
    margin: 0 !important;
    background: transparent !important;
    border-bottom: 1px solid #f0f0f0 !important;
    transition: all 0.2s ease;
    cursor: pointer;
}

.participant-option:hover {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%) !important;
    transform: translateX(4px);
}

.participant-option:checked {
    background: linear-gradient(135deg, #0d6efd 0%, #0b5ed7 100%) !important;
    color: white !important;
    transform: translateX(8px);
    box-shadow: inset 4px 0 0 rgba(255, 255, 255, 0.3);
}

.participant-option.already-assigned {
    background: linear-gradient(135deg, #e3f2fd 0%, #bbdefb 100%) !important;
    border-left: 4px solid #2196f3 !important;
}

.participant-option.already-assigned:checked {
    background: linear-gradient(135deg, #1976d2 0%, #1565c0 100%) !important;
}

.participant-card {
    padding: 12px 16px;
    display: flex;
    flex-direction: column;
    gap: 6px;
}

.participant-header {
    display: flex;
    align-items: center;
    gap: 10px;
    flex-wrap: wrap;
}

.participant-bib {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, #6c757d 0%, #495057 100%);
    color: white;
    padding: 4px 10px;
    border-radius: 20px;
    font-size: 0.75rem;
    font-weight: bold;
    min-width: 45px;
    height: 24px;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
}

.participant-option:checked .participant-bib {
    background: linear-gradient(135deg, #ffffff 0%, #e9ecef 100%);
    color: #0d6efd;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.3);
}

.participant-name {
    font-weight: 600;
    font-size: 0.9rem;
    color: #212529;
    flex-grow: 1;
}

.participant-option:checked .participant-name {
    color: white;
    font-weight: 700;
}

.assignment-badge {
    background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
    color: white;
    padding: 2px 8px;
    border-radius: 12px;
    font-size: 0.7rem;
    font-weight: bold;
    display: inline-flex;
    align-items: center;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.2);
}

.participant-option:checked .assignment-badge {
    background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
    color: #28a745;
}

.participant-details {
    display: flex;
    flex-wrap: wrap;
    gap: 8px;
    align-items: center;
}

.detail-item {
    display: inline-flex;
    align-items: center;
    font-size: 0.75rem;
    padding: 2px 6px;
    border-radius: 8px;
    background: rgba(108, 117, 125, 0.1);
    color: #6c757d;
    transition: all 0.2s ease;
}

.participant-option:checked .detail-item {
    background: rgba(255, 255, 255, 0.2);
    color: rgba(255, 255, 255, 0.9);
}

.detail-item.club {
    background: rgba(13, 110, 253, 0.1);
    color: #0d6efd;
}

.detail-item.category {
    background: rgba(255, 193, 7, 0.1);
    color: #ffc107;
}

.detail-item.gender {
    background: rgba(220, 53, 69, 0.1);
    color: #dc3545;
}

.detail-item.year {
    background: rgba(108, 117, 125, 0.1);
    color: #6c757d;
}

.participant-select-footer {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    padding: 12px 16px;
    border-top: 1px solid #dee2e6;
}

#participantStatusBadge {
    transition: all 0.3s ease;
}

#participantStatusBadge.has-selection {
    background: linear-gradient(135deg, #28a745 0%, #20c997 100%) !important;
    animation: pulse 1s ease-in-out;
}


.heat-number-1  { background-color: hsl(209, 100%, 50%) !important; } /* +14° */
.heat-number-6  { background-color: hsl(222, 100%, 50%) !important; } /* +13° */
.heat-number-2  { background-color: hsl(234, 100%, 50%) !important; } /* +12° */
.heat-number-5  { background-color: hsl(245, 100%, 50%) !important; } /* +11° */
.heat-number-4  { background-color: hsl(255, 100%, 50%) !important; } /* +10° */
.heat-number-3  { background-color: hsl(264, 100%, 50%) !important; } /* +9°  */
.heat-number-8  { background-color: hsl(272, 100%, 50%) !important; } /* +8°  */
.heat-number-7  { background-color: hsl(279, 100%, 50%) !important; } /* +7°  */
.heat-number-9  { background-color: hsl(285, 100%, 50%) !important; } /* +6°  */
.heat-number-11 { background-color: hsl(290, 100%, 50%) !important; } /* +5°  */
.heat-number-10 { background-color: hsl(294, 100%, 50%) !important; } /* +4°  */
.heat-number-13 { background-color: hsl(297, 100%, 50%) !important; } /* +3°  */
.heat-number-14 { background-color: hsl(299, 100%, 50%) !important; } /* +2° */

/* Heat board scroll offset for sticky header */
.heat-board {
    scroll-margin-top: 70px;
}

@keyframes pulse {
    0% { transform: scale(1); }
    50% { transform: scale(1.1); }
    100% { transform: scale(1); }
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .participant-card {
        padding: 10px 12px;
    }
    
    .participant-header {
        gap: 8px;
    }
    
    .participant-bib {
        font-size: 0.7rem;
        padding: 3px 8px;
        min-width: 40px;
        height: 22px;
    }
    
    .participant-name {
        font-size: 0.85rem;
    }
    
    .detail-item {
        font-size: 0.7rem;
        padding: 1px 4px;
    }
}

/* Scrollbar styling for webkit browsers */
.participant-multiselect::-webkit-scrollbar {
    width: 8px;
}

.participant-multiselect::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 4px;
}

.participant-multiselect::-webkit-scrollbar-thumb {
    background: linear-gradient(135deg, #6c757d 0%, #495057 100%);
    border-radius: 4px;
}

.participant-multiselect::-webkit-scrollbar-thumb:hover {
    background: linear-gradient(135deg, #495057 0%, #343a40 100%);
}
/* Form enhancements */
.card-header p {
    margin-top: 4px;
}

/* Button hover effects */
#ajaxAssignBtn {
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    transition: all 0.2s ease;
}

#ajaxAssignBtn:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.15);
}

/* Loading state */
#ajaxAssignBtn.loading {
    position: relative;
    color: transparent;
}

#ajaxAssignBtn.loading::after {
    content: '';
    position: absolute;
    width: 16px;
    height: 16px;
    top: 50%;
    left: 50%;
    margin-left: -8px;
    margin-top: -8px;
    border: 2px solid #ffffff;
    border-radius: 50%;
    border-top-color: transparent;
    animation: spin 0.8s linear infinite;
}

@keyframes spin {
    to {
        transform: rotate(360deg);
    }
}

/* Filter section styling */
.form-select-sm {
    font-size: 0.875rem;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .participant-multiselect {
        font-size: 0.875rem;
    }
    
    .participant-bib {
        font-size: 0.7rem;
        padding: 1px 6px;
        min-width: 35px;
    }
}
/* Row View Styling */
.participant-row-container {
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    border: 2px solid #e9ecef;
    background: #ffffff;
    max-height: 600px;
    overflow-y: auto;
}

.participant-row-header {
    display: grid;
    grid-template-columns: 80px 1fr 1fr 1fr 80px 80px 120px 80px;
    gap: 1px;
    background: #f8f9fa;
    border-bottom: 2px solid #dee2e6;
    position: sticky;
    top: 0;
    z-index: 10;
}

.row-header-item {
    padding: 12px 8px;
    font-weight: 600;
    font-size: 0.875rem;
    background: #e9ecef;
    text-align: center;
    color: #495057;
    border-right: 1px solid #dee2e6;
}

.row-header-item:last-child {
    border-right: none;
}

.participant-rows {
    background: #ffffff;
}

.participant-row-item {
    display: grid;
    grid-template-columns: 80px 1fr 1fr 1fr 80px 80px 120px 80px;
    gap: 1px;
    background: #f8f9fa;
    border-bottom: 1px solid #e9ecef;
    cursor: pointer;
    transition: all 0.2s ease;
    position: relative;
    min-height: 60px;
    align-items: center;
}

.participant-row-item:hover {
    background: #e3f2fd;
    transform: translateX(2px);
    box-shadow: 0 2px 8px rgba(0, 123, 255, 0.15);
}

/* Drag-and-Drop Styles */
#participantsTable tbody .participant-row[draggable="true"] {
    cursor: grab;
}

#participantsTable tbody .participant-row[draggable="true"]:active {
    cursor: grabbing;
}

#participantsTable tbody .participant-row[draggable="true"]:hover {
    background-color: #fff3cd;
    border-left: 3px solid #ffc107;
}

#reorder-table tbody.drag-over {
    background-color: #e3f2fd;
    border: 2px dashed #007bff;
}


.participant-row-item.selected {
    background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
    color: white;
    transform: translateX(4px);
    box-shadow: 0 4px 12px rgba(0, 123, 255, 0.3);
}

.participant-row-item.already-assigned {
    border-left: 4px solid #28a745;
    background: linear-gradient(135deg, #f8fffa 0%, #e8f5e8 100%);
}

.participant-row-item.already-assigned.selected {
    background: linear-gradient(135deg, #28a745 0%, #1e7e34 100%);
}

.row-selection-indicator {
    position: absolute;
    top: 8px;
    right: 8px;
    background: #28a745;
    color: white;
    width: 20px;
    height: 20px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.7rem;
    opacity: 0;
    transform: scale(0);
    transition: all 0.3s ease;
    border: 1px solid white;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
    z-index: 5;
}

.participant-row-item.selected .row-selection-indicator {
    opacity: 1;
    transform: scale(1);
}

.row-item {
    padding: 8px;
    background: white;
    display: flex;
    align-items: center;
    justify-content: center;
    text-align: center;
    border-right: 1px solid #e9ecef;
    min-height: 44px;
}
td.row-item{    text-align: left !important;
    justify-content: flex-start !important;}
.row-item:last-child {
    border-right: none;
}

.participant-row-item.selected .row-item {
    background: rgba(255, 255, 255, 0.1);
    color: white;
}

/* Individual row item styling */
.row-bib-badge {
    background: linear-gradient(135deg, #6c757d 0%, #495057 100%);
    color: white;
    padding: 4px 8px;
    border-radius: 12px;
    font-size: 0.8rem;
    font-weight: bold;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    min-width: 40px;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
}
.heat-badge {
    
    color: white;
    padding: 4px 8px;
    border-radius: 12px;
    font-size: 0.8rem;
    font-weight: bold;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
}
.participant-row-item.selected .row-bib-badge {
    background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
    color: #007bff;
}

.name-col {
    text-align: left !important;
    justify-content: flex-start !important;
}

.row-name {
    font-weight: 600;
    font-size: 0.9rem;
    line-height: 1.2;
}
.row-name {
    display: inline-block;
}

.row-id {
    display: inline;
}
.row-id {
    font-size: 0.7rem;
    color: #6c757d;
    margin-top: 2px;
}

.participant-row-item.selected .row-id {
    color: rgba(255, 255, 255, 0.8);
}

.club-col, .category-col {
    text-align: left !important;
    justify-content: flex-start !important;
}

.row-club, .row-category {
    font-size: 0.85rem;
    padding: 2px 6px;
    border-radius: 6px;
    background: rgba(108, 117, 125, 0.1);
    display: inline-block;
    max-width: 100%;
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
}

.participant-row-item.selected .row-club,
.participant-row-item.selected .row-category {
    background: rgba(255, 255, 255, 0.2);
}

.row-gender {
    font-size: 0.85rem;
    display: flex;
    align-items: center;
    gap: 4px;
}

.row-year {
    font-size: 0.85rem;
    color: #6c757d;
}

.participant-row-item.selected .row-year {
    color: rgba(255, 255, 255, 0.9);
}

.row-status {
    font-size: 0.8rem;
    padding: 4px 8px;
    border-radius: 12px;
    display: inline-flex;
    align-items: center;
    gap: 4px;
    font-weight: 500;
}

.row-status.assigned {
    background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
    color: white;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
}

.row-status.unassigned {
    background: rgba(108, 117, 125, 0.1);
    color: #6c757d;
}

.participant-row-item.selected .row-status.assigned {
    background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
    color: #28a745;
}

.participant-row-item.selected .row-status.unassigned {
    background: rgba(255, 255, 255, 0.2);
    color: rgba(255, 255, 255, 0.9);
}

/* View Toggle Button Styling */
.btn-group .btn.active {
    background-color: #007bff;
    border-color: #007bff;
    color: white;
}

/* Responsive adjustments for row view */
@media (max-width: 768px) {
    .participant-row-header,
    .participant-row-item {
        grid-template-columns: 60px 1fr 100px 80px 60px 60px 100px;
        font-size: 0.8rem;
    }
    
    .row-header-item,
    .row-item {
        padding: 6px 4px;
        min-height: 40px;
    }
    
    .row-name {
        font-size: 0.8rem;
    }
    
    .row-id {
        font-size: 0.65rem;
    }
    
    .row-bib-badge {
        font-size: 0.7rem;
        padding: 2px 6px;
        min-width: 35px;
    }
}

@media (max-width: 576px) {
    .participant-row-header,
    .participant-row-item {
        grid-template-columns: 50px 1fr 80px 60px 50px 50px 80px;
    }
    
    .row-header-item,
    .row-item {
        padding: 4px 2px;
        font-size: 0.75rem;
    }
    
    .row-club, .row-category {
        font-size: 0.7rem;
    }
}

/* Hide/show animation for row view */
.participant-row-item.hidden {
    display: none;
}

.participant-row-item.show {
    animation: fadeInRow 0.3s ease;
}

@keyframes fadeInRow {
    from {
        opacity: 0;
        transform: translateX(-10px);
    }
    to {
        opacity: 1;
        transform: translateX(0);
    }
}

/* Scrollbar styling for row view */
.participant-row-container::-webkit-scrollbar {
    width: 8px;
}

.participant-row-container::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 4px;
}

.participant-row-container::-webkit-scrollbar-thumb {
    background: linear-gradient(135deg, #6c757d 0%, #495057 100%);
    border-radius: 4px;
}

.participant-row-container::-webkit-scrollbar-thumb:hover {
    background: linear-gradient(135deg, #495057 0%, #343a40 100%);
}

/* Ensure both views share the same container styling */
.participant-display-container {
    position: relative;
}
/* Modern Participant Grid Styling */
.participant-grid-container {
    position: relative;
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    border: 2px solid #e9ecef;
    background: #f8f9fa;
    max-height: 600px;
    overflow-y: auto;
}

.participant-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
    gap: 12px;
    padding: 16px;
}

.participant-card-item {
    background: white;
    border-radius: 12px;
    padding: 16px;
    border: 2px solid #e9ecef;
    cursor: pointer;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.participant-card-item:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0, 123, 255, 0.15);
    border-color: #007bff;
}

.participant-card-item.selected {
    background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
    color: white;
    border-color: #0056b3;
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0, 123, 255, 0.3);
}

.participant-card-item.already-assigned {
    border-left: 4px solid #28a745;
    background: linear-gradient(135deg, #f8fffa 0%, #e8f5e8 100%);
}

.participant-card-item.already-assigned.selected {
    background: linear-gradient(135deg, #28a745 0%, #1e7e34 100%);
}

.participant-card-header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 12px;
    position: relative;
}

.participant-bib-badge {
    background: linear-gradient(135deg, #6c757d 0%, #495057 100%);
    color: white;
    padding: 6px 12px;
    border-radius: 20px;
    font-size: 0.8rem;
    font-weight: bold;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    min-width: 50px;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
}

.participant-card-item.selected .participant-bib-badge {
    background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
    color: #007bff;
}

.participant-selection-indicator {
    position: absolute;
    top: -8px;
    right: -8px;
    background: #28a745;
    color: white;
    width: 24px;
    height: 24px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.7rem;
    opacity: 0;
    transform: scale(0);
    transition: all 0.3s ease;
    border: 2px solid white;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.2);
}

.participant-card-item.selected .participant-selection-indicator {
    opacity: 1;
    transform: scale(1);
}

.assignment-indicator {
    background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
    color: white;
    padding: 2px 8px;
    border-radius: 12px;
    font-size: 0.7rem;
    font-weight: bold;
    display: flex;
    align-items: center;
    gap: 4px;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
}

.participant-card-item.selected .assignment-indicator {
    background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
    color: #28a745;
}

.participant-card-body {
    display: flex;
    flex-direction: column;
    gap: 12px;
}

.participant-name {
    font-weight: 600;
    font-size: 1rem;
    color: #212529;
    line-height: 1.2;
}

.participant-card-item.selected .participant-name {
    color: white;
    font-weight: 700;
}

.participant-details-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 8px;
}

.detail-badge {
    display: flex;
    align-items: center;
    gap: 6px;
    font-size: 0.75rem;
    padding: 4px 8px;
    border-radius: 8px;
    background: rgba(108, 117, 125, 0.1);
    color: #6c757d;
    transition: all 0.2s ease;
}

.detail-badge i {
    width: 12px;
    text-align: center;
}

.detail-badge span {
    flex: 1;
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
}
.table-participants td{
    vertical-align: middle;
}
.table-responsive {
    position: relative;
    overflow: auto;
    max-height: 70vh;
    overflow-x: auto;
    -webkit-overflow-scrolling: touch;
}
.detail-badge.club {
    background: #343a4012;
    color: #343a40;
}
td .detail-badge {
    display: inline-block;
}
.detail-badge.category {
    background: #1987541c;
    color: #198754;
}

.detail-badge.gender {
    background: rgba(220, 53, 69, 0.1);
    color: #dc3545;
}
.detail-badge.gender-male {
    background: lch(49 81.77 283.4 / 0.1);
    color: #0d6efd;
}
.detail-badge.year {
    background: rgba(108, 117, 125, 0.1);
    color: #6c757d;
}

.participant-card-item.selected .detail-badge {
    background: rgba(255, 255, 255, 0.2);
    color: rgba(255, 255, 255, 0.9);
}

.no-participants-message {
    background: white;
    border-radius: 12px;
    margin: 16px;
}

.participant-select-footer {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    padding: 12px 16px;
    border-top: 1px solid #dee2e6;
}

/* Search bar styling */
.input-group .input-group-text {
    background: white;
    border-color: #ced4da;
}

#participantSearch {
    border-color: #ced4da;
}

#participantSearch:focus {
    border-color: #007bff;
    box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
}

/* Selection status badge animation */
#participantStatusBadge {
    transition: all 0.3s ease;
}

#participantStatusBadge.has-selection {
    background: linear-gradient(135deg, #28a745 0%, #20c997 100%) !important;
    animation: pulse 1s ease-in-out;
}

@keyframes pulse {
    0% { transform: scale(1); }
    50% { transform: scale(1.1); }
    100% { transform: scale(1); }
}

/* Hide/show animation */
.participant-card-item.hidden {
    display: none;
}

.participant-card-item.show {
    animation: fadeInUp 0.3s ease;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

/* Responsive design */
@media (max-width: 768px) {
    .participant-grid {
        grid-template-columns: 1fr;
        gap: 8px;
        padding: 12px;
    }
    
    .participant-card-item {
        padding: 12px;
    }
    
    .participant-details-grid {
        grid-template-columns: 1fr;
        gap: 6px;
    }
    
    .participant-bib-badge {
        font-size: 0.7rem;
        padding: 4px 8px;
        min-width: 40px;
    }
}

@media (max-width: 576px) {
    .participant-grid-container {
        max-height: 400px;
    }
    
    .participant-card-header {
        margin-bottom: 8px;
    }
    
    .participant-name {
        font-size: 0.9rem;
    }
    
    .detail-badge {
        font-size: 0.7rem;
        padding: 3px 6px;
    }
}

/* Scrollbar styling */
.participant-grid-container::-webkit-scrollbar {
    width: 8px;
}

.participant-grid-container::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 4px;
}

.participant-grid-container::-webkit-scrollbar-thumb {
    background: linear-gradient(135deg, #6c757d 0%, #495057 100%);
    border-radius: 4px;
}

.participant-grid-container::-webkit-scrollbar-thumb:hover {
    background: linear-gradient(135deg, #495057 0%, #343a40 100%);
}
</style>
<script>
jQuery(function() {
    jQuery("#reorder-table tbody").sortable({
        helper: fixWidthHelper,
        update: function(event, ui) {
            const order = jQuery("#reorder-table tbody tr").map(function() {
                return jQuery(this).data("id");
            }).get();

            jQuery.ajax({
                url: "save_reorder.php",
                method: "POST",
                data: { order: order },
                success: function(response) {
                    console.log("Saved order:", order);
                    console.log("Saved order:", response);
                }
            });
        }
    }).disableSelection();

    function fixWidthHelper(e, ui) {
        ui.children().each(function() {
            jQuery(this).width(jQuery(this).width());
        });
        return ui;
    }
});
jQuery(function () {
    const $tbody = jQuery("#reorder-table tbody");

    $tbody.sortable({
        helper: function (e, item) {
            let selected = item.closest('tbody').find('input.bulk-check:checked').closest('tr');

            // If the dragged row is not selected, deselect others
            if (!item.find('input.bulk-check').is(':checked')) {
                selected = item;
                $tbody.find('input.bulk-check').prop('checked', false);
                item.find('input.bulk-check').prop('checked', true);
            }

            // Clone all selected rows for visual feedback
            const helper = jQuery('<tbody/>');
            selected.each(function () {
                helper.append(jQuery(this).clone().css('background', '#f0f0f0'));
            });

            item.data('multidrag', selected); // Store original selection
            return helper;
        },
        start: function (e, ui) {
            const selected = ui.item.data('multidrag');
            selected.css('opacity', 0.5);
        },
        stop: function (e, ui) {
            const selected = ui.item.data('multidrag');
            const targetIndex = ui.item.index();

            // Move all selected rows to the new index
            selected.css('opacity', 1);
            selected.detach();

            if (targetIndex === 0) {
                $tbody.prepend(selected);
            } else {
                $tbody.find('tr').eq(targetIndex - 1).after(selected);
            }

            // Send new order via AJAX
            const newOrder = $tbody.find('tr').map(function () {
                return jQuery(this).data("id");
            }).get();

            jQuery.ajax({
                url: "save_reorder.php",
                method: "POST",
                data: { order: newOrder },
                success: function (response) {
                    console.log("New order saved", newOrder);
                }
            });
        },
        cancel: 'input,button',
        items: '> tr'
    });
});
jQuery('#legacy-reverseSelectedBtn').on('click', function () {
    const $tbody = jQuery('#reorder-table tbody');
    const $selectedRows = $tbody.find('tr:visible').has('input.bulk-check:checked');

    if ($selectedRows.length < 2) {
        showAlert('Select at least 2 rows to reverse.', 'Selection Required', 'exclamation-triangle');
        return;
    }

    // Get index of the first selected row
    const firstIndex = $selectedRows.first().index();

    // Detach and reverse
    const $reversed = jQuery($selectedRows.get().reverse());
    $selectedRows.remove();
    if (firstIndex === 0) {
        $tbody.prepend($reversed);
    } else {
        $tbody.find('tr').eq(firstIndex - 1).after($reversed);
    }

    // Renumber serials
    let serial = 1;
    $tbody.find('tr:visible').each(function () {
        jQuery(this).find('.serial-number').text(serial++);
    });

    // Save new order via AJAX
    const newOrder = $tbody.find('tr').map(function () {
        return jQuery(this).data('id');
    }).get();

    jQuery.ajax({
        url: 'save_reorder.php',
        method: 'POST',
        data: { order: newOrder },
        success: function (res) {
            console.log('Reversed order saved');
        }
    });
});
jQuery('#legacy-shuffleSelectedBtn').on('click', function () {
    const $tbody = jQuery('#reorder-table tbody');
    const $selectedRows = $tbody.find('tr:visible').has('input.bulk-check:checked');

    if ($selectedRows.length < 2) {
        showAlert('Select at least 2 rows to shuffle.', 'Selection Required', 'exclamation-triangle');
        return;
    }

    // Get index of first selected row
    const firstIndex = $selectedRows.first().index();

    // Convert selected rows to array and shuffle it
    const rowsArray = $selectedRows.get();
    for (let i = rowsArray.length - 1; i > 0; i--) {
        const j = Math.floor(Math.random() * (i + 1));
        [rowsArray[i], rowsArray[j]] = [rowsArray[j], rowsArray[i]];
    }

    const $shuffled = jQuery(rowsArray);
    $selectedRows.remove();

    if (firstIndex === 0) {
        $tbody.prepend($shuffled);
    } else {
        $tbody.find('tr').eq(firstIndex - 1).after($shuffled);
    }

    // Renumber serials
    let serial = 1;
    $tbody.find('tr:visible').each(function () {
        jQuery(this).find('.serial-number').text(serial++);
    });

    // Save new order via AJAX
    const newOrder = $tbody.find('tr').map(function () {
        return jQuery(this).data('id');
    }).get();

    jQuery.ajax({
        url: 'save_reorder.php',
        method: 'POST',
        data: { order: newOrder },
        success: function (res) {
            console.log('Shuffled order saved');
            $shuffled.addClass('shuffled');
setTimeout(() => $shuffled.removeClass('shuffled'), 600);

        }
    });
});
function sortSelectedRows(comparator) {
    const $tbody = jQuery('#reorder-table tbody');
    const $selectedRows = $tbody.find('tr:visible').has('input.bulk-check:checked');

    if ($selectedRows.length < 2) {
        showAlert('Select at least 2 rows to sort.', 'Selection Required', 'exclamation-triangle');
        return;
    }

    const firstIndex = $selectedRows.first().index();
    const rowsArray = $selectedRows.get();

    rowsArray.sort(comparator);
    const $sorted = jQuery(rowsArray);
    $selectedRows.remove();

    if (firstIndex === 0) {
        $tbody.prepend($sorted);
    } else {
        $tbody.find('tr').eq(firstIndex - 1).after($sorted);
    }

    // Renumber serials
    let serial = 1;
    $tbody.find('tr:visible').each(function () {
        jQuery(this).find('.serial-number').text(serial++);
    });

    // Save new order
    const newOrder = $tbody.find('tr').map(function () {
        return jQuery(this).data('id');
    }).get();

    jQuery.ajax({
        url: 'save_reorder.php',
        method: 'POST',
        data: { order: newOrder },
        success: function (res) {
            console.log('Sorted order saved');
        }
    });
}

// Sort Alphabetically (Last + First)
jQuery('#legacy-sortByNameBtn').on('click', function () {
    sortSelectedRows(function (a, b) {
        const nameA = jQuery(a).find('td').eq(3).text().toLowerCase();
        const nameB = jQuery(b).find('td').eq(3).text().toLowerCase();
        return nameA.localeCompare(nameB);
    });
});

// Sort by bib (numerically)
jQuery('#legacy-sortBybibBtn').on('click', function () {
    sortSelectedRows(function (a, b) {
        const bibA = parseInt(jQuery(a).find('td').eq(2).text(), 10);
        const bibB = parseInt(jQuery(b).find('td').eq(2).text(), 10);
        return bibA - bibB;
    });
});

// Sort by Year (youngest last)
jQuery('#legacy-sortByYearBtn').on('click', function () {
    sortSelectedRows(function (a, b) {
        const yearA = parseInt(jQuery(a).data('year'), 10);
        const yearB = parseInt(jQuery(b).data('year'), 10);
        return yearA - yearB;
    });
});

</script>
<script>
// Enhanced AJAX assignment with better UX
jQuery('#ajaxAssignBtn').on('click', function () {
    const $btn = jQuery(this);
    const form = jQuery('#ajaxAssignForm');
    const eventId = form.data('event');
    const heatNumber = form.find('[name=heat_number]').val();
    const participants = form.find('[name="participant_ids[]"] option:selected').map(function () {
        return this.value;
    }).get();

    if (!heatNumber) {
        showAlert('Please select a heat first.', 'Selection Required', 'exclamation-triangle');
        document.getElementById('heat_number').focus();
        return;
    }
    
    if (participants.length === 0) {
        showAlert('Please select at least one participant to assign.', 'Selection Required', 'exclamation-triangle');
        document.getElementById('participantSelect').focus();
        return;
    }

    // Show loading state
    $btn.addClass('loading').prop('disabled', true);
    const originalText = $btn.html();

    jQuery.ajax({
        url: 'ajax_assing.php',
        method: 'POST',
        data: {
            event_id: eventId,
            heat_number: heatNumber,
            participant_ids: participants
        },
        dataType: 'json',
        success: function (response) {
            if (response.status === 'success') {
                // Show success message
                $btn.removeClass('loading btn-success').addClass('btn-outline-success').html('<i class="fas fa-check me-2"></i>Success!');
                
                // Show detailed success message
                const participantCount = participants.length;
                const heatName = jQuery('#heat_number option:selected').text();
                
                showAlert(
                    `Successfully assigned ${participantCount} participant(s) to ${heatName}!\n\n${response.message}`,
                    'Assignment Successful',
                    'check-circle'
                );
                
                // Reload page after short delay
                setTimeout(() => {
                    window.location.reload();
                }, 1500);
            } else {
                throw new Error(response.message || 'Assignment failed');
            }
        },
        error: function (xhr, status, error) {
            console.error('AJAX Error:', xhr.responseText);
            let errorMessage = 'Assignment failed. Please try again.';
            
            try {
                const response = JSON.parse(xhr.responseText);
                errorMessage = response.message || errorMessage;
            } catch (e) {
                if (xhr.responseText) {
                    errorMessage = 'Server error: ' + xhr.responseText.substring(0, 100);
                }
            }
            
            showAlert('Error: ' + errorMessage, 'Assignment Failed', 'exclamation-circle');
        },
        complete: function () {
            // Restore button state
            $btn.removeClass('loading').prop('disabled', false);
            if (!$btn.hasClass('btn-outline-success')) {
                $btn.html(originalText);
            }
        }
    });
});

// Bulk unassign selected participants from all heats
jQuery('#bulkUnassignBtn').on('click', function () {
    const $btn = jQuery(this);
    const form = jQuery('#ajaxAssignForm');
    const eventId = form.data('event');
    const participants = form.find('[name="participant_ids[]"] option:selected').map(function () {
        return this.value;
    }).get();
    
    if (participants.length === 0) {
        showAlert('Please select at least one participant to unassign.', 'Selection Required', 'exclamation-triangle');
        return;
    }
    
    if (!confirm(`Are you sure you want to unassign ${participants.length} participant(s) from all heats?`)) {
        return;
    }
    
    // Show loading state
    $btn.addClass('loading').prop('disabled', true);
    const originalHtml = $btn.html();
    $btn.html('<i class="fas fa-spinner fa-spin"></i>');
    
    jQuery.ajax({
        url: 'ajax_unassign.php',
        method: 'POST',
        data: {
            event_id: eventId,
            participant_ids: participants
        },
        dataType: 'json',
        success: function (response) {
            if (response.status === 'success') {
                showAlert(
                    `Successfully unassigned ${participants.length} participant(s) from all heats!`,
                    'Unassignment Successful',
                    'check-circle'
                );
                
                setTimeout(() => {
                    window.location.reload();
                }, 1000);
            } else {
                throw new Error(response.message || 'Unassignment failed');
            }
        },
        error: function (xhr, status, error) {
            console.error('AJAX Error:', xhr.responseText);
            let errorMessage = 'Unassignment failed. Please try again.';
            
            try {
                const response = JSON.parse(xhr.responseText);
                errorMessage = response.message || errorMessage;
            } catch (e) {
                if (xhr.responseText) {
                    errorMessage = 'Server error: ' + xhr.responseText.substring(0, 100);
                }
            }
            
            showAlert('Error: ' + errorMessage, 'Unassignment Failed', 'exclamation-circle');
        },
        complete: function () {
            $btn.removeClass('loading').prop('disabled', false).html(originalHtml);
        }
    });
});

// Bulk unassign from participants table header
jQuery('#bulkUnassignParticipantsBtn').on('click', function () {
    const $btn = jQuery(this);
    const form = jQuery('#ajaxAssignForm');
    const eventId = form.data('event');
    const participants = form.find('[name="participant_ids[]"] option:selected').map(function () {
        return this.value;
    }).get();
    
    if (participants.length === 0) {
        showAlert('Please select at least one participant to unassign.', 'Selection Required', 'exclamation-triangle');
        return;
    }
    
    if (!confirm(`Are you sure you want to unassign ${participants.length} participant(s) from all heats?`)) {
        return;
    }
    
    // Show loading state
    $btn.prop('disabled', true);
    const originalHtml = $btn.html();
    $btn.html('<i class="fas fa-spinner fa-spin me-1"></i>Unassigning...');
    
    jQuery.ajax({
        url: 'ajax_unassign.php',
        method: 'POST',
        data: {
            event_id: eventId,
            participant_ids: participants
        },
        dataType: 'json',
        success: function (response) {
            if (response.status === 'success') {
                showAlert(
                    `Successfully unassigned ${participants.length} participant(s) from all heats!`,
                    'Unassignment Successful',
                    'check-circle'
                );
                
                setTimeout(() => {
                    window.location.reload();
                }, 1000);
            } else {
                throw new Error(response.message || 'Unassignment failed');
            }
        },
        error: function (xhr, status, error) {
            console.error('AJAX Error:', xhr.responseText);
            let errorMessage = 'Unassignment failed. Please try again.';
            
            try {
                const response = JSON.parse(xhr.responseText);
                errorMessage = response.message || errorMessage;
            } catch (e) {
                if (xhr.responseText) {
                    errorMessage = 'Server error: ' + xhr.responseText.substring(0, 100);
                }
            }
            
            showAlert('Error: ' + errorMessage, 'Unassignment Failed', 'exclamation-circle');
            $btn.prop('disabled', false).html(originalHtml);
        }
    });
});

// Unassign individual participant from all heats
function unassignParticipant(participantId) {
    if (!confirm('Remove this participant from all heats?')) {
        return;
    }
    
    const eventId = document.querySelector('#ajaxAssignForm').dataset.event;
    
    jQuery.ajax({
        url: 'ajax_unassign.php',
        method: 'POST',
        data: {
            event_id: eventId,
            participant_ids: [participantId]
        },
        dataType: 'json',
        success: function (response) {
            if (response.status === 'success') {
                showAlert('Participant unassigned successfully!', 'Success', 'check-circle');
                setTimeout(() => {
                    window.location.reload();
                }, 1000);
            } else {
                throw new Error(response.message || 'Unassignment failed');
            }
        },
        error: function (xhr, status, error) {
            console.error('AJAX Error:', xhr.responseText);
            showAlert('Error: Failed to unassign participant', 'Unassignment Failed', 'exclamation-circle');
        }
    });
}

// Auto-clear selection after successful assignment
function clearFormAfterSuccess() {
    document.getElementById('heat_number').value = '';
    clearSelection();
    clearAllFilters();
}
</script>
<script>
    jQuery(document).ready(function () {
    // Master "select all" checkbox — only visible rows
    jQuery('#bulk-check-master').on('change', function () {
        const checked = this.checked;
        jQuery('#reorder-table tbody tr:visible .bulk-check').each(function () {
            this.checked = checked;
            jQuery(this).closest('tr').toggleClass('selected-row', checked);
        });
    });

    // Toggle row highlight on individual row selection
    jQuery(document).on('change', '.bulk-check', function () {
        jQuery(this).closest('tr').toggleClass('selected-row', this.checked);
    });
});
    </script>
   

    <div class="modal fade" id="assignbibModal" tabindex="-1" aria-labelledby="assignbibModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <form id="assignbibForm">
        <div class="modal-header">
          <h5 class="modal-title" id="assignbibModalLabel">Assign bib Numbers</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <div class="mb-3">
            <label for="bib_series_id" class="form-label">Select bib Series</label>
            <select name="bib_series_id" id="bib_series_id" class="form-select" required>
              <option value="">-- Choose Series --</option>
              <?php foreach ($bib_series as $series): ?>
                <option value="<?= $series['id'] ?>" data-start="<?= $series['start_number'] ?>" data-end="<?= $series['end_number'] ?>">
                  <?= htmlspecialchars($series['name']) ?> (<?= $series['start_number'] ?>–<?= $series['end_number'] ?>)
                </option>
              <?php endforeach; ?>
            </select>
          </div>
          
          <div class="mb-3">
            <label for="start_number" class="form-label">Start bib Number</label>
            <input type="number" name="start_number" id="start_number" class="form-control" placeholder="Auto from series" min="1">
            <small class="form-text text-muted">Leave empty to use next available from series</small>
          </div>
          
          <div class="form-check mb-3">
            <input type="checkbox" name="overwrite_existing" id="overwrite_existing" class="form-check-input">
            <label class="form-check-label" for="overwrite_existing">
              Overwrite existing bib numbers
            </label>
            <small class="form-text text-muted d-block">If unchecked, only participants without bib will be assigned</small>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-primary">Assign bibs</button>
        </div>
      </form>
    </div>
  </div>
</div>
 <script>
// Auto-fill start number when series is selected
jQuery('#bib_series_id').on('change', function() {
    const selectedOption = jQuery(this).find('option:selected');
    const startNumber = selectedOption.data('start');
    if (startNumber) {
        jQuery('#start_number').attr('placeholder', 'Auto from series (' + startNumber + ')');
    }
});
// Replace the old #legacy-promoteToHeatBtn handler with this:
jQuery('#legacy-promoteToHeatBtn').on('click', function () {
    jQuery('#promoteToHeatModal').modal('show');
});


jQuery('#assignbibForm').on('submit', function (e) {
    e.preventDefault();

    // Check both legacy table and new heat boards for selected checkboxes
    const legacySelected = jQuery('#reorder-table tbody tr:visible .bulk-check:checked')
        .map(function () {
            return jQuery(this).val();
        }).get();
    
    const heatBoardSelected = jQuery('.assignment-checkbox:checked')
        .map(function () {
            return jQuery(this).val();
        }).get();
    
    const selectedIds = [...legacySelected, ...heatBoardSelected];

    const seriesId = jQuery('#bib_series_id').val();
    const startNumber = jQuery('#start_number').val();
    const overwriteExisting = jQuery('#overwrite_existing').is(':checked');
    const eventId = <?= json_encode($selected_event) ?>;

    if (!seriesId || selectedIds.length === 0) {
        showAlert('Please select at least one participant and a BIB series.', 'Selection Required', 'exclamation-triangle');
        return;
    }

    jQuery.ajax({
        url: 'ajax_assign_bib.php',
        method: 'POST',
        data: {
            participant_ids: selectedIds,
            bib_series_id: seriesId,
            start_number: startNumber,
            overwrite_existing: overwriteExisting ? 1 : 0,
            event_id: eventId
        },
        success: function (response) {
            try {
                const res = JSON.parse(response);
                if (res.status === 'success') {
                    showAlert(res.message, 'Success', 'check-circle');
                    setTimeout(() => location.reload(), 1500);
                } else {
                    showAlert(res.message || 'An error occurred.', 'Error', 'exclamation-circle');
                }
            } catch (e) {
                showAlert('Invalid response from server.', 'Error', 'exclamation-circle');
                console.error(response);
            }
        },
        error: function () {
            showAlert('AJAX request failed. Please try again.', 'Error', 'exclamation-circle');
        }
    });
});
</script>

<!-- Drag-and-Drop Heat Assignment Modal -->
<div class="modal fade" id="dragDropHeatModal" tabindex="-1" aria-labelledby="dragDropHeatModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title" id="dragDropHeatModalLabel">
          <i class="fas fa-fire me-2"></i>Assign to Heat
        </h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div class="mb-3">
          <label class="form-label fw-bold">
            <span id="dragDropParticipantCount">1</span> Participant<span id="dragDropParticipantPlural">s</span>:
          </label>
          <div id="dragDropParticipantInfo" class="p-2 bg-light rounded" style="max-height: 200px; overflow-y: auto;">
            <!-- Participant list will be populated here -->
          </div>
        </div>
        <div class="mb-3">
          <label for="dragDropHeatSelect" class="form-label fw-bold">
            <i class="fas fa-fire me-1"></i>Select Heat:
          </label>
          <select id="dragDropHeatSelect" class="form-select">
            <option value="">-- Select Heat --</option>
            <?php foreach ($heat_options as $heat): ?>
              <option value="<?= $heat['heat_number'] ?>">
                Heat <?= $heat['heat_number'] ?><?= $heat['heat_name'] ? ' – ' . htmlspecialchars($heat['heat_name']) : '' ?>
              </option>
            <?php endforeach; ?>
          </select>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
          <i class="fas fa-times me-1"></i>Cancel
        </button>
        <button type="button" id="dragDropAssignBtn" class="btn btn-success">
          <i class="fas fa-user-plus me-1"></i>Assign to Heat
        </button>
      </div>
    </div>
  </div>
</div>

<script>
// Drag-and-Drop functionality for participant assignment (supports multiple selection)
document.addEventListener('DOMContentLoaded', function() {
    let draggedParticipantIds = [];
    let draggedParticipants = [];
    let touchHoldTimer = null;
    let touchStartPos = { x: 0, y: 0 };
    let isDragEnabled = false;
    const TOUCH_HOLD_DELAY = 1500; // 1 second hold to activate drag
    
    // Make participant table rows draggable
    const participantRows = document.querySelectorAll('#participantsTable tbody .participant-row');
    participantRows.forEach(row => {
        row.setAttribute('draggable', 'true');
        
        // Mouse drag (desktop)
        row.addEventListener('dragstart', function(e) {
            // Check if there are selected checkboxes
            const selectedCheckboxes = document.querySelectorAll('#participantsTable tbody .participant-checkbox:checked');
            
            if (selectedCheckboxes.length > 0) {
                // Drag multiple selected participants
                draggedParticipantIds = [];
                draggedParticipants = [];
                
                selectedCheckboxes.forEach(checkbox => {
                    const participantRow = checkbox.closest('.participant-row');
                    if (participantRow) {
                        const participantId = participantRow.dataset.id;
                        const lastName = participantRow.querySelector('td:nth-child(3) .fw-bold')?.textContent || '';
                        const bib = participantRow.querySelector('.css-bib .badge')?.textContent || '';
                        const category = participantRow.dataset.category || '';
                        const gender = participantRow.dataset.gender || '';
                        const year = participantRow.dataset.year || '';
                        
                        draggedParticipantIds.push(participantId);
                        draggedParticipants.push({
                            id: participantId,
                            name: lastName,
                            bib: bib,
                            category: category,
                            gender: gender,
                            year: year
                        });
                    }
                });
                
                // Visual feedback for all selected rows
                selectedCheckboxes.forEach(checkbox => {
                    const row = checkbox.closest('.participant-row');
                    if (row) row.style.opacity = '0.5';
                });
            } else {
                // Drag single participant (the one being dragged)
                draggedParticipantIds = [this.dataset.id];
                const lastName = this.querySelector('td:nth-child(3) .fw-bold')?.textContent || '';
                const bib = this.querySelector('.css-bib .badge')?.textContent || '';
                const category = this.dataset.category || '';
                const gender = this.dataset.gender || '';
                const year = this.dataset.year || '';
                
                draggedParticipants = [{
                    id: this.dataset.id,
                    name: lastName,
                    bib: bib,
                    category: category,
                    gender: gender,
                    year: year
                }];
                
                // Visual feedback
                this.style.opacity = '0.5';
            }
            
            e.dataTransfer.effectAllowed = 'copy';
            e.dataTransfer.setData('text/html', this.innerHTML);
        });
        
        row.addEventListener('dragend', function(e) {
            // Reset opacity for all rows
            document.querySelectorAll('#participantsTable tbody .participant-row').forEach(r => {
                r.style.opacity = '1';
            });
        });
        
        // Touch events (mobile/tablet) with 1-second hold delay
        row.addEventListener('touchstart', function(e) {
            // Don't activate drag if touching checkbox or button
            if (e.target.closest('input[type="checkbox"], button, a')) {
                return;
            }
            
            const touch = e.touches[0];
            touchStartPos = { x: touch.clientX, y: touch.clientY };
            isDragEnabled = false;
            
            const targetRow = this;
            
            // Visual feedback - add pulsing effect during hold
            targetRow.style.transition = 'transform 0.3s ease-in-out, box-shadow 0.3s ease-in-out';
            let pulseCount = 0;
            const pulseInterval = setInterval(() => {
                if (touchHoldTimer) {
                    pulseCount++;
                    const scale = 1 + (Math.sin(pulseCount * 0.5) * 0.02);
                    targetRow.style.transform = 'scale(' + scale + ')';
                    targetRow.style.boxShadow = '0 0 ' + (10 + pulseCount * 2) + 'px rgba(13, 110, 253, 0.3)';
                }
            }, 100);
            
            // Set timer to enable drag after 1 second hold
            touchHoldTimer = setTimeout(() => {
                clearInterval(pulseInterval);
                isDragEnabled = true;
                
                // Strong visual feedback when drag is enabled
                targetRow.style.transition = 'transform 0.2s ease-out, box-shadow 0.2s ease-out';
                targetRow.style.transform = 'scale(1.05)';
                targetRow.style.boxShadow = '0 4px 20px rgba(13, 110, 253, 0.5)';
                targetRow.classList.add('drag-ready-touch');
                
                // Haptic feedback if available
                if (navigator.vibrate) {
                    navigator.vibrate(50);
                }
                
                // Prepare drag data
                const selectedCheckboxes = document.querySelectorAll('#participantsTable tbody .participant-checkbox:checked');
                
                if (selectedCheckboxes.length > 0) {
                    draggedParticipantIds = [];
                    draggedParticipants = [];
                    
                    selectedCheckboxes.forEach(checkbox => {
                        const participantRow = checkbox.closest('.participant-row');
                        if (participantRow) {
                            const participantId = participantRow.dataset.id;
                            const lastName = participantRow.querySelector('td:nth-child(3) .fw-bold')?.textContent || '';
                            const bib = participantRow.querySelector('.css-bib .badge')?.textContent || '';
                            const category = participantRow.dataset.category || '';
                            const gender = participantRow.dataset.gender || '';
                            const year = participantRow.dataset.year || '';
                            
                            draggedParticipantIds.push(participantId);
                            draggedParticipants.push({
                                id: participantId,
                                name: lastName,
                                bib: bib,
                                category: category,
                                gender: gender,
                                year: year
                            });
                        }
                    });
                } else {
                    const participantId = targetRow.dataset.id;
                    const lastName = targetRow.querySelector('td:nth-child(3) .fw-bold')?.textContent || '';
                    const bib = targetRow.querySelector('.css-bib .badge')?.textContent || '';
                    const category = targetRow.dataset.category || '';
                    const gender = targetRow.dataset.gender || '';
                    const year = targetRow.dataset.year || '';
                    
                    draggedParticipantIds = [participantId];
                    draggedParticipants = [{
                        id: participantId,
                        name: lastName,
                        bib: bib,
                        category: category,
                        gender: gender,
                        year: year
                    }];
                }
            }, TOUCH_HOLD_DELAY);
            
            // Cancel hold timer if touch moves significantly (user is scrolling)
            const cancelHold = () => {
                if (touchHoldTimer) {
                    clearTimeout(touchHoldTimer);
                    clearInterval(pulseInterval);
                    touchHoldTimer = null;
                    isDragEnabled = false;
                    targetRow.style.transition = '';
                    targetRow.style.transform = '';
                    targetRow.style.boxShadow = '';
                    targetRow.classList.remove('drag-ready-touch');
                }
            };
            
            const checkTouchMove = (moveEvent) => {
                if (!isDragEnabled) {
                    const touch = moveEvent.touches[0];
                    const dx = Math.abs(touch.clientX - touchStartPos.x);
                    const dy = Math.abs(touch.clientY - touchStartPos.y);
                    
                    // If moved more than 10px, cancel hold (user is scrolling)
                    if (dx > 10 || dy > 10) {
                        cancelHold();
                        targetRow.removeEventListener('touchmove', checkTouchMove);
                    }
                }
            };
            
            targetRow.addEventListener('touchmove', checkTouchMove);
            targetRow.addEventListener('touchend', () => {
                if (!isDragEnabled) {
                    cancelHold();
                }
                targetRow.removeEventListener('touchmove', checkTouchMove);
            }, { once: true });
        }, { passive: false });
        
        row.addEventListener('touchmove', function(e) {
            if (!isDragEnabled) {
                return; // Allow normal scrolling
            }
            
            e.preventDefault(); // Prevent scrolling while dragging
            
            const touch = e.touches[0];
            
            // Create ghost element for visual feedback if not exists
            let ghost = document.getElementById('touch-drag-ghost');
            if (!ghost) {
                ghost = this.cloneNode(true);
                ghost.id = 'touch-drag-ghost';
                ghost.style.position = 'fixed';
                ghost.style.pointerEvents = 'none';
                ghost.style.opacity = '0.7';
                ghost.style.zIndex = '10000';
                ghost.style.width = this.offsetWidth + 'px';
                ghost.style.transform = 'rotate(3deg)';
                ghost.style.boxShadow = '0 8px 30px rgba(0, 0, 0, 0.3)';
                document.body.appendChild(ghost);
            }
            
            // Position ghost under finger
            ghost.style.left = (touch.clientX - this.offsetWidth / 2) + 'px';
            ghost.style.top = (touch.clientY - 30) + 'px';
            
            // Highlight drop zones
            const dropZones = document.querySelectorAll('.sortable-tbody, #reorder-table tbody');
            dropZones.forEach(zone => {
                const rect = zone.getBoundingClientRect();
                if (touch.clientX >= rect.left && touch.clientX <= rect.right &&
                    touch.clientY >= rect.top && touch.clientY <= rect.bottom) {
                    zone.classList.add('drag-over-touch');
                } else {
                    zone.classList.remove('drag-over-touch');
                }
            });
        }, { passive: false });
        
        row.addEventListener('touchend', function(e) {
            if (touchHoldTimer) {
                clearTimeout(touchHoldTimer);
                touchHoldTimer = null;
            }
            
            this.style.transition = '';
            this.style.transform = '';
            this.style.boxShadow = '';
            this.classList.remove('drag-ready-touch');
            
            if (!isDragEnabled) {
                return;
            }
            
            e.preventDefault();
            
            const ghost = document.getElementById('touch-drag-ghost');
            const touch = e.changedTouches[0];
            
            // Find drop target
            const dropZone = document.querySelector('.sortable-tbody.drag-over-touch, #reorder-table tbody.drag-over-touch');
            
            if (dropZone && draggedParticipantIds.length > 0) {
                // Determine if dropping on heat board or reorder table
                const heatBoard = dropZone.closest('.sortable-tbody');
                
                if (heatBoard) {
                    const heatNumber = heatBoard.dataset.heat;
                    // Assign to specific heat
                    assignMultipleParticipantsToHeat(draggedParticipantIds, heatNumber);
                } else {
                    // Assign to selected heat from dropdown
                    const selectedHeat = document.getElementById('heat_number').value;
                    if (selectedHeat) {
                        assignMultipleParticipantsToHeat(draggedParticipantIds, selectedHeat);
                    }
                }
            }
            
            // Cleanup
            if (ghost) {
                ghost.remove();
            }
            
            document.querySelectorAll('.sortable-tbody, #reorder-table tbody').forEach(zone => {
                zone.classList.remove('drag-over-touch');
            });
            
            // Reset all row opacities
            document.querySelectorAll('#participantsTable tbody .participant-row').forEach(r => {
                r.style.opacity = '1';
            });
            
            isDragEnabled = false;
            draggedParticipantIds = [];
            draggedParticipants = [];
        });
    });
    
    // Helper function to assign multiple participants
    function assignMultipleParticipantsToHeat(participantIds, heatNumber) {
        fetch('heat_management_api.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({
                action: 'assign_participants',
                event_id: <?= $selected_event ?>,
                participant_ids: participantIds,
                heat_number: heatNumber
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert('Error: ' + (data.message || 'Failed to assign participants'));
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Failed to assign participants');
        });
    }
    
    // Make reorder-table a drop target
    const reorderTable = document.querySelector('#reorder-table tbody');
    if (reorderTable) {
        reorderTable.addEventListener('dragover', function(e) {
            e.preventDefault();
            e.dataTransfer.dropEffect = 'copy';
            this.style.backgroundColor = '#e3f2fd';
        });
        
        reorderTable.addEventListener('dragleave', function(e) {
            this.style.backgroundColor = '';
        });
        
        reorderTable.addEventListener('drop', function(e) {
            e.preventDefault();
            this.style.backgroundColor = '';
            
            if (draggedParticipantIds.length > 0) {
                // Update participant count
                const count = draggedParticipants.length;
                document.getElementById('dragDropParticipantCount').textContent = count;
                document.getElementById('dragDropParticipantPlural').textContent = count === 1 ? '' : 's';
                
                // Populate modal with participant info
                const infoContainer = document.getElementById('dragDropParticipantInfo');
                infoContainer.innerHTML = '';
                
                draggedParticipants.forEach((participant, index) => {
                    const participantDiv = document.createElement('div');
                    participantDiv.className = 'mb-2 pb-2' + (index < draggedParticipants.length - 1 ? ' border-bottom' : '');
                    participantDiv.innerHTML = '<div class="fw-bold">' + participant.name + '</div>' +
                        '<small class="text-muted">BIB: ' + participant.bib + ' | ' + 
                        participant.category + ' | ' + participant.gender + ' | ' + participant.year + '</small>';
                    infoContainer.appendChild(participantDiv);
                });
                
                // Show modal
                const modal = new bootstrap.Modal(document.getElementById('dragDropHeatModal'));
                modal.show();
            }
        });
    }
    
    // Handle assignment button click
    document.getElementById('dragDropAssignBtn').addEventListener('click', function() {
        const heatNumber = document.getElementById('dragDropHeatSelect').value;
        const eventId = <?= json_encode($selected_event) ?>;
        
        if (!heatNumber) {
            showAlert('Please select a heat.', 'Selection Required', 'exclamation-triangle');
            return;
        }
        
        if (draggedParticipantIds.length === 0) {
            showAlert('No participants selected.', 'Selection Required', 'exclamation-triangle');
            return;
        }
        
        // Disable button during processing
        const btn = this;
        btn.disabled = true;
        btn.innerHTML = '<i class="fas fa-spinner fa-spin me-1"></i>Assigning...';
        
        // Assign all participants sequentially
        let assignedCount = 0;
        let errorCount = 0;
        
        const assignParticipant = (index) => {
            if (index >= draggedParticipantIds.length) {
                // All done
                btn.disabled = false;
                btn.innerHTML = '<i class="fas fa-user-plus me-1"></i>Assign to Heat';
                
                if (errorCount === 0) {
                    bootstrap.Modal.getInstance(document.getElementById('dragDropHeatModal')).hide();
                    showAlert(
                        'Successfully assigned ' + assignedCount + ' participant(s) to heat ' + heatNumber,
                        'Assignment Successful',
                        'check-circle'
                    );
                    setTimeout(() => location.reload(), 1500);
                } else {
                    showAlert(
                        'Assigned ' + assignedCount + ' participant(s). ' + errorCount + ' failed.',
                        'Partial Success',
                        'exclamation-triangle'
                    );
                    setTimeout(() => location.reload(), 1500);
                }
                return;
            }
            
            const participantId = draggedParticipantIds[index];
            
            fetch('heats_configure.php?event_id=' + eventId, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: 'participant_id=' + participantId + '&heat_number=' + heatNumber
            })
            .then(response => {
                if (response.ok) {
                    assignedCount++;
                } else {
                    errorCount++;
                }
                assignParticipant(index + 1);
            })
            .catch(error => {
                console.error('Error:', error);
                errorCount++;
                assignParticipant(index + 1);
            });
        };
        
        assignParticipant(0);
    });
    
    // Reset modal when closed
    document.getElementById('dragDropHeatModal').addEventListener('hidden.bs.modal', function() {
        document.getElementById('dragDropHeatSelect').value = '';
        draggedParticipantIds = [];
        draggedParticipants = [];
        
        // Clear all checkboxes
        document.querySelectorAll('#participantsTable tbody .participant-checkbox:checked').forEach(checkbox => {
            checkbox.checked = false;
        });
    });
});

</script>

<!-- Add this modal after the Move to Heat Modal -->
<div class="modal fade" id="promoteToHeatModal" tabindex="-1" aria-labelledby="promoteToHeatModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <form id="promoteToHeatForm">
        <div class="modal-header">
          <h5 class="modal-title" id="promoteToHeatModalLabel">Promote Participants to Heat</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <div class="mb-3">
            <label for="promote_target_heat" class="form-label">Target Heat</label>
            <select name="promote_target_heat" id="promote_target_heat" class="form-select" required>
              <option value="">-- Select Heat --</option>
              <?php foreach ($heat_options as $heat): ?>
                <option value="<?= $heat['heat_number'] ?>">
                  <?= $heat['heat_number'] ?><?= $heat['heat_name'] ? ' – ' . htmlspecialchars($heat['heat_name']) : '' ?>
                </option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="alert alert-warning">
            <small>
              Participants will be promoted to the selected heat based on promotion logic/results.
            </small>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-warning">Promote to Heat</button>
        </div>
      </form>
    </div>
  </div>
</div>
<!-- Move to Heat Modal -->
<div class="modal fade" id="moveToHeatModal" tabindex="-1" aria-labelledby="moveToHeatModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <form id="moveToHeatForm">
        <div class="modal-header">
          <h5 class="modal-title" id="moveToHeatModalLabel">Move/Copy Selected to Heat</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <div class="mb-3">
            <label for="target_heat_number" class="form-label">Target Heat</label>
            <select name="target_heat_number" id="target_heat_number" class="form-select" required>
              <option value="">-- Select Heat --</option>
              <?php foreach ($heat_options as $heat): ?>
                <option value="<?= $heat['heat_number'] ?>">
                  <?= $heat['heat_number'] ?><?= $heat['heat_name'] ? ' – ' . htmlspecialchars($heat['heat_name']) : '' ?>
                </option>
              <?php endforeach; ?>
            </select>
          </div>
          
          <div class="mb-3">
            <label class="form-label">Action</label>
            <div class="form-check">
              <input type="radio" name="action_type" id="action_move" value="move" class="form-check-input" checked>
              <label class="form-check-label" for="action_move">
                <strong>Move</strong> - Transfer participants to target heat (remove from current heat)
              </label>
            </div>
            <div class="form-check">
              <input type="radio" name="action_type" id="action_copy" value="copy" class="form-check-input">
              <label class="form-check-label" for="action_copy">
                <strong>Copy</strong> - Duplicate participants in target heat (keep in current heat)
              </label>
            </div>            
          </div>
          
          <div class="alert alert-info">
            <small id="actionDescription">Selected participants will be moved to the target heat.</small>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-primary" id="actionSubmitBtn">Move to Heat</button>
        </div>
      </form>
    </div>
  </div>
</div>
<script>
    jQuery('#promoteToHeatForm').on('submit', function (e) {
    e.preventDefault();

    const targetHeat = jQuery('#promote_target_heat').val();
    const eventId = <?= json_encode($selected_event) ?>;

    if (!targetHeat) {
        showAlert('Please select a target heat.', 'Selection Required', 'exclamation-triangle');
        return;
    }

    showConfirm(
        `Promote participants to Heat ${targetHeat}?`,
        function() {
            const $btn = jQuery('#promoteToHeatForm button[type="submit"]');
            $btn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin me-1"></i>Promoting...');

            jQuery.ajax({
                url: '../api/summary_table_api.php',
                method: 'GET',
                data: {
                    action: 'promote',
                    event_id: eventId,
                    target_heat: targetHeat
                },
                dataType: 'json',
                success: function (response) {
                    const icon = response.status === 'success' ? 'check-circle' : 'exclamation-circle';
                    const title = response.status === 'success' ? 'Success' : 'Error';
                    showAlert(response.message, title, icon);
                    if (response.status === 'success') {
                        setTimeout(() => location.reload(), 1500);
                    }
                },
                error: function (xhr) {
                    showAlert('AJAX error: ' + xhr.responseText, 'Error', 'exclamation-circle');
                },
                complete: function () {
                    $btn.prop('disabled', false).html('Promote to Heat');
                    jQuery('#promoteToHeatModal').modal('hide');
                }
            });
        },
        'Confirm Promotion',
        'question-circle'
    );
});</script>
<script>
// Update action description and button text based on selected radio
jQuery('input[name="action_type"]').on('change', function() {
    const actionType = jQuery(this).val();
    const description = jQuery('#actionDescription');
    const submitBtn = jQuery('#actionSubmitBtn');
    
    if (actionType === 'move') {
        description.text('Selected participants will be moved to the target heat.');
        submitBtn.text('Move to Heat');
        submitBtn.removeClass('btn-success').addClass('btn-primary');
    } else if (actionType === 'copy') {
        description.text('Selected participants will be copied to the target heat (originals remain).');
        submitBtn.text('Copy to Heat');
        submitBtn.removeClass('btn-primary').addClass('btn-success');
    } else if (actionType === 'promote') {
        description.text('Participants will be promoted to the target heat based on heat flow settings and results from the linked heat.');
        submitBtn.text('Promote to Heat');
        submitBtn.removeClass('btn-primary btn-success').addClass('btn-warning');
    }
});

jQuery('#moveToHeatForm').on('submit', function (e) {
    e.preventDefault();

    // Check both legacy table and new heat boards for selected checkboxes
    const legacySelected = jQuery('#reorder-table tbody tr:visible .bulk-check:checked')
        .map(function () {
            return jQuery(this).val();
        }).get();
    
    const heatBoardSelected = jQuery('.assignment-checkbox:checked')
        .map(function () {
            return jQuery(this).val();
        }).get();
    
    const selectedIds = [...legacySelected, ...heatBoardSelected];

    const targetHeat = jQuery('#target_heat_number').val();
    const actionType = jQuery('input[name="action_type"]:checked').val();
    const eventId = <?= json_encode($selected_event) ?>;

    if (!targetHeat) {
        showAlert('Please select a target heat.', 'Selection Required', 'exclamation-triangle');
        return;
    }
    if (actionType !== 'promote' && selectedIds.length === 0) {
        showAlert('Please select at least one participant.', 'Selection Required', 'exclamation-triangle');
        return;
    }

    if (!targetHeat || selectedIds.length === 0) {
        showAlert('Please select a target heat and at least one participant.', 'Selection Required', 'exclamation-triangle');
        return;
    }

    const actionText = actionType === 'move' ? 'move' : 'copy';
    const actionTitle = actionText.charAt(0).toUpperCase() + actionText.slice(1);
    
    showConfirm(
        `${actionTitle} ${selectedIds.length} selected participant(s) to Heat ${targetHeat}?`,
        function() {
            jQuery.ajax({
                url: 'ajax_move_to_heat.php',
                method: 'POST',
                data: {
                    event_participant_ids: selectedIds,
                    target_heat: targetHeat,
                    action_type: actionType,
                    event_id: eventId
                },
                dataType: 'json',
                success: function (response) {
                    if (response.status === 'success') {
                        showAlert(response.message, 'Success', 'check-circle');
                        jQuery('#moveToHeatModal').modal('hide');
                        setTimeout(() => location.reload(), 1500);
                    } else {
                        showAlert('Error: ' + response.message, 'Error', 'exclamation-circle');
                    }
                },
                error: function (xhr, status, error) {
                    showAlert('AJAX request failed: ' + error, 'Error', 'exclamation-circle');
                    console.error(xhr.responseText);
                }
            });
        },
        `Confirm ${actionTitle}`,
        'question-circle'
    );
});
</script>

<!-- New Two-Pane Layout JavaScript Functions -->
<script>
// Filter assignments in right pane
function filterAssignments() {
    const heatFilter = document.getElementById('filter_heat_assignments').value;
    const categoryFilter = document.getElementById('filter_category_assignments').value;
    const genderFilter = document.getElementById('filter_gender_assignments').value;
    
    const heatBoards = document.querySelectorAll('.heat-board');
    
    heatBoards.forEach(board => {
        const heatNum = board.dataset.heat;
        let showBoard = true;
        
        if (heatFilter && heatNum !== heatFilter) {
            showBoard = false;
        }
        
        const rows = board.querySelectorAll('.assignment-row');
        let visibleRowsInBoard = 0;
        
        rows.forEach(row => {
            const rowCategory = row.dataset.category;
            const rowGender = row.dataset.gender;
            
            let showRow = true;
            
            if (categoryFilter && rowCategory !== categoryFilter) {
                showRow = false;
            }
            if (genderFilter && rowGender !== genderFilter) {
                showRow = false;
            }
            
            row.style.display = showRow ? '' : 'none';
            if (showRow) visibleRowsInBoard++;
        });
        
        // Hide board if no visible rows
        if (visibleRowsInBoard === 0 && (categoryFilter || genderFilter)) {
            showBoard = false;
        }
        
        board.style.display = showBoard ? '' : 'none';
    });
}

// Clear assignment filters
function clearAssignmentFilters() {
    document.getElementById('filter_heat_assignments').value = '';
    document.getElementById('filter_category_assignments').value = '';
    document.getElementById('filter_gender_assignments').value = '';
    filterAssignments();
}

// Clear all participant filters and search
function clearAllFiltersAndSearch() {
    document.getElementById('filter_category').value = '';
    document.getElementById('filter_gender').value = '';
    document.getElementById('filter_club').value = '';
    document.getElementById('yearFilter').value = '';
    document.getElementById('search').value = '';
    
    // Reset custom year range
    customYearRange = null;
    document.getElementById('yearRangeBtn').style.display = 'none';
    
    filterParticipants();
}

// Scroll to specific heat
function scrollToHeat(heatNumber) {
    const heatElement = document.getElementById('heat-' + heatNumber);
    if (heatElement) {
        // CSS scroll-margin-top handles the offset for sticky header
        heatElement.scrollIntoView({ behavior: 'smooth', block: 'start' });
        
        // Highlight briefly
        heatElement.style.boxShadow = '0 0 20px rgba(13, 110, 253, 0.5)';
        setTimeout(() => {
            heatElement.style.boxShadow = '';
        }, 2000);
    }
}

// Toggle heat collapse
function toggleHeatCollapse(heatNumber) {
    const heatElement = document.getElementById('heat-' + heatNumber);
    const collapseDiv = heatElement.querySelector('.heat-collapse');
    const icon = heatElement.querySelector('.collapse-icon');
    
    if (collapseDiv.classList.contains('show')) {
        collapseDiv.classList.remove('show');
        icon.classList.remove('fa-chevron-down');
        icon.classList.add('fa-chevron-right');
    } else {
        collapseDiv.classList.add('show');
        icon.classList.remove('fa-chevron-right');
        icon.classList.add('fa-chevron-down');
    }
}

// Expand all heats
function expandAllHeats() {
    document.querySelectorAll('.heat-collapse').forEach(collapse => {
        collapse.classList.add('show');
    });
    document.querySelectorAll('.collapse-icon').forEach(icon => {
        icon.classList.remove('fa-chevron-right');
        icon.classList.add('fa-chevron-down');
    });
}

// Collapse all heats
function collapseAllHeats() {
    document.querySelectorAll('.heat-collapse').forEach(collapse => {
        collapse.classList.remove('show');
    });
    document.querySelectorAll('.collapse-icon').forEach(icon => {
        icon.classList.remove('fa-chevron-down');
        icon.classList.add('fa-chevron-right');
    });
}

// Remove single assignment
let pendingRemovalId = null;

function removeAssignment(assignmentId) {
    // Store the assignment ID
    pendingRemovalId = assignmentId;
    
    // Show Bootstrap modal
    const modal = new bootstrap.Modal(document.getElementById('removeAssignmentModal'));
    modal.show();
}

// Handle confirm button click
document.addEventListener('DOMContentLoaded', function() {
    const confirmBtn = document.getElementById('confirmRemoveBtn');
    if (confirmBtn) {
        confirmBtn.addEventListener('click', function() {
            if (pendingRemovalId) {
                executeRemoveAssignment(pendingRemovalId);
                
                // Hide the modal
                const modal = bootstrap.Modal.getInstance(document.getElementById('removeAssignmentModal'));
                if (modal) modal.hide();
                
                // Reset pending ID
                pendingRemovalId = null;
            }
        });
    }
});

function executeRemoveAssignment(assignmentId) {
    const eventId = <?= json_encode($selected_event) ?>;
    
    const formData = new FormData();
    formData.append('event_id', eventId);
    formData.append('action', 'delete_assignment');
    formData.append('assignment_id', assignmentId);
    
    fetch('heat_management_api.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.status === 'success') {
            location.reload();
        } else {
            alert('Error: ' + data.message);
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Failed to remove assignment');
    });
}

// Toggle table row selection
function toggleTableRowSelection(row) {
    const checkbox = row.querySelector('.participant-checkbox');
    if (checkbox) {
        checkbox.checked = !checkbox.checked;
        row.classList.toggle('selected-row', checkbox.checked);
        
        // Update selected participant IDs in hidden select
        updateSelectedParticipants();
    }
}

// Update hidden select with selected participant IDs
function updateSelectedParticipants() {
    const checkedBoxes = document.querySelectorAll('.participant-checkbox:checked');
    const select = document.getElementById('participantSelect');
    
    // Clear existing options
    select.innerHTML = '';
    
    // Add selected IDs as options
    checkedBoxes.forEach(checkbox => {
        const option = document.createElement('option');
        option.value = checkbox.value;
        option.selected = true;
        select.appendChild(option);
    });
    
    // Update selected count display
    const countElement = document.getElementById('selectedCount');
    if (countElement) {
        countElement.textContent = checkedBoxes.length;
    }
    
    // Update status badge
    const statusBadge = document.getElementById('participantStatusBadge');
    if (statusBadge) {
        statusBadge.textContent = checkedBoxes.length + ' selected';
    }
    
    // Show/hide bulk unassign button
    const bulkUnassignBtn = document.getElementById('bulkUnassignParticipantsBtn');
    if (bulkUnassignBtn) {
        if (checkedBoxes.length > 0) {
            // Check if any selected participants are assigned to heats
            let hasAssigned = false;
            checkedBoxes.forEach(checkbox => {
                const row = checkbox.closest('tr');
                if (row && row.dataset.assigned > 0) {
                    hasAssigned = true;
                }
            });
            bulkUnassignBtn.style.display = hasAssigned ? 'block' : 'none';
        } else {
            bulkUnassignBtn.style.display = 'none';
        }
    }
}

// Select all visible participants
function selectAllVisible() {
    const visibleRows = document.querySelectorAll('.participant-row[style=""]');
    visibleRows.forEach(row => {
        const checkbox = row.querySelector('.participant-checkbox');
        if (checkbox) {
            checkbox.checked = true;
            row.classList.add('selected-row');
        }
    });
    updateSelectedParticipants();
}

// Clear selection
function clearSelection() {
    document.querySelectorAll('.participant-checkbox').forEach(checkbox => {
        checkbox.checked = false;
    });
    document.querySelectorAll('.participant-row').forEach(row => {
        row.classList.remove('selected-row');
    });
    updateSelectedParticipants();
}

// ========================================
// Heat Board Action Functions (New Layout)
// ========================================

// Get all selected assignment rows from heat boards
function getSelectedAssignments() {
    return document.querySelectorAll('.assignment-row .assignment-checkbox:checked');
}

// Reverse selected assignments within their heats
function reverseSelectedAssignments() {
    const selected = getSelectedAssignments();
    
    if (selected.length < 2) {
        showAlert('Select at least 2 participants to reverse.', 'Selection Required', 'exclamation-triangle');
        return;
    }
    
    // Group by heat
    const byHeat = {};
    selected.forEach(checkbox => {
        const row = checkbox.closest('tr');
        const heat = row.dataset.heat;
        if (!byHeat[heat]) byHeat[heat] = [];
        byHeat[heat].push(row);
    });
    
    // Reverse each heat's selected rows
    Object.keys(byHeat).forEach(heat => {
        const rows = byHeat[heat];
        if (rows.length < 2) return;
        
        const tbody = rows[0].closest('tbody');
        
        // Get the position where first row currently is
        const allRows = Array.from(tbody.querySelectorAll('tr:not(.empty-heat-placeholder)'));
        const firstIndex = allRows.indexOf(rows[0]);
        const insertBeforeRow = allRows[firstIndex + rows.length]; // Row after the last selected
        
        // Reverse the array
        const reversed = rows.reverse();
        
        // Remove all selected rows
        rows.forEach(r => r.remove());
        
        // Insert reversed rows at the original position
        reversed.forEach(r => {
            tbody.insertBefore(r, insertBeforeRow || null);
        });
        
        // Save order for this heat
        saveHeatOrder(heat);
    });
    
    console.log('✅ Reversed selected assignments');
}

// Shuffle selected assignments
function shuffleSelectedAssignments() {
    const selected = getSelectedAssignments();
    
    if (selected.length < 2) {
        showAlert('Select at least 2 participants to shuffle.', 'Selection Required', 'exclamation-triangle');
        return;
    }
    
    // Group by heat
    const byHeat = {};
    selected.forEach(checkbox => {
        const row = checkbox.closest('tr');
        const heat = row.dataset.heat;
        if (!byHeat[heat]) byHeat[heat] = [];
        byHeat[heat].push(row);
    });
    
    // Shuffle each heat's selected rows
    Object.keys(byHeat).forEach(heat => {
        const rows = byHeat[heat];
        if (rows.length < 2) return;
        
        const tbody = rows[0].closest('tbody');
        
        // Get the position where first row currently is
        const allRows = Array.from(tbody.querySelectorAll('tr:not(.empty-heat-placeholder)'));
        const firstIndex = allRows.indexOf(rows[0]);
        const insertBeforeRow = allRows[firstIndex + rows.length]; // Row after the last selected
        
        // Fisher-Yates shuffle
        for (let i = rows.length - 1; i > 0; i--) {
            const j = Math.floor(Math.random() * (i + 1));
            [rows[i], rows[j]] = [rows[j], rows[i]];
        }
        
        // Remove all selected rows
        rows.forEach(r => r.remove());
        
        // Insert shuffled rows at the original position
        rows.forEach(r => {
            tbody.insertBefore(r, insertBeforeRow || null);
        });
        
        // Visual feedback
        rows.forEach(r => {
            r.style.backgroundColor = '#fff3cd';
            setTimeout(() => { r.style.backgroundColor = ''; }, 600);
        });
        
        // Save order for this heat
        saveHeatOrder(heat);
    });
    
    console.log('✅ Shuffled selected assignments');
}

// Sort selected assignments by name
function sortSelectedByName() {
    const selected = getSelectedAssignments();
    
    if (selected.length < 2) {
        showAlert('Select at least 2 participants to sort.', 'Selection Required', 'exclamation-triangle');
        return;
    }
    
    // Group by heat
    const byHeat = {};
    selected.forEach(checkbox => {
        const row = checkbox.closest('tr');
        const heat = row.dataset.heat;
        if (!byHeat[heat]) byHeat[heat] = [];
        byHeat[heat].push(row);
    });
    
    // Sort each heat's selected rows
    Object.keys(byHeat).forEach(heat => {
        const rows = byHeat[heat];
        if (rows.length < 2) return;
        
        const tbody = rows[0].closest('tbody');
        
        // Get the position where first row currently is
        const allRows = Array.from(tbody.querySelectorAll('tr:not(.empty-heat-placeholder)'));
        const firstIndex = allRows.indexOf(rows[0]);
        const insertBeforeRow = allRows[firstIndex + rows.length]; // Row after the last selected
        
        // Sort by name (from td)
        rows.sort((a, b) => {
            const nameA = a.querySelector('td:nth-child(3) .fw-bold').textContent.toLowerCase();
            const nameB = b.querySelector('td:nth-child(3) .fw-bold').textContent.toLowerCase();
            return nameA.localeCompare(nameB);
        });
        
        // Remove and re-insert
        rows.forEach(r => r.remove());
        rows.forEach(r => {
            tbody.insertBefore(r, insertBeforeRow || null);
        });
        
        saveHeatOrder(heat);
    });
    
    console.log('✅ Sorted selected by name');
}

// Sort selected assignments by BIB
function sortSelectedByBib() {
    const selected = getSelectedAssignments();
    
    if (selected.length < 2) {
        showAlert('Select at least 2 participants to sort.', 'Selection Required', 'exclamation-triangle');
        return;
    }
    
    // Group by heat
    const byHeat = {};
    selected.forEach(checkbox => {
        const row = checkbox.closest('tr');
        const heat = row.dataset.heat;
        if (!byHeat[heat]) byHeat[heat] = [];
        byHeat[heat].push(row);
    });
    
    // Sort each heat's selected rows
    Object.keys(byHeat).forEach(heat => {
        const rows = byHeat[heat];
        if (rows.length < 2) return;
        
        const tbody = rows[0].closest('tbody');
        
        // Get the position where first row currently is
        const allRows = Array.from(tbody.querySelectorAll('tr:not(.empty-heat-placeholder)'));
        const firstIndex = allRows.indexOf(rows[0]);
        const insertBeforeRow = allRows[firstIndex + rows.length]; // Row after the last selected
        
        // Sort by BIB (from badge)
        rows.sort((a, b) => {
            const bibA = parseInt(a.querySelector('td:nth-child(2) .badge').textContent, 10);
            const bibB = parseInt(b.querySelector('td:nth-child(2) .badge').textContent, 10);
            return bibA - bibB;
        });
        
        // Remove and re-insert
        rows.forEach(r => r.remove());
        rows.forEach(r => {
            tbody.insertBefore(r, insertBeforeRow || null);
        });
        
        saveHeatOrder(heat);
    });
    
    console.log('✅ Sorted selected by BIB');
}

// Sort selected assignments by year
function sortSelectedByYear() {
    const selected = getSelectedAssignments();
    
    if (selected.length < 2) {
        showAlert('Select at least 2 participants to sort.', 'Selection Required', 'exclamation-triangle');
        return;
    }
    
    // Group by heat
    const byHeat = {};
    selected.forEach(checkbox => {
        const row = checkbox.closest('tr');
        const heat = row.dataset.heat;
        if (!byHeat[heat]) byHeat[heat] = [];
        byHeat[heat].push(row);
    });
    
    // Sort each heat's selected rows
    Object.keys(byHeat).forEach(heat => {
        const rows = byHeat[heat];
        if (rows.length < 2) return;
        
        const tbody = rows[0].closest('tbody');
        
        // Get the position where first row currently is
        const allRows = Array.from(tbody.querySelectorAll('tr:not(.empty-heat-placeholder)'));
        const firstIndex = allRows.indexOf(rows[0]);
        const insertBeforeRow = allRows[firstIndex + rows.length]; // Row after the last selected
        
        // Sort by year
        rows.sort((a, b) => {
            const yearA = parseInt(a.dataset.year || '0', 10);
            const yearB = parseInt(b.dataset.year || '0', 10);
            return yearA - yearB;
        });
        
        // Remove and re-insert
        rows.forEach(r => r.remove());
        rows.forEach(r => {
            tbody.insertBefore(r, insertBeforeRow || null);
        });
        
        saveHeatOrder(heat);
    });
    
    console.log('✅ Sorted selected by year');
}

// Sort selected assignments by gender
function sortSelectedByGender() {
    const selected = getSelectedAssignments();
    
    if (selected.length < 2) {
        showAlert('Select at least 2 participants to sort.', 'Selection Required', 'exclamation-triangle');
        return;
    }
    
    // Group by heat
    const byHeat = {};
    selected.forEach(checkbox => {
        const row = checkbox.closest('tr');
        const heat = row.dataset.heat;
        if (!byHeat[heat]) byHeat[heat] = [];
        byHeat[heat].push(row);
    });
    
    // Sort each heat's selected rows
    Object.keys(byHeat).forEach(heat => {
        const rows = byHeat[heat];
        if (rows.length < 2) return;
        
        const tbody = rows[0].closest('tbody');
        
        // Get the position where first row currently is
        const allRows = Array.from(tbody.querySelectorAll('tr:not(.empty-heat-placeholder)'));
        const firstIndex = allRows.indexOf(rows[0]);
        const insertBeforeRow = allRows[firstIndex + rows.length]; // Row after the last selected
        
        // Sort by gender (M before F, or alphabetically)
        rows.sort((a, b) => {
            const genderA = a.dataset.gender || '';
            const genderB = b.dataset.gender || '';
            return genderA.localeCompare(genderB);
        });
        
        // Remove and re-insert
        rows.forEach(r => r.remove());
        rows.forEach(r => {
            tbody.insertBefore(r, insertBeforeRow || null);
        });
        
        saveHeatOrder(heat);
    });
    
    console.log('✅ Sorted selected by gender');
}

// Initialize SortableJS for heat boards
document.addEventListener('DOMContentLoaded', function() {
    // Make participant table rows draggable to heats (supports multi-select)
    const participantTable = document.querySelector('#participantsTable tbody');
    if (participantTable) {
        console.log('✅ Initializing SortableJS for #participantsTable tbody', participantTable);
        new Sortable(participantTable, {
            group: {
                name: 'participants',
                pull: 'clone',
                put: false
            },
            sort: false,
            animation: 150,
            draggable: '.participant-row',
            ghostClass: 'sortable-ghost',
            dragClass: 'sortable-drag',
            chosenClass: 'sortable-chosen',
            multiDrag: true,
            selectedClass: 'selected-row',
            fallbackTolerance: 3,
            delay: 1000,
            delayOnTouchOnly: true,
            onStart: function(evt) {
                const selectedItems = evt.items || [evt.item];
                console.log('🚀 Drag started from participant table', {
                    item: evt.item,
                    items: evt.items,
                    selectedCount: selectedItems.length,
                    hasMultiDrag: evt.items && evt.items.length > 1,
                    from: evt.from,
                    dataId: evt.item.dataset.id
                });
            },
            onEnd: function(evt) {
                const selectedItems = evt.items || [evt.item];
                console.log('🏁 Drag ended from participant table', {
                    from: evt.from.id || evt.from.className,
                    to: evt.to.dataset?.heat || evt.to.className,
                    droppedCount: selectedItems.length
                });
                // Remove the cloned elements from participant table
                if (evt.item) evt.item.remove();
                if (evt.items) {
                    evt.items.forEach(item => item.remove());
                }
            }
        });
        console.log('✅ SortableJS initialized for participant table');
    } else {
        console.error('❌ Could not find #participantsTable tbody');
    }
    
    // Make each heat's tbody sortable and accept participants from left pane
    const heatBodies = document.querySelectorAll('.sortable-tbody');
    console.log(`✅ Found ${heatBodies.length} heat boards to initialize`);
    
    heatBodies.forEach((tbody, index) => {
        console.log(`   Initializing heat board #${index + 1}:`, {
            heatNumber: tbody.dataset.heat,
            hasPlaceholder: tbody.querySelector('.empty-heat-placeholder') !== null,
            rowCount: tbody.querySelectorAll('tr').length
        });
        
        new Sortable(tbody, {
            group: {
                name: 'heat-assignments',
                pull: true,
                put: ['heat-assignments', 'participants']
            },
            animation: 150,
            draggable: 'tr:not(.empty-heat-placeholder)',
            filter: '.empty-heat-placeholder',
            ghostClass: 'sortable-ghost',
            dragClass: 'sortable-drag',
            chosenClass: 'sortable-chosen',
            multiDrag: true,
            selectedClass: 'selected-row',
            fallbackTolerance: 3,
            delay: 1000,
            delayOnTouchOnly: true,
            emptyInsertThreshold: 100, // Increased threshold to detect empty tbody better
            forceFallback: false,
            removeCloneOnHide: true,
            
            onStart: function(evt) {
                // Manual multi-drag: collect assignment IDs of selected rows (not DOM elements)
                const selectedRows = Array.from(evt.from.querySelectorAll('tr.selected-row'));
                const selectedIds = selectedRows.map(r => r.dataset.assignmentId).filter(Boolean);
                
                // Store IDs and source heat - not DOM elements which may become stale
                evt._customSelectedIds = selectedIds;
                evt._customSourceHeat = evt.from.dataset.heat;
                evt.item._customSelectedIds = selectedIds;
                evt.item._customSourceHeat = evt.from.dataset.heat;
                
                console.log('🚀 Drag started in heat board:', {
                    heat: evt.from.dataset.heat,
                    draggedItem: evt.item,
                    draggedItemHasClass: evt.item.classList.contains('selected-row'),
                    selectedCount: selectedRows.length,
                    selectedIds: selectedIds,
                    selectedRowsDetails: selectedRows.map(r => ({
                        id: r.dataset.assignmentId,
                        hasClass: r.classList.contains('selected-row'),
                        checkboxChecked: r.querySelector('.assignment-checkbox')?.checked
                    })),
                    hasMultiSelection: selectedIds.length > 1
                });
            },
            
            onAdd: function(evt) {
                const toHeat = evt.to.dataset.heat;
                const tbody = evt.to;
                
                console.log('➕ onAdd triggered:', {
                    toHeat,
                    item: evt.item,
                    items: evt.items,
                    itemId: evt.item?.dataset?.id,
                    assignmentId: evt.item?.dataset?.assignmentId
                });
                
                // Remove empty placeholder if it exists
                const placeholder = tbody.querySelector('.empty-heat-placeholder');
                if (placeholder) {
                    console.log('   Removing placeholder from heat', toHeat);
                    placeholder.remove();
                }
                
                // Handle multiple participants dropped
                if (evt.items && evt.items.length > 0) {
                    const participantIds = evt.items
                        .filter(item => item.dataset.id && !item.dataset.assignmentId)
                        .map(item => item.dataset.id);
                    
                    console.log('   Multi-drop detected:', participantIds);
                    
                    if (participantIds.length > 0) {
                        assignMultipleParticipantsToHeat(participantIds, toHeat);
                        // Remove dropped items
                        evt.items.forEach(item => item.remove());
                    }
                } 
                // Handle single participant dropped
                else if (evt.item) {
                    const participantId = evt.item.dataset.id;
                    const assignmentId = evt.item.dataset.assignmentId;
                    
                    console.log('   Single drop detected:', { participantId, assignmentId });
                    
                    if (participantId && !assignmentId) {
                        assignParticipantToHeat(participantId, toHeat, evt.item);
                    }
                }
            },
            onEnd: function(evt) {
                const fromHeat = evt.from.dataset.heat;
                const toHeat = evt.to.dataset.heat;
                
                // Retrieve selected IDs from storage
                const selectedIds = evt._customSelectedIds || evt.item._customSelectedIds || [];
                const sourceHeat = evt._customSourceHeat || evt.item._customSourceHeat;
                const hasMultiSelection = selectedIds.length > 1;
                
                console.log('🏁 Drag ended in heat board:', {
                    fromHeat,
                    toHeat,
                    sourceHeat,
                    item: evt.item,
                    selectedIds: selectedIds,
                    selectedCount: selectedIds.length,
                    hasMultiSelection: hasMultiSelection
                });
                
                // Handle multiple selected items
                if (hasMultiSelection && sourceHeat && toHeat && sourceHeat !== toHeat) {
                    console.log(`   Processing ${selectedIds.length} selected rows for heat transfer`);
                    
                    // Query fresh DOM elements from SOURCE heat based on IDs
                    const sourceHeatBody = document.querySelector(`tbody[data-heat="${sourceHeat}"]`);
                    if (!sourceHeatBody) {
                        console.error('   Source heat body not found:', sourceHeat);
                        return;
                    }
                    
                    // Move all selected rows to the target heat
                    const targetRow = evt.item;
                    const targetIndex = Array.from(evt.to.children).indexOf(targetRow);
                    
                    selectedIds.forEach((assignmentId, index) => {
                        if (assignmentId == evt.item.dataset.assignmentId) {
                            return; // Skip the dragged item, it's already moved
                        }
                        
                        // Find the row with this assignment ID in the SOURCE heat
                        const row = sourceHeatBody.querySelector(`tr[data-assignment-id="${assignmentId}"]`);
                        if (!row) {
                            console.warn(`   Row not found for assignment ${assignmentId}`);
                            return;
                        }
                        
                        console.log(`   Moving row ${index + 1}:`, { assignmentId });
                        
                        // Update the assignment
                        updateAssignmentHeat(assignmentId, toHeat, sourceHeat);
                        
                        // Move the row in DOM
                        const clonedRow = row.cloneNode(true);
                        if (targetIndex >= 0 && evt.to.children[targetIndex + index + 1]) {
                            evt.to.insertBefore(clonedRow, evt.to.children[targetIndex + index + 1]);
                        } else {
                            evt.to.appendChild(clonedRow);
                        }
                        
                        // Remove from original location
                        row.remove();
                        
                        // Uncheck the checkbox in the new location
                        const checkbox = clonedRow.querySelector('.assignment-checkbox');
                        if (checkbox) {
                            checkbox.checked = false;
                            clonedRow.classList.remove('selected-row');
                        }
                    });
                    
                    // Uncheck the dragged item's checkbox
                    const draggedCheckbox = evt.item.querySelector('.assignment-checkbox');
                    if (draggedCheckbox) {
                        draggedCheckbox.checked = false;
                        evt.item.classList.remove('selected-row');
                    }
                    
                    if (toHeat) saveHeatOrder(toHeat);
                    if (fromHeat) saveHeatOrder(fromHeat);
                }
                // Handle multiple items moved between heats (if evt.items is available)
                else if (evt.items && evt.items.length > 0) {
                    console.log(`   Processing ${evt.items.length} items in multi-drag`);
                    evt.items.forEach((item, index) => {
                        const assignmentId = item.dataset.assignmentId;
                        console.log(`   Item ${index + 1}:`, { assignmentId, fromHeat, toHeat });
                        if (assignmentId && fromHeat && toHeat && fromHeat !== toHeat) {
                            updateAssignmentHeat(assignmentId, toHeat, fromHeat);
                        }
                    });
                    
                    if (toHeat) saveHeatOrder(toHeat);
                    if (fromHeat && fromHeat !== toHeat) saveHeatOrder(fromHeat);
                }
                // Handle single item moved
                else if (evt.item) {
                    const assignmentId = evt.item.dataset.assignmentId;
                    
                    if (assignmentId && fromHeat && toHeat && fromHeat !== toHeat) {
                        updateAssignmentHeat(assignmentId, toHeat, fromHeat);
                    }
                    
                    // Save order for both heats if they're different
                    if (toHeat) {
                        saveHeatOrder(toHeat);
                    }
                    if (fromHeat && fromHeat !== toHeat) {
                        saveHeatOrder(fromHeat);
                    }
                }
            }
        });
    });
    
    // Initialize heat-check-all checkboxes
    document.querySelectorAll('.heat-check-all').forEach(checkbox => {
        console.log('📋 Registering heat-check-all for heat:', checkbox.dataset.heat);
        
        checkbox.addEventListener('change', function() {
            const heatNumber = this.dataset.heat;
            const isChecked = this.checked;
            const tbody = document.querySelector('.sortable-tbody[data-heat="' + heatNumber + '"]');
            
            console.log('🔲 Heat-check-all clicked:', {
                heat: heatNumber,
                isChecked: isChecked,
                tbody: tbody ? 'found' : 'not found'
            });
            
            if (tbody) {
                let visibleCount = 0;
                let selectedCount = 0;
                
                tbody.querySelectorAll('.assignment-checkbox').forEach(cb => {
                    const row = cb.closest('tr');
                    // Only select/deselect visible rows (not filtered out)
                    // Check if row is visible using multiple methods
                    const isVisible = row && 
                                     row.style.display !== 'none' && 
                                     row.offsetParent !== null &&
                                     window.getComputedStyle(row).display !== 'none';
                    
                    if (isVisible) {
                        visibleCount++;
                        cb.checked = isChecked;
                        // Toggle selected-row class for multi-drag
                        if (isChecked) {
                            row.classList.add('selected-row');
                            selectedCount++;
                            console.log('   ✓ Added selected-row to:', row.dataset.assignmentId);
                        } else {
                            row.classList.remove('selected-row');
                        }
                    }
                });
                
                console.log('   Result:', {
                    visibleRows: visibleCount,
                    selectedRows: selectedCount,
                    selectedRowsWithClass: tbody.querySelectorAll('tr.selected-row').length,
                    allSelectedRows: Array.from(tbody.querySelectorAll('tr.selected-row')).map(r => r.dataset.assignmentId)
                });
            }
        });
    });
    
    // Initialize assignment checkbox handlers for multi-select drag
    document.addEventListener('change', function(e) {
        if (e.target.classList.contains('assignment-checkbox')) {
            const row = e.target.closest('tr');
            if (row) {
                if (e.target.checked) {
                    row.classList.add('selected-row');
                } else {
                    row.classList.remove('selected-row');
                }
            }
            
            // Update heat-check-all state
            const tbody = e.target.closest('tbody');
            if (tbody) {
                const heatNumber = tbody.dataset.heat;
                const heatCheckAll = document.querySelector('.heat-check-all[data-heat="' + heatNumber + '"]');
                
                // Only count visible checkboxes (not filtered out)
                const allCheckboxes = Array.from(tbody.querySelectorAll('.assignment-checkbox')).filter(cb => {
                    const row = cb.closest('tr');
                    return row && 
                           row.style.display !== 'none' && 
                           row.offsetParent !== null &&
                           window.getComputedStyle(row).display !== 'none';
                });
                const checkedCheckboxes = allCheckboxes.filter(cb => cb.checked);
                
                if (heatCheckAll) {
                    if (allCheckboxes.length === 0) {
                        heatCheckAll.checked = false;
                        heatCheckAll.indeterminate = false;
                    } else if (checkedCheckboxes.length === 0) {
                        heatCheckAll.checked = false;
                        heatCheckAll.indeterminate = false;
                    } else if (checkedCheckboxes.length === allCheckboxes.length) {
                        heatCheckAll.checked = true;
                        heatCheckAll.indeterminate = false;
                    } else {
                        heatCheckAll.checked = false;
                        heatCheckAll.indeterminate = true;
                    }
                }
            }
        }
    });
    
    // Allow clicking on assignment rows to toggle selection
    document.addEventListener('click', function(e) {
        const row = e.target.closest('tr.assignment-row');
        if (row && !e.target.closest('button') && !e.target.closest('input[type="checkbox"]')) {
            const checkbox = row.querySelector('.assignment-checkbox');
            if (checkbox) {
                checkbox.checked = !checkbox.checked;
                // Trigger change event
                checkbox.dispatchEvent(new Event('change', { bubbles: true }));
            }
        }
    });
    
    // Initialize AJAX assign button
    const assignBtn = document.getElementById('ajaxAssignBtn');
    if (assignBtn) {
        assignBtn.addEventListener('click', function() {
            const form = document.getElementById('ajaxAssignForm');
            const heatNumber = document.getElementById('heat_number').value;
            const selectedParticipants = Array.from(document.querySelectorAll('.participant-checkbox:checked'))
                .map(cb => cb.value);
            
            if (!heatNumber) {
                alert('Please select a heat');
                return;
            }
            
            if (selectedParticipants.length === 0) {
                alert('Please select at least one participant');
                return;
            }
            
            // Update hidden select
            const select = document.getElementById('participantSelect');
            select.innerHTML = '';
            selectedParticipants.forEach(id => {
                const option = document.createElement('option');
                option.value = id;
                option.selected = true;
                select.appendChild(option);
            });
            
            // Submit form
            form.submit();
        });
    }
    
    // ========================================
    // Wire up action buttons for heat boards
    // ========================================
    
    // Reverse selected
    document.getElementById('reverseSelectedBtn')?.addEventListener('click', reverseSelectedAssignments);
    
    // Shuffle selected
    document.getElementById('shuffleSelectedBtn')?.addEventListener('click', shuffleSelectedAssignments);
    
    // Sort by name
    document.getElementById('sortByNameBtn')?.addEventListener('click', sortSelectedByName);
    
    // Sort by BIB
    document.getElementById('sortByBibBtn')?.addEventListener('click', sortSelectedByBib);
    
    // Sort by year
    document.getElementById('sortByYearBtn')?.addEventListener('click', sortSelectedByYear);
    
    // Sort by gender
    document.getElementById('sortByGenderBtn')?.addEventListener('click', sortSelectedByGender);
    
    console.log('✅ Action buttons initialized for heat boards');
});

// Assign participant from left pane to heat via drag-drop
function assignParticipantToHeat(participantId, heatNumber, droppedRow) {
    const eventId = <?= json_encode($selected_event) ?>;
    
    const formData = new FormData();
    formData.append('event_id', eventId);
    formData.append('heat_number', heatNumber);
    formData.append('participant_ids[]', participantId);
    formData.append('assign_participants', '1');
    
    fetch('heats_configure.php?event_id=' + eventId, {
        method: 'POST',
        body: formData
    })
    .then(response => {
        if (response.ok) {
            console.log('Participant assigned to heat ' + heatNumber);
            // Reload to show updated data
            location.reload();
        } else {
            console.error('Failed to assign participant');
            alert('Failed to assign participant to heat');
            // Remove the dropped row
            droppedRow.remove();
        }
    })
    .catch(error => {
        console.error('Error assigning participant:', error);
        alert('Error assigning participant. The page will reload.');
        location.reload();
    });
}

// Assign multiple participants from left pane to heat via drag-drop
function assignMultipleParticipantsToHeat(participantIds, heatNumber) {
    const eventId = <?= json_encode($selected_event) ?>;
    
    console.log('Assigning multiple participants:', participantIds, 'to heat', heatNumber);
    
    const formData = new FormData();
    formData.append('event_id', eventId);
    formData.append('heat_number', heatNumber);
    
    // Add each participant ID as an array element
    participantIds.forEach(id => {
        formData.append('participant_ids[]', id);
    });
    formData.append('assign_participants', '1');
    
    fetch('heats_configure.php?event_id=' + eventId, {
        method: 'POST',
        body: formData
    })
    .then(response => {
        if (response.ok) {
            console.log(participantIds.length + ' participants assigned to heat ' + heatNumber);
            // Reload to show updated data
            location.reload();
        } else {
            console.error('Failed to assign participants');
            alert('Failed to assign participants to heat');
            location.reload();
        }
    })
    .catch(error => {
        console.error('Error assigning participants:', error);
        alert('Error assigning participants. The page will reload.');
        location.reload();
    });
}

// Update assignment heat when dragged to different heat
function updateAssignmentHeat(assignmentId, newHeat, oldHeat) {
    const eventId = <?= json_encode($selected_event) ?>;
    
    const formData = new FormData();
    formData.append('event_id', eventId);
    formData.append('action', 'update_heat');
    formData.append('assignment_id', assignmentId);
    formData.append('new_heat', newHeat);
    formData.append('old_heat', oldHeat);
    
    fetch('heat_management_api.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.status === 'success') {
            console.log('Assignment moved to heat ' + newHeat);
            // Update the visual heat badge in the row
            const row = document.querySelector('tr[data-assignment-id="' + assignmentId + '"]');
            if (row) {
                row.dataset.heat = newHeat;
            }
        } else {
            console.error('Failed to update heat:', data.message);
            alert('Failed to move participant: ' + data.message);
            // Reload to revert the UI change
            location.reload();
        }
    })
    .catch(error => {
        console.error('Error updating heat:', error);
        alert('Error moving participant. The page will reload.');
        location.reload();
    });
}

// Save heat order after drag-drop
function saveHeatOrder(heatNumber) {
    const eventId = <?= json_encode($selected_event) ?>;
    const tbody = document.querySelector('.sortable-tbody[data-heat="' + heatNumber + '"]');
    if (!tbody) {
        console.error('Heat tbody not found for heat ' + heatNumber);
        return;
    }
    
    const rows = tbody.querySelectorAll('tr[data-assignment-id]');
    const order = Array.from(rows).map(row => row.dataset.assignmentId);
    
    if (order.length === 0) {
        console.log('No participants to order in heat ' + heatNumber);
        return;
    }
    
    const formData = new FormData();
    formData.append('event_id', eventId);
    formData.append('action', 'update_order');
    formData.append('heat_number', heatNumber);
    formData.append('order', JSON.stringify(order));
    
    fetch('heat_management_api.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.status === 'success') {
            console.log('Heat ' + heatNumber + ' order saved (' + order.length + ' participants)');
        } else {
            console.error('Failed to save order:', data.message);
        }
    })
    .catch(error => {
        console.error('Error saving order:', error);
    });
}
</script>

        <!-- Remove Assignment Confirmation Modal -->
        <div class="modal fade" id="removeAssignmentModal" tabindex="-1" aria-labelledby="removeAssignmentLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header bg-danger text-white">
                        <h5 class="modal-title" id="removeAssignmentLabel">
                            <i class="fas fa-exclamation-triangle me-2"></i>Confirm Removal
                        </h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p class="mb-0">Are you sure you want to remove this participant from the heat?</p>
                        <p class="text-muted small mb-0 mt-2">
                            <i class="fas fa-info-circle me-1"></i>
                            The participant will remain in the event but will be moved back to the available pool.
                        </p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            <i class="fas fa-times me-1"></i>Cancel
                        </button>
                        <button type="button" class="btn btn-danger" id="confirmRemoveBtn">
                            <i class="fas fa-trash me-1"></i>Remove
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Help Modal for Configure Heats -->
        <div class="modal fade" id="heatsConfigureHelpModal" tabindex="-1" aria-labelledby="heatsConfigureHelpLabel" aria-hidden="true">
            <div class="modal-dialog modal-xl modal-dialog-scrollable">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="heatsConfigureHelpLabel"><i class="fas fa-question-circle me-2"></i>Configure Heats — Help</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body p-0" style="height:70vh;">
                        <iframe id="heatsConfigureHelpFrame" src="../help/heats_configure_help.html" style="border:0;width:100%;height:100%;"></iframe>
                    </div>
                </div>
            </div>
        </div>

        <!-- Heat Configuration Modals Container -->
        <div id="heatConfigModalsContainer">
            <div class="text-center text-muted p-3">
                <i class="fas fa-spinner fa-spin"></i> Loading heat configuration modals...
            </div>
        </div>

        <script>
            // Load heat configuration modals via API
            async function loadHeatConfigModals() {
                try {
                    console.log('Loading heat configuration modals...');
                    const response = await fetch('heat_config_modals_api.php?event_id=<?= $selected_event ?>&heat_numbers=all');
                    console.log('Response status:', response.status);
                    
                    if (!response.ok) {
                        throw new Error('HTTP error! status: ' + response.status);
                    }
                    const data = await response.json();
                    console.log('API Response:', data);
                    
                    if (!data.success) {
                        throw new Error(data.error || 'Failed to load modals');
                    }
                    
                    document.getElementById('heatConfigModalsContainer').innerHTML = data.html;
                    console.log('Heat configuration modals loaded successfully for heats:', data.heat_numbers);
                    
                    // Verify modals are in the DOM
                    data.heat_numbers.forEach(heatNum => {
                        const modalId = 'heatConfigModal_' + heatNum;
                        const modalEl = document.getElementById(modalId);
                        console.log('Checking modal', modalId, ':', modalEl ? 'Found' : 'NOT FOUND');
                    });
                } catch (error) {
                    console.error('Error loading heat configuration modals:', error);
                    document.getElementById('heatConfigModalsContainer').innerHTML = 
                        '<div class="alert alert-danger m-3">Failed to load heat configuration modals: ' + error.message + '</div>';
                }
            }

            // Open heat configuration modal
            function openHeatConfigModal(heatNumber) {
                const modalId = 'heatModal' + heatNumber;
                console.log('Attempting to open modal:', modalId);
                const modalEl = document.getElementById(modalId);
                console.log('Modal element:', modalEl);
                
                if (!modalEl) {
                    console.error('Heat configuration modal not found for heat:', heatNumber);
                    console.log('Available modals:', Array.from(document.querySelectorAll('[id^="heatModal"]')).map(m => m.id));
                    showAlert('Heat configuration modal not loaded. Please refresh the page.', 'Error', 'exclamation-triangle');
                    return;
                }
                
                const modal = new bootstrap.Modal(modalEl);
                modal.show();
            }

            // Toggle all categories checkbox in modal
            function toggleAllCategoriesModal(heatNumber) {
                const allCheckbox = document.getElementById(`all_categories_modal_${heatNumber}`);
                const categoryCheckboxes = document.querySelectorAll(`input[data-heat="${heatNumber}"].category-checkbox`);
                
                if (allCheckbox.checked) {
                    categoryCheckboxes.forEach(checkbox => {
                        checkbox.checked = false;
                        checkbox.disabled = true;
                    });
                } else {
                    categoryCheckboxes.forEach(checkbox => {
                        checkbox.disabled = false;
                    });
                }
            }

            // Update category selection in modal
            function updateCategorySelectionModal(heatNumber) {
                const allCheckbox = document.getElementById(`all_categories_modal_${heatNumber}`);
                const categoryCheckboxes = document.querySelectorAll(`input[data-heat="${heatNumber}"].category-checkbox:checked`);
                
                if (categoryCheckboxes.length > 0) {
                    allCheckbox.checked = false;
                }
            }

            // Load modals when page is ready
            document.addEventListener('DOMContentLoaded', function() {
                loadHeatConfigModals();
            });
        </script>

        <script>
            function openHeatsConfigureHelp(){
                var frame = document.getElementById('heatsConfigureHelpFrame');
                if(frame && !frame.src){
                    frame.src = '../help/heats_configure_help.html';
                }
                var modalEl = document.getElementById('heatsConfigureHelpModal');
                if(window.bootstrap && modalEl){
                    var modal = bootstrap.Modal.getOrCreateInstance(modalEl);
                    modal.show();
                } else if (modalEl){
                    // Fallback for older Bootstrap bindings
                    try { jQuery(modalEl).modal('show'); } catch(e) {}
                }
            }
        </script>

        <!-- Generic Alert Modal -->
        <div class="modal fade" id="genericAlertModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="genericAlertTitle">
                            <i class="fas fa-info-circle me-2"></i>Notice
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body" id="genericAlertMessage">
                        <!-- Message will be inserted here -->
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-primary" data-bs-dismiss="modal">OK</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Generic Confirm Modal -->
        <div class="modal fade" id="genericConfirmModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="genericConfirmTitle">
                            <i class="fas fa-question-circle me-2"></i>Confirm
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body" id="genericConfirmMessage">
                        <!-- Message will be inserted here -->
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="button" class="btn btn-primary" id="genericConfirmBtn">Confirm</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Year Range Modal -->
        <div class="modal fade" id="yearRangeModal" tabindex="-1">
            <div class="modal-dialog modal-sm">
                <div class="modal-content">
                    <div class="modal-header">
                        <h6 class="modal-title">
                            <i class="fas fa-calendar-alt me-2"></i>Custom Year Range
                        </h6>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label small fw-bold">From Year</label>
                            <input type="number" class="form-control" id="yearRangeFrom" min="1900" max="2100" placeholder="e.g., 2005">
                        </div>
                        <div class="mb-3">
                            <label class="form-label small fw-bold">To Year</label>
                            <input type="number" class="form-control" id="yearRangeTo" min="1900" max="2100" placeholder="e.g., 2007">
                        </div>
                        <div class="alert alert-info small mb-0">
                            <i class="fas fa-info-circle me-1"></i>Filter participants born between these years (inclusive)
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Cancel</button>
                        <button type="button" class="btn btn-primary btn-sm" onclick="applyYearRange()">
                            <i class="fas fa-filter me-1"></i>Apply Range
                        </button>
                    </div>
                </div>
            </div>
        </div>

        </div>
    </div>

    <script>
        // Year Range Filter Variables
        let customYearRange = null;
        
        // Handle year filter change
        function handleYearFilterChange() {
            const select = document.getElementById('yearFilter');
            const value = select.value;
            const editBtn = document.getElementById('yearRangeBtn');
            
            if (value === 'custom-range') {
                // Show modal for custom range input
                showYearRangeModal();
            } else {
                // Hide edit button and clear custom range
                editBtn.style.display = 'none';
                customYearRange = null;
                filterParticipants();
            }
        }
        
        // Show year range modal
        function showYearRangeModal() {
            const modal = new bootstrap.Modal(document.getElementById('yearRangeModal'));
            
            // Pre-fill if custom range exists
            if (customYearRange) {
                document.getElementById('yearRangeFrom').value = customYearRange.from;
                document.getElementById('yearRangeTo').value = customYearRange.to;
            } else {
                document.getElementById('yearRangeFrom').value = '';
                document.getElementById('yearRangeTo').value = '';
            }
            
            modal.show();
        }
        
        // Apply custom year range
        function applyYearRange() {
            const fromYear = parseInt(document.getElementById('yearRangeFrom').value);
            const toYear = parseInt(document.getElementById('yearRangeTo').value);
            const select = document.getElementById('yearFilter');
            const editBtn = document.getElementById('yearRangeBtn');
            
            // Validation
            if (!fromYear || !toYear) {
                alert('Please enter both start and end years');
                return;
            }
            
            if (fromYear > toYear) {
                alert('Start year must be less than or equal to end year');
                return;
            }
            
            // Store custom range
            customYearRange = { from: fromYear, to: toYear };
            
            // Update select to show custom range
            const customOption = select.querySelector('option[value="custom-range"]');
            customOption.textContent = `${fromYear}-${toYear}`;
            select.value = 'custom-range';
            
            // Show edit button
            editBtn.style.display = 'inline-block';
            
            // Close modal
            bootstrap.Modal.getInstance(document.getElementById('yearRangeModal')).hide();
            
            // Apply filter
            filterParticipants();
        }
        
        // Bootstrap Modal Helper Functions
        function showAlert(message, title = 'Notice', icon = 'info-circle') {
            const modal = new bootstrap.Modal(document.getElementById('genericAlertModal'));
            document.getElementById('genericAlertTitle').innerHTML = `<i class="fas fa-${icon} me-2"></i>${title}`;
            document.getElementById('genericAlertMessage').textContent = message;
            modal.show();
        }

        function showConfirm(message, onConfirm, title = 'Confirm', icon = 'question-circle') {
            const modal = new bootstrap.Modal(document.getElementById('genericConfirmModal'));
            document.getElementById('genericConfirmTitle').innerHTML = `<i class="fas fa-${icon} me-2"></i>${title}`;
            document.getElementById('genericConfirmMessage').textContent = message;
            
            const confirmBtn = document.getElementById('genericConfirmBtn');
            
            // Remove old listeners
            const newBtn = confirmBtn.cloneNode(true);
            confirmBtn.parentNode.replaceChild(newBtn, confirmBtn);
            
            // Add new listener
            newBtn.addEventListener('click', function() {
                modal.hide();
                if (onConfirm) onConfirm();
            });
            
            modal.show();
        }
    </script>

</div> <!-- End container-fluid -->
        <?php include 'footer.php'; ?>
    </body>
    </html>
