        <div class="modal fade heat-config-modal" id="heatModal<?= $h ?>" tabindex="-1" aria-labelledby="heatModalLabel<?= $h ?>" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-xl">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="heatModalLabel<?= $h ?>">
                            <i class="fas fa-fire me-2 text-warning"></i>
                            Configure Heat <?= $h ?>
                            <?php if ($setting['is_active']): ?>
                                <span class="badge text-bg-success ms-2">ACTIVE</span>
                            <?php endif; ?>
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    
                    <form method="post" action="admin_heat_config.php?event_id=<?= $selected_event_id ?>" onsubmit="return validateHeatForm(<?= $h ?>)">
                        <input type="hidden" name="event_id" value="<?= $selected_event_id ?>">
                        <input type="hidden" name="save_settings" value="1">
                        <input type="hidden" name="single_heat" value="<?= $h ?>">
                        
                        <div class="modal-body">
                            <!-- Heat Activation Status -->
                            <?php if ($setting['is_active']): ?>
                                <div class="alert alert-success border-0 mb-4">
                                    <div class="d-flex align-items-center">
                                        <i class="fas fa-fire text-success fs-4 me-3"></i>
                                        <div>
                                            <h6 class="mb-1">This Heat is Currently Active</h6>
                                            <small class="text-muted">All scoring activity is directed to this heat</small>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                            
                            <!-- Tabbed Interface -->
                            <ul class="nav nav-tabs mb-4" id="heatConfigTabs<?= $h ?>" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active" id="basic-tab-<?= $h ?>" data-bs-toggle="tab" 
                                            data-bs-target="#basic-<?= $h ?>" type="button" role="tab">
                                        <i class="fas fa-info-circle me-2"></i>Basic Settings
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="timing-tab-<?= $h ?>" data-bs-toggle="tab" 
                                            data-bs-target="#timing-<?= $h ?>" type="button" role="tab">
                                        <i class="fas fa-clock me-2"></i>Timing & Runs
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="format-tab-<?= $h ?>" data-bs-toggle="tab" 
                                            data-bs-target="#format-<?= $h ?>" type="button" role="tab">
                                        <i class="fas fa-clipboard-list me-2"></i>Format
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="flow-tab-<?= $h ?>" data-bs-toggle="tab" 
                                            data-bs-target="#flow-<?= $h ?>" type="button" role="tab">
                                        <i class="fas fa-sitemap me-2"></i>Flow
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="activation-tab-<?= $h ?>" data-bs-toggle="tab" 
                                            data-bs-target="#activation-<?= $h ?>" type="button" role="tab">
                                        <i class="fas fa-power-off me-2"></i>Activation
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="scoring-layout-tab-<?= $h ?>" data-bs-toggle="tab" 
                                            data-bs-target="#scoring-layout-<?= $h ?>" type="button" role="tab">
                                        <i class="fas fa-layout me-2"></i>Score Input Layout
                                    </button>
                                </li>
                            </ul>
                            
                            <!-- Tab Content -->
                            <div class="tab-content" id="heatConfigTabContent<?= $h ?>">
                                
                                <!-- Basic Settings Tab -->
                                <div class="tab-pane fade show active" id="basic-<?= $h ?>" role="tabpanel">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label fw-semibold">Heat Name</label>
                                                <input type="text" class="form-control" 
                                                       name="heat_name[<?= $h ?>]" 
                                                       value="<?= htmlspecialchars($setting['heat_name'] ?? '') ?>"
                                                       placeholder="Enter descriptive heat name">
                                                <div class="form-text">Optional: Give this heat a descriptive name</div>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label fw-semibold">Scoring Type</label>
                                                <select class="form-select" name="scoring_type[<?= $h ?>]">
                                                    <option value="Points" <?= $setting['scoring_type'] == 'Points' ? 'selected' : '' ?>>Points Based</option>
                                                    <option value="Time" <?= $setting['scoring_type'] == 'Time' ? 'selected' : '' ?>>Time Based</option>
                                                </select>
                                                <div class="form-text">How this heat will be scored</div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="mb-4">
                                        <label class="form-label fw-semibold">Divisions</label>
                                        <?php if (empty($event_categories)): ?>
                                            <div class="alert alert-warning">
                                                <i class="fas fa-exclamation-triangle me-2"></i>
                                                No divisions defined for this event. 
                                                <a href="event_categories.php?event_id=<?= $selected_event_id ?>" class="alert-link">Add divisions first</a>
                                            </div>
                                        <?php else: ?>
                                            <div class="border-0 shadow-none card">
                                                <div class="border-0 shadow-none card-header py-2">
                                                    <div class="form-check">
                                                        <input class="form-check-input" type="checkbox" 
                                                               id="all_categories_modal_<?= $h ?>"
                                                               <?= empty($setting['categories']) ? 'checked' : '' ?>
                                                               onchange="toggleAllCategoriesModal(<?= $h ?>)">
                                                        <label class="form-check-label fw-semibold" for="all_categories_modal_<?= $h ?>">
                                                            All Divisions
                                                        </label>
                                                    </div>
                                                </div>
                                                <div class="border-0 shadow-none card-body" style="max-height: 200px; overflow-y: auto;">
                                                    <div class="row">
                                                        <?php foreach ($event_categories as $category): ?>
                                                            <div class="col-md-6">
                                                                <div class="form-check">
                                                                    <input class="form-check-input category-checkbox" type="checkbox" 
                                                                           name="categories[<?= $h ?>][]" 
                                                                           value="<?= $category['id'] ?>"
                                                                           id="cat_modal_<?= $h ?>_<?= $category['id'] ?>"
                                                                           data-heat="<?= $h ?>"
                                                                           <?= in_array($category['id'], $setting['categories']) ? 'checked' : '' ?>
                                                                           <?= empty($setting['categories']) ? 'disabled' : '' ?>
                                                                           onchange="updateCategorySelectionModal(<?= $h ?>)">
                                                                    <label class="form-check-label" for="cat_modal_<?= $h ?>_<?= $category['id'] ?>">
                                                                        <?= htmlspecialchars($category['category_name']) ?>
                                                                    </label>
                                                                </div>
                                                            </div>
                                                        <?php endforeach; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                
                                <!-- Timing & Runs Tab -->
                                <div class="tab-pane fade" id="timing-<?= $h ?>" role="tabpanel">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label fw-semibold">Start Time</label>
                                                <input type="time" class="form-control" 
                                                       name="time_start[<?= $h ?>]" 
                                                       value="<?= htmlspecialchars($setting['time_start'] ?? '') ?>"
                                                       onchange="calculateEstimatedFinishModal(<?= $h ?>)">
                                                <div class="form-text">When this heat is scheduled to begin</div>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label fw-semibold">Time per Athlete</label>
                                                <div class="input-group">
                                                    <input type="number" class="form-control" 
                                                           name="estimate_time_per_participant[<?= $h ?>]" 
                                                           value="<?= $setting['estimate_time_per_participant'] ?>"
                                                           min="0" step="5"
                                                           onchange="calculateEstimatedFinishModal(<?= $h ?>)">
                                                    <span class="input-group-text">seconds</span>
                                                </div>
                                                <div class="form-text">Estimated time allocation per athlete</div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label fw-semibold">Number of Runs</label>
                                                <select class="form-select" name="runs_count[<?= $h ?>]" 
                                                        onchange="updateRunOptionsModal(<?= $h ?>)">
                                                    <?php for ($r = 1; $r <= 5; $r++): ?>
                                                        <option value="<?= $r ?>" <?= $setting['runs_count'] == $r ? 'selected' : '' ?>>
                                                            <?= $r ?> Run<?= $r > 1 ? 's' : '' ?>
                                                        </option>
                                                    <?php endfor; ?>
                                                </select>
                                                <div class="form-text">How many runs each participant gets</div>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label fw-semibold">Scoring Method</label>
                                                <select class="form-select" name="runs_scoring_method[<?= $h ?>]" 
                                                        id="runs_scoring_modal_<?= $h ?>"
                                                        onchange="updateScoringExplanationModal(<?= $h ?>)">
                                                    <!-- Options populated by JavaScript -->
                                                </select>
                                                <div class="form-text">
                                                    <span id="scoring_explanation_modal_<?= $h ?>">How to calculate final score from multiple runs</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Estimated Finish -->
                                    <div id="estimated_finish_modal_<?= $h ?>" class="alert alert-light border d-none">
                                        <i class="fas fa-clock text-primary me-2"></i>
                                        <strong>Estimated Finish:</strong>
                                        <span id="finish_time_modal_<?= $h ?>"></span>
                                    </div>
                                </div>
                                
                                <!-- Format Settings Tab -->
                                <div class="tab-pane fade" id="format-<?= $h ?>" role="tabpanel">
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <h6 class="text-muted mb-3">Competition Format</h6>
                                            
                                            <div class="mb-3">
                                                <label class="form-label fw-semibold">Format Name</label>
                                                <input type="text" class="form-control" 
                                                       name="format_name[<?= $h ?>]" 
                                                       value="<?= htmlspecialchars($setting['format_name'] ?? '') ?>"
                                                       placeholder="e.g., Street Style, Park Competition">
                                                <div class="form-text">Override event format name for this heat</div>
                                            </div>
                                            
                                            <div class="mb-3">
                                                <label class="form-label fw-semibold">Discipline</label>
                                                <select class="form-select" name="discipline[<?= $h ?>]">
                                                    <option value="">-- Use Event Default --</option>
                                                    <option value="freestyle_scooter" <?= ($setting['discipline'] ?? '') == 'freestyle_scooter' ? 'selected' : '' ?>>Freestyle Scooter</option>
                                                    <option value="street_scooter" <?= ($setting['discipline'] ?? '') == 'street_scooter' ? 'selected' : '' ?>>Street Scooter</option>
                                                    <option value="park_scooter" <?= ($setting['discipline'] ?? '') == 'park_scooter' ? 'selected' : '' ?>>Park Scooter</option>
                                                    <option value="freestyle_skiing" <?= ($setting['discipline'] ?? '') == 'freestyle_skiing' ? 'selected' : '' ?>>Freestyle Skiing</option>
                                                    <option value="alpine_skiing" <?= ($setting['discipline'] ?? '') == 'alpine_skiing' ? 'selected' : '' ?>>Alpine Skiing</option>
                                                    <option value="snowboard_freestyle" <?= ($setting['discipline'] ?? '') == 'snowboard_freestyle' ? 'selected' : '' ?>>Snowboard Freestyle</option>
                                                    <option value="skateboard_street" <?= ($setting['discipline'] ?? '') == 'skateboard_street' ? 'selected' : '' ?>>Skateboard Street</option>
                                                    <option value="skateboard_park" <?= ($setting['discipline'] ?? '') == 'skateboard_park' ? 'selected' : '' ?>>Skateboard Park</option>
                                                    <option value="bmx_freestyle" <?= ($setting['discipline'] ?? '') == 'bmx_freestyle' ? 'selected' : '' ?>>BMX Freestyle</option>
                                                    <option value="breaking" <?= ($setting['discipline'] ?? '') == 'breaking' ? 'selected' : '' ?>>Breaking</option>
                                                    <option value="parkour" <?= ($setting['discipline'] ?? '') == 'parkour' ? 'selected' : '' ?>>Parkour</option>
                                                </select>
                                            </div>
                                            
                                            <div class="mb-3">
                                                <label class="form-label fw-semibold">Difficulty Level</label>
                                                <select class="form-select" name="difficulty_level[<?= $h ?>]">
                                                    <option value="">-- No Specific Level --</option>
                                                    <option value="beginner" <?= ($setting['difficulty_level'] ?? '') == 'beginner' ? 'selected' : '' ?>>Beginner</option>
                                                    <option value="intermediate" <?= ($setting['difficulty_level'] ?? '') == 'intermediate' ? 'selected' : '' ?>>Intermediate</option>
                                                    <option value="advanced" <?= ($setting['difficulty_level'] ?? '') == 'advanced' ? 'selected' : '' ?>>Advanced</option>
                                                    <option value="professional" <?= ($setting['difficulty_level'] ?? '') == 'professional' ? 'selected' : '' ?>>Professional</option>
                                                    <option value="elite" <?= ($setting['difficulty_level'] ?? '') == 'elite' ? 'selected' : '' ?>>Elite</option>
                                                </select>
                                            </div>
                                            
                                            <div class="mb-3">
                                                <label class="form-label fw-semibold">Scoring Method</label>
                                                <select class="form-select" name="scoring_method[<?= $h ?>]">
                                                    <option value="standard" <?= $setting['scoring_method'] == 'standard' ? 'selected' : '' ?>>Standard Scoring</option>
                                                    <option value="comparative" <?= $setting['scoring_method'] == 'comparative' ? 'selected' : '' ?>>Comparative Scoring</option>
                                                    <option value="elimination" <?= $setting['scoring_method'] == 'elimination' ? 'selected' : '' ?>>Elimination</option>
                                                    <option value="head_to_head" <?= $setting['scoring_method'] == 'head_to_head' ? 'selected' : '' ?>>Head to Head</option>
                                                    <option value="battle" <?= $setting['scoring_method'] == 'battle' ? 'selected' : '' ?>>Battle Format</option>
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <div class="col-lg-6">
                                            <h6 class="text-muted mb-3">Course & Judging</h6>
                                            
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label class="form-label fw-semibold">Course Length</label>
                                                        <div class="input-group">
                                                            <input type="number" class="form-control" 
                                                                   name="course_length[<?= $h ?>]" 
                                                                   value="<?= $setting['course_length'] ?>"
                                                                   min="0" step="1">
                                                            <span class="input-group-text">meters</span>
                                                        </div>
                                                        <div class="form-text">0 = not applicable</div>
                                                    </div>
                                                </div>
                                                
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label class="form-label fw-semibold">Time Limit</label>
                                                        <div class="input-group">
                                                            <input type="number" class="form-control" 
                                                                   name="time_limit[<?= $h ?>]" 
                                                                   value="<?= $setting['time_limit'] ?>"
                                                                   min="0" step="1">
                                                            <span class="input-group-text">seconds</span>
                                                        </div>
                                                        <div class="form-text">0 = no limit</div>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="mb-3">
                                                <label class="form-label fw-semibold">Required Figures</label>
                                                <textarea class="form-control" rows="3"
                                                          name="required_figures[<?= $h ?>]" 
                                                          placeholder="List required figures/maneuvers..."><?= htmlspecialchars(is_array($setting['required_figures']) ? implode("\n", $setting['required_figures']) : $setting['required_figures']) ?></textarea>
                                            </div>
                                            
                                            <div class="mb-3">
                                                <label class="form-label fw-semibold">Judges Required</label>
                                                <input type="number" class="form-control" 
                                                       name="judges_required[<?= $h ?>]" 
                                                       value="<?= $setting['judges_required'] ?>"
                                                       min="1" max="15">
                                                <div class="form-text">Number of judges needed</div>
                                            </div>
                                            
                                            <div class="row">
                                                <div class="col-md-4">
                                                    <div class="mb-3">
                                                        <label class="form-label fw-semibold">Score Min</label>
                                                        <input type="number" class="form-control" 
                                                               name="scale_min[<?= $h ?>]" 
                                                               value="<?= $setting['scale_min'] ?>"
                                                               step="0.01">
                                                    </div>
                                                </div>
                                                
                                                <div class="col-md-4">
                                                    <div class="mb-3">
                                                        <label class="form-label fw-semibold">Score Max</label>
                                                        <input type="number" class="form-control" 
                                                               name="scale_max[<?= $h ?>]" 
                                                               value="<?= $setting['scale_max'] ?>"
                                                               step="0.01">
                                                    </div>
                                                </div>
                                                
                                                <div class="col-md-4">
                                                    <div class="mb-3">
                                                        <label class="form-label fw-semibold">Precision</label>
                                                        <select class="form-select" name="precision_decimal[<?= $h ?>]">
                                                            <option value="0" <?= $setting['precision_decimal'] == 0 ? 'selected' : '' ?>>Whole Numbers</option>
                                                            <option value="1" <?= $setting['precision_decimal'] == 1 ? 'selected' : '' ?>>1 Decimal</option>
                                                            <option value="2" <?= $setting['precision_decimal'] == 2 ? 'selected' : '' ?>>2 Decimals</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="mb-3">
                                                <label class="form-label fw-semibold">
                                                    <i class="fas fa-filter me-1"></i>Judge Score Drop Rule
                                                </label>
                                                <select class="form-select" name="drop_rule[<?= $h ?>]" id="drop_rule_<?= $h ?>">
                                                    <option value="" <?= empty($setting['drop_rule']) ? 'selected' : '' ?>>-- Use Event Default --</option>
                                                    <option value="none" <?= ($setting['drop_rule'] ?? '') === 'none' ? 'selected' : '' ?>>None - Use All Judge Scores</option>
                                                    <option value="lowest" <?= ($setting['drop_rule'] ?? '') === 'lowest' ? 'selected' : '' ?>>Drop Lowest Score</option>
                                                    <option value="highest" <?= ($setting['drop_rule'] ?? '') === 'highest' ? 'selected' : '' ?>>Drop Highest Score</option>
                                                    <option value="highest_and_lowest" <?= ($setting['drop_rule'] ?? '') === 'highest_and_lowest' ? 'selected' : '' ?>>Drop Highest & Lowest Scores</option>
                                                </select>
                                                <div class="form-text">
                                                    <i class="fas fa-info-circle me-1"></i>Override which judge scores to exclude when calculating run scores. 
                                                    Leave as "Use Event Default" to inherit from event format settings.
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" 
                                                           name="weather_dependent[<?= $h ?>]" value="1"
                                                           id="weather_modal_<?= $h ?>"
                                                           <?= $setting['weather_dependent'] ? 'checked' : '' ?>>
                                                    <label class="form-check-label" for="weather_modal_<?= $h ?>">
                                                        <i class="fas fa-cloud-sun me-1"></i>Weather Dependent Competition
                                                    </label>
                                                </div>
                                                <div class="form-text">Check if this heat is affected by weather conditions</div>
                                            </div>
                                            
                                            <div class="mb-3">
                                                <label class="form-label fw-semibold">Format Description</label>
                                                <textarea class="form-control" rows="3"
                                                          name="format_description[<?= $h ?>]" 
                                                          placeholder="Additional format-specific details, rules, or requirements for this heat"><?= htmlspecialchars($setting['format_description'] ?? '') ?></textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Flow Control Tab -->
                                <div class="tab-pane fade" id="flow-<?= $h ?>" role="tabpanel">
                                    <div class="row">
                                        <div class="col-12 col-sm-12 col-lg-8">
                                            <div class="border-0 shadow-none card">
                                                <div class="border-0 shadow-none card-header">
                                                    <h6 class="mb-0">
                                                        <i class="fas fa-sitemap me-2"></i>Flow Configuration
                                                    </h6>
                                                </div>
                                                <div class="border-0 shadow-none card-body">
                                                    <div class="mb-3">
                                                        <label class="form-label fw-semibold">Flow Type</label>
                                                        <select class="form-select" name="flow_type[<?= $h ?>]" 
                                                                onchange="toggleFlowConfigModal(<?= $h ?>)">
                                                            <option value="none" <?= $setting['flow_type'] == 'none' ? 'selected' : '' ?>>
                                                                No Flow (Manual Entry)
                                                            </option>
                                                            <option value="promotion" <?= $setting['flow_type'] == 'promotion' ? 'selected' : '' ?>>
                                                                Promotion from Previous Heat
                                                            </option>
                                                            <option value="qualifying" <?= $setting['flow_type'] == 'qualifying' ? 'selected' : '' ?>>
                                                                Qualifying Heat (Best from Categories)
                                                            </option>
                                                        </select>
                                                    </div>
                                                    
                                                    <div id="flow_config_modal_<?= $h ?>" class="<?= $setting['flow_type'] !== 'none' ? '' : 'd-none' ?>">
                                                        <?php if ($h > 1): ?>
                                                            <div class="mb-3">
                                                                <label class="form-label fw-semibold">Source Heat(s) <span class="badge bg-info">Multi-select</span></label>
                                                                <select class="form-select" name="flow_source_heat[<?= $h ?>][]" multiple size="<?= min($h - 1, 5) ?>">
                                                                    <?php 
                                                                    // Parse existing source heats (could be JSON array or single value)
                                                                    $selected_heats = [];
                                                                    if (!empty($setting['flow_source_heat'])) {
                                                                        $decoded = json_decode($setting['flow_source_heat'], true);
                                                                        $selected_heats = is_array($decoded) ? $decoded : [$setting['flow_source_heat']];
                                                                    }
                                                                    ?>
                                                                    <?php for ($source_h = 1; $source_h < $h; $source_h++): ?>
                                                                        <option value="<?= $source_h ?>" 
                                                                                data-heat-number="<?= $source_h ?>"
                                                                                <?= in_array($source_h, $selected_heats) ? 'selected' : '' ?>>
                                                                            Heat <?= $source_h ?><?= !empty($heat_settings[$source_h]['heat_name']) ? ' (' . htmlspecialchars($heat_settings[$source_h]['heat_name']) . ')' : '' ?>
                                                                        </option>
                                                                    <?php endfor; ?>
                                                                </select>
                                                                <div class="form-text">
                                                                    <i class="fas fa-info-circle me-1"></i>Hold Ctrl (Cmd on Mac) to select multiple source heats
                                                                </div>
                                                            </div>
                                                        <?php endif; ?>
                                                        
                                                        <div class="mb-3">
                                                            <label class="form-label fw-semibold">Participants to Promote per Category</label>
                                                            <input type="number" class="form-control" 
                                                                   name="flow_participants_per_category[<?= $h ?>]"
                                                                   value="<?= $setting['flow_participants_per_category'] ?>"
                                                                   min="0"
                                                                   data-heat="<?= $h ?>">
                                                            <div class="form-text">
                                                                Number of top participants from each category to advance to this heat (0 = disabled)
                                                            </div>
                                                        </div>
                                                        
                                                        <div class="mb-3">
                                                            <label class="form-label fw-semibold">
                                                                Position Range 
                                                                <span class="badge bg-secondary ms-1">Optional</span>
                                                            </label>
                                                            <input type="text" class="form-control" 
                                                                   name="flow_position_range[<?= $h ?>]"
                                                                   value="<?= htmlspecialchars($setting['flow_position_range'] ?? '') ?>"
                                                                   placeholder="e.g., 1-3, 4-8, 9-12"
                                                                   pattern="\d+-\d+"
                                                                   data-heat="<?= $h ?>">
                                                            <div class="form-text">
                                                                <i class="fas fa-info-circle me-1"></i>
                                                                Specify position range from source heat (e.g., "3-4" for 3rd and 4th place, "4-15" for positions 4-15).
                                                                <br>Leave empty to use top N participants per category.
                                                            </div>
                                                        </div>
                                                        
                                                        <div class="alert alert-info">
                                                            <i class="fas fa-info-circle me-2"></i>
                                                            Flow configuration will automatically populate participants based on results from the source heat.
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="col-12 col-lg-4 col-sm-12">
                                            <!-- Diversity Rules Configuration -->
                                            <div class="border-0 shadow-none card">
                                                <div class="border-0 shadow-none card-header">
                                                    <h6 class="mb-0">
                                                        <i class="fas fa-shapes me-2"></i>Diversity Rules
                                                    </h6>
                                                </div>
                                                <div class="border-0 shadow-none card-body">
                                                    <div class="form-check form-switch mb-3">
                                                        <input class="form-check-input" type="checkbox" 
                                                               name="diversity_rules_enabled[<?= $h ?>]" 
                                                               id="diversity_rules_<?= $h ?>"
                                                               value="1"
                                                               <?= ($setting['diversity_rules_enabled'] ?? 1) ? 'checked' : '' ?>>
                                                        <label class="form-check-label fw-semibold" for="diversity_rules_<?= $h ?>">
                                                            Apply Diversity Rules
                                                        </label>
                                                    </div>
                                                    
                                                    <div class="alert alert-info">
                                                        <i class="fas fa-info-circle me-2"></i>
                                                        <small>
                                                            When enabled, diversity rules defined in the scoring format will be applied to this heat.
                                                            Disable to ignore diversity requirements for this specific heat.
                                                        </small>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="border-0 shadow-none card">
                                                <div class="border-0 shadow-none card-header">
                                                    <h6 class="mb-0">
                                                        <i class="fas fa-info-circle me-2"></i>Flow Info
                                                    </h6>
                                                </div>
                                                <div class="border-0 shadow-none card-body">
                                                    <div class="text-center">
                                                        <div class="mb-2">
                                                            <i class="fas fa-arrow-right fa-2x text-primary"></i>
                                                        </div>
                                                        <h6 class="text-primary">Automatic</h6>
                                                        <small class="text-muted">
                                                            Participants will be automatically populated based on your flow configuration
                                                        </small>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Activation Tab -->
                                <div class="tab-pane fade" id="activation-<?= $h ?>" role="tabpanel">
                                    <div class="row">
                                        <div class="col-md-8">
                                            <!-- Active Heat Selection -->
                                            <div class="border-0 shadow-none card">
                                                <div class="border-0 shadow-none card-header">
                                                    <h6 class="mb-0">
                                                        <i class="fas fa-power-off me-2"></i>Heat Activation
                                                    </h6>
                                                </div>
                                                <div class="border-0 shadow-none card-body">
                                                    <div class="form-check form-switch mb-3">
                                                        <input class="form-check-input" type="radio" name="is_active" 
                                                               value="<?= $h ?>" id="active_modal_<?= $h ?>"
                                                               <?= $setting['is_active'] ? 'checked' : '' ?>
                                                               onchange="toggleActiveHeatModal(<?= $h ?>)">
                                                        <label class="form-check-label fw-semibold" for="active_modal_<?= $h ?>">
                                                            Set as Active Heat
                                                        </label>
                                                    </div>
                                                    
                                                    <?php if ($setting['is_active']): ?>
                                                        <div class="alert alert-success">
                                                            <i class="fas fa-check-circle me-2"></i>
                                                            This heat is currently active and receiving all scoring activity
                                                        </div>
                                                    <?php else: ?>
                                                        <div class="alert alert-light">
                                                            <i class="fas fa-info-circle me-2"></i>
                                                            This heat is inactive. Select to activate for scoring.
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            
                                            <!-- Active Run Selection -->
                                            <div id="run_selector_modal_<?= $h ?>" class="card mt-3 <?= $setting['is_active'] ? '' : 'd-none' ?>" data-active-run="<?= max(1, intval($setting['active_run'] ?? 1)) ?>">
                                                <div class="border-0 shadow-none card-header">
                                                    <h6 class="mb-0">
                                                        <i class="fas fa-play me-2"></i>Active Run Selection
                                                    </h6>
                                                </div>
                                                <div class="border-0 shadow-none card-body">
                                                    <div class="row">
                                                        <?php for ($r = 1; $r <= max(1, $setting['runs_count']); $r++): ?>
                                                            <div class="col-auto">
                                                                <div class="form-check">
                                                                    <input class="form-check-input" type="radio" 
                                                                           name="active_run[<?= $h ?>]" value="<?= $r ?>" 
                                                                           id="run_modal_<?= $h ?>_<?= $r ?>" 
                                                                           <?= $r === $setting['active_run'] ? 'checked' : '' ?>>
                                                                    <label class="form-check-label" for="run_modal_<?= $h ?>_<?= $r ?>">
                                                                        Run <?= $r ?>
                                                                    </label>
                                                                </div>
                                                            </div>
                                                        <?php endfor; ?>
                                                    </div>
                                                    <div class="form-text mt-2">
                                                        Select which run is currently active for scoring
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-4">
                                            <div class="border-0 shadow-none card">
                                                <div class="border-0 shadow-none card-header">
                                                    <h6 class="mb-0">
                                                        <i class="fas fa-chart-line me-2"></i>Heat Status
                                                    </h6>
                                                </div>
                                                <div class="border-0 shadow-none card-body">
                                                    <div class="text-center">
                                                        <?php if ($setting['is_active']): ?>
                                                            <div class="text-success mb-2">
                                                                <i class="fas fa-fire fa-2x"></i>
                                                            </div>
                                                            <h6 class="text-success">ACTIVE</h6>
                                                            <small class="text-muted">Receiving all scores</small>
                                                        <?php else: ?>
                                                            <div class="text-muted mb-2">
                                                                <i class="fas fa-pause fa-2x"></i>
                                                            </div>
                                                            <h6 class="text-muted">INACTIVE</h6>
                                                            <small class="text-muted">Not receiving scores</small>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Scoring Layout Tab -->
                                <div class="tab-pane fade" id="scoring-layout-<?= $h ?>" role="tabpanel">
                                    <?php
                                        // Get current heat-specific scoring layout config
                                        $heatLayoutConfig = [];
                                        if (!empty($setting['scoring_layout_config'])) {
                                            $heatLayoutConfig = json_decode($setting['scoring_layout_config'], true) ?? [];
                                        }
                                        
                                        // Get event-level default config
                                        $eventLayoutConfig = [];
                                        if (!empty($event_data['scoring_layout_config'])) {
                                            $eventLayoutConfig = json_decode($event_data['scoring_layout_config'], true) ?? [];
                                        }
                                        
                                        // Define available components for judge scoring panel
                                        $scoringComponents = [
                                            'criteriaInputGrid' => [
                                                'title' => 'Criteria Scoring Grid',
                                                'description' => 'Individual criteria input fields with sliders for detailed scoring',
                                                'category' => 'scoring'
                                            ],
                                            'finalCalculatedScore' => [
                                                'title' => 'Final Score Display',
                                                'description' => 'Shows the final calculated score from criteria or manual input',
                                                'category' => 'scoring'
                                            ],
                                            'figuresCard' => [
                                                'title' => 'Figures Selection Card',
                                                'description' => 'Figure selection chips for snowboard/freestyle sports',
                                                'category' => 'figures'
                                            ],
                                            'diversityValidation' => [
                                                'title' => 'Diversity Validation',
                                                'description' => 'Real-time figure diversity rule checking and warnings',
                                                'category' => 'figures'
                                            ],
                                            'figureHistory' => [
                                                'title' => 'Figure History',
                                                'description' => 'Previous figure selections across runs for reference',
                                                'category' => 'figures'
                                            ],
                                            'latestScores' => [
                                                'title' => 'Latest Scores Table',
                                                'description' => 'Recent scores with edit/overwrite functionality',
                                                'category' => 'history'
                                            ],
                                            'otherHeatScores' => [
                                                'title' => 'Other Judges Scores',
                                                'description' => 'Scores from other judges for the same participant',
                                                'category' => 'history'
                                            ],
                                            'formatInfo' => [
                                                'title' => 'Format Information Card',
                                                'description' => 'Scoring format details, rules, and metadata',
                                                'category' => 'info'
                                            ],
                                            'drawingBoardButton' => [
                                                'title' => 'Drawing Board Button',
                                                'description' => 'Button to open the drawing board for adding situation sketches',
                                                'category' => 'info'
                                            ]
                                        ];
                                        
                                        // Group components by category
                                        $componentsByCategory = [];
                                        foreach ($scoringComponents as $key => $component) {
                                            $componentsByCategory[$component['category']][$key] = $component;
                                        }
                                    ?>
                                    
                                    <div class="row">
                                        <div class="col-lg-8">
                                            <div class="alert alert-info mb-4">
                                                <i class="fas fa-info-circle me-2"></i>
                                                <strong>Heat-Specific Layout:</strong> Configure which components are visible on the judge scoring panel for this heat only. 
                                                Leave unchecked to inherit from event-level settings.
                                            </div>
                                            
                                            <?php foreach ($componentsByCategory as $categoryName => $components): ?>
                                                <div class="card mb-3">
                                                    <div class="card-header">
                                                        <h6 class="mb-0">
                                                            <?php
                                                                $categoryIcons = [
                                                                    'scoring' => 'fas fa-calculator',
                                                                    'figures' => 'fas fa-snowflake',
                                                                    'history' => 'fas fa-history', 
                                                                    'info' => 'fas fa-info-circle'
                                                                ];
                                                                $categoryTitles = [
                                                                    'scoring' => 'Scoring Components',
                                                                    'figures' => 'Figure Selection',
                                                                    'history' => 'Score History',
                                                                    'info' => 'Information'
                                                                ];
                                                            ?>
                                                            <i class="<?= $categoryIcons[$categoryName] ?? 'fas fa-cube' ?> me-2"></i>
                                                            <?= $categoryTitles[$categoryName] ?? ucfirst($categoryName) ?>
                                                        </h6>
                                                    </div>
                                                    <div class="card-body">
                                                        <?php foreach ($components as $key => $component): ?>
                                                            <?php
                                                                // Check if heat has override, otherwise use event default
                                                                $heatEnabled = $heatLayoutConfig['cards'][$key]['enabled'] ?? null;
                                                                $eventEnabled = $eventLayoutConfig['cards'][$key]['enabled'] ?? true;
                                                                $hasOverride = $heatEnabled !== null;
                                                                $isEnabled = $heatEnabled ?? $eventEnabled;
                                                            ?>
                                                            <div class="mb-3 p-2 <?= $hasOverride ? 'bg-light border rounded' : '' ?>">
                                                                <div class="form-check">
                                                                    <input class="form-check-input" type="hidden" 
                                                                           name="heat_scoring_layout[<?= $h ?>][cards][<?= $key ?>][enabled]" value="0">
                                                                    <input class="form-check-input" type="checkbox" 
                                                                           name="heat_scoring_layout[<?= $h ?>][cards][<?= $key ?>][enabled]" 
                                                                           id="heat_layout_<?= $h ?>_<?= $key ?>" 
                                                                           value="1" <?= $isEnabled ? 'checked' : '' ?>>
                                                                    <label class="form-check-label" for="heat_layout_<?= $h ?>_<?= $key ?>">
                                                                        <strong><?= htmlspecialchars($component['title']) ?></strong>
                                                                        <?php if ($hasOverride): ?>
                                                                            <span class="badge bg-primary ms-2">Heat Override</span>
                                                                        <?php else: ?>
                                                                            <span class="badge bg-secondary ms-2">From Event</span>
                                                                        <?php endif; ?>
                                                                        <br>
                                                                        <small class="text-muted"><?= htmlspecialchars($component['description']) ?></small>
                                                                    </label>
                                                                </div>
                                                                
                                                                <?php if ($key === 'figuresCard'): ?>
                                                                    <!-- Figure Categories Selection (conditional on figuresCard enabled) -->
                                                                    <div class="ms-4 mt-3 p-3 border rounded bg-white" id="heat_figureCategoriesConfig_<?= $h ?>" style="display: <?= $isEnabled ? 'block' : 'none' ?>;">
                                                                        <h6 class="mb-2 text-primary"><i class="fas fa-layer-group me-1"></i>Visible Figure Categories</h6>
                                                                        <p class="small text-muted mb-2">Select which figure categories judges can see for this heat (overrides event settings)</p>
                                                                        
                                                                        <?php
                                                                        // Get categories for the event's sport
                                                                        $categoriesStmt = $pdo->prepare("
                                                                            SELECT category_name, sort_order 
                                                                            FROM figure_categories 
                                                                            WHERE sport_name = ? AND is_active = 1 
                                                                            ORDER BY sort_order, category_name
                                                                        ");
                                                                        $categoriesStmt->execute([$event_data['sport_discipline'] ?? '']);
                                                                        $availableCategories = $categoriesStmt->fetchAll(PDO::FETCH_ASSOC);
                                                                        
                                                                        // Get heat-specific selected categories
                                                                        $heatSelectedCategories = $heatLayoutConfig['cards']['figuresCard']['visibleCategories'] ?? [];
                                                                        
                                                                        // Get event-level selected categories
                                                                        $eventSelectedCategories = $eventLayoutConfig['cards']['figuresCard']['visibleCategories'] ?? [];
                                                                        ?>
                                                                        
                                                                        <?php if (empty($availableCategories)): ?>
                                                                            <div class="alert alert-warning alert-sm mb-0">
                                                                                <i class="fas fa-info-circle me-1"></i>
                                                                                <strong>No divisions found.</strong> Please select a sport discipline for the event, or add divisions in 
                                                                                <a href="figures_management.php" target="_blank">Figures Management</a>.
                                                                            </div>
                                                                        <?php else: ?>
                                                                            <div class="form-check mb-2">
                                                                                <input class="form-check-input" type="checkbox" 
                                                                                       id="heat_use_event_categories_<?= $h ?>"
                                                                                       <?= empty($heatSelectedCategories) ? 'checked' : '' ?>
                                                                                       onchange="toggleHeatCategoryOverride(<?= $h ?>, this.checked)">
                                                                                <label class="form-check-label fw-semibold" for="heat_use_event_categories_<?= $h ?>">
                                                                                    <span class="badge bg-secondary">Use Event Settings</span>
                                                                                    <?php if (!empty($eventSelectedCategories)): ?>
                                                                                        <small class="text-muted ms-2">(<?= count($eventSelectedCategories) ?> categories)</small>
                                                                                    <?php else: ?>
                                                                                        <small class="text-muted ms-2">(All categories)</small>
                                                                                    <?php endif; ?>
                                                                                </label>
                                                                            </div>
                                                                            
                                                                            <div id="heat_category_override_<?= $h ?>" style="display: <?= !empty($heatSelectedCategories) ? 'block' : 'none' ?>;">
                                                                                <hr class="my-2">
                                                                                <p class="small fw-semibold mb-2"><i class="fas fa-layer-group me-1"></i>Heat-Specific Categories:</p>
                                                                                <div class="row g-2">
                                                                                    <?php foreach ($availableCategories as $category): ?>
                                                                                        <?php 
                                                                                        $categoryName = $category['category_name'];
                                                                                        // If heat has override, use heat selection; otherwise show event default
                                                                                        $isSelected = !empty($heatSelectedCategories) 
                                                                                            ? in_array($categoryName, $heatSelectedCategories)
                                                                                            : (empty($eventSelectedCategories) || in_array($categoryName, $eventSelectedCategories));
                                                                                        ?>
                                                                                        <div class="col-md-6">
                                                                                            <div class="form-check">
                                                                                                <input class="form-check-input heat-figure-category-checkbox" type="checkbox" 
                                                                                                       name="heat_scoring_layout[<?= $h ?>][cards][figuresCard][visibleCategories][]" 
                                                                                                       id="heat_category_<?= $h ?>_<?= htmlspecialchars($categoryName) ?>" 
                                                                                                       value="<?= htmlspecialchars($categoryName) ?>" 
                                                                                                       data-heat="<?= $h ?>"
                                                                                                       <?= $isSelected ? 'checked' : '' ?>>
                                                                                                <label class="form-check-label" for="heat_category_<?= $h ?>_<?= htmlspecialchars($categoryName) ?>">
                                                                                                    <span class="badge bg-secondary"><?= htmlspecialchars($categoryName) ?></span>
                                                                                                </label>
                                                                                            </div>
                                                                                        </div>
                                                                                    <?php endforeach; ?>
                                                                                </div>
                                                                                <div class="mt-2">
                                                                                    <button type="button" class="btn btn-sm btn-outline-primary" onclick="toggleAllHeatCategories(<?= $h ?>, true)">
                                                                                        <i class="fas fa-check-square me-1"></i>Select All
                                                                                    </button>
                                                                                    <button type="button" class="btn btn-sm btn-outline-secondary" onclick="toggleAllHeatCategories(<?= $h ?>, false)">
                                                                                        <i class="fas fa-square me-1"></i>Deselect All
                                                                                    </button>
                                                                                </div>
                                                                            </div>
                                                                            
                                                                            <div class="form-text mt-2">
                                                                                <i class="fas fa-info-circle me-1"></i>
                                                                                Leave "Use Event Settings" checked to inherit from event configuration, or uncheck to set heat-specific categories.
                                                                            </div>
                                                                        <?php endif; ?>
                                                                    </div>
                                                                <?php endif; ?>
                                                            </div>
                                                        <?php endforeach; ?>
                                                    </div>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                        
                                        <div class="col-lg-4">
                                            <div class="card">
                                                <div class="card-header">
                                                    <h6 class="mb-0">
                                                        <i class="fas fa-cogs me-2"></i>Layout Options
                                                    </h6>
                                                </div>
                                                <div class="card-body">
                                                    <div class="mb-3">
                                                        <label class="form-label">Display Mode</label>
                                                        <select class="form-select form-select-sm" 
                                                                name="heat_scoring_layout[<?= $h ?>][layout][compactMode]">
                                                            <option value="">Use Event Default</option>
                                                            <option value="0" <?= ($heatLayoutConfig['layout']['compactMode'] ?? null) === false ? 'selected' : '' ?>>Full Size Cards</option>
                                                            <option value="1" <?= ($heatLayoutConfig['layout']['compactMode'] ?? null) === true ? 'selected' : '' ?>>Compact Mode</option>
                                                        </select>
                                                    </div>
                                                    
                                                    <div class="mb-3">
                                                        <div class="form-check">
                                                            <input class="form-check-input" type="checkbox" 
                                                                   name="heat_scoring_layout[<?= $h ?>][layout][hideEmptyCards]" 
                                                                   id="heat_hideEmpty_<?= $h ?>" value="1" 
                                                                   <?= ($heatLayoutConfig['layout']['hideEmptyCards'] ?? true) ? 'checked' : '' ?>>
                                                            <label class="form-check-label" for="heat_hideEmpty_<?= $h ?>">
                                                                Hide Empty Cards
                                                            </label>
                                                        </div>
                                                    </div>
                                                    
                                                    <hr>
                                                    
                                                    <div class="alert alert-warning">
                                                        <i class="fas fa-exclamation-triangle me-2"></i>
                                                        <strong>Note:</strong> Heat-specific settings override event defaults only for this heat.
                                                    </div>
                                                    
                                                    <button type="button" class="btn btn-outline-secondary btn-sm w-100" 
                                                            onclick="resetHeatLayout(<?= $h ?>)">
                                                        <i class="fas fa-undo me-1"></i>Reset to Event Defaults
                                                    </button>
                                                </div>
                                            </div>
                                            
                                            <div class="card mt-3">
                                                <div class="card-header">
                                                    <h6 class="mb-0">
                                                        <i class="fas fa-eye me-2"></i>Preview
                                                    </h6>
                                                </div>
                                                <div class="card-body">
                                                    <p class="text-muted mb-2">Enabled components for judges:</p>
                                                    <div id="layoutPreview_<?= $h ?>" class="small">
                                                        <!-- Will be populated by JavaScript -->
                                                    </div>
                                                    <hr>
                                                    <a href="../judge/score.php?event_id=<?= $selected_event_id ?>&heat=<?= $h ?>" 
                                                       target="_blank" class="btn btn-outline-primary btn-sm w-100">
                                                        <i class="fas fa-external-link-alt me-1"></i>
                                                        Test Judge Panel
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                                <i class="fas fa-times me-1"></i>Cancel
                            </button>
                            <button type="submit" class="btn btn-success">
                                <i class="fas fa-save me-1"></i>Save Heat Configuration
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

<script>
// Initialize heat configuration modal for heat <?= $h ?>

(function(heatNumber) {
    'use strict';
    
    // Modal-specific helper functions
    function toggleAllCategoriesModal(heatNum) {
        const allCheckbox = document.getElementById('all_categories_modal_' + heatNum);
        if (!allCheckbox) return;
        
        const categoryCheckboxes = document.querySelectorAll('input[data-heat="' + heatNum + '"].category-checkbox');
        
        if (allCheckbox.checked) {
            categoryCheckboxes.forEach(checkbox => {
                checkbox.checked = false;
                checkbox.disabled = true;
            });
        } else {
            categoryCheckboxes.forEach(checkbox => {
                checkbox.disabled = false;
            });
        }
    }
    
    function updateCategorySelectionModal(heatNum) {
        const allCheckbox = document.getElementById('all_categories_modal_' + heatNum);
        if (!allCheckbox) return;
        
        const categoryCheckboxes = document.querySelectorAll('input[data-heat="' + heatNum + '"].category-checkbox:checked');
        
        if (categoryCheckboxes.length > 0) {
            allCheckbox.checked = false;
        }
    }
    
    function toggleFlowConfigModal(heatNum) {
        const flowType = document.querySelector('select[name="flow_type[' + heatNum + ']"]');
        if (!flowType) return;
        
        const flowTypeValue = flowType.value;
        const flowConfig = document.getElementById('flow_config_modal_' + heatNum);
        const participantsInput = document.querySelector('input[name="flow_participants_per_category[' + heatNum + ']"]');
        const positionInput = document.querySelector('input[name="flow_position_range[' + heatNum + ']"]');
        const sourceHeatSelect = document.querySelector('select[name="flow_source_heat[' + heatNum + '][]"]');
        
        if (flowTypeValue === 'none') {
            if (flowConfig) flowConfig.style.display = 'none';
        } else {
            if (flowConfig) flowConfig.style.display = 'block';
            
            if (flowTypeValue === 'promotion') {
                if (sourceHeatSelect) sourceHeatSelect.closest('.mb-3').style.display = 'block';
                if (participantsInput) participantsInput.closest('.mb-3').style.display = 'block';
                if (positionInput) positionInput.closest('.mb-3').style.display = 'none';
            } else if (flowTypeValue === 'position_range') {
                if (sourceHeatSelect) sourceHeatSelect.closest('.mb-3').style.display = 'block';
                if (positionInput) positionInput.closest('.mb-3').style.display = 'block';
                if (participantsInput) participantsInput.closest('.mb-3').style.display = 'none';
            }
        }
    }
    
    function calculateEstimatedFinishModal(heatNum) {
        const startTimeInput = document.querySelector('input[name="time_start[' + heatNum + ']"]');
        const timePerParticipantInput = document.querySelector('input[name="estimate_time_per_participant[' + heatNum + ']"]');
        const estimatedFinishDiv = document.getElementById('estimated_finish_modal_' + heatNum);
        const finishTimeSpan = document.getElementById('finish_time_modal_' + heatNum);
        
        if (!startTimeInput || !timePerParticipantInput || !estimatedFinishDiv || !finishTimeSpan) return;
        
        const startTime = startTimeInput.value;
        const timePerParticipant = parseInt(timePerParticipantInput.value) || 0;
        const participantCount = window.heatParticipantCounts ? (window.heatParticipantCounts[heatNum] || 0) : 0;
        
        if (startTime && timePerParticipant > 0 && participantCount > 0) {
            const totalMinutes = Math.ceil((timePerParticipant * participantCount) / 60);
            const [hours, minutes] = startTime.split(':').map(Number);
            const startDate = new Date();
            startDate.setHours(hours, minutes, 0);
            startDate.setMinutes(startDate.getMinutes() + totalMinutes);
            
            const finishHours = String(startDate.getHours()).padStart(2, '0');
            const finishMinutes = String(startDate.getMinutes()).padStart(2, '0');
            
            finishTimeSpan.textContent = finishHours + ':' + finishMinutes + ' (' + totalMinutes + ' min for ' + participantCount + ' participants)';
            estimatedFinishDiv.classList.remove('d-none');
        } else {
            estimatedFinishDiv.classList.add('d-none');
        }
    }
    
    function updateRunOptionsModal(heatNum) {
        const runsCountInput = document.querySelector('input[name="runs_count[' + heatNum + ']"]');
        const runsScoringMethodSelect = document.querySelector('select[name="runs_scoring_method[' + heatNum + ']"]');
        
        if (!runsCountInput || !runsScoringMethodSelect) return;
        
        const runsCount = parseInt(runsCountInput.value) || 1;
        
        // Clear existing options
        runsScoringMethodSelect.innerHTML = '';
        
        // Add options based on runs count
        if (runsCount === 1) {
            const option = document.createElement('option');
            option.value = 'best_from_all';
            option.textContent = 'Single Run';
            runsScoringMethodSelect.appendChild(option);
        } else {
            const options = [
                { value: 'best_from_all', label: 'Best score from all ' + runsCount + ' runs' },
                { value: 'average_all', label: 'Average of all ' + runsCount + ' runs' },
                { value: 'sum_all', label: 'Sum of all ' + runsCount + ' runs' }
            ];
            
            if (runsCount >= 3) {
                options.push({ value: 'best_2_of_3', label: 'Best 2 out of ' + runsCount + ' runs' });
            }
            
            options.forEach(opt => {
                const option = document.createElement('option');
                option.value = opt.value;
                option.textContent = opt.label;
                runsScoringMethodSelect.appendChild(option);
            });
        }
        
        updateScoringExplanationModal(heatNum);
        updateRunSelectorModal(heatNum);
    }
    
    function updateScoringExplanationModal(heatNum) {
        const runsScoringMethodSelect = document.querySelector('select[name="runs_scoring_method[' + heatNum + ']"]');
        const explanationDiv = document.getElementById('scoring_explanation_modal_' + heatNum);
        
        if (!runsScoringMethodSelect || !explanationDiv) return;
        
        const method = runsScoringMethodSelect.value;
        const explanations = {
            'best_from_all': 'Only the highest score across all runs will count.',
            'average_all': 'All run scores will be averaged together.',
            'sum_all': 'All run scores will be added together for a total score.',
            'best_2_of_3': 'The two highest scores will be used (lowest score dropped).'
        };
        
        explanationDiv.textContent = explanations[method] || '';
    }
    
    function updateRunSelectorModal(heatNum) {
        const runsCountInput = document.querySelector('input[name="runs_count[' + heatNum + ']"]');
        const runSelectorDiv = document.getElementById('run_selector_modal_' + heatNum);
        
        if (!runsCountInput || !runSelectorDiv) return;
        
        const runsCount = parseInt(runsCountInput.value) || 1;
        const currentActiveRun = parseInt(runSelectorDiv.dataset.activeRun) || 1;
        
        if (runsCount === 1) {
            runSelectorDiv.classList.add('d-none');
        } else {
            runSelectorDiv.classList.remove('d-none');
            
            const runButtonsContainer = runSelectorDiv.querySelector('.btn-group');
            if (runButtonsContainer) {
                runButtonsContainer.innerHTML = '';
                
                for (let i = 1; i <= runsCount; i++) {
                    const input = document.createElement('input');
                    input.type = 'radio';
                    input.className = 'btn-check';
                    input.name = 'active_run[' + heatNum + ']';
                    input.id = 'run_modal_' + heatNum + '_' + i;
                    input.value = i;
                    input.autocomplete = 'off';
                    if (i === currentActiveRun) input.checked = true;
                    
                    const label = document.createElement('label');
                    label.className = 'btn btn-outline-primary';
                    label.setAttribute('for', 'run_modal_' + heatNum + '_' + i);
                    label.textContent = 'Run ' + i;
                    
                    runButtonsContainer.appendChild(input);
                    runButtonsContainer.appendChild(label);
                }
            }
        }
    }
    
    function validateHeatFormModal(heatNum) {
        const flowType = document.querySelector('select[name="flow_type[' + heatNum + ']"]');
        
        if (!flowType) return true;
        
        if (flowType.value === 'promotion' || flowType.value === 'position_range') {
            const sourceHeatSelect = document.querySelector('select[name="flow_source_heat[' + heatNum + '][]"]');
            
            if (sourceHeatSelect && sourceHeatSelect.selectedOptions.length === 0) {
                alert('Please select at least one source heat for the flow configuration.');
                
                const flowTab = document.querySelector('#flow-tab-' + heatNum);
                if (flowTab) {
                    const tab = new bootstrap.Tab(flowTab);
                    tab.show();
                }
                
                if (sourceHeatSelect.closest('.mb-3')) {
                    sourceHeatSelect.closest('.mb-3').scrollIntoView({ behavior: 'smooth', block: 'center' });
                    setTimeout(() => sourceHeatSelect.focus(), 300);
                }
                
                return false;
            }
        }
        
        return true;
    }
    
    // Expose validation function globally for form onsubmit
    window['validateHeatForm'] = window['validateHeatForm'] || function(num) {
        return validateHeatFormModal(num);
    };
    
    // Expose toggle functions globally for onchange handlers
    window['toggleAllCategoriesModal'] = window['toggleAllCategoriesModal'] || toggleAllCategoriesModal;
    window['updateCategorySelectionModal'] = window['updateCategorySelectionModal'] || updateCategorySelectionModal;
    window['toggleFlowConfigModal'] = window['toggleFlowConfigModal'] || toggleFlowConfigModal;
    window['calculateEstimatedFinishModal'] = window['calculateEstimatedFinishModal'] || calculateEstimatedFinishModal;
    window['updateRunOptionsModal'] = window['updateRunOptionsModal'] || updateRunOptionsModal;
    window['updateScoringExplanationModal'] = window['updateScoringExplanationModal'] || updateScoringExplanationModal;
    
    // Initialize the modal when it's shown
    const modalElement = document.getElementById('heatModal' + heatNumber);
    if (modalElement) {
        modalElement.addEventListener('shown.bs.modal', function() {
            // Initialize flow config visibility
            toggleFlowConfigModal(heatNumber);
            
            // Initialize run options
            updateRunOptionsModal(heatNumber);
            
            // Initialize estimated finish
            calculateEstimatedFinishModal(heatNumber);
            
            // Initialize category state
            const allCheckbox = document.getElementById('all_categories_modal_' + heatNumber);
            if (allCheckbox && allCheckbox.checked) {
                toggleAllCategoriesModal(heatNumber);
            }
        });
    }
    
    // Auto-initialize if modal is already in DOM
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', function() {
            if (modalElement) {
                toggleFlowConfigModal(heatNumber);
                updateRunOptionsModal(heatNumber);
                calculateEstimatedFinishModal(heatNumber);
            }
        });
    } else {
        if (modalElement) {
            toggleFlowConfigModal(heatNumber);
            updateRunOptionsModal(heatNumber);
            calculateEstimatedFinishModal(heatNumber);
        }
    }
    
})(<?= $h ?>);
</script>
