<?php
/**
 * Get Active Heat API
 * Returns the currently active heat for an event
 */
header('Content-Type: application/json');

require_once '../includes/db.php';

$response = ['success' => false, 'data' => null, 'message' => ''];

try {
    $event_id = $_GET['event_id'] ?? null;
    
    if (!$event_id) {
        throw new Exception('Event ID is required');
    }
    
    // Get active heat from event_heat_settings
    $stmt = $pdo->prepare("
        SELECT 
            heat_number,
            heat_name,
            status,
            active_run,
            runs_count,
            is_active
        FROM event_heat_settings 
        WHERE event_id = ? AND status = 'active'
        ORDER BY heat_number
        LIMIT 1
    ");
    $stmt->execute([$event_id]);
    $active_heat = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // If no active heat, get the first heat
    if (!$active_heat) {
        $stmt = $pdo->prepare("
            SELECT 
                heat_number,
                heat_name,
                status,
                active_run,
                runs_count,
                is_active
            FROM event_heat_settings 
            WHERE event_id = ?
            ORDER BY heat_number
            LIMIT 1
        ");
        $stmt->execute([$event_id]);
        $active_heat = $stmt->fetch(PDO::FETCH_ASSOC);
    }
    
    if ($active_heat) {
        $response['success'] = true;
        $response['data'] = $active_heat;
    } else {
        $response['success'] = false;
        $response['message'] = 'No heats found for this event';
    }
    
} catch (Exception $e) {
    $response['message'] = $e->getMessage();
}

echo json_encode($response);
