<?php
include '../includes/auth.php';
include '../includes/db.php';

echo "<h1>Events Table Structure Debug</h1>";

// Show table structure
echo "<h2>Table Structure:</h2>";
$columns_stmt = $pdo->query("DESCRIBE events");
$columns = $columns_stmt->fetchAll(PDO::FETCH_ASSOC);

echo "<table border='1' cellpadding='5'>";
echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
foreach ($columns as $column) {
    echo "<tr>";
    echo "<td>" . htmlspecialchars($column['Field']) . "</td>";
    echo "<td>" . htmlspecialchars($column['Type']) . "</td>";
    echo "<td>" . htmlspecialchars($column['Null']) . "</td>";
    echo "<td>" . htmlspecialchars($column['Key']) . "</td>";
    echo "<td>" . htmlspecialchars($column['Default']) . "</td>";
    echo "<td>" . htmlspecialchars($column['Extra']) . "</td>";
    echo "</tr>";
}
echo "</table>";

// Show actual data for event ID 3
echo "<h2>Raw Data for Event ID 3:</h2>";
$data_stmt = $pdo->prepare("SELECT * FROM events WHERE id = 3");
$data_stmt->execute();
$event_data = $data_stmt->fetch(PDO::FETCH_ASSOC);

echo "<table border='1' cellpadding='5'>";
echo "<tr><th>Column</th><th>Value</th><th>Type</th></tr>";
foreach ($event_data as $key => $value) {
    echo "<tr>";
    echo "<td><strong>" . htmlspecialchars($key) . "</strong></td>";
    echo "<td>" . htmlspecialchars($value ?? 'NULL') . "</td>";
    echo "<td>" . gettype($value) . "</td>";
    echo "</tr>";
}
echo "</table>";

// Test specific queries
echo "<h2>Test Queries:</h2>";

echo "<h3>Query 1: SELECT *</h3>";
$test1 = $pdo->prepare("SELECT * FROM events WHERE id = 3");
$test1->execute();
$result1 = $test1->fetch(PDO::FETCH_ASSOC);
echo "<pre>";
print_r($result1);
echo "</pre>";

echo "<h3>Query 2: SELECT specific columns</h3>";
$test2 = $pdo->prepare("SELECT id, name, location, sport_discipline, scoring_format, scoring_mode FROM events WHERE id = 3");
$test2->execute();
$result2 = $test2->fetch(PDO::FETCH_ASSOC);
echo "<pre>";
print_r($result2);
echo "</pre>";

echo "<h3>Query 3: Column names from information schema</h3>";
$columns_query = $pdo->prepare("SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'events' ORDER BY ORDINAL_POSITION");
$columns_query->execute();
$column_names = $columns_query->fetchAll(PDO::FETCH_COLUMN);
echo "<pre>";
print_r($column_names);
echo "</pre>";
?>