<?php
require_once '../includes/db.php';

// Get parameters
$event_id = $_GET['event_id'] ?? 3; // Default to event 3
$heat_number = $_GET['heat_number'] ?? null;

echo "<h2>Debug Heat Participants</h2>";
echo "<p>Event ID: $event_id</p>";
echo "<p>Heat Number: " . ($heat_number ?? 'ALL') . "</p>";

// Get all heats for this event
$heats_stmt = $pdo->prepare("
    SELECT DISTINCT heat_number 
    FROM event_participants 
    WHERE event_id = ? AND heat_number IS NOT NULL
    ORDER BY heat_number
");
$heats_stmt->execute([$event_id]);
$heats = $heats_stmt->fetchAll(PDO::FETCH_COLUMN);

echo "<h3>Available Heats: " . implode(', ', $heats) . "</h3>";

// Get participants query
if ($heat_number) {
    $where_clause = "ep.event_id = ? AND ep.heat_number = ?";
    $params = [$event_id, $heat_number];
} else {
    $where_clause = "ep.event_id = ?";
    $params = [$event_id];
}

$participants_stmt = $pdo->prepare("
    SELECT 
        ep.id,
        ep.event_id,
        ep.participant_id,
        ep.bib_number,
        ep.heat_number,
        ep.sort_order,
        ep.participant_status,
        p.first_name,
        p.last_name,
        p.name
    FROM event_participants ep
    LEFT JOIN participants p ON ep.participant_id = p.id
    WHERE $where_clause
    ORDER BY ep.heat_number, ep.sort_order
");
$participants_stmt->execute($params);
$participants = $participants_stmt->fetchAll(PDO::FETCH_ASSOC);

echo "<h3>Found " . count($participants) . " participants</h3>";

echo "<table border='1' cellpadding='5' style='border-collapse: collapse'>";
echo "<tr><th>ID</th><th>Event ID</th><th>Participant ID</th><th>BIB</th><th>Heat</th><th>Sort Order</th><th>Status</th><th>Name</th></tr>";
foreach ($participants as $p) {
    $name = $p['first_name'] . ' ' . $p['last_name'];
    if (empty(trim($name))) {
        $name = $p['name'] ?? '';
    }
    
    echo "<tr>";
    echo "<td>{$p['id']}</td>";
    echo "<td>{$p['event_id']}</td>";
    echo "<td>{$p['participant_id']}</td>";
    echo "<td>{$p['bib_number']}</td>";
    echo "<td>{$p['heat_number']}</td>";
    echo "<td>{$p['sort_order']}</td>";
    echo "<td>{$p['participant_status']}</td>";
    echo "<td>$name</td>";
    echo "</tr>";
}
echo "</table>";

// Test the API
if ($heat_number) {
    echo "<h3>API Test</h3>";
    $api_url = "heat_management_api.php?action=get_queue&event_id=$event_id&heat_number=$heat_number&mode=sort_order";
    echo "<p>API URL: <a href='$api_url' target='_blank'>$api_url</a></p>";
    
    $api_response = file_get_contents($api_url);
    echo "<h4>API Response:</h4>";
    echo "<pre>" . htmlspecialchars($api_response) . "</pre>";
    
    $api_data = json_decode($api_response, true);
    if ($api_data) {
        echo "<h4>Parsed API Data:</h4>";
        echo "<pre>" . print_r($api_data, true) . "</pre>";
    }
}

echo "<hr>";
echo "<h3>Navigation</h3>";
echo "<ul>";
foreach ($heats as $h) {
    echo "<li><a href='?event_id=$event_id&heat_number=$h'>Heat $h</a></li>";
}
echo "</ul>";
?>
