@echo off
REM StyleScore Publish Daemon Manager for Windows
REM This script helps manage the publish daemon on Windows systems

setlocal enabledelayedexpansion

set SCRIPT_DIR=%~dp0
set PHP_SCRIPT=%SCRIPT_DIR%publish_daemon.php
set LOG_FILE=%SCRIPT_DIR%logs\daemon.log
set PID_FILE=%SCRIPT_DIR%logs\daemon.pid

REM Check if PHP is available
php --version >nul 2>&1
if errorlevel 1 (
    echo ERROR: PHP is not installed or not in PATH
    echo Please install PHP and add it to your system PATH
    pause
    exit /b 1
)

if "%1"=="" goto show_usage
if "%1"=="start" goto start_daemon
if "%1"=="stop" goto stop_daemon
if "%1"=="restart" goto restart_daemon
if "%1"=="status" goto show_status
if "%1"=="test" goto test_daemon
if "%1"=="logs" goto show_logs
goto show_usage

:start_daemon
echo Starting StyleScore Publish Daemon...

REM Check if already running
if exist "%PID_FILE%" (
    set /p DAEMON_PID=<"%PID_FILE%"
    tasklist /FI "PID eq !DAEMON_PID!" 2>nul | find /i "php.exe" >nul
    if not errorlevel 1 (
        echo Daemon is already running with PID !DAEMON_PID!
        goto end
    ) else (
        echo Removing stale PID file...
        del "%PID_FILE%" >nul 2>&1
    )
)

REM Create logs directory if it doesn't exist
if not exist "%SCRIPT_DIR%logs" mkdir "%SCRIPT_DIR%logs"

REM Start daemon in background
echo Starting daemon in background...
start /b "" php "%PHP_SCRIPT%" start > "%LOG_FILE%" 2>&1
timeout /t 2 /nobreak >nul

REM Try to find the PHP process (this is a simple approach)
for /f "tokens=2" %%i in ('tasklist /FI "IMAGENAME eq php.exe" /FO CSV ^| find "php.exe"') do (
    set DAEMON_PID=%%i
    set DAEMON_PID=!DAEMON_PID:"=!
)

if defined DAEMON_PID (
    echo !DAEMON_PID! > "%PID_FILE%"
    echo Daemon started successfully with PID !DAEMON_PID!
    echo Log file: %LOG_FILE%
) else (
    echo Failed to start daemon or get PID
    echo Check the log file: %LOG_FILE%
)
goto end

:stop_daemon
echo Stopping StyleScore Publish Daemon...

if not exist "%PID_FILE%" (
    echo No PID file found. Daemon may not be running.
    goto end
)

set /p DAEMON_PID=<"%PID_FILE%"
echo Attempting to stop daemon with PID %DAEMON_PID%...

taskkill /PID %DAEMON_PID% /F >nul 2>&1
if not errorlevel 1 (
    echo Daemon stopped successfully
    del "%PID_FILE%" >nul 2>&1
) else (
    echo Failed to stop daemon. Process may have already ended.
    del "%PID_FILE%" >nul 2>&1
)
goto end

:restart_daemon
echo Restarting StyleScore Publish Daemon...
call :stop_daemon
timeout /t 2 /nobreak >nul
call :start_daemon
goto end

:show_status
echo StyleScore Publish Daemon Status
echo ================================
echo.

if exist "%PID_FILE%" (
    set /p DAEMON_PID=<"%PID_FILE%"
    tasklist /FI "PID eq !DAEMON_PID!" 2>nul | find /i "php.exe" >nul
    if not errorlevel 1 (
        echo Daemon Status: RUNNING (PID: !DAEMON_PID!)
    ) else (
        echo Daemon Status: NOT RUNNING (stale PID file)
        del "%PID_FILE%" >nul 2>&1
    )
) else (
    echo Daemon Status: NOT RUNNING
)

echo.
echo Server Status:
echo --------------
php "%PHP_SCRIPT%" status
goto end

:test_daemon
echo Testing publish system...
echo ========================
php "%PHP_SCRIPT%" test
goto end

:show_logs
echo Recent log entries:
echo ==================
if exist "%LOG_FILE%" (
    REM Show last 20 lines of log file (PowerShell method)
    powershell -Command "Get-Content '%LOG_FILE%' | Select-Object -Last 20"
) else (
    echo No log file found at: %LOG_FILE%
)

if exist "%SCRIPT_DIR%logs\publish_daemon.log" (
    echo.
    echo Daemon log entries:
    echo -------------------
    powershell -Command "Get-Content '%SCRIPT_DIR%logs\publish_daemon.log' | Select-Object -Last 10"
)
goto end

:show_usage
echo StyleScore Publish Daemon Manager
echo =================================
echo.
echo Usage: %~nx0 [command]
echo.
echo Commands:
echo   start    - Start the publish daemon
echo   stop     - Stop the publish daemon  
echo   restart  - Restart the publish daemon
echo   status   - Show daemon and server status
echo   test     - Test publishing to first active server
echo   logs     - Show recent log entries
echo.
echo Examples:
echo   %~nx0 start
echo   %~nx0 status
echo   %~nx0 logs
echo.

:end
pause
